/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.transport.netty.ChannelBufferStreamInputFactory;

public class ChannelBufferBytesReference
implements BytesReference {
    private final ChannelBuffer buffer;

    public ChannelBufferBytesReference(ChannelBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public byte get(int index) {
        return this.buffer.getByte(this.buffer.readerIndex() + index);
    }

    @Override
    public int length() {
        return this.buffer.readableBytes();
    }

    @Override
    public BytesReference slice(int from, int length) {
        return new ChannelBufferBytesReference(this.buffer.slice(from, length));
    }

    @Override
    public StreamInput streamInput() {
        return ChannelBufferStreamInputFactory.create(this.buffer.duplicate());
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        this.buffer.getBytes(this.buffer.readerIndex(), os, this.length());
    }

    @Override
    public byte[] toBytes() {
        return this.copyBytesArray().toBytes();
    }

    @Override
    public BytesArray toBytesArray() {
        if (this.buffer.hasArray()) {
            return new BytesArray(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.readerIndex(), this.buffer.readableBytes());
        }
        return this.copyBytesArray();
    }

    @Override
    public BytesArray copyBytesArray() {
        byte[] copy = new byte[this.buffer.readableBytes()];
        this.buffer.getBytes(this.buffer.readerIndex(), copy);
        return new BytesArray(copy);
    }

    @Override
    public ChannelBuffer toChannelBuffer() {
        return this.buffer.duplicate();
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset() + this.buffer.readerIndex();
    }

    @Override
    public String toUtf8() {
        return this.buffer.toString(Charsets.UTF_8);
    }

    @Override
    public BytesRef toBytesRef() {
        if (this.buffer.hasArray()) {
            return new BytesRef(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.readerIndex(), this.buffer.readableBytes());
        }
        byte[] copy = new byte[this.buffer.readableBytes()];
        this.buffer.getBytes(this.buffer.readerIndex(), copy);
        return new BytesRef(copy);
    }

    @Override
    public BytesRef copyBytesRef() {
        byte[] copy = new byte[this.buffer.readableBytes()];
        this.buffer.getBytes(this.buffer.readerIndex(), copy);
        return new BytesRef(copy);
    }

    public int hashCode() {
        return BytesReference.Helper.bytesHashCode(this);
    }

    public boolean equals(Object obj) {
        return BytesReference.Helper.bytesEqual(this, (BytesReference)obj);
    }
}

