/* $Id: JoinClause.java 1636571 2014-11-04 13:02:56Z kwright $ */

/**
* Licensed to the Apache Software Foundation (ASF) under one or more
* contributor license agreements. See the NOTICE file distributed with
* this work for additional information regarding copyright ownership.
* The ASF licenses this file to You under the Apache License, Version 2.0
* (the "License"); you may not use this file except in compliance with
* the License. You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.apache.manifoldcf.core.interfaces;

import java.util.*;

public class JoinClause implements ClauseDescription
{
  public static final String _rcsid = "@(#)$Id: JoinClause.java 1636571 2014-11-04 13:02:56Z kwright $";

  protected final String columnName;
  protected final String joinColumnName;
  protected final String operation;
  
  /** Construct */
  public JoinClause(String columnName, String joinColumnName)
  {
    this(columnName,joinColumnName,"=");
  }
  
  public JoinClause(String columnName, String joinColumnName, String operation)
  {
    this.columnName = columnName;
    this.joinColumnName = joinColumnName;
    this.operation = operation;
  }
  
  /** Get the column name */
  public String getColumnName()
  {
    return columnName;
  }
  
  /** Get the operation string */
  public String getOperation()
  {
    return operation;
  }
  
  /** Get the individual values */
  public List getValues()
  {
    return null;
  }
  
  /** Get the join column name */
  public String getJoinColumnName()
  {
    return joinColumnName;
  }

}
