/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.livelink;

import com.opentext.api.LAPI_USERS;
import com.opentext.api.LLBadServerCertificateException;
import com.opentext.api.LLConnect;
import com.opentext.api.LLCouldNotConnectHTTPException;
import com.opentext.api.LLHTTPAccessDeniedException;
import com.opentext.api.LLHTTPCGINotFoundException;
import com.opentext.api.LLHTTPClientException;
import com.opentext.api.LLHTTPForbiddenException;
import com.opentext.api.LLHTTPProxyAuthRequiredException;
import com.opentext.api.LLHTTPRedirectionException;
import com.opentext.api.LLHTTPServerException;
import com.opentext.api.LLIOException;
import com.opentext.api.LLIllegalOperationException;
import com.opentext.api.LLIndexOutOfBoundsException;
import com.opentext.api.LLNoFieldSpecifiedException;
import com.opentext.api.LLNoValueSpecifiedException;
import com.opentext.api.LLSSLNotAvailableException;
import com.opentext.api.LLSecurityProviderException;
import com.opentext.api.LLUnknownFieldException;
import com.opentext.api.LLUnsupportedAuthMethodException;
import com.opentext.api.LLValue;
import com.opentext.api.LLWebAuthInitException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.authorities.system.ManifoldCF;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ICacheCreateHandle;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IKeystoreManager;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.crawler.connectors.livelink.LLSERVER;
import org.apache.manifoldcf.crawler.connectors.livelink.MatchMap;
import org.apache.manifoldcf.crawler.connectors.livelink.Messages;
import org.apache.manifoldcf.ui.util.Encoder;

public class LivelinkAuthority
extends BaseAuthorityConnector {
    public static final String _rcsid = "@(#)$Id: LivelinkAuthority.java 988245 2010-08-23 18:39:35Z kwright $";
    private boolean hasSessionParameters = false;
    private boolean hasConnected = false;
    private long expirationTime = -1L;
    private static final long expirationInterval = 300000L;
    private String serverProtocol = null;
    private String serverName = null;
    private int serverPort = -1;
    private String serverUsername = null;
    private String serverPassword = null;
    private String serverHTTPCgi = null;
    private String serverHTTPNTLMDomain = null;
    private String serverHTTPNTLMUsername = null;
    private String serverHTTPNTLMPassword = null;
    private IKeystoreManager serverHTTPSKeystore = null;
    private LAPI_USERS LLUsers = null;
    private LLSERVER llServer = null;
    private String cacheLifetime = null;
    private String cacheLRUsize = null;
    private long responseLifetime = 60000L;
    private int LRUsize = 1000;
    private MatchMap matchMap = null;
    private static final int FAILURE_RETRY_COUNT = 5;
    protected ICacheManager cacheManager = null;
    protected static StringSet emptyStringSet = new StringSet();

    public void setThreadContext(IThreadContext tc) throws ManifoldCFException {
        super.setThreadContext(tc);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)tc);
    }

    public void clearThreadContext() {
        super.clearThreadContext();
        this.cacheManager = null;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
    }

    protected void getSessionParameters() throws ManifoldCFException {
        if (!this.hasSessionParameters) {
            String serverHTTPSKeystoreData;
            this.serverProtocol = this.params.getParameter("Server protocol");
            this.serverName = this.params.getParameter("Server name");
            String serverPortString = this.params.getParameter("Server port");
            this.serverUsername = this.params.getParameter("Server user name");
            this.serverPassword = this.params.getObfuscatedParameter("Server password");
            this.serverHTTPCgi = this.params.getParameter("Server HTTP CGI path");
            this.serverHTTPNTLMDomain = this.params.getParameter("Server HTTP NTLM domain");
            this.serverHTTPNTLMUsername = this.params.getParameter("Server HTTP NTLM user name");
            this.serverHTTPNTLMPassword = this.params.getObfuscatedParameter("Server HTTP NTLM password");
            String userNamePattern = this.params.getParameter("User name regexp");
            String userEvalExpression = this.params.getParameter("Livelink user spec");
            String userNameMapping = this.params.getParameter("Livelink user name map");
            if ((userNameMapping == null || userNameMapping.length() == 0) && userNamePattern != null && userEvalExpression != null) {
                this.matchMap = new MatchMap();
                this.matchMap.appendOldstyleMatchPair(userNamePattern, userEvalExpression);
            } else {
                if (userNameMapping == null) {
                    userNameMapping = "(.*)\\\\@([A-Z|a-z|0-9|_|-]*)\\\\.(.*)=$(2)\\$(1l)";
                }
                this.matchMap = new MatchMap(userNameMapping);
            }
            if (this.serverProtocol == null || this.serverProtocol.length() == 0) {
                this.serverProtocol = "internal";
            }
            this.serverPort = serverPortString == null ? 2099 : new Integer(serverPortString);
            if (this.serverHTTPNTLMDomain != null && this.serverHTTPNTLMDomain.length() == 0) {
                this.serverHTTPNTLMDomain = null;
            }
            if (this.serverHTTPNTLMUsername == null || this.serverHTTPNTLMUsername.length() == 0) {
                this.serverHTTPNTLMUsername = null;
                this.serverHTTPNTLMPassword = null;
            }
            if ((serverHTTPSKeystoreData = this.params.getParameter("Server HTTPS truststore")) != null) {
                this.serverHTTPSKeystore = KeystoreManagerFactory.make((String)"", (String)serverHTTPSKeystoreData);
            }
            this.cacheLifetime = this.params.getParameter("Cache lifetime minutes");
            if (this.cacheLifetime == null) {
                this.cacheLifetime = "1";
            }
            this.cacheLRUsize = this.params.getParameter("Max cache LRU size");
            if (this.cacheLRUsize == null) {
                this.cacheLRUsize = "1000";
            }
            try {
                this.responseLifetime = Long.parseLong(this.cacheLifetime) * 60L * 1000L;
                this.LRUsize = Integer.parseInt(this.cacheLRUsize);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Cache lifetime or Cache LRU size must be an integer: " + e.getMessage(), (Throwable)e);
            }
            if (Logging.authorityConnectors.isDebugEnabled()) {
                String passwordExists = this.serverPassword != null && this.serverPassword.length() > 0 ? "password exists" : "";
                Logging.authorityConnectors.debug((Object)("Livelink: Livelink connection parameters: Server='" + this.serverName + "'; port='" + this.serverPort + "'; user name='" + this.serverUsername + "'; " + passwordExists));
            }
            this.hasSessionParameters = true;
        }
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        this.getSessionParameters();
        if (!this.hasConnected) {
            int sanityRetryCount = 5;
            while (true) {
                try {
                    this.llServer = new LLSERVER(!this.serverProtocol.equals("internal"), this.serverProtocol.equals("https"), this.serverName, this.serverPort, this.serverUsername, this.serverPassword, this.serverHTTPCgi, this.serverHTTPNTLMDomain, this.serverHTTPNTLMUsername, this.serverHTTPNTLMPassword, this.serverHTTPSKeystore);
                    this.LLUsers = new LAPI_USERS((LLConnect)this.llServer.getLLSession());
                    if (Logging.authorityConnectors.isDebugEnabled()) {
                        Logging.authorityConnectors.debug((Object)"Livelink: Livelink session created.");
                    }
                    this.hasConnected = true;
                }
                catch (RuntimeException e) {
                    sanityRetryCount = this.handleLivelinkRuntimeException(e, sanityRetryCount);
                    continue;
                }
                break;
            }
        }
        this.expirationTime = System.currentTimeMillis() + 300000L;
    }

    public String check() throws ManifoldCFException {
        try {
            this.hasConnected = false;
            this.getSession();
            int sanityRetryCount = 5;
            while (true) {
                try {
                    LLValue userObject = new LLValue();
                    int status = this.LLUsers.GetUserInfo("Admin", userObject);
                    if (status == 103101 || status == 401203) {
                        return super.check();
                    }
                    if (status != 0) {
                        return "Connection failed: User authentication failed";
                    }
                    return super.check();
                }
                catch (RuntimeException e) {
                    sanityRetryCount = this.handleLivelinkRuntimeException(e, sanityRetryCount);
                    continue;
                }
                break;
            }
        }
        catch (ServiceInterruption e) {
            return "Temporary service interruption: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    public void poll() throws ManifoldCFException {
        if (!this.hasConnected) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.expirationTime) {
            this.hasConnected = false;
            this.expirationTime = -1L;
            if (this.llServer != null) {
                this.llServer.disconnect();
                this.llServer = null;
            }
            this.LLUsers = null;
        }
    }

    public boolean isConnected() {
        return this.hasConnected;
    }

    public void disconnect() throws ManifoldCFException {
        this.hasSessionParameters = false;
        this.hasConnected = false;
        this.expirationTime = -1L;
        if (this.llServer != null) {
            this.llServer.disconnect();
            this.llServer = null;
        }
        this.LLUsers = null;
        this.matchMap = null;
        this.serverProtocol = null;
        this.serverName = null;
        this.serverPort = -1;
        this.serverUsername = null;
        this.serverPassword = null;
        this.serverHTTPCgi = null;
        this.serverHTTPNTLMDomain = null;
        this.serverHTTPNTLMUsername = null;
        this.serverHTTPNTLMPassword = null;
        this.serverHTTPSKeystore = null;
        this.cacheLifetime = null;
        this.cacheLRUsize = null;
        super.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        this.getSessionParameters();
        AuthorizationResponseDescription objectDescription = new AuthorizationResponseDescription(userName, this.serverProtocol, this.serverName, this.serverPort, this.serverUsername, this.serverPassword, this.serverHTTPCgi, this.serverHTTPNTLMDomain, this.serverHTTPNTLMUsername, this.serverHTTPNTLMPassword, this.serverHTTPSKeystore, this.responseLifetime, this.LRUsize);
        ICacheHandle ch = this.cacheManager.enterCache(new ICacheDescription[]{objectDescription}, null, null);
        try {
            AuthorizationResponse response;
            ICacheCreateHandle createHandle;
            block8: {
                AuthorizationResponse authorizationResponse;
                createHandle = this.cacheManager.enterCreateSection(ch);
                try {
                    response = (AuthorizationResponse)this.cacheManager.lookupObject(createHandle, (ICacheDescription)objectDescription);
                    if (response == null) break block8;
                    authorizationResponse = response;
                }
                catch (Throwable throwable) {
                    this.cacheManager.leaveCreateSection(createHandle);
                    throw throwable;
                }
                this.cacheManager.leaveCreateSection(createHandle);
                return authorizationResponse;
            }
            response = this.getAuthorizationResponseUncached(userName);
            this.cacheManager.saveObject(createHandle, (ICacheDescription)objectDescription, (Object)response);
            AuthorizationResponse authorizationResponse = response;
            this.cacheManager.leaveCreateSection(createHandle);
            return authorizationResponse;
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    protected AuthorizationResponse getAuthorizationResponseUncached(String userName) throws ManifoldCFException {
        try {
            this.getSession();
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Authentication user name = '" + userName + "'"));
            }
            String domainAndUser = this.matchMap.translate(userName);
            if (Logging.authorityConnectors.isDebugEnabled()) {
                Logging.authorityConnectors.debug((Object)("Livelink: Livelink user name = '" + domainAndUser + "'"));
            }
            int sanityRetryCount = 5;
            while (true) {
                try {
                    int j;
                    LLValue childrenObjects;
                    ArrayList<String> list = new ArrayList<String>();
                    LLValue userObject = new LLValue();
                    int status = this.LLUsers.GetUserInfo(domainAndUser, userObject);
                    if (status == 103101 || status == 401203) {
                        if (Logging.authorityConnectors.isDebugEnabled()) {
                            Logging.authorityConnectors.debug((Object)("Livelink: Livelink user '" + domainAndUser + "' does not exist"));
                        }
                        return RESPONSE_USERNOTFOUND;
                    }
                    if (status != 0) {
                        Logging.authorityConnectors.warn((Object)("Livelink: User '" + domainAndUser + "' GetUserInfo error # " + Integer.toString(status) + " " + this.llServer.getErrors()));
                        return RESPONSE_UNREACHABLE;
                    }
                    int deleted = userObject.toInteger("Deleted");
                    if (deleted == 1) {
                        if (Logging.authorityConnectors.isDebugEnabled()) {
                            Logging.authorityConnectors.debug((Object)("Livelink: Livelink user '" + domainAndUser + "' has been deleted"));
                        }
                        return RESPONSE_USERNOTFOUND;
                    }
                    int privs = userObject.toInteger("UserPrivileges");
                    if ((privs & 0x800) == 2048) {
                        list.add("GUEST");
                    }
                    if ((privs & 0x100) == 256) {
                        list.add("SYSTEM");
                    }
                    if ((status = this.LLUsers.ListRights(0, domainAndUser, childrenObjects = new LLValue())) == 103101 || status == 401203) {
                        if (Logging.authorityConnectors.isDebugEnabled()) {
                            Logging.authorityConnectors.debug((Object)("Livelink: Livelink error looking up user rights for '" + domainAndUser + "' - user does not exist"));
                        }
                        return RESPONSE_USERNOTFOUND;
                    }
                    if (status != 0) {
                        Logging.authorityConnectors.warn((Object)("Livelink: For user '" + domainAndUser + "', ListRights error # " + Integer.toString(status) + " " + this.llServer.getErrors()));
                        return RESPONSE_UNREACHABLE;
                    }
                    int size = childrenObjects.isRecord() ? 1 : (childrenObjects.isTable() ? childrenObjects.size() : 0);
                    for (j = 0; j < size; ++j) {
                        int token = childrenObjects.toInteger(j, "ID");
                        list.add(Integer.toString(token));
                    }
                    String[] rval = new String[list.size()];
                    for (j = 0; j < rval.length; ++j) {
                        rval[j] = (String)list.get(j);
                    }
                    return new AuthorizationResponse(rval, 0);
                }
                catch (RuntimeException e) {
                    sanityRetryCount = this.handleLivelinkRuntimeException(e, sanityRetryCount);
                    continue;
                }
                break;
            }
        }
        catch (ServiceInterruption e) {
            Logging.authorityConnectors.warn((Object)("Livelink: Server seems to be down: " + e.getMessage()), (Throwable)e);
            return RESPONSE_UNREACHABLE;
        }
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return RESPONSE_UNREACHABLE;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "LivelinkConnector.Server"));
        tabsArray.add(Messages.getString(locale, "LivelinkConnector.UserMapping"));
        tabsArray.add(Messages.getString(locale, "LivelinkConnector.Cache"));
        out.print("<script type=\"text/javascript\">\n<!--\nfunction ServerDeleteCertificate(aliasName)\n{\n  editconnection.serverkeystorealias.value = aliasName;\n  editconnection.serverconfigop.value = \"Delete\";\n  postForm();\n}\n\nfunction ServerAddCertificate()\n{\n  if (editconnection.servercertificate.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.ChooseACertificateFile") + "\");\n" + "    editconnection.servercertificate.focus();\n" + "  }\n" + "  else\n" + "  {\n" + "    editconnection.serverconfigop.value = \"Add\";\n" + "    postForm();\n" + "  }\n" + "}\n" + "\n" + "function checkConfig()\n" + "{\n" + "  if (editconnection.serverport.value != \"\" && !isInteger(editconnection.serverport.value))\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.AValidNumberIsRequired") + "\");\n" + "    editconnection.serverport.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.usernameregexp.value != \"\" && !isRegularExpression(editconnection.usernameregexp.value))\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.UserNameRegularExpressionMustBeValidRegularExpression") + "\");\n" + "    editconnection.usernameregexp.focus();\n" + "    return false;\n" + "  }\n" + "  return true;\n" + "}\n" + "\n" + "function checkConfigForSave()\n" + "{\n" + "  if (editconnection.servername.value == \"\")\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.EnterALivelinkServerName") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.Server") + "\");\n" + "    editconnection.servername.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.serverport.value == \"\")\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.AServerPortNumberIsRequired") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.Server") + "\");\n" + "    editconnection.serverport.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.usernameregexp.value == \"\")\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.UserNameRegularExpressionCannotBeNull") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.UserMapping") + "\");\n" + "    editconnection.usernameregexp.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.cachelifetime.value == \"\")\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.CacheLifetimeCannotBeNull") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.Cache") + "\");\n" + "    editconnection.cachelifetime.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.cachelifetime.value != \"\" && !isInteger(editconnection.cachelifetime.value))\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.CacheLifetimeMustBeAnInteger") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.Cache") + "\");\n" + "    editconnection.cachelifetime.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.cachelrusize.value == \"\")\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.CacheLRUSizeCannotBeNull") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.Cache") + "\");\n" + "    editconnection.cachelrusize.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.cachelrusize.value != \"\" && !isInteger(editconnection.cachelrusize.value))\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.CacheLRUSizeMustBeAnInteger") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "LivelinkConnector.Cache") + "\");\n" + "    editconnection.cachelrusize.focus();\n" + "    return false;\n" + "  }\n" + "  return true;\n" + "}\n" + "\n" + "//-->\n" + "</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String cacheLRUsize;
        String serverHTTPNTLMPassword;
        String serverHTTPNTLMUserName;
        String serverHTTPNTLMDomain;
        String serverPassword;
        String serverUserName;
        String serverPort;
        String serverName;
        String serverProtocol = parameters.getParameter("Server protocol");
        if (serverProtocol == null) {
            serverProtocol = "internal";
        }
        if ((serverName = parameters.getParameter("Server name")) == null) {
            serverName = "localhost";
        }
        if ((serverPort = parameters.getParameter("Server port")) == null) {
            serverPort = "2099";
        }
        if ((serverUserName = parameters.getParameter("Server user name")) == null) {
            serverUserName = "";
        }
        serverPassword = (serverPassword = parameters.getObfuscatedParameter("Server password")) == null ? "" : out.mapPasswordToKey(serverPassword);
        String serverHTTPCgiPath = parameters.getParameter("Server HTTP CGI path");
        if (serverHTTPCgiPath == null) {
            serverHTTPCgiPath = "/livelink/livelink.exe";
        }
        if ((serverHTTPNTLMDomain = parameters.getParameter("Server HTTP NTLM domain")) == null) {
            serverHTTPNTLMDomain = "";
        }
        if ((serverHTTPNTLMUserName = parameters.getParameter("Server HTTP NTLM user name")) == null) {
            serverHTTPNTLMUserName = "";
        }
        serverHTTPNTLMPassword = (serverHTTPNTLMPassword = parameters.getObfuscatedParameter("Server HTTP NTLM password")) == null ? "" : out.mapPasswordToKey(serverHTTPNTLMPassword);
        String serverHTTPSKeystore = parameters.getParameter("Server HTTPS truststore");
        IKeystoreManager localServerHTTPSKeystore = serverHTTPSKeystore == null ? KeystoreManagerFactory.make((String)"") : KeystoreManagerFactory.make((String)"", (String)serverHTTPSKeystore);
        String cacheLifetime = parameters.getParameter("Cache lifetime minutes");
        if (cacheLifetime == null) {
            cacheLifetime = "1";
        }
        if ((cacheLRUsize = parameters.getParameter("Max cache LRU size")) == null) {
            cacheLRUsize = "1000";
        }
        MatchMap matchMap = null;
        String usernameRegexp = parameters.getParameter("User name regexp");
        String livelinkUserExpr = parameters.getParameter("Livelink user spec");
        if (usernameRegexp != null && usernameRegexp.length() > 0 && livelinkUserExpr != null) {
            matchMap = new MatchMap();
            matchMap.appendOldstyleMatchPair(usernameRegexp, livelinkUserExpr);
        } else {
            String userNameMapping = parameters.getParameter("Livelink user name map");
            if (userNameMapping == null) {
                userNameMapping = "^(.*)\\\\@([A-Z|a-z|0-9|_|-]*)\\\\.(.*)$=$(2)\\\\$(1l)";
            }
            matchMap = new MatchMap(userNameMapping);
        }
        usernameRegexp = matchMap.getMatchString(0);
        livelinkUserExpr = matchMap.getReplaceString(0);
        out.print("<input name=\"serverconfigop\" type=\"hidden\" value=\"Continue\"/>\n");
        if (serverHTTPSKeystore != null) {
            out.print("<input type=\"hidden\" name=\"serverhttpskeystoredata\" value=\"" + Encoder.attributeEscape((String)serverHTTPSKeystore) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "LivelinkConnector.Server"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\">" + Messages.getBodyString(locale, "LivelinkConnector.ServerProtocol") + "</td>\n" + "    <td class=\"value\">\n" + "      <select name=\"serverprotocol\" size=\"2\">\n" + "        <option value=\"internal\" " + (serverProtocol.equals("internal") ? "selected=\"selected\"" : "") + ">" + Messages.getBodyString(locale, "LivelinkConnector.internal") + "</option>\n" + "        <option value=\"http\" " + (serverProtocol.equals("http") ? "selected=\"selected\"" : "") + ">http</option>\n" + "        <option value=\"https\" " + (serverProtocol.equals("https") ? "selected=\"selected\"" : "") + ">https</option>\n" + "      </select>\n" + "    </td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LivelinkConnector.ServerName") + "</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"64\" name=\"servername\" value=\"" + Encoder.attributeEscape((String)serverName) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LivelinkConnector.ServerPort") + "</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"serverport\" value=\"" + serverPort + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LivelinkConnector.ServerUserName") + "</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"serverusername\" value=\"" + Encoder.attributeEscape((String)serverUserName) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LivelinkConnector.ServerPassword") + "</nobr></td>\n" + "    <td class=\"value\"><input type=\"password\" size=\"32\" name=\"serverpassword\" value=\"" + Encoder.attributeEscape((String)serverPassword) + "\"/></td>\n" + "  </tr>\n" + "  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LivelinkConnector.ServerHTTPCGIPath") + "</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"serverhttpcgipath\" value=\"" + Encoder.attributeEscape((String)serverHTTPCgiPath) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LivelinkConnector.ServerHTTPNTLMDomain") + "</nobr><br/><nobr>" + Messages.getBodyString(locale, "LivelinkConnector.SetIfNTLMAuthDesired") + "</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input type=\"text\" size=\"32\" name=\"serverhttpntlmdomain\" value=\"" + Encoder.attributeEscape((String)serverHTTPNTLMDomain) + "\"/>\n" + "    </td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LivelinkConnector.ServerHTTPNTLMUserName") + "</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input type=\"text\" size=\"32\" name=\"serverhttpntlmusername\" value=\"" + Encoder.attributeEscape((String)serverHTTPNTLMUserName) + "\"/>\n" + "    </td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LivelinkConnector.ServerHTTPNTLMPassword") + "</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input type=\"password\" size=\"32\" name=\"serverhttpntlmpassword\" value=\"" + Encoder.attributeEscape((String)serverHTTPNTLMPassword) + "\"/>\n" + "    </td>\n" + "  </tr>\n" + "  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            out.print("  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LivelinkConnector.ServerSSLCertificateList") + "</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input type=\"hidden\" name=\"serverkeystorealias\" value=\"\"/>\n" + "      <table class=\"displaytable\">\n");
            String[] contents = localServerHTTPSKeystore.getContents();
            if (contents.length == 0) {
                out.print("        <tr><td class=\"message\" colspan=\"2\"><nobr>" + Messages.getBodyString(locale, "LivelinkConnector.NoCertificatesPresent") + "</nobr></td></tr>\n");
            } else {
                for (int i = 0; i < contents.length; ++i) {
                    String alias = contents[i];
                    String description = localServerHTTPSKeystore.getDescription(alias);
                    if (description.length() > 128) {
                        description = description.substring(0, 125) + "...";
                    }
                    out.print("        <tr>\n          <td class=\"value\"><input type=\"button\" onclick='Javascript:ServerDeleteCertificate(\"" + Encoder.attributeJavascriptEscape((String)alias) + "\")' alt=\"" + Messages.getAttributeString(locale, "LivelinkConnector.DeleteCert") + Encoder.attributeEscape((String)alias) + "\" value=\"" + Messages.getAttributeString(locale, "LivelinkConnector.Delete") + "\"/></td>\n" + "          <td>" + Encoder.bodyEscape((String)description) + "</td>\n" + "        </tr>\n");
                }
            }
            out.print("      </table>\n      <input type=\"button\" onclick='Javascript:ServerAddCertificate()' alt=\"" + Messages.getAttributeString(locale, "LivelinkConnector.AddCert") + "\" value=\"" + Messages.getAttributeString(locale, "LivelinkConnector.Add") + "\"/>&nbsp;\n" + "      " + Messages.getBodyString(locale, "LivelinkConnector.Certificate") + "<input name=\"servercertificate\" size=\"50\" type=\"file\"/>\n" + "    </td>\n" + "  </tr>\n");
            out.print("</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"serverprotocol\" value=\"" + serverProtocol + "\"/>\n" + "<input type=\"hidden\" name=\"servername\" value=\"" + Encoder.attributeEscape((String)serverName) + "\"/>\n" + "<input type=\"hidden\" name=\"serverport\" value=\"" + serverPort + "\"/>\n" + "<input type=\"hidden\" name=\"serverusername\" value=\"" + Encoder.attributeEscape((String)serverUserName) + "\"/>\n" + "<input type=\"hidden\" name=\"serverpassword\" value=\"" + Encoder.attributeEscape((String)serverPassword) + "\"/>\n" + "<input type=\"hidden\" name=\"serverhttpcgipath\" value=\"" + Encoder.attributeEscape((String)serverHTTPCgiPath) + "\"/>\n" + "<input type=\"hidden\" name=\"serverhttpntlmdomain\" value=\"" + Encoder.attributeEscape((String)serverHTTPNTLMDomain) + "\"/>\n" + "<input type=\"hidden\" name=\"serverhttpntlmusername\" value=\"" + Encoder.attributeEscape((String)serverHTTPNTLMUserName) + "\"/>\n" + "<input type=\"hidden\" name=\"serverhttpntlmpassword\" value=\"" + Encoder.attributeEscape((String)serverHTTPNTLMPassword) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "LivelinkConnector.UserMapping"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LivelinkConnector.UserNameRegularExpression") + "</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"40\" name=\"usernameregexp\" value=\"" + Encoder.attributeEscape((String)usernameRegexp) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LivelinkConnector.LivelinkUserExpression") + "</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"40\" name=\"livelinkuserexpr\" value=\"" + Encoder.attributeEscape((String)livelinkUserExpr) + "\"/></td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"usernameregexp\" value=\"" + Encoder.attributeEscape((String)usernameRegexp) + "\"/>\n" + "<input type=\"hidden\" name=\"livelinkuserexpr\" value=\"" + Encoder.attributeEscape((String)livelinkUserExpr) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "LivelinkConnector.Cache"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LivelinkConnector.CacheLifetime") + "</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"cachelifetime\" value=\"" + Encoder.attributeEscape((String)cacheLifetime) + "\"/> " + Messages.getBodyString(locale, "LivelinkConnector.minutes") + "</td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LivelinkConnector.CacheLRUSize") + "</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"cachelrusize\" value=\"" + Encoder.attributeEscape((String)cacheLRUsize) + "\"/></td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"cachelifetime\" value=\"" + Encoder.attributeEscape((String)cacheLifetime) + "\"/>\n" + "<input type=\"hidden\" name=\"cachelrusize\" value=\"" + Encoder.attributeEscape((String)cacheLRUsize) + "\"/>\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String cacheLRUsize;
        String cacheLifetime;
        String serverConfigOp;
        String serverHTTPSKeystoreValue;
        String serverHTTPNTLMPassword;
        String serverHTTPNTLMUserName;
        String serverHTTPNTLMDomain;
        String serverHTTPCgiPath;
        String serverPassword;
        String serverUserName;
        String serverPort;
        String serverName;
        String serverProtocol = variableContext.getParameter("serverprotocol");
        if (serverProtocol != null) {
            parameters.setParameter("Server protocol", serverProtocol);
        }
        if ((serverName = variableContext.getParameter("servername")) != null) {
            parameters.setParameter("Server name", serverName);
        }
        if ((serverPort = variableContext.getParameter("serverport")) != null) {
            parameters.setParameter("Server port", serverPort);
        }
        if ((serverUserName = variableContext.getParameter("serverusername")) != null) {
            parameters.setParameter("Server user name", serverUserName);
        }
        if ((serverPassword = variableContext.getParameter("serverpassword")) != null) {
            parameters.setObfuscatedParameter("Server password", variableContext.mapKeyToPassword(serverPassword));
        }
        if ((serverHTTPCgiPath = variableContext.getParameter("serverhttpcgipath")) != null) {
            parameters.setParameter("Server HTTP CGI path", serverHTTPCgiPath);
        }
        if ((serverHTTPNTLMDomain = variableContext.getParameter("serverhttpntlmdomain")) != null) {
            parameters.setParameter("Server HTTP NTLM domain", serverHTTPNTLMDomain);
        }
        if ((serverHTTPNTLMUserName = variableContext.getParameter("serverhttpntlmusername")) != null) {
            parameters.setParameter("Server HTTP NTLM user name", serverHTTPNTLMUserName);
        }
        if ((serverHTTPNTLMPassword = variableContext.getParameter("serverhttpntlmpassword")) != null) {
            parameters.setObfuscatedParameter("Server HTTP NTLM password", variableContext.mapKeyToPassword(serverHTTPNTLMPassword));
        }
        if ((serverHTTPSKeystoreValue = variableContext.getParameter("serverhttpskeystoredata")) != null) {
            parameters.setParameter("Server HTTPS truststore", serverHTTPSKeystoreValue);
        }
        if ((serverConfigOp = variableContext.getParameter("serverconfigop")) != null) {
            String alias;
            if (serverConfigOp.equals("Delete")) {
                alias = variableContext.getParameter("serverkeystorealias");
                serverHTTPSKeystoreValue = parameters.getParameter("Server HTTPS truststore");
                IKeystoreManager mgr = serverHTTPSKeystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)serverHTTPSKeystoreValue) : KeystoreManagerFactory.make((String)"");
                mgr.remove(alias);
                parameters.setParameter("Server HTTPS truststore", mgr.getString());
            } else if (serverConfigOp.equals("Add")) {
                alias = IDFactory.make((IThreadContext)threadContext);
                byte[] certificateValue = variableContext.getBinaryBytes("servercertificate");
                serverHTTPSKeystoreValue = parameters.getParameter("Server HTTPS truststore");
                IKeystoreManager mgr = serverHTTPSKeystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)serverHTTPSKeystoreValue) : KeystoreManagerFactory.make((String)"");
                ByteArrayInputStream is = new ByteArrayInputStream(certificateValue);
                String certError = null;
                try {
                    mgr.importCertificate(alias, (InputStream)is);
                }
                catch (Throwable e) {
                    certError = e.getMessage();
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {}
                }
                if (certError != null) {
                    return "Illegal certificate: " + certError;
                }
                parameters.setParameter("Server HTTPS truststore", mgr.getString());
            }
        }
        String usernameRegexp = variableContext.getParameter("usernameregexp");
        String livelinkUserExpr = variableContext.getParameter("livelinkuserexpr");
        if (usernameRegexp != null && livelinkUserExpr != null) {
            parameters.setParameter("User name regexp", null);
            parameters.setParameter("Livelink user spec", null);
            MatchMap matchMap = new MatchMap();
            matchMap.appendMatchPair(usernameRegexp, livelinkUserExpr);
            parameters.setParameter("Livelink user name map", matchMap.toString());
        }
        if ((cacheLifetime = variableContext.getParameter("cachelifetime")) != null) {
            parameters.setParameter("Cache lifetime minutes", cacheLifetime);
        }
        if ((cacheLRUsize = variableContext.getParameter("cachelrusize")) != null) {
            parameters.setParameter("Max cache LRU size", cacheLRUsize);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "LivelinkConnector.Parameters") + "</nobr></td>\n" + "    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore") || param.length() > "truststore".length() && param.substring(param.length() - "truststore".length()).equalsIgnoreCase("truststore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=&lt;" + Integer.toString(kmanager.getContents().length) + " certificate(s)&gt;</nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n</table>\n");
    }

    protected int handleLivelinkRuntimeException(RuntimeException e, int sanityRetryCount) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof LLHTTPAccessDeniedException || e instanceof LLHTTPClientException || e instanceof LLHTTPServerException || e instanceof LLIndexOutOfBoundsException || e instanceof LLNoFieldSpecifiedException || e instanceof LLNoValueSpecifiedException || e instanceof LLSecurityProviderException || e instanceof LLUnknownFieldException) {
            String details = this.llServer.getErrors();
            throw new ManifoldCFException("Livelink API error: " + e.getMessage() + (details == null ? "" : "; " + details), (Throwable)e, 5);
        }
        if (e instanceof LLBadServerCertificateException || e instanceof LLHTTPCGINotFoundException || e instanceof LLCouldNotConnectHTTPException || e instanceof LLHTTPForbiddenException || e instanceof LLHTTPProxyAuthRequiredException || e instanceof LLHTTPRedirectionException || e instanceof LLUnsupportedAuthMethodException || e instanceof LLWebAuthInitException) {
            String details = this.llServer.getErrors();
            throw new ManifoldCFException("Livelink API error: " + e.getMessage() + (details == null ? "" : "; " + details), (Throwable)e);
        }
        if (e instanceof LLSSLNotAvailableException) {
            String details = this.llServer.getErrors();
            throw new ManifoldCFException("Missing llssl.jar error: " + e.getMessage() + (details == null ? "" : "; " + details), (Throwable)e);
        }
        if (e instanceof LLIllegalOperationException) {
            String details = this.llServer.getErrors();
            return LivelinkAuthority.assessRetry(sanityRetryCount, new ManifoldCFException("Livelink API illegal operation error: " + e.getMessage() + (details == null ? "" : "; " + details), (Throwable)e));
        }
        if (e instanceof LLIOException || e instanceof RuntimeException && e.getClass().getName().startsWith("com.opentext.api.")) {
            try {
                InetAddress.getByName(this.serverName);
            }
            catch (UnknownHostException e2) {
                throw new ManifoldCFException("Server name '" + this.serverName + "' cannot be resolved", (Throwable)e2);
            }
            throw new ServiceInterruption("Transient error: " + e.getMessage(), (Throwable)e, System.currentTimeMillis() + 300000L, System.currentTimeMillis() + 43200000L, -1, true);
        }
        throw e;
    }

    protected static int assessRetry(int sanityRetryCount, ManifoldCFException e) throws ManifoldCFException {
        if (sanityRetryCount == 0) {
            throw e;
        }
        --sanityRetryCount;
        try {
            ManifoldCF.sleep((long)1000L);
        }
        catch (InterruptedException e2) {
            throw new ManifoldCFException(e2.getMessage(), (Throwable)e2, 2);
        }
        return sanityRetryCount;
    }

    protected static class AuthorizationResponseDescription
    extends BaseDescription {
        protected final String userName;
        protected final String serverProtocol;
        protected final String serverName;
        protected final int serverPort;
        protected final String serverUsername;
        protected final String serverPassword;
        protected final String serverHTTPCgi;
        protected final String serverHTTPNTLMDomain;
        protected final String serverHTTPNTLMUsername;
        protected final String serverHTTPNTLMPassword;
        protected final String serverHTTPSKeystore;
        protected long responseLifetime;
        protected long expirationTime = -1L;

        public AuthorizationResponseDescription(String userName, String serverProtocol, String serverName, int serverPort, String serverUsername, String serverPassword, String serverHTTPCgi, String serverHTTPNTLMDomain, String serverHTTPNTLMUsername, String serverHTTPNTLMPassword, IKeystoreManager serverHTTPSKeystore, long responseLifetime, int LRUsize) throws ManifoldCFException {
            super("LiveLinkAuthority", LRUsize);
            this.userName = userName;
            this.serverProtocol = serverProtocol;
            this.serverName = serverName;
            this.serverPort = serverPort;
            this.serverUsername = serverUsername;
            this.serverPassword = serverPassword;
            this.serverHTTPCgi = serverHTTPCgi == null ? "" : serverHTTPCgi;
            this.serverHTTPNTLMDomain = serverHTTPNTLMDomain == null ? "" : serverHTTPNTLMDomain;
            this.serverHTTPNTLMUsername = serverHTTPNTLMUsername == null ? "" : serverHTTPNTLMUsername;
            this.serverHTTPNTLMPassword = serverHTTPNTLMPassword == null ? "" : serverHTTPNTLMPassword;
            this.serverHTTPSKeystore = serverHTTPSKeystore != null ? serverHTTPSKeystore.getString() : null;
            this.responseLifetime = responseLifetime;
        }

        public StringSet getObjectKeys() {
            return emptyStringSet;
        }

        public String getCriticalSectionName() {
            return ((Object)((Object)this)).getClass().getName() + "-" + this.userName + "-" + this.serverProtocol + "-" + this.serverName + "-" + Integer.toString(this.serverPort) + "-" + this.serverUsername + "-" + this.serverPassword + "-" + this.serverHTTPCgi + "-" + this.serverHTTPNTLMDomain + "-" + this.serverHTTPNTLMUsername + "-" + this.serverHTTPNTLMPassword + "-" + (this.serverHTTPSKeystore == null ? "" : this.serverHTTPSKeystore);
        }

        public long getObjectExpirationTime(long currentTime) {
            if (this.expirationTime == -1L) {
                this.expirationTime = currentTime + this.responseLifetime;
            }
            return this.expirationTime;
        }

        public int hashCode() {
            return this.userName.hashCode() + this.serverProtocol.hashCode() + this.serverName.hashCode() + new Integer(this.serverPort).hashCode() + this.serverUsername.hashCode() + this.serverPassword.hashCode() + this.serverHTTPCgi.hashCode() + this.serverHTTPNTLMDomain.hashCode() + this.serverHTTPNTLMUsername.hashCode() + this.serverHTTPNTLMPassword.hashCode() + (this.serverHTTPSKeystore == null ? 0 : this.serverHTTPSKeystore.hashCode());
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuthorizationResponseDescription)) {
                return false;
            }
            AuthorizationResponseDescription ard = (AuthorizationResponseDescription)((Object)o);
            return ard.userName.equals(this.userName) && ard.serverProtocol.equals(this.serverProtocol) && ard.serverName.equals(this.serverName) && ard.serverPort == this.serverPort && ard.serverUsername.equals(this.serverUsername) && ard.serverPassword.equals(this.serverPassword) && ard.serverHTTPCgi.equals(this.serverHTTPCgi) && ard.serverHTTPNTLMDomain.equals(this.serverHTTPNTLMDomain) && ard.serverHTTPNTLMUsername.equals(this.serverHTTPNTLMUsername) && ard.serverHTTPNTLMPassword.equals(this.serverHTTPNTLMPassword) && (ard.serverHTTPSKeystore != null && this.serverHTTPSKeystore != null && ard.serverHTTPSKeystore.equals(this.serverHTTPSKeystore) || (ard.serverHTTPSKeystore == null || this.serverHTTPSKeystore == null) && ard.serverHTTPSKeystore == this.serverHTTPSKeystore);
        }
    }
}

