/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.mahout.utils.vectors.arff;

import java.io.IOException;
import java.io.StringWriter;

import com.google.common.io.Resources;
import org.apache.commons.io.Charsets;
import org.apache.mahout.common.MahoutTestCase;
import org.junit.Test;

/**
 * Test case for {@link Driver}
 */
public class DriverTest extends MahoutTestCase {

  @Test
  public void dictionary() throws IOException {

    ARFFModel model = new MapBackedARFFModel();
    ARFFVectorIterableTest.getVectors("sample-dense.arff", model);
    StringWriter writer = new StringWriter();
    Driver.writeLabelBindings(writer, model, ",");
    String expected1 = Resources.toString(Resources.getResource("expected-arff-dictionary.csv"), Charsets.UTF_8);
    String expected2 = Resources.toString(Resources.getResource("expected-arff-dictionary-2.csv"), Charsets.UTF_8);
    assertTrue(expected1.equals(writer.toString()) || expected2.equals(writer.toString()));
  }


  @Test
  public void dictionaryJSON() throws IOException {
    ARFFModel model = new MapBackedARFFModel();
    ARFFVectorIterableTest.getVectors("sample-dense.arff", model);
    StringWriter writer = new StringWriter();
    Driver.writeLabelBindingsJSON(writer, model);
    String expected1 = Resources.toString(Resources.getResource("expected-arff-schema.json"), Charsets.UTF_8);
    String expected2 = Resources.toString(Resources.getResource("expected-arff-schema-2.json"), Charsets.UTF_8);
    assertTrue(expected1.equals(writer.toString()) || expected2.equals(writer.toString()));
  }
}
