/* ----------------------------------------------------------------------- *//**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *//* ----------------------------------------------------------------------- */


DROP TABLE IF EXISTS abalone;
CREATE TABLE abalone (
        id integer,
        sex char(1),
        length float,
        diameter float,
        height float,
        whole_weight float,
        shucked_weight float,
        viscera_weight float,
        shell_weight float,
        rings integer
    );


INSERT INTO abalone VALUES
(1,'M',0.455,0.365,0.095,0.514,0.2245,0.101,0.15,15),
(2,'M',0.35,0.265,0.09,0.2255,0.0995,0.0485,0.07,7),
(3,'F',0.53,0.42,0.135,0.677,0.2565,0.1415,0.21,9),
(4,'M',0.44,0.365,0.125,0.516,0.2155,0.114,0.155,10),
(5,'I',0.33,0.255,0.08,0.205,0.0895,0.0395,0.055,7),
(6,'I',0.425,0.3,0.095,0.3515,0.141,0.0775,0.12,8),
(7,'F',0.53,0.415,0.15,0.7775,0.237,0.1415,0.33,20),
(8,'F',0.545,0.425,0.125,0.768,0.294,0.1495,0.26,16),
(9,'M',0.475,0.37,0.125,0.5095,0.2165,0.1125,0.165,9),
(10,'F',0.55,0.44,0.15,0.8945,0.3145,0.151,0.32,19),
(11,'F',0.525,0.38,0.14,0.6065,0.194,0.1475,0.21,14),
(12,'M',0.43,0.35,0.11,0.406,0.1675,0.081,0.135,10),
(13,'M',0.49,0.38,0.135,0.5415,0.2175,0.095,0.19,11),
(14,'F',0.535,0.405,0.145,0.6845,0.2725,0.171,0.205,10),
(15,'F',0.47,0.355,0.1,0.4755,0.1675,0.0805,0.185,10),
(16,'M',0.5,0.4,0.13,0.6645,0.258,0.133,0.24,12),
(17,'I',0.355,0.28,0.085,0.2905,0.095,0.0395,0.115,7),
(18,'F',0.44,0.34,0.1,0.451,0.188,0.087,0.13,10),
(19,'M',0.365,0.295,0.08,0.2555,0.097,0.043,0.1,7),
(20,'M',0.45,0.32,0.1,0.381,0.1705,0.075,0.115,9),
(21,'M',0.355,0.28,0.095,0.2455,0.0955,0.062,0.075,11),
(22,'I',0.38,0.275,0.1,0.2255,0.08,0.049,0.085,10),
(23,'F',0.565,0.44,0.155,0.9395,0.4275,0.214,0.27,12),
(24,'F',0.55,0.415,0.135,0.7635,0.318,0.21,0.2,9),
(25,'F',0.615,0.48,0.165,1.1615,0.513,0.301,0.305,10),
(26,'F',0.56,0.44,0.14,0.9285,0.3825,0.188,0.3,11),
(27,'F',0.58,0.45,0.185,0.9955,0.3945,0.272,0.285,11),
(28,'M',0.59,0.445,0.14,0.931,0.356,0.234,0.28,12),
(29,'M',0.605,0.475,0.18,0.9365,0.394,0.219,0.295,15),
(30,'M',0.575,0.425,0.14,0.8635,0.393,0.227,0.2,11),
(31,'M',0.58,0.47,0.165,0.9975,0.3935,0.242,0.33,10),
(32,'F',0.68,0.56,0.165,1.639,0.6055,0.2805,0.46,15),
(33,'M',0.665,0.525,0.165,1.338,0.5515,0.3575,0.35,18),
(34,'F',0.68,0.55,0.175,1.798,0.815,0.3925,0.455,19),
(35,'F',0.705,0.55,0.2,1.7095,0.633,0.4115,0.49,13),
(36,'M',0.465,0.355,0.105,0.4795,0.227,0.124,0.125,8),
(37,'F',0.54,0.475,0.155,1.217,0.5305,0.3075,0.34,16),
(38,'F',0.45,0.355,0.105,0.5225,0.237,0.1165,0.145,8),
(39,'F',0.575,0.445,0.135,0.883,0.381,0.2035,0.26,11),
(40,'M',0.355,0.29,0.09,0.3275,0.134,0.086,0.09,9),
(41,'F',0.45,0.335,0.105,0.425,0.1865,0.091,0.115,9),
(42,'F',0.55,0.425,0.135,0.8515,0.362,0.196,0.27,14),
(43,'I',0.24,0.175,0.045,0.07,0.0315,0.0235,0.02,5),
(44,'I',0.205,0.15,0.055,0.042,0.0255,0.015,0.012,5),
(45,'I',0.21,0.15,0.05,0.042,0.0175,0.0125,0.015,4),
(46,'I',0.39,0.295,0.095,0.203,0.0875,0.045,0.075,7),
(47,'M',0.47,0.37,0.12,0.5795,0.293,0.227,0.14,9),
(48,'F',0.46,0.375,0.12,0.4605,0.1775,0.11,0.15,7),
(49,'I',0.325,0.245,0.07,0.161,0.0755,0.0255,0.045,6),
(50,'F',0.525,0.425,0.16,0.8355,0.3545,0.2135,0.245,9),
(51,'I',0.52,0.41,0.12,0.595,0.2385,0.111,0.19,8),
(52,'M',0.4,0.32,0.095,0.303,0.1335,0.06,0.1,7),
(53,'M',0.485,0.36,0.13,0.5415,0.2595,0.096,0.16,10),
(54,'F',0.47,0.36,0.12,0.4775,0.2105,0.1055,0.15,10),
(55,'M',0.405,0.31,0.1,0.385,0.173,0.0915,0.11,7),
(56,'F',0.5,0.4,0.14,0.6615,0.2565,0.1755,0.22,8),
(57,'M',0.445,0.35,0.12,0.4425,0.192,0.0955,0.135,8),
(58,'M',0.47,0.385,0.135,0.5895,0.2765,0.12,0.17,8),
(59,'I',0.245,0.19,0.06,0.086,0.042,0.014,0.025,4),
(60,'F',0.505,0.4,0.125,0.583,0.246,0.13,0.175,7),
(61,'M',0.45,0.345,0.105,0.4115,0.18,0.1125,0.135,7),
(62,'M',0.505,0.405,0.11,0.625,0.305,0.16,0.175,9),
(63,'F',0.53,0.41,0.13,0.6965,0.302,0.1935,0.2,10),
(64,'M',0.425,0.325,0.095,0.3785,0.1705,0.08,0.1,7),
(65,'M',0.52,0.4,0.12,0.58,0.234,0.1315,0.185,8),
(66,'M',0.475,0.355,0.12,0.48,0.234,0.1015,0.135,8),
(67,'F',0.565,0.44,0.16,0.915,0.354,0.1935,0.32,12),
(68,'F',0.595,0.495,0.185,1.285,0.416,0.224,0.485,13),
(69,'F',0.475,0.39,0.12,0.5305,0.2135,0.1155,0.17,10),
(70,'I',0.31,0.235,0.07,0.151,0.063,0.0405,0.045,6),
(71,'M',0.555,0.425,0.13,0.7665,0.264,0.168,0.275,13),
(72,'F',0.4,0.32,0.11,0.353,0.1405,0.0985,0.1,8),
(73,'F',0.595,0.475,0.17,1.247,0.48,0.225,0.425,20),
(74,'M',0.57,0.48,0.175,1.185,0.474,0.261,0.38,11),
(75,'F',0.605,0.45,0.195,1.098,0.481,0.2895,0.315,13),
(76,'F',0.6,0.475,0.15,1.0075,0.4425,0.221,0.28,15),
(77,'M',0.595,0.475,0.14,0.944,0.3625,0.189,0.315,9),
(78,'F',0.6,0.47,0.15,0.922,0.363,0.194,0.305,10),
(79,'F',0.555,0.425,0.14,0.788,0.282,0.1595,0.285,11),
(80,'F',0.615,0.475,0.17,1.1025,0.4695,0.2355,0.345,14),
(81,'F',0.575,0.445,0.14,0.941,0.3845,0.252,0.285,9),
(82,'M',0.62,0.51,0.175,1.615,0.5105,0.192,0.675,12),
(83,'F',0.52,0.425,0.165,0.9885,0.396,0.225,0.32,16),
(84,'M',0.595,0.475,0.16,1.3175,0.408,0.234,0.58,21),
(85,'M',0.58,0.45,0.14,1.013,0.38,0.216,0.36,14),
(86,'F',0.57,0.465,0.18,1.295,0.339,0.2225,0.44,12),
(87,'M',0.625,0.465,0.14,1.195,0.4825,0.205,0.4,13),
(88,'M',0.56,0.44,0.16,0.8645,0.3305,0.2075,0.26,10),
(89,'F',0.46,0.355,0.13,0.517,0.2205,0.114,0.165,9),
(90,'F',0.575,0.45,0.16,0.9775,0.3135,0.231,0.33,12),
(91,'M',0.565,0.425,0.135,0.8115,0.341,0.1675,0.255,15),
(92,'M',0.555,0.44,0.15,0.755,0.307,0.1525,0.26,12),
(93,'M',0.595,0.465,0.175,1.115,0.4015,0.254,0.39,13),
(94,'F',0.625,0.495,0.165,1.262,0.507,0.318,0.39,10),
(95,'M',0.695,0.56,0.19,1.494,0.588,0.3425,0.485,15),
(96,'M',0.665,0.535,0.195,1.606,0.5755,0.388,0.48,14),
(97,'M',0.535,0.435,0.15,0.725,0.269,0.1385,0.25,9),
(98,'M',0.47,0.375,0.13,0.523,0.214,0.132,0.145,8),
(99,'M',0.47,0.37,0.13,0.5225,0.201,0.133,0.165,7),
(100,'F',0.475,0.375,0.125,0.5785,0.2775,0.085,0.155,10),
(101,'I',0.36,0.265,0.095,0.2315,0.105,0.046,0.075,7),
(102,'M',0.55,0.435,0.145,0.843,0.328,0.1915,0.255,15),
(103,'M',0.53,0.435,0.16,0.883,0.316,0.164,0.335,15),
(104,'M',0.53,0.415,0.14,0.724,0.3105,0.1675,0.205,10),
(105,'M',0.605,0.47,0.16,1.1735,0.4975,0.2405,0.345,12),
(106,'F',0.52,0.41,0.155,0.727,0.291,0.1835,0.235,12),
(107,'F',0.545,0.43,0.165,0.802,0.2935,0.183,0.28,11),
(108,'F',0.5,0.4,0.125,0.6675,0.261,0.1315,0.22,10),
(109,'F',0.51,0.39,0.135,0.6335,0.231,0.179,0.2,9),
(110,'F',0.435,0.395,0.105,0.3635,0.136,0.098,0.13,9),
(111,'M',0.495,0.395,0.125,0.5415,0.2375,0.1345,0.155,9),
(112,'M',0.465,0.36,0.105,0.431,0.172,0.107,0.175,9),
(113,'I',0.435,0.32,0.08,0.3325,0.1485,0.0635,0.105,9),
(114,'M',0.425,0.35,0.105,0.393,0.13,0.063,0.165,9),
(115,'F',0.545,0.41,0.125,0.6935,0.2975,0.146,0.21,11),
(116,'F',0.53,0.415,0.115,0.5915,0.233,0.1585,0.18,11),
(117,'F',0.49,0.375,0.135,0.6125,0.2555,0.102,0.22,11),
(118,'M',0.44,0.34,0.105,0.402,0.1305,0.0955,0.165,10),
(119,'F',0.56,0.43,0.15,0.8825,0.3465,0.172,0.31,9),
(120,'M',0.405,0.305,0.085,0.2605,0.1145,0.0595,0.085,8),
(121,'F',0.47,0.365,0.105,0.4205,0.163,0.1035,0.14,9),
(122,'I',0.385,0.295,0.085,0.2535,0.103,0.0575,0.085,7),
(123,'F',0.515,0.425,0.14,0.766,0.304,0.1725,0.255,14),
(124,'M',0.37,0.265,0.075,0.214,0.09,0.051,0.07,6),
(125,'I',0.36,0.28,0.08,0.1755,0.081,0.0505,0.07,6),
(126,'I',0.27,0.195,0.06,0.073,0.0285,0.0235,0.03,5),
(127,'I',0.375,0.275,0.09,0.238,0.1075,0.0545,0.07,6),
(128,'I',0.385,0.29,0.085,0.2505,0.112,0.061,0.08,8),
(129,'M',0.7,0.535,0.16,1.7255,0.63,0.2635,0.54,19),
(130,'M',0.71,0.54,0.165,1.959,0.7665,0.261,0.78,18),
(131,'M',0.595,0.48,0.165,1.262,0.4835,0.283,0.41,17),
(132,'F',0.44,0.35,0.125,0.4035,0.175,0.063,0.129,9),
(133,'F',0.325,0.26,0.09,0.1915,0.085,0.036,0.062,7),
(134,'I',0.35,0.26,0.095,0.211,0.086,0.056,0.068,7),
(135,'I',0.265,0.2,0.065,0.0975,0.04,0.0205,0.028,7),
(136,'F',0.425,0.33,0.115,0.406,0.1635,0.081,0.1355,8),
(137,'F',0.305,0.23,0.08,0.156,0.0675,0.0345,0.048,7),
(138,'M',0.345,0.255,0.09,0.2005,0.094,0.0295,0.063,9),
(139,'F',0.405,0.325,0.11,0.3555,0.151,0.063,0.117,9),
(140,'M',0.375,0.285,0.095,0.253,0.096,0.0575,0.0925,9),
(141,'F',0.565,0.445,0.155,0.826,0.341,0.2055,0.2475,10),
(142,'F',0.55,0.45,0.145,0.741,0.295,0.1435,0.2665,10),
(143,'M',0.65,0.52,0.19,1.3445,0.519,0.306,0.4465,16),
(144,'M',0.56,0.455,0.155,0.797,0.34,0.19,0.2425,11),
(145,'M',0.475,0.375,0.13,0.5175,0.2075,0.1165,0.17,10),
(146,'F',0.49,0.38,0.125,0.549,0.245,0.1075,0.174,10),
(147,'M',0.46,0.35,0.12,0.515,0.224,0.108,0.1565,10),
(148,'I',0.28,0.205,0.08,0.127,0.052,0.039,0.042,9),
(149,'I',0.175,0.13,0.055,0.0315,0.0105,0.0065,0.0125,5),
(150,'I',0.17,0.13,0.095,0.03,0.013,0.008,0.01,4),
(151,'M',0.59,0.475,0.145,1.053,0.4415,0.262,0.325,15),
(152,'F',0.605,0.5,0.185,1.1185,0.469,0.2585,0.335,9),
(153,'F',0.635,0.515,0.19,1.3715,0.5065,0.305,0.45,10),
(154,'F',0.605,0.485,0.16,1.0565,0.37,0.2355,0.355,10),
(155,'F',0.565,0.45,0.135,0.9885,0.387,0.1495,0.31,12),
(156,'M',0.515,0.405,0.13,0.722,0.32,0.131,0.21,10),
(157,'F',0.575,0.46,0.19,0.994,0.392,0.2425,0.34,13),
(158,'M',0.645,0.485,0.215,1.514,0.546,0.2615,0.635,16),
(159,'F',0.58,0.455,0.17,0.9075,0.374,0.2135,0.285,13),
(160,'F',0.575,0.46,0.165,1.124,0.2985,0.1785,0.44,13),
(161,'M',0.605,0.465,0.165,1.056,0.4215,0.2475,0.34,13),
(162,'F',0.605,0.485,0.16,1.222,0.53,0.2575,0.28,13),
(163,'M',0.61,0.485,0.175,1.2445,0.544,0.297,0.345,12),
(164,'F',0.725,0.56,0.21,2.141,0.65,0.398,1.005,18),
(165,'F',0.65,0.545,0.23,1.752,0.5605,0.2895,0.815,16),
(166,'M',0.725,0.57,0.19,2.55,1.0705,0.483,0.725,14),
(167,'F',0.725,0.575,0.175,2.124,0.765,0.4515,0.85,20),
(168,'F',0.68,0.57,0.205,1.842,0.625,0.408,0.65,20),
(169,'M',0.705,0.56,0.22,1.981,0.8175,0.3085,0.76,14),
(170,'F',0.68,0.515,0.175,1.6185,0.5125,0.409,0.62,12),
(171,'M',0.695,0.55,0.215,1.9565,0.7125,0.541,0.59,14),
(172,'F',0.53,0.395,0.145,0.775,0.308,0.169,0.255,7),
(173,'M',0.525,0.435,0.155,1.065,0.486,0.233,0.285,8),
(174,'F',0.52,0.405,0.115,0.776,0.32,0.1845,0.22,8),
(175,'I',0.235,0.16,0.04,0.048,0.0185,0.018,0.015,5),
(176,'I',0.36,0.26,0.09,0.1785,0.0645,0.037,0.075,7),
(177,'I',0.315,0.21,0.06,0.125,0.06,0.0375,0.035,5),
(178,'I',0.315,0.245,0.085,0.1435,0.053,0.0475,0.05,8),
(179,'I',0.225,0.16,0.045,0.0465,0.025,0.015,0.015,4),
(180,'M',0.58,0.475,0.15,0.97,0.385,0.2165,0.35,11),
(181,'M',0.57,0.48,0.18,0.9395,0.399,0.2,0.295,14),
(182,'M',0.64,0.51,0.175,1.368,0.515,0.266,0.57,21),
(183,'F',0.56,0.45,0.16,1.0235,0.429,0.268,0.3,10),
(184,'F',0.62,0.475,0.175,1.0165,0.4355,0.214,0.325,10),
(185,'F',0.645,0.51,0.2,1.5675,0.621,0.367,0.46,12),
(186,'M',0.62,0.49,0.19,1.218,0.5455,0.2965,0.355,13),
(187,'F',0.63,0.48,0.15,1.0525,0.392,0.336,0.285,12),
(188,'F',0.63,0.5,0.185,1.383,0.54,0.3315,0.38,10),
(189,'F',0.63,0.48,0.16,1.199,0.5265,0.335,0.315,11),
(190,'F',0.585,0.46,0.17,0.9325,0.365,0.271,0.29,9),
(191,'M',0.615,0.48,0.18,1.1595,0.4845,0.2165,0.325,13),
(192,'M',0.61,0.485,0.17,1.0225,0.419,0.2405,0.36,12),
(193,'M',0.58,0.45,0.15,0.927,0.276,0.1815,0.36,14),
(194,'I',0.355,0.275,0.085,0.22,0.092,0.06,0.15,8),
(195,'F',0.51,0.4,0.14,0.8145,0.459,0.1965,0.195,10),
(196,'M',0.5,0.405,0.155,0.772,0.346,0.1535,0.245,12),
(197,'F',0.505,0.41,0.15,0.644,0.285,0.145,0.21,11),
(198,'M',0.64,0.5,0.185,1.3035,0.4445,0.2635,0.465,16),
(199,'M',0.56,0.45,0.16,0.922,0.432,0.178,0.26,15),
(200,'M',0.585,0.46,0.185,0.922,0.3635,0.213,0.285,10),
(201,'F',0.45,0.345,0.12,0.4165,0.1655,0.095,0.135,9),
(202,'M',0.5,0.4,0.165,0.825,0.254,0.205,0.285,13),
(203,'F',0.5,0.4,0.145,0.63,0.234,0.1465,0.23,12),
(204,'F',0.53,0.435,0.17,0.8155,0.2985,0.155,0.275,13),
(205,'M',0.42,0.335,0.115,0.369,0.171,0.071,0.12,8),
(206,'F',0.44,0.34,0.14,0.482,0.186,0.1085,0.16,9),
(207,'I',0.4,0.3,0.11,0.315,0.109,0.067,0.12,9),
(208,'I',0.435,0.34,0.11,0.3795,0.1495,0.085,0.12,8),
(209,'F',0.525,0.415,0.17,0.8325,0.2755,0.1685,0.31,13),
(210,'I',0.37,0.28,0.095,0.2655,0.122,0.052,0.08,7),
(211,'F',0.49,0.365,0.145,0.6345,0.1995,0.1625,0.22,10),
(212,'M',0.335,0.25,0.09,0.181,0.0755,0.0415,0.06,7),
(213,'F',0.415,0.325,0.105,0.38,0.1595,0.0785,0.12,12),
(214,'M',0.5,0.405,0.14,0.6155,0.241,0.1355,0.205,9),
(215,'F',0.485,0.395,0.16,0.66,0.2475,0.128,0.235,14),
(216,'M',0.55,0.405,0.14,0.8025,0.244,0.1635,0.255,10),
(217,'M',0.45,0.35,0.13,0.46,0.174,0.111,0.135,8),
(218,'I',0.405,0.3,0.12,0.324,0.1265,0.07,0.11,7),
(219,'M',0.47,0.36,0.135,0.501,0.1665,0.115,0.165,10),
(220,'F',0.415,0.305,0.13,0.32,0.1305,0.0755,0.105,8),
(221,'F',0.445,0.325,0.125,0.455,0.1785,0.1125,0.14,9),
(222,'F',0.47,0.35,0.145,0.5175,0.187,0.1235,0.18,11),
(223,'F',0.49,0.375,0.15,0.5755,0.22,0.144,0.19,9),
(224,'F',0.445,0.355,0.15,0.485,0.181,0.125,0.155,11),
(225,'I',0.425,0.38,0.105,0.3265,0.1285,0.0785,0.1,10),
(226,'F',0.5,0.37,0.135,0.45,0.1715,0.1055,0.155,9),
(227,'F',0.39,0.29,0.125,0.3055,0.121,0.082,0.09,7),
(228,'I',0.365,0.27,0.085,0.205,0.078,0.0485,0.07,7),
(229,'F',0.58,0.465,0.165,1.1015,0.404,0.2095,0.35,11),
(230,'F',0.53,0.415,0.16,0.783,0.2935,0.158,0.245,15),
(231,'M',0.555,0.445,0.135,0.836,0.336,0.1625,0.275,13),
(232,'M',0.565,0.44,0.175,0.9025,0.31,0.193,0.325,14),
(233,'M',0.625,0.505,0.215,1.4455,0.496,0.287,0.435,22),
(234,'I',0.275,0.215,0.075,0.1155,0.0485,0.029,0.035,7),
(235,'I',0.44,0.35,0.135,0.435,0.1815,0.083,0.125,12),
(236,'I',0.295,0.225,0.08,0.124,0.0485,0.032,0.04,9),
(237,'I',0.075,0.055,0.01,0.002,0.001,0.0005,0.0015,1),
(238,'I',0.13,0.1,0.03,0.013,0.0045,0.003,0.004,3),
(239,'I',0.11,0.09,0.03,0.008,0.0025,0.002,0.003,3),
(240,'I',0.16,0.12,0.035,0.021,0.0075,0.0045,0.005,5),
(241,'M',0.565,0.425,0.16,0.9425,0.3495,0.2185,0.275,17),
(242,'I',0.27,0.2,0.07,0.1,0.034,0.0245,0.035,5),
(243,'I',0.23,0.175,0.065,0.0645,0.026,0.0105,0.02,5),
(244,'I',0.3,0.23,0.08,0.1275,0.0435,0.0265,0.04,8),
(245,'I',0.33,0.255,0.085,0.1655,0.063,0.039,0.06,8),
(246,'I',0.35,0.26,0.085,0.174,0.0705,0.0345,0.06,10),
(247,'I',0.32,0.245,0.08,0.1585,0.0635,0.0325,0.05,13),
(248,'I',0.36,0.275,0.085,0.1975,0.0745,0.0415,0.07,9),
(249,'I',0.305,0.245,0.075,0.156,0.0675,0.038,0.045,7),
(250,'I',0.345,0.27,0.11,0.2135,0.082,0.0545,0.07,7),
(251,'I',0.33,0.25,0.105,0.1715,0.0655,0.035,0.06,7),
(252,'M',0.59,0.47,0.18,1.1235,0.4205,0.2805,0.36,13),
(253,'F',0.595,0.455,0.155,1.0605,0.5135,0.2165,0.3,12),
(254,'F',0.575,0.46,0.185,1.094,0.4485,0.217,0.345,15),
(255,'M',0.6,0.495,0.165,1.2415,0.485,0.2775,0.34,15),
(256,'M',0.56,0.45,0.175,1.011,0.3835,0.2065,0.37,15),
(257,'M',0.56,0.45,0.185,1.07,0.3805,0.175,0.41,19),
(258,'M',0.545,0.46,0.16,0.8975,0.341,0.1655,0.345,10),
(259,'F',0.635,0.505,0.17,1.415,0.605,0.297,0.365,15),
(260,'F',0.59,0.475,0.16,1.1015,0.4775,0.2555,0.295,13),
(261,'F',0.54,0.475,0.155,0.928,0.394,0.194,0.26,11),
(262,'F',0.57,0.44,0.125,0.865,0.3675,0.1725,0.27,12),
(263,'M',0.53,0.42,0.165,0.8945,0.319,0.239,0.245,11),
(264,'I',0.245,0.195,0.06,0.095,0.0445,0.0245,0.026,4),
(265,'M',0.27,0.2,0.08,0.1205,0.0465,0.028,0.04,6),
(266,'F',0.46,0.38,0.13,0.639,0.3,0.1525,0.16,11),
(267,'M',0.52,0.45,0.15,0.895,0.3615,0.186,0.235,14),
(268,'M',0.35,0.275,0.11,0.2925,0.1225,0.0635,0.0905,8),
(269,'M',0.47,0.39,0.15,0.6355,0.2185,0.0885,0.255,9),
(270,'F',0.45,0.36,0.125,0.4995,0.2035,0.1,0.17,13),
(271,'F',0.64,0.525,0.215,1.779,0.4535,0.2855,0.55,22),
(272,'M',0.59,0.5,0.2,1.187,0.412,0.2705,0.37,16),
(273,'M',0.62,0.485,0.205,1.219,0.3875,0.2505,0.385,14),
(274,'M',0.63,0.505,0.225,1.525,0.56,0.3335,0.45,15),
(275,'M',0.63,0.515,0.155,1.259,0.4105,0.197,0.41,13),
(276,'M',0.655,0.54,0.215,1.844,0.7425,0.327,0.585,22),
(277,'F',0.66,0.53,0.185,1.3485,0.493,0.245,0.49,12),
(278,'M',0.61,0.5,0.24,1.642,0.532,0.3345,0.69,18),
(279,'M',0.635,0.525,0.205,1.484,0.55,0.3115,0.43,20),
(280,'F',0.515,0.425,0.135,0.712,0.2665,0.1605,0.25,11),
(281,'F',0.535,0.415,0.185,0.8415,0.314,0.1585,0.3,15),
(282,'I',0.36,0.285,0.105,0.2415,0.0915,0.057,0.075,7),
(283,'F',0.455,0.355,0.12,0.4495,0.177,0.104,0.15,9),
(284,'M',0.485,0.395,0.14,0.6295,0.2285,0.127,0.225,14),
(285,'M',0.515,0.38,0.175,0.9565,0.325,0.158,0.31,14),
(286,'F',0.535,0.415,0.17,0.879,0.295,0.1965,0.285,10),
(287,'M',0.53,0.435,0.155,0.699,0.288,0.1595,0.205,10),
(288,'F',0.495,0.4,0.155,0.6445,0.242,0.1325,0.205,17),
(289,'M',0.44,0.355,0.125,0.4775,0.132,0.0815,0.19,9),
(290,'F',0.535,0.435,0.16,0.8105,0.3155,0.1795,0.24,10),
(291,'M',0.54,0.435,0.18,0.996,0.3835,0.226,0.325,17),
(292,'F',0.565,0.505,0.21,1.2765,0.501,0.279,0.355,12),
(293,'M',0.61,0.475,0.165,1.116,0.428,0.2205,0.315,15),
(294,'F',0.565,0.455,0.175,1.013,0.342,0.207,0.35,19),
(295,'M',0.6,0.495,0.195,1.0575,0.384,0.19,0.375,26),
(296,'I',0.295,0.215,0.085,0.128,0.049,0.034,0.04,6),
(297,'I',0.275,0.205,0.075,0.1105,0.045,0.0285,0.035,6),
(298,'I',0.28,0.21,0.085,0.1065,0.039,0.0295,0.03,4),
(299,'M',0.49,0.395,0.14,0.549,0.2215,0.1275,0.15,11),
(300,'M',0.37,0.28,0.105,0.234,0.0905,0.0585,0.075,9),
(301,'F',0.405,0.305,0.095,0.3485,0.1455,0.0895,0.1,9),
(302,'F',0.54,0.435,0.175,0.892,0.322,0.174,0.335,13),
(303,'M',0.37,0.28,0.1,0.252,0.1065,0.0595,0.074,8),
(304,'M',0.36,0.27,0.1,0.217,0.0885,0.0495,0.0715,6),
(305,'F',0.47,0.36,0.13,0.472,0.182,0.114,0.15,10),
(306,'I',0.2,0.145,0.06,0.037,0.0125,0.0095,0.011,4),
(307,'I',0.165,0.12,0.03,0.0215,0.007,0.005,0.005,3),
(308,'M',0.645,0.515,0.24,1.5415,0.471,0.369,0.535,13),
(309,'M',0.55,0.41,0.125,0.7605,0.2505,0.1635,0.195,14),
(310,'M',0.57,0.435,0.145,0.9055,0.3925,0.2355,0.275,10),
(311,'F',0.63,0.485,0.19,1.2435,0.4635,0.3055,0.39,21),
(312,'M',0.56,0.44,0.14,0.971,0.443,0.2045,0.265,14),
(313,'M',0.595,0.455,0.195,1.3305,0.4595,0.3235,0.345,19),
(314,'F',0.62,0.47,0.2,1.2255,0.381,0.27,0.435,23),
(315,'M',0.63,0.485,0.175,1.3,0.4335,0.2945,0.46,23),
(316,'I',0.45,0.355,0.11,0.4585,0.194,0.067,0.14,8),
(317,'F',0.635,0.535,0.19,1.242,0.576,0.2475,0.39,14),
(318,'M',0.45,0.35,0.1,0.3675,0.1465,0.1015,0.12,10),
(319,'F',0.58,0.455,0.155,0.8365,0.315,0.1385,0.32,18),
(320,'I',0.33,0.255,0.095,0.172,0.066,0.0255,0.06,6),
(321,'I',0.265,0.21,0.06,0.0965,0.0425,0.022,0.03,5),
(322,'I',0.19,0.145,0.04,0.038,0.0165,0.0065,0.015,4),
(323,'M',0.385,0.31,0.1,0.2845,0.1065,0.075,0.1,11),
(324,'I',0.265,0.205,0.07,0.1055,0.039,0.041,0.035,5),
(325,'M',0.335,0.265,0.105,0.222,0.0935,0.056,0.075,7),
(326,'I',0.355,0.275,0.09,0.251,0.097,0.053,0.08,7),
(327,'I',0.32,0.255,0.1,0.1755,0.073,0.0415,0.065,7),
(328,'M',0.51,0.4,0.13,0.6435,0.27,0.1665,0.205,12),
(329,'M',0.36,0.295,0.105,0.241,0.0865,0.053,0.095,8),
(330,'I',0.36,0.28,0.09,0.2255,0.0885,0.04,0.09,8),
(331,'M',0.5,0.38,0.155,0.5955,0.2135,0.161,0.2,12),
(332,'F',0.4,0.325,0.12,0.3185,0.134,0.0565,0.095,8),
(333,'I',0.3,0.22,0.08,0.121,0.0475,0.042,0.035,5),
(334,'I',0.235,0.175,0.04,0.0705,0.0335,0.015,0.02,5),
(335,'F',0.74,0.6,0.195,1.974,0.598,0.4085,0.71,16),
(336,'M',0.62,0.465,0.19,1.3415,0.5705,0.3175,0.355,11),
(337,'M',0.6,0.475,0.19,1.0875,0.403,0.2655,0.325,14),
(338,'M',0.59,0.45,0.185,1.283,0.473,0.276,0.425,16),
(339,'M',0.62,0.475,0.185,1.325,0.6045,0.325,0.33,13),
(340,'F',0.565,0.45,0.195,1.0035,0.406,0.2505,0.285,15),
(341,'M',0.575,0.455,0.145,1.165,0.581,0.2275,0.3,14),
(342,'F',0.62,0.51,0.205,1.3475,0.4775,0.2565,0.48,14),
(343,'M',0.62,0.465,0.185,1.274,0.579,0.3065,0.32,12),
(344,'F',0.505,0.375,0.18,0.568,0.2325,0.1495,0.17,12),
(345,'F',0.46,0.425,0.155,0.746,0.3005,0.152,0.24,8),
(346,'M',0.49,0.39,0.14,0.707,0.2795,0.2185,0.18,13),
(347,'F',0.525,0.42,0.16,0.756,0.2745,0.173,0.275,9),
(348,'I',0.34,0.26,0.08,0.2,0.08,0.0555,0.055,6),
(349,'I',0.375,0.305,0.115,0.2715,0.092,0.074,0.09,8),
(350,'M',0.61,0.48,0.15,1.2,0.56,0.2455,0.28,14),
(351,'F',0.61,0.495,0.185,1.153,0.536,0.2905,0.245,8),
(352,'F',0.585,0.45,0.17,0.8685,0.3325,0.1635,0.27,22),
(353,'M',0.57,0.46,0.14,0.9535,0.4465,0.2065,0.245,12),
(354,'M',0.58,0.455,0.17,0.93,0.408,0.259,0.22,9),
(355,'M',0.635,0.515,0.17,1.275,0.509,0.286,0.34,16),
(356,'M',0.7,0.58,0.205,2.13,0.7415,0.49,0.58,20),
(357,'M',0.675,0.525,0.185,1.587,0.6935,0.336,0.395,13),
(358,'F',0.645,0.525,0.19,1.8085,0.7035,0.3885,0.395,18),
(359,'M',0.745,0.585,0.215,2.499,0.9265,0.472,0.7,17),
(360,'F',0.685,0.545,0.18,1.768,0.7495,0.392,0.485,16),
(361,'M',0.605,0.49,0.18,1.227,0.48,0.287,0.35,18),
(362,'F',0.59,0.465,0.15,0.997,0.392,0.246,0.34,12),
(363,'F',0.65,0.525,0.175,1.4225,0.61,0.2995,0.445,20),
(364,'F',0.6,0.48,0.15,1.029,0.4085,0.2705,0.295,16),
(365,'F',0.62,0.5,0.175,1.186,0.4985,0.3015,0.35,12),
(366,'M',0.63,0.515,0.16,1.016,0.4215,0.244,0.355,19),
(367,'M',0.58,0.465,0.145,0.887,0.4405,0.1655,0.265,11),
(368,'F',0.58,0.455,0.12,1.0735,0.479,0.2735,0.265,10),
(369,'M',0.63,0.49,0.18,1.13,0.458,0.2765,0.315,12),
(370,'F',0.69,0.56,0.215,1.719,0.68,0.299,0.47,17),
(371,'F',0.65,0.545,0.165,1.566,0.6645,0.3455,0.415,16),
(372,'F',0.66,0.565,0.195,1.7605,0.692,0.3265,0.5,16),
(373,'F',0.68,0.58,0.2,1.787,0.585,0.453,0.6,19),
(374,'F',0.7,0.575,0.17,1.31,0.5095,0.314,0.42,14),
(375,'M',0.685,0.52,0.15,1.343,0.4635,0.292,0.4,13),
(376,'F',0.675,0.545,0.195,1.7345,0.6845,0.3695,0.605,20),
(377,'M',0.63,0.49,0.19,1.1775,0.4935,0.3365,0.285,11),
(378,'F',0.585,0.45,0.16,1.077,0.4995,0.2875,0.25,10),
(379,'M',0.565,0.465,0.175,0.995,0.3895,0.183,0.37,15),
(380,'F',0.61,0.495,0.185,1.1085,0.3705,0.3135,0.33,12),
(381,'M',0.605,0.47,0.18,1.1405,0.3755,0.2805,0.385,15),
(382,'M',0.535,0.42,0.145,0.791,0.33,0.189,0.25,10),
(383,'M',0.485,0.4,0.135,0.663,0.313,0.137,0.2,10),
(384,'M',0.47,0.375,0.12,0.5565,0.226,0.122,0.195,12),
(385,'M',0.545,0.425,0.135,0.8445,0.373,0.21,0.235,10),
(386,'F',0.455,0.37,0.105,0.4925,0.216,0.1245,0.135,9),
(387,'M',0.54,0.42,0.155,0.7385,0.3515,0.152,0.215,12),
(388,'M',0.46,0.38,0.135,0.482,0.207,0.1225,0.145,10),
(389,'M',0.49,0.42,0.125,0.609,0.239,0.1435,0.22,14),
(390,'I',0.465,0.375,0.12,0.471,0.222,0.119,0.14,9),
(391,'I',0.415,0.325,0.1,0.3215,0.1535,0.0595,0.105,10),
(392,'M',0.475,0.375,0.125,0.593,0.277,0.115,0.18,10),
(393,'F',0.47,0.375,0.125,0.5615,0.252,0.137,0.18,10),
(394,'I',0.365,0.295,0.095,0.25,0.1075,0.0545,0.08,9),
(395,'I',0.345,0.275,0.095,0.1995,0.0755,0.0535,0.07,6),
(396,'I',0.39,0.31,0.1,0.302,0.116,0.064,0.115,11),
(397,'F',0.5,0.395,0.14,0.7155,0.3165,0.176,0.24,10),
(398,'M',0.47,0.38,0.145,0.5865,0.2385,0.144,0.185,8),
(399,'M',0.535,0.44,0.15,0.6765,0.256,0.139,0.26,12),
(400,'M',0.585,0.455,0.15,0.987,0.4355,0.2075,0.31,11),
(401,'F',0.485,0.365,0.12,0.5885,0.27,0.131,0.175,9),
(402,'M',0.515,0.455,0.135,0.7225,0.295,0.1625,0.235,9),
(403,'F',0.435,0.325,0.11,0.4335,0.178,0.0985,0.155,7),
(404,'F',0.515,0.415,0.14,0.6935,0.3115,0.152,0.2,10),
(405,'I',0.44,0.345,0.12,0.365,0.1655,0.083,0.11,7),
(406,'F',0.525,0.44,0.15,0.8425,0.3685,0.1985,0.24,12),
(407,'M',0.45,0.355,0.115,0.479,0.2125,0.1045,0.15,8),
(408,'M',0.59,0.485,0.12,0.911,0.39,0.182,0.29,16),
(409,'M',0.555,0.45,0.145,0.915,0.4,0.246,0.285,11),
(410,'M',0.57,0.44,0.095,0.827,0.3395,0.2215,0.235,8),
(411,'M',0.59,0.5,0.165,1.1045,0.4565,0.2425,0.34,15),
(412,'M',0.585,0.475,0.12,0.945,0.41,0.2115,0.28,14),
(413,'F',0.58,0.46,0.12,0.9935,0.4625,0.2385,0.28,11),
(414,'M',0.545,0.44,0.12,0.8565,0.3475,0.1715,0.24,12),
(415,'F',0.605,0.495,0.17,1.2385,0.528,0.2465,0.39,14),
(416,'F',0.62,0.47,0.14,1.0325,0.3605,0.224,0.36,15),
(417,'F',0.63,0.5,0.17,1.3135,0.5595,0.267,0.4,20),
(418,'M',0.63,0.515,0.165,1.352,0.488,0.349,0.45,20),
(419,'F',0.63,0.5,0.155,1.005,0.367,0.199,0.36,16),
(420,'M',0.545,0.41,0.14,0.625,0.223,0.16,0.235,13),
(421,'F',0.67,0.54,0.165,1.5015,0.518,0.358,0.505,14),
(422,'I',0.49,0.38,0.12,0.529,0.2165,0.139,0.155,11),
(423,'F',0.49,0.39,0.135,0.5785,0.2465,0.123,0.2,13),
(424,'I',0.29,0.225,0.07,0.101,0.036,0.0235,0.035,8),
(425,'I',0.26,0.2,0.07,0.092,0.037,0.02,0.03,6),
(426,'M',0.58,0.45,0.175,1.068,0.425,0.203,0.32,13),
(427,'F',0.61,0.485,0.165,1.0915,0.3935,0.2435,0.33,18),
(428,'M',0.6,0.5,0.16,1.015,0.3995,0.1735,0.33,19),
(429,'F',0.56,0.455,0.125,0.943,0.344,0.129,0.375,21),
(430,'F',0.575,0.45,0.17,1.0475,0.3775,0.1705,0.385,18),
(431,'F',0.57,0.45,0.175,0.9555,0.38,0.1665,0.295,18),
(432,'M',0.6,0.47,0.155,1.036,0.4375,0.196,0.325,20),
(433,'M',0.565,0.455,0.17,0.9065,0.342,0.156,0.32,18),
(434,'M',0.545,0.42,0.14,0.7505,0.2475,0.13,0.255,22),
(435,'I',0.44,0.345,0.1,0.366,0.122,0.0905,0.12,13),
(436,'M',0.5,0.41,0.15,0.662,0.2815,0.137,0.22,11),
(437,'I',0.36,0.275,0.095,0.217,0.084,0.0435,0.09,7),
(438,'I',0.385,0.305,0.095,0.252,0.0915,0.055,0.09,14),
(439,'M',0.39,0.3,0.09,0.3055,0.143,0.0645,0.085,9),
(440,'M',0.5,0.415,0.165,0.6885,0.249,0.138,0.25,13),
(441,'I',0.36,0.275,0.11,0.2335,0.095,0.0525,0.085,10),
(442,'I',0.335,0.26,0.1,0.192,0.0785,0.0585,0.07,8),
(443,'F',0.505,0.425,0.14,0.85,0.275,0.1625,0.285,19),
(444,'I',0.395,0.295,0.1,0.2715,0.134,0.0325,0.085,10),
(445,'F',0.41,0.325,0.105,0.3635,0.159,0.077,0.12,10),
(446,'F',0.56,0.455,0.19,0.714,0.283,0.129,0.275,9),
(447,'M',0.565,0.435,0.185,0.9815,0.329,0.136,0.39,13),
(448,'M',0.565,0.455,0.185,0.9265,0.354,0.1575,0.375,16),
(449,'M',0.605,0.5,0.175,1.098,0.4765,0.232,0.375,12),
(450,'F',0.565,0.455,0.15,0.8205,0.365,0.159,0.26,18),
(451,'M',0.725,0.565,0.215,1.891,0.6975,0.4725,0.58,16),
(452,'F',0.675,0.535,0.16,1.41,0.592,0.3175,0.42,16),
(453,'F',0.665,0.555,0.195,1.4385,0.581,0.354,0.36,17),
(454,'F',0.565,0.49,0.155,0.9245,0.405,0.2195,0.255,11),
(455,'F',0.645,0.55,0.175,1.2915,0.57,0.3045,0.33,14),
(456,'M',0.575,0.47,0.14,0.8375,0.3485,0.1735,0.24,11),
(457,'F',0.64,0.54,0.175,1.221,0.51,0.259,0.39,15),
(458,'I',0.36,0.28,0.105,0.199,0.0695,0.045,0.08,9),
(459,'I',0.415,0.31,0.11,0.2965,0.123,0.057,0.0995,10),
(460,'F',0.525,0.41,0.135,0.7085,0.293,0.1525,0.235,11),
(461,'M',0.38,0.285,0.1,0.2665,0.115,0.061,0.075,11),
(462,'F',0.585,0.465,0.17,0.9915,0.3865,0.224,0.265,12),
(463,'I',0.24,0.185,0.07,0.0715,0.026,0.018,0.025,6),
(464,'I',0.22,0.165,0.055,0.0545,0.0215,0.012,0.02,5),
(465,'I',0.255,0.195,0.07,0.0735,0.0255,0.02,0.025,6),
(466,'I',0.175,0.125,0.05,0.0235,0.008,0.0035,0.008,5),
(467,'F',0.67,0.55,0.19,1.3905,0.5425,0.3035,0.4,12),
(468,'M',0.655,0.53,0.195,1.388,0.567,0.2735,0.41,13),
(469,'F',0.68,0.55,0.21,1.7445,0.5975,0.305,0.625,17),
(470,'M',0.675,0.555,0.2,1.4385,0.545,0.2665,0.465,21),
(471,'F',0.53,0.44,0.135,0.7835,0.313,0.1715,0.2185,9),
(472,'F',0.515,0.405,0.12,0.646,0.2895,0.1405,0.177,10),
(473,'I',0.43,0.34,0.12,0.3575,0.151,0.0645,0.1045,9),
(474,'F',0.52,0.405,0.12,0.627,0.2645,0.1415,0.181,11),
(475,'F',0.545,0.415,0.16,0.7715,0.272,0.1455,0.2765,10),
(476,'M',0.53,0.415,0.175,0.7395,0.261,0.1395,0.2645,17),
(477,'F',0.465,0.35,0.115,0.421,0.1565,0.091,0.1345,9),
(478,'M',0.665,0.54,0.175,1.347,0.4955,0.254,0.415,17),
(479,'M',0.735,0.59,0.225,1.756,0.637,0.3405,0.58,21),
(480,'M',0.66,0.545,0.185,1.32,0.5305,0.2635,0.455,16),
(481,'F',0.7,0.585,0.185,1.8075,0.7055,0.3215,0.475,29),
(482,'M',0.575,0.4,0.155,0.9325,0.3605,0.2445,0.3,17),
(483,'M',0.57,0.465,0.125,0.849,0.3785,0.1765,0.24,15),
(484,'F',0.58,0.46,0.15,0.9955,0.429,0.212,0.26,19),
(485,'M',0.63,0.48,0.145,1.0115,0.4235,0.237,0.305,12),
(486,'F',0.585,0.465,0.14,0.908,0.381,0.1615,0.315,13),
(487,'M',0.55,0.45,0.13,0.92,0.378,0.2385,0.29,11),
(488,'F',0.625,0.515,0.15,1.2415,0.5235,0.3065,0.36,15),
(489,'M',0.54,0.42,0.135,0.8075,0.3485,0.1795,0.235,11),
(490,'F',0.57,0.455,0.165,1.0595,0.44,0.2195,0.285,14),
(491,'M',0.59,0.455,0.145,1.073,0.475,0.19,0.285,14),
(492,'M',0.58,0.46,0.13,0.921,0.357,0.181,0.29,13),
(493,'F',0.655,0.51,0.155,1.2895,0.5345,0.2855,0.41,11),
(494,'M',0.655,0.53,0.175,1.2635,0.486,0.2635,0.415,15),
(495,'M',0.625,0.5,0.195,1.369,0.5875,0.2185,0.37,17),
(496,'F',0.625,0.5,0.15,0.953,0.3445,0.2235,0.305,15),
(497,'F',0.64,0.52,0.175,1.248,0.4245,0.2595,0.48,12),
(498,'F',0.605,0.485,0.165,1.0105,0.435,0.209,0.3,19),
(499,'F',0.615,0.525,0.155,1.0385,0.427,0.2315,0.345,11),
(500,'M',0.555,0.45,0.175,0.874,0.3275,0.202,0.305,10),
(501,'F',0.58,0.44,0.18,0.854,0.3665,0.1635,0.245,12),
(502,'F',0.62,0.52,0.225,1.1835,0.378,0.27,0.395,23),
(503,'F',0.62,0.47,0.225,1.115,0.378,0.2145,0.36,15),
(504,'F',0.6,0.505,0.19,1.129,0.4385,0.256,0.36,13),
(505,'F',0.625,0.485,0.19,1.1745,0.4385,0.2305,0.42,17),
(506,'M',0.6,0.47,0.175,1.105,0.4865,0.247,0.315,15),
(507,'M',0.56,0.46,0.235,0.8395,0.3325,0.157,0.305,12),
(508,'M',0.585,0.455,0.225,1.055,0.3815,0.221,0.365,15),
(509,'M',0.56,0.435,0.18,0.889,0.36,0.204,0.25,11),
(510,'I',0.56,0.445,0.155,0.8735,0.3005,0.209,0.275,16),
(511,'I',0.68,0.53,0.185,1.1095,0.439,0.245,0.34,10),
(512,'F',0.455,0.35,0.14,0.5185,0.221,0.1265,0.135,10),
(513,'F',0.49,0.38,0.145,0.6725,0.249,0.181,0.21,10),
(514,'M',0.31,0.22,0.085,0.146,0.061,0.0365,0.045,6),
(515,'F',0.275,0.195,0.07,0.08,0.031,0.0215,0.025,5),
(516,'M',0.27,0.195,0.08,0.1,0.0385,0.0195,0.03,6),
(517,'M',0.4,0.29,0.115,0.2795,0.1115,0.0575,0.075,9),
(518,'M',0.28,0.2,0.08,0.0915,0.033,0.0215,0.03,5),
(519,'M',0.325,0.23,0.09,0.147,0.06,0.034,0.045,4),
(520,'F',0.345,0.25,0.09,0.203,0.078,0.059,0.055,6),
(521,'M',0.21,0.15,0.05,0.0385,0.0155,0.0085,0.01,3),
(522,'F',0.36,0.27,0.09,0.1885,0.0845,0.0385,0.055,5),
(523,'I',0.365,0.26,0.115,0.218,0.0935,0.0445,0.07,9),
(524,'M',0.2,0.14,0.055,0.035,0.0145,0.008,0.01,5),
(525,'M',0.235,0.16,0.06,0.0545,0.0265,0.0095,0.015,4),
(526,'M',0.175,0.125,0.04,0.024,0.0095,0.006,0.005,4),
(527,'M',0.155,0.11,0.04,0.0155,0.0065,0.003,0.005,3),
(528,'F',0.57,0.445,0.155,0.733,0.282,0.159,0.235,14),
(529,'F',0.57,0.45,0.16,0.9715,0.3965,0.255,0.26,12),
(530,'M',0.385,0.3,0.095,0.24,0.0885,0.059,0.085,9),
(531,'I',0.53,0.42,0.185,0.752,0.299,0.156,0.205,20),
(532,'F',0.46,0.355,0.13,0.458,0.192,0.1055,0.13,13),
(533,'I',0.47,0.37,0.12,0.4705,0.1845,0.1055,0.155,12),
(534,'F',0.435,0.335,0.11,0.38,0.1695,0.086,0.11,9),
(535,'I',0.47,0.37,0.14,0.4985,0.2095,0.1225,0.145,10),
(536,'I',0.465,0.38,0.13,0.454,0.1895,0.08,0.155,11),
(537,'I',0.52,0.405,0.14,0.5775,0.2,0.145,0.179,11),
(538,'M',0.29,0.23,0.075,0.1165,0.043,0.0255,0.04,7),
(539,'M',0.275,0.205,0.07,0.094,0.0335,0.02,0.0325,5),
(540,'F',0.375,0.29,0.115,0.2705,0.093,0.066,0.0885,10),
(541,'F',0.5,0.375,0.14,0.604,0.242,0.1415,0.179,15),
(542,'F',0.44,0.355,0.115,0.415,0.1585,0.0925,0.131,11),
(543,'M',0.42,0.325,0.115,0.2885,0.1,0.057,0.1135,15),
(544,'M',0.445,0.35,0.115,0.3615,0.1565,0.0695,0.117,8),
(545,'F',0.38,0.29,0.105,0.257,0.099,0.051,0.085,10),
(546,'M',0.32,0.245,0.075,0.1555,0.0585,0.038,0.049,11),
(547,'M',0.255,0.195,0.065,0.08,0.0315,0.018,0.027,8),
(548,'M',0.205,0.155,0.045,0.0425,0.017,0.0055,0.0155,7),
(549,'F',0.565,0.45,0.16,0.795,0.3605,0.1555,0.23,12),
(550,'I',0.555,0.425,0.18,0.875,0.3695,0.2005,0.255,11),
(551,'I',0.65,0.515,0.16,1.1625,0.495,0.203,0.33,17),
(552,'I',0.615,0.49,0.155,0.9885,0.4145,0.195,0.345,13),
(553,'I',0.56,0.44,0.165,0.8,0.335,0.1735,0.25,12),
(554,'I',0.48,0.37,0.12,0.514,0.2075,0.131,0.155,13),
(555,'I',0.485,0.39,0.125,0.591,0.287,0.141,0.12,9),
(556,'I',0.5,0.385,0.15,0.6265,0.2605,0.1665,0.16,10),
(557,'I',0.525,0.405,0.15,0.795,0.3075,0.205,0.255,14),
(558,'F',0.66,0.5,0.165,1.1905,0.4585,0.298,0.37,12),
(559,'F',0.66,0.53,0.17,1.326,0.519,0.2625,0.44,13),
(560,'I',0.52,0.4,0.145,0.66,0.267,0.1055,0.22,13),
(561,'F',0.44,0.34,0.105,0.364,0.148,0.0805,0.1175,8),
(562,'I',0.515,0.4,0.12,0.659,0.2705,0.179,0.17,13),
(563,'F',0.475,0.35,0.115,0.452,0.1715,0.092,0.155,11),
(564,'F',0.545,0.415,0.15,0.7335,0.2795,0.163,0.2185,11),
(565,'F',0.47,0.355,0.13,0.5465,0.2005,0.126,0.185,14),
(566,'M',0.35,0.255,0.065,0.179,0.0705,0.0385,0.06,10),
(567,'I',0.485,0.355,0.13,0.581,0.245,0.132,0.168,12),
(568,'I',0.435,0.33,0.125,0.406,0.1685,0.1055,0.096,12),
(569,'M',0.28,0.21,0.08,0.1085,0.041,0.0265,0.0345,7),
(570,'F',0.41,0.32,0.115,0.387,0.165,0.1005,0.0985,11),
(571,'I',0.45,0.35,0.14,0.474,0.21,0.109,0.1275,16),
(572,'I',0.45,0.345,0.135,0.443,0.1975,0.0875,0.1175,14),
(573,'F',0.59,0.455,0.155,1.066,0.382,0.2275,0.415,20),
(574,'F',0.57,0.44,0.14,0.9535,0.3785,0.201,0.305,17),
(575,'I',0.61,0.475,0.15,0.9665,0.4145,0.2,0.345,10),
(576,'F',0.61,0.475,0.14,1.133,0.5275,0.2355,0.35,11),
(577,'I',0.56,0.425,0.14,0.9175,0.4005,0.1975,0.26,10),
(578,'F',0.585,0.435,0.175,0.982,0.4055,0.2495,0.27,10),
(579,'I',0.58,0.445,0.15,0.8865,0.383,0.209,0.255,11),
(580,'F',0.63,0.48,0.175,1.3675,0.5015,0.3035,0.515,17),
(581,'F',0.625,0.49,0.175,1.233,0.5565,0.247,0.365,11),
(582,'I',0.55,0.425,0.15,0.806,0.376,0.171,0.245,14),
(583,'F',0.645,0.525,0.19,1.4635,0.6615,0.3435,0.435,19),
(584,'I',0.46,0.355,0.14,0.4935,0.216,0.133,0.115,13),
(585,'F',0.41,0.305,0.1,0.363,0.1735,0.065,0.11,11),
(586,'I',0.495,0.39,0.125,0.6655,0.284,0.162,0.2,11),
(587,'I',0.52,0.425,0.17,0.6805,0.28,0.174,0.195,10),
(588,'F',0.55,0.41,0.145,0.8285,0.3095,0.1905,0.25,13),
(589,'M',0.45,0.335,0.14,0.4625,0.164,0.076,0.15,14),
(590,'F',0.405,0.31,0.12,0.3095,0.138,0.058,0.095,13),
(591,'I',0.51,0.4,0.15,0.745,0.2865,0.1675,0.235,13),
(592,'F',0.37,0.29,0.115,0.25,0.111,0.057,0.075,9),
(593,'I',0.525,0.41,0.175,0.874,0.3585,0.207,0.205,18),
(594,'F',0.66,0.52,0.18,1.514,0.526,0.2975,0.42,19),
(595,'M',0.535,0.42,0.15,0.6995,0.2575,0.153,0.24,12),
(596,'I',0.575,0.455,0.18,0.8525,0.3015,0.1825,0.3,13),
(597,'F',0.55,0.43,0.14,0.7135,0.2565,0.186,0.225,9),
(598,'I',0.605,0.47,0.14,0.939,0.3385,0.201,0.32,13),
(599,'I',0.605,0.495,0.145,1.054,0.369,0.2255,0.36,12),
(600,'F',0.56,0.445,0.195,0.981,0.305,0.2245,0.335,16),
(601,'I',0.535,0.42,0.145,0.926,0.398,0.1965,0.25,17),
(602,'F',0.385,0.315,0.11,0.286,0.1225,0.0635,0.0835,10),
(603,'F',0.39,0.3,0.1,0.265,0.1075,0.06,0.0865,13),
(604,'I',0.47,0.345,0.115,0.4885,0.2005,0.108,0.166,11),
(605,'I',0.515,0.39,0.14,0.5555,0.2,0.1135,0.2235,12),
(606,'I',0.425,0.345,0.125,0.425,0.16,0.0795,0.154,13),
(607,'M',0.345,0.27,0.09,0.195,0.078,0.0455,0.059,9),
(608,'I',0.485,0.37,0.13,0.458,0.181,0.113,0.136,10),
(609,'M',0.37,0.285,0.1,0.228,0.0675,0.0675,0.081,10),
(610,'M',0.35,0.265,0.09,0.1775,0.0575,0.042,0.068,12),
(611,'F',0.44,0.345,0.17,0.4085,0.15,0.0825,0.1515,12),
(612,'M',0.195,0.145,0.05,0.032,0.01,0.008,0.012,4),
(613,'M',0.325,0.24,0.075,0.155,0.0475,0.0355,0.06,9),
(614,'I',0.495,0.37,0.125,0.4775,0.185,0.0705,0.169,18),
(615,'I',0.45,0.35,0.145,0.525,0.2085,0.1,0.1655,15),
(616,'M',0.415,0.345,0.135,0.3865,0.128,0.07,0.148,13),
(617,'F',0.47,0.355,0.14,0.433,0.1525,0.095,0.152,12),
(618,'M',0.32,0.24,0.085,0.17,0.0655,0.047,0.049,7),
(619,'M',0.31,0.225,0.075,0.1295,0.0455,0.0335,0.044,9),
(620,'M',0.235,0.17,0.055,0.0515,0.018,0.0105,0.0195,7),
(621,'M',0.345,0.255,0.08,0.169,0.06,0.0425,0.054,10),
(622,'I',0.485,0.38,0.14,0.673,0.2175,0.13,0.195,18),
(623,'F',0.5,0.385,0.115,0.6785,0.2945,0.138,0.195,12),
(624,'F',0.5,0.385,0.105,0.498,0.1795,0.1095,0.17,17),
(625,'I',0.465,0.36,0.105,0.498,0.214,0.116,0.14,15),
(626,'F',0.525,0.405,0.16,0.658,0.2655,0.1125,0.225,12),
(627,'F',0.425,0.335,0.095,0.322,0.1205,0.061,0.125,10),
(628,'F',0.38,0.305,0.095,0.2815,0.1255,0.0525,0.09,8),
(629,'I',0.53,0.415,0.145,0.944,0.3845,0.185,0.265,21),
(630,'M',0.34,0.265,0.085,0.1835,0.077,0.046,0.065,10),
(631,'I',0.475,0.365,0.115,0.49,0.223,0.1235,0.1335,9),
(632,'F',0.43,0.34,0.12,0.391,0.1555,0.095,0.1405,7),
(633,'M',0.46,0.365,0.125,0.467,0.1895,0.0945,0.158,10),
(634,'I',0.47,0.36,0.13,0.5225,0.198,0.1065,0.165,9),
(635,'M',0.36,0.295,0.1,0.2105,0.066,0.0525,0.075,9),
(636,'M',0.355,0.265,0.09,0.168,0.05,0.041,0.063,8),
(637,'M',0.38,0.235,0.1,0.258,0.1055,0.054,0.08,7),
(638,'M',0.355,0.26,0.085,0.1905,0.081,0.0485,0.055,6),
(639,'I',0.44,0.345,0.12,0.487,0.1965,0.108,0.16,14),
(640,'F',0.51,0.4,0.13,0.5735,0.219,0.1365,0.195,13),
(641,'M',0.325,0.24,0.085,0.173,0.0795,0.038,0.05,7),
(642,'I',0.62,0.485,0.18,1.1785,0.4675,0.2655,0.39,13),
(643,'F',0.59,0.45,0.16,0.9,0.358,0.156,0.315,19),
(644,'M',0.33,0.255,0.095,0.1875,0.0735,0.045,0.06,7),
(645,'M',0.45,0.34,0.13,0.3715,0.1605,0.0795,0.105,9),
(646,'I',0.445,0.33,0.12,0.347,0.12,0.084,0.105,11),
(647,'M',0.33,0.215,0.075,0.1145,0.045,0.0265,0.035,6),
(648,'M',0.48,0.375,0.145,0.777,0.216,0.13,0.17,9),
(649,'I',0.46,0.35,0.12,0.4885,0.193,0.105,0.155,11),
(650,'F',0.475,0.36,0.125,0.447,0.1695,0.081,0.14,9),
(651,'M',0.255,0.18,0.065,0.079,0.034,0.014,0.025,5),
(652,'I',0.335,0.245,0.09,0.1665,0.0595,0.04,0.06,6),
(653,'I',0.47,0.35,0.13,0.466,0.1845,0.099,0.145,11),
(654,'M',0.31,0.225,0.08,0.1345,0.054,0.024,0.05,7),
(655,'F',0.37,0.28,0.11,0.2305,0.0945,0.0465,0.075,10),
(656,'M',0.295,0.215,0.075,0.129,0.05,0.0295,0.04,7),
(657,'F',0.555,0.435,0.165,0.97,0.336,0.2315,0.295,17),
(658,'F',0.615,0.515,0.17,1.14,0.4305,0.2245,0.42,16),
(659,'I',0.58,0.49,0.195,1.3165,0.5305,0.254,0.41,18),
(660,'F',0.585,0.475,0.185,0.9585,0.4145,0.1615,0.33,11),
(661,'I',0.65,0.525,0.18,1.626,0.597,0.3445,0.53,18),
(662,'I',0.535,0.45,0.17,0.781,0.3055,0.1555,0.295,11),
(663,'F',0.415,0.34,0.13,0.3675,0.146,0.0885,0.12,10),
(664,'F',0.38,0.305,0.105,0.281,0.1045,0.0615,0.09,12),
(665,'I',0.45,0.355,0.12,0.412,0.1145,0.0665,0.16,19),
(666,'F',0.395,0.295,0.095,0.2245,0.078,0.054,0.08,10),
(667,'M',0.455,0.35,0.12,0.4835,0.1815,0.144,0.16,11),
(668,'F',0.485,0.38,0.15,0.605,0.2155,0.14,0.18,15),
(669,'M',0.55,0.425,0.155,0.9175,0.2775,0.243,0.335,13),
(670,'F',0.45,0.35,0.145,0.5425,0.1765,0.123,0.175,13),
(671,'M',0.475,0.385,0.145,0.6175,0.235,0.108,0.215,14),
(672,'F',0.5,0.38,0.155,0.655,0.2405,0.143,0.205,17),
(673,'F',0.53,0.41,0.165,0.8115,0.24,0.169,0.24,19),
(674,'M',0.49,0.39,0.15,0.573,0.225,0.124,0.17,21),
(675,'F',0.49,0.385,0.15,0.7865,0.241,0.14,0.24,23),
(676,'F',0.52,0.395,0.18,0.64,0.158,0.11,0.245,22),
(677,'M',0.54,0.415,0.145,0.74,0.2635,0.168,0.245,12),
(678,'F',0.5,0.375,0.115,0.5945,0.185,0.148,0.19,11),
(679,'F',0.45,0.38,0.165,0.8165,0.25,0.1915,0.265,23),
(680,'F',0.37,0.275,0.1,0.2225,0.093,0.026,0.08,8),
(681,'I',0.37,0.275,0.1,0.2295,0.0885,0.0465,0.07,7),
(682,'M',0.485,0.37,0.14,0.5725,0.204,0.1415,0.175,10),
(683,'F',0.435,0.325,0.115,0.3915,0.154,0.094,0.12,7),
(684,'M',0.535,0.405,0.185,0.8345,0.3175,0.1725,0.29,16),
(685,'M',0.51,0.4,0.14,0.6515,0.2455,0.1665,0.185,10),
(686,'M',0.565,0.44,0.185,0.909,0.344,0.2325,0.255,15),
(687,'F',0.535,0.4,0.15,0.8045,0.3345,0.2125,0.21,13),
(688,'F',0.535,0.405,0.125,0.927,0.26,0.1425,0.345,16),
(689,'M',0.525,0.4,0.17,0.7305,0.279,0.2055,0.195,11),
(690,'M',0.59,0.44,0.15,0.9555,0.366,0.2425,0.295,11),
(691,'M',0.5,0.375,0.15,0.636,0.2535,0.145,0.19,10),
(692,'I',0.255,0.19,0.075,0.0865,0.0345,0.0205,0.025,5),
(693,'F',0.43,0.325,0.115,0.3865,0.1475,0.1065,0.11,11),
(694,'M',0.38,0.29,0.12,0.283,0.1175,0.0655,0.085,9),
(695,'I',0.165,0.11,0.02,0.019,0.0065,0.0025,0.005,4),
(696,'I',0.315,0.23,0.09,0.1285,0.043,0.04,0.04,7),
(697,'I',0.155,0.105,0.05,0.0175,0.005,0.0035,0.005,4),
(698,'M',0.28,0.205,0.1,0.1165,0.0545,0.0285,0.03,5),
(699,'F',0.43,0.335,0.12,0.444,0.155,0.1145,0.14,13),
(700,'F',0.395,0.315,0.105,0.3515,0.1185,0.091,0.1195,16),
(701,'M',0.385,0.285,0.105,0.2905,0.1215,0.0685,0.0875,12),
(702,'F',0.48,0.385,0.135,0.536,0.1895,0.142,0.173,14),
(703,'F',0.445,0.33,0.105,0.4525,0.18,0.103,0.123,9),
(704,'M',0.395,0.295,0.115,0.316,0.1205,0.0595,0.1105,12),
(705,'M',0.4,0.3,0.125,0.417,0.191,0.09,0.1175,9),
(706,'M',0.415,0.325,0.14,0.417,0.1535,0.1015,0.144,10),
(707,'M',0.315,0.25,0.09,0.203,0.0615,0.037,0.0795,11),
(708,'F',0.345,0.26,0.09,0.207,0.0775,0.0435,0.0765,10),
(709,'M',0.36,0.295,0.13,0.2765,0.0895,0.057,0.1005,10),
(710,'I',0.295,0.225,0.09,0.1105,0.0405,0.0245,0.032,7),
(711,'I',0.325,0.25,0.08,0.176,0.0595,0.0355,0.063,7),
(712,'M',0.375,0.3,0.1,0.2465,0.104,0.0475,0.083,11),
(713,'I',0.28,0.205,0.055,0.1135,0.045,0.0275,0.0335,7),
(714,'M',0.355,0.265,0.085,0.201,0.069,0.053,0.0695,8),
(715,'M',0.35,0.255,0.08,0.1915,0.08,0.0385,0.063,9),
(716,'I',0.275,0.2,0.065,0.1035,0.0475,0.0205,0.03,7),
(717,'I',0.29,0.205,0.07,0.0975,0.036,0.019,0.035,8),
(718,'I',0.25,0.19,0.06,0.0765,0.036,0.0115,0.0245,6),
(719,'I',0.18,0.125,0.035,0.0265,0.0095,0.0055,0.0085,4),
(720,'I',0.15,0.1,0.025,0.015,0.0045,0.004,0.005,2),
(721,'I',0.16,0.11,0.025,0.018,0.0065,0.0055,0.005,3),
(722,'M',0.555,0.455,0.16,1.0575,0.3925,0.228,0.293,13),
(723,'M',0.555,0.44,0.15,1.092,0.416,0.212,0.4405,15),
(724,'M',0.525,0.41,0.13,0.99,0.3865,0.243,0.295,15),
(725,'M',0.465,0.36,0.08,0.488,0.191,0.125,0.155,11),
(726,'F',0.49,0.36,0.11,0.5005,0.161,0.107,0.195,17),
(727,'M',0.4,0.305,0.085,0.297,0.108,0.0705,0.1,10),
(728,'F',0.48,0.375,0.105,0.525,0.2185,0.1195,0.155,12),
(729,'M',0.505,0.4,0.125,0.77,0.2735,0.159,0.255,13),
(730,'F',0.52,0.4,0.12,0.6515,0.261,0.2015,0.165,15),
(731,'M',0.525,0.4,0.13,0.8295,0.2405,0.1825,0.275,11),
(732,'M',0.545,0.42,0.13,0.879,0.374,0.1695,0.23,13),
(733,'M',0.52,0.4,0.12,0.823,0.298,0.1805,0.265,15),
(734,'M',0.505,0.38,0.13,0.656,0.227,0.1785,0.22,13),
(735,'M',0.525,0.425,0.12,0.8665,0.2825,0.176,0.29,18),
(736,'M',0.51,0.39,0.125,0.6565,0.262,0.1835,0.175,10),
(737,'M',0.52,0.385,0.115,0.669,0.2385,0.172,0.205,12),
(738,'F',0.52,0.405,0.125,0.6435,0.2415,0.1735,0.21,12),
(739,'M',0.535,0.41,0.135,0.862,0.2855,0.1525,0.32,14),
(740,'M',0.445,0.345,0.09,0.3795,0.143,0.074,0.125,10),
(741,'M',0.53,0.44,0.205,0.835,0.32,0.2175,0.245,14),
(742,'F',0.36,0.265,0.09,0.2065,0.078,0.057,0.06,8),
(743,'F',0.535,0.42,0.15,0.7365,0.2785,0.186,0.215,14),
(744,'F',0.52,0.405,0.14,0.8175,0.2795,0.183,0.26,17),
(745,'M',0.53,0.415,0.13,0.8425,0.275,0.1945,0.265,20),
(746,'F',0.53,0.42,0.13,1.001,0.34,0.226,0.265,17),
(747,'F',0.66,0.52,0.2,1.676,0.673,0.4805,0.45,17),
(748,'M',0.52,0.385,0.14,0.6595,0.2485,0.2035,0.16,9),
(749,'M',0.535,0.42,0.13,0.8055,0.301,0.181,0.28,14),
(750,'M',0.695,0.515,0.175,1.5165,0.578,0.4105,0.39,15),
(751,'F',0.51,0.39,0.105,0.612,0.187,0.15,0.195,13),
(752,'M',0.485,0.355,0.12,0.547,0.215,0.1615,0.14,10),
(753,'F',0.605,0.46,0.17,1.122,0.347,0.3045,0.315,13),
(754,'F',0.58,0.455,0.165,1.1365,0.369,0.3005,0.275,13),
(755,'M',0.65,0.515,0.175,1.4805,0.5295,0.272,0.525,20),
(756,'M',0.62,0.505,0.185,1.5275,0.69,0.368,0.35,13),
(757,'M',0.615,0.525,0.155,1.1375,0.367,0.236,0.37,20),
(758,'F',0.605,0.495,0.19,1.437,0.469,0.2655,0.41,15),
(759,'M',0.57,0.44,0.155,1.116,0.4775,0.2315,0.27,13),
(760,'M',0.57,0.43,0.12,1.0615,0.348,0.167,0.31,15),
(761,'M',0.585,0.405,0.15,1.2565,0.435,0.202,0.325,15),
(762,'F',0.55,0.44,0.155,0.946,0.313,0.1825,0.335,16),
(763,'F',0.54,0.44,0.135,0.959,0.2385,0.221,0.3,17),
(764,'M',0.64,0.51,0.19,1.613,0.6215,0.361,0.47,14),
(765,'F',0.61,0.47,0.145,1.153,0.403,0.296,0.32,14),
(766,'M',0.545,0.45,0.15,0.978,0.3365,0.1905,0.3,11),
(767,'F',0.59,0.445,0.13,1.1325,0.3825,0.234,0.32,13),
(768,'M',0.345,0.27,0.095,0.197,0.0665,0.05,0.07,9),
(769,'F',0.55,0.43,0.155,0.785,0.289,0.227,0.233,11),
(770,'F',0.53,0.425,0.17,0.949,0.3485,0.2395,0.278,17),
(771,'F',0.53,0.455,0.165,0.9805,0.3155,0.2815,0.2965,11),
(772,'I',0.485,0.375,0.14,0.521,0.2,0.123,0.17,8),
(773,'M',0.385,0.275,0.115,0.2685,0.0975,0.0825,0.085,8),
(774,'M',0.455,0.34,0.135,0.462,0.1675,0.158,0.12,9),
(775,'M',0.49,0.38,0.14,0.7605,0.245,0.167,0.185,10),
(776,'M',0.53,0.41,0.165,0.732,0.189,0.17,0.31,11),
(777,'M',0.505,0.385,0.145,0.6775,0.236,0.179,0.2,15),
(778,'M',0.49,0.38,0.14,0.6385,0.2305,0.142,0.195,13),
(779,'M',0.465,0.35,0.14,0.5755,0.2015,0.1505,0.19,15),
(780,'F',0.47,0.36,0.145,0.537,0.1725,0.1375,0.195,15),
(781,'M',0.56,0.41,0.165,0.93,0.3505,0.237,0.3,13),
(782,'M',0.505,0.385,0.15,0.6415,0.246,0.152,0.215,12),
(783,'M',0.515,0.435,0.145,0.8815,0.292,0.206,0.255,10),
(784,'I',0.385,0.28,0.125,0.244,0.102,0.038,0.085,6),
(785,'I',0.215,0.155,0.06,0.0525,0.021,0.0165,0.015,5),
(786,'M',0.55,0.415,0.175,1.042,0.3295,0.2325,0.2905,15),
(787,'F',0.515,0.39,0.13,0.5755,0.1975,0.13,0.1845,9),
(788,'M',0.495,0.385,0.135,0.709,0.211,0.1375,0.262,12),
(789,'F',0.505,0.39,0.16,0.644,0.2475,0.2025,0.1635,9),
(790,'F',0.6,0.465,0.165,0.8875,0.309,0.246,0.262,12),
(791,'F',0.57,0.465,0.16,0.8935,0.3145,0.2575,0.263,10),
(792,'F',0.485,0.375,0.135,0.556,0.1925,0.1315,0.1685,10),
(793,'M',0.47,0.37,0.18,0.51,0.1915,0.1285,0.1625,9),
(794,'M',0.575,0.45,0.165,0.9215,0.3275,0.225,0.256,12),
(795,'M',0.58,0.465,0.16,1.0345,0.315,0.26,0.3635,12),
(796,'M',0.515,0.405,0.145,0.695,0.215,0.1635,0.234,15),
(797,'M',0.53,0.41,0.155,0.7155,0.2805,0.1685,0.214,11),
(798,'M',0.44,0.335,0.11,0.394,0.157,0.096,0.122,9),
(799,'M',0.52,0.42,0.16,0.745,0.255,0.157,0.2885,11),
(800,'F',0.425,0.345,0.11,0.3665,0.125,0.081,0.117,11),
(801,'M',0.46,0.34,0.135,0.495,0.1655,0.117,0.185,10),
(802,'M',0.45,0.335,0.125,0.349,0.119,0.1055,0.115,10),
(803,'M',0.425,0.33,0.13,0.4405,0.152,0.0935,0.155,9),
(804,'I',0.37,0.275,0.1,0.22,0.094,0.045,0.065,7),
(805,'M',0.515,0.38,0.135,0.6615,0.2875,0.2095,0.155,10),
(806,'M',0.405,0.305,0.12,0.3185,0.1235,0.0905,0.095,7),
(807,'I',0.28,0.205,0.07,0.1015,0.041,0.03,0.03,6),
(808,'F',0.48,0.4,0.125,0.759,0.2125,0.179,0.24,15),
(809,'F',0.44,0.34,0.13,0.4195,0.153,0.1155,0.13,10),
(810,'F',0.52,0.41,0.115,0.807,0.2855,0.179,0.235,12),
(811,'M',0.505,0.405,0.14,0.875,0.2665,0.174,0.285,12),
(812,'F',0.49,0.365,0.13,0.6835,0.165,0.1315,0.205,21),
(813,'I',0.235,0.175,0.055,0.067,0.027,0.0125,0.018,6),
(814,'I',0.255,0.185,0.06,0.088,0.0365,0.021,0.023,5),
(815,'I',0.315,0.24,0.085,0.1715,0.071,0.0345,0.0535,7),
(816,'I',0.325,0.25,0.08,0.1735,0.0765,0.0345,0.049,7),
(817,'I',0.335,0.25,0.08,0.183,0.0735,0.04,0.0575,6),
(818,'I',0.35,0.27,0.09,0.2055,0.075,0.0575,0.062,6),
(819,'I',0.35,0.25,0.07,0.18,0.0655,0.048,0.054,6),
(820,'I',0.36,0.3,0.085,0.27,0.1185,0.064,0.0745,7),
(821,'I',0.365,0.275,0.135,0.24,0.108,0.0445,0.0735,7),
(822,'I',0.37,0.275,0.14,0.2215,0.097,0.0455,0.0615,6),
(823,'I',0.38,0.275,0.095,0.1375,0.086,0.0585,0.0605,7),
(824,'I',0.385,0.29,0.095,0.312,0.143,0.0635,0.086,6),
(825,'I',0.385,0.3,0.1,0.2895,0.1215,0.063,0.09,7),
(826,'I',0.395,0.29,0.095,0.319,0.138,0.08,0.082,7),
(827,'I',0.395,0.29,0.095,0.304,0.127,0.084,0.077,6),
(828,'I',0.4,0.31,0.1,0.306,0.13,0.06,0.094,6),
(829,'I',0.41,0.325,0.1,0.394,0.208,0.0655,0.106,6),
(830,'I',0.415,0.32,0.11,0.3735,0.175,0.0755,0.109,7),
(831,'M',0.415,0.305,0.1,0.325,0.156,0.0505,0.091,6),
(832,'I',0.425,0.325,0.1,0.398,0.1185,0.0645,0.0945,6),
(833,'I',0.44,0.365,0.115,0.501,0.2435,0.084,0.1465,9),
(834,'I',0.445,0.335,0.1,0.4895,0.2745,0.086,0.1105,7),
(835,'I',0.445,0.325,0.1,0.378,0.1795,0.1,0.089,7),
(836,'I',0.45,0.35,0.13,0.547,0.245,0.1405,0.1405,8),
(837,'M',0.47,0.375,0.12,0.5805,0.266,0.0935,0.169,8),
(838,'I',0.475,0.365,0.125,0.5465,0.229,0.1185,0.172,9),
(839,'F',0.48,0.365,0.135,0.6395,0.2945,0.113,0.175,8),
(840,'I',0.485,0.355,0.105,0.498,0.2175,0.096,0.1525,9),
(841,'M',0.49,0.385,0.125,0.609,0.3065,0.096,0.1775,8),
(842,'F',0.495,0.41,0.125,0.7555,0.3355,0.129,0.214,9),
(843,'M',0.5,0.4,0.125,0.5975,0.27,0.1275,0.166,9),
(844,'M',0.505,0.44,0.14,0.8275,0.3415,0.1855,0.239,8),
(845,'M',0.525,0.395,0.13,0.7635,0.3375,0.1425,0.225,8),
(846,'M',0.54,0.405,0.125,0.891,0.4815,0.1915,0.202,9),
(847,'F',0.54,0.42,0.14,0.805,0.369,0.1725,0.21,11),
(848,'F',0.545,0.44,0.135,0.9185,0.429,0.2015,0.2375,10),
(849,'F',0.55,0.43,0.125,0.923,0.4035,0.175,0.283,8),
(850,'M',0.55,0.45,0.15,1.0145,0.407,0.2015,0.2875,10),
(851,'F',0.55,0.45,0.15,0.875,0.362,0.1755,0.2765,10),
(852,'M',0.555,0.435,0.145,0.9685,0.4985,0.168,0.2385,9),
(853,'M',0.565,0.45,0.155,1.0595,0.4735,0.24,0.265,10),
(854,'M',0.57,0.455,0.15,0.952,0.3895,0.2155,0.2745,9),
(855,'M',0.57,0.435,0.13,0.7535,0.349,0.1755,0.194,10),
(856,'F',0.575,0.465,0.14,0.958,0.442,0.1815,0.2705,9),
(857,'M',0.59,0.475,0.165,1.077,0.4545,0.244,0.3095,9),
(858,'M',0.59,0.46,0.13,1.102,0.455,0.2055,0.33,12),
(859,'F',0.595,0.48,0.15,1.11,0.498,0.228,0.33,10),
(860,'F',0.595,0.48,0.16,1.2095,0.5225,0.296,0.32,8),
(861,'F',0.595,0.475,0.16,1.1405,0.547,0.231,0.271,6),
(862,'F',0.595,0.465,0.14,1.113,0.5175,0.244,0.305,12),
(863,'M',0.6,0.475,0.175,1.3445,0.549,0.2875,0.36,11),
(864,'F',0.6,0.475,0.155,1.21,0.653,0.1695,0.3205,10),
(865,'M',0.6,0.495,0.175,1.29,0.606,0.276,0.3445,11),
(866,'F',0.605,0.475,0.175,1.382,0.609,0.2325,0.3985,10),
(867,'M',0.605,0.455,0.16,1.1035,0.421,0.3015,0.325,9),
(868,'F',0.615,0.5,0.175,1.377,0.5585,0.33,0.292,12),
(869,'F',0.615,0.52,0.15,1.3435,0.629,0.2605,0.345,10),
(870,'M',0.615,0.51,0.15,1.296,0.545,0.3315,0.32,9),
(871,'M',0.615,0.505,0.165,1.34,0.5315,0.2815,0.41,12),
(872,'F',0.62,0.505,0.16,1.3725,0.6285,0.275,0.3685,11),
(873,'M',0.62,0.5,0.165,1.307,0.6355,0.2545,0.315,9),
(874,'F',0.625,0.49,0.155,1.2085,0.465,0.162,0.411,11),
(875,'F',0.625,0.49,0.2,1.3825,0.5895,0.285,0.381,11),
(876,'M',0.63,0.505,0.165,1.26,0.4525,0.2755,0.406,14),
(877,'M',0.635,0.51,0.17,1.3555,0.619,0.305,0.39,9),
(878,'F',0.635,0.5,0.15,1.376,0.6495,0.361,0.31,10),
(879,'F',0.635,0.485,0.165,1.2945,0.668,0.2605,0.2715,9),
(880,'F',0.64,0.51,0.165,1.486,0.7595,0.332,0.321,8),
(881,'M',0.65,0.525,0.175,1.4715,0.675,0.315,0.399,11),
(882,'M',0.655,0.52,0.165,1.4095,0.586,0.291,0.405,9),
(883,'M',0.655,0.58,0.205,2.0805,0.959,0.3415,0.601,17),
(884,'M',0.66,0.53,0.17,1.3905,0.5905,0.212,0.453,15),
(885,'M',0.66,0.52,0.19,1.558,0.755,0.298,0.4,10),
(886,'F',0.67,0.585,0.16,1.309,0.5445,0.2945,0.413,10),
(887,'F',0.675,0.525,0.17,1.8095,0.784,0.391,0.455,12),
(888,'F',0.675,0.525,0.155,1.4785,0.628,0.3405,0.42,9),
(889,'F',0.68,0.56,0.195,1.7775,0.861,0.322,0.415,11),
(890,'F',0.685,0.54,0.16,1.6675,0.833,0.3775,0.475,11),
(891,'F',0.695,0.56,0.22,1.834,0.8455,0.422,0.455,11),
(892,'M',0.73,0.595,0.23,2.8255,1.1465,0.419,0.897,17),
(893,'I',0.205,0.14,0.05,0.046,0.0165,0.012,0.0135,6),
(894,'I',0.24,0.175,0.055,0.0705,0.025,0.014,0.021,5),
(895,'I',0.24,0.175,0.065,0.0665,0.031,0.0135,0.017,3),
(896,'I',0.255,0.19,0.05,0.083,0.0295,0.0215,0.027,6),
(897,'I',0.255,0.18,0.055,0.083,0.031,0.0215,0.02,4),
(898,'I',0.265,0.195,0.06,0.092,0.0345,0.025,0.0245,6),
(899,'I',0.28,0.12,0.075,0.117,0.0455,0.029,0.0345,4),
(900,'I',0.295,0.23,0.08,0.1625,0.065,0.05,0.0385,5),
(901,'I',0.3,0.235,0.08,0.131,0.05,0.0265,0.043,4),
(902,'I',0.3,0.23,0.095,0.1385,0.056,0.0365,0.037,6),
(903,'I',0.305,0.22,0.07,0.141,0.062,0.031,0.037,5),
(904,'I',0.315,0.235,0.075,0.1485,0.0585,0.0375,0.0425,6),
(905,'I',0.315,0.23,0.07,0.144,0.053,0.0305,0.04,8),
(906,'I',0.32,0.24,0.09,0.1575,0.07,0.0265,0.0425,5),
(907,'I',0.325,0.24,0.075,0.187,0.0825,0.0445,0.05,6),
(908,'I',0.33,0.265,0.085,0.196,0.0775,0.0305,0.0445,6),
(909,'I',0.335,0.25,0.075,0.1825,0.0705,0.044,0.055,7),
(910,'I',0.335,0.25,0.075,0.186,0.0945,0.038,0.0445,7),
(911,'I',0.34,0.25,0.075,0.1785,0.0665,0.0455,0.045,5),
(912,'I',0.34,0.25,0.07,0.2225,0.104,0.0425,0.055,7),
(913,'I',0.345,0.265,0.1,0.2455,0.111,0.0535,0.065,7),
(914,'I',0.37,0.29,0.095,0.249,0.1045,0.058,0.067,6),
(915,'I',0.37,0.28,0.095,0.2865,0.1505,0.069,0.0795,7),
(916,'I',0.375,0.28,0.09,0.215,0.084,0.06,0.055,6),
(917,'I',0.385,0.265,0.08,0.251,0.124,0.037,0.07,6),
(918,'I',0.41,0.31,0.09,0.339,0.155,0.0695,0.09,7),
(919,'I',0.41,0.305,0.09,0.3535,0.157,0.0745,0.1,7),
(920,'I',0.41,0.31,0.09,0.3335,0.1635,0.061,0.091,6),
(921,'I',0.415,0.33,0.09,0.3595,0.17,0.081,0.09,6),
(922,'I',0.42,0.32,0.115,0.376,0.169,0.092,0.1,5),
(923,'I',0.42,0.315,0.1,0.3435,0.157,0.0795,0.09,6),
(924,'I',0.425,0.34,0.1,0.382,0.164,0.096,0.1,6),
(925,'I',0.425,0.315,0.1,0.377,0.1645,0.072,0.105,6),
(926,'I',0.43,0.325,0.1,0.3645,0.1575,0.0825,0.105,7),
(927,'I',0.43,0.325,0.09,0.425,0.217,0.087,0.095,7),
(928,'I',0.435,0.325,0.12,0.3995,0.1815,0.061,0.1125,8),
(929,'I',0.435,0.34,0.115,0.3925,0.1825,0.078,0.1145,6),
(930,'I',0.44,0.345,0.13,0.4495,0.209,0.0835,0.134,6),
(931,'I',0.44,0.325,0.09,0.35,0.148,0.067,0.105,7),
(932,'F',0.445,0.335,0.11,0.4355,0.2025,0.1095,0.1195,6),
(933,'I',0.445,0.35,0.13,0.4195,0.1695,0.0945,0.1195,7),
(934,'I',0.45,0.36,0.13,0.478,0.191,0.127,0.137,7),
(935,'I',0.45,0.355,0.105,0.4445,0.197,0.093,0.1335,8),
(936,'I',0.45,0.345,0.11,0.47,0.2355,0.0855,0.1135,7),
(937,'I',0.45,0.335,0.105,0.447,0.2335,0.153,0.119,7),
(938,'I',0.455,0.355,0.125,0.5325,0.225,0.126,0.1465,7),
(939,'I',0.455,0.375,0.12,0.497,0.2355,0.1055,0.1295,6),
(940,'I',0.46,0.36,0.1,0.4635,0.2325,0.093,0.115,7),
(941,'I',0.46,0.345,0.105,0.449,0.196,0.0945,0.1265,7),
(942,'I',0.465,0.365,0.115,0.467,0.2315,0.0925,0.113,7),
(943,'I',0.465,0.37,0.115,0.534,0.261,0.098,0.143,7),
(944,'I',0.465,0.345,0.11,0.4415,0.1755,0.0905,0.12,7),
(945,'F',0.465,0.35,0.125,0.482,0.23,0.106,0.1095,6),
(946,'M',0.47,0.365,0.12,0.612,0.327,0.15,0.14,8),
(947,'F',0.47,0.365,0.12,0.582,0.29,0.092,0.146,8),
(948,'M',0.475,0.37,0.125,0.537,0.222,0.1215,0.15,9),
(949,'F',0.475,0.36,0.12,0.5915,0.3245,0.11,0.127,6),
(950,'M',0.48,0.375,0.115,0.6765,0.3205,0.1065,0.17,6),
(951,'M',0.48,0.385,0.145,0.64,0.2925,0.1405,0.1575,6),
(952,'M',0.48,0.36,0.1,0.439,0.194,0.099,0.115,8),
(953,'M',0.48,0.365,0.12,0.6015,0.312,0.117,0.14,7),
(954,'F',0.485,0.37,0.115,0.4785,0.1995,0.0955,0.129,7),
(955,'M',0.49,0.385,0.125,0.649,0.32,0.124,0.1695,8),
(956,'M',0.495,0.395,0.135,0.6335,0.3035,0.1295,0.1495,8),
(957,'M',0.495,0.4,0.135,0.61,0.272,0.1435,0.144,7),
(958,'M',0.5,0.39,0.135,0.6595,0.3145,0.1535,0.1565,6),
(959,'I',0.5,0.385,0.12,0.56,0.2835,0.103,0.135,8),
(960,'M',0.5,0.385,0.135,0.6425,0.3195,0.129,0.1535,7),
(961,'M',0.5,0.4,0.125,0.6725,0.336,0.12,0.1825,7),
(962,'F',0.505,0.39,0.13,0.674,0.3165,0.141,0.1785,9),
(963,'I',0.505,0.39,0.15,0.685,0.362,0.131,0.156,8),
(964,'M',0.505,0.41,0.125,0.642,0.289,0.133,0.155,9),
(965,'I',0.505,0.355,0.125,0.601,0.25,0.1205,0.185,8),
(966,'M',0.51,0.39,0.135,0.769,0.3935,0.1455,0.19,8),
(967,'I',0.51,0.375,0.1,0.5785,0.238,0.1225,0.175,7),
(968,'I',0.51,0.405,0.135,0.769,0.3655,0.1585,0.18,7),
(969,'M',0.51,0.405,0.15,0.7035,0.347,0.134,0.1885,8),
(970,'M',0.51,0.41,0.145,0.796,0.3865,0.1815,0.1955,8),
(971,'F',0.515,0.43,0.14,0.834,0.367,0.2,0.23,8),
(972,'M',0.515,0.39,0.155,0.7125,0.3695,0.137,0.155,7),
(973,'F',0.525,0.415,0.14,0.724,0.3475,0.173,0.175,8),
(974,'M',0.525,0.4,0.14,0.7325,0.334,0.1575,0.17,11),
(975,'F',0.53,0.425,0.13,0.7585,0.325,0.197,0.205,8),
(976,'F',0.53,0.425,0.15,0.8495,0.328,0.232,0.202,8),
(977,'M',0.53,0.405,0.125,0.6515,0.2715,0.1605,0.186,7),
(978,'F',0.535,0.4,0.135,0.8215,0.3935,0.196,0.205,8),
(979,'M',0.535,0.43,0.14,0.7165,0.2855,0.1595,0.2155,8),
(980,'M',0.535,0.435,0.14,0.874,0.3735,0.229,0.2195,8),
(981,'F',0.55,0.445,0.155,0.9905,0.544,0.178,0.218,9),
(982,'F',0.55,0.43,0.14,0.8105,0.368,0.161,0.275,9),
(983,'F',0.56,0.455,0.16,0.967,0.4525,0.207,0.274,9),
(984,'F',0.565,0.4,0.13,0.6975,0.3075,0.1665,0.18,8),
(985,'M',0.57,0.45,0.155,1.195,0.5625,0.2565,0.295,10),
(986,'M',0.57,0.45,0.155,1.1935,0.513,0.21,0.343,10),
(987,'F',0.57,0.455,0.15,1.107,0.54,0.255,0.27,8),
(988,'M',0.57,0.445,0.14,1.0635,0.5265,0.2195,0.24,8),
(989,'M',0.57,0.46,0.17,0.9035,0.4075,0.1935,0.214,7),
(990,'M',0.575,0.475,0.16,1.114,0.4955,0.2745,0.29,9),
(991,'F',0.575,0.46,0.16,1.103,0.538,0.221,0.249,9),
(992,'F',0.58,0.46,0.15,1.1155,0.5575,0.2255,0.29,7),
(993,'F',0.58,0.46,0.18,1.0515,0.4095,0.2595,0.276,8),
(994,'M',0.58,0.455,0.15,1.012,0.4985,0.2115,0.2835,10),
(995,'F',0.58,0.45,0.145,1.137,0.5585,0.22,0.29,8),
(996,'M',0.58,0.49,0.13,1.1335,0.586,0.2565,0.237,9),
(997,'M',0.59,0.465,0.155,1.136,0.5245,0.2615,0.275,11),
(998,'M',0.59,0.47,0.16,1.206,0.479,0.2425,0.309,8),
(999,'F',0.59,0.455,0.145,1.063,0.5155,0.2445,0.25,8),
(1000,'F',0.595,0.47,0.155,1.121,0.4515,0.178,0.155,11),
(1001,'F',0.595,0.45,0.15,1.114,0.5865,0.2205,0.25,11),
(1002,'M',0.595,0.475,0.165,1.213,0.621,0.2435,0.274,9),
(1003,'F',0.595,0.46,0.14,1.0045,0.4655,0.2095,0.2515,9),
(1004,'M',0.595,0.455,0.15,1.044,0.518,0.2205,0.27,9),
(1005,'F',0.605,0.49,0.15,1.1345,0.5265,0.2645,0.295,9),
(1006,'M',0.605,0.475,0.155,1.161,0.572,0.2455,0.275,9),
(1007,'M',0.605,0.47,0.165,1.2315,0.6025,0.262,0.2925,11),
(1008,'M',0.61,0.47,0.15,1.1625,0.565,0.258,0.3085,11),
(1009,'M',0.61,0.475,0.155,1.168,0.554,0.239,0.3295,10),
(1010,'F',0.615,0.48,0.16,1.2525,0.585,0.2595,0.33,8),
(1011,'F',0.62,0.51,0.18,1.3315,0.594,0.276,0.388,11),
(1012,'F',0.625,0.48,0.17,1.3525,0.6235,0.278,0.365,10),
(1013,'M',0.625,0.49,0.175,1.3325,0.5705,0.271,0.405,10),
(1014,'F',0.625,0.475,0.175,1.1435,0.4755,0.2475,0.349,10),
(1015,'F',0.625,0.5,0.165,1.288,0.573,0.3035,0.315,9),
(1016,'F',0.625,0.485,0.2,1.38,0.5845,0.302,0.401,9),
(1017,'M',0.63,0.485,0.155,1.278,0.637,0.275,0.31,8),
(1018,'F',0.63,0.495,0.165,1.3075,0.599,0.284,0.315,11),
(1019,'M',0.63,0.48,0.15,1.1785,0.5185,0.248,0.3235,8),
(1020,'M',0.635,0.49,0.175,1.375,0.623,0.2705,0.395,11),
(1021,'M',0.635,0.525,0.185,1.4065,0.684,0.3,0.3745,10),
(1022,'M',0.64,0.505,0.155,1.4025,0.705,0.2655,0.335,10),
(1023,'F',0.64,0.5,0.17,1.5175,0.693,0.326,0.409,11),
(1024,'F',0.64,0.5,0.175,1.394,0.4935,0.291,0.4,10),
(1025,'F',0.645,0.5,0.155,1.2205,0.6145,0.236,0.3185,10),
(1026,'M',0.645,0.52,0.175,1.636,0.779,0.342,0.432,11),
(1027,'M',0.645,0.52,0.175,1.561,0.709,0.3555,0.4,8),
(1028,'F',0.645,0.505,0.165,1.4325,0.684,0.308,0.336,8),
(1029,'M',0.645,0.5,0.175,1.3385,0.633,0.299,0.349,11),
(1030,'F',0.645,0.5,0.16,1.2465,0.5475,0.327,0.3,10),
(1031,'F',0.645,0.515,0.15,1.212,0.515,0.2055,0.385,10),
(1032,'M',0.65,0.495,0.16,1.304,0.57,0.312,0.3725,9),
(1033,'M',0.65,0.52,0.21,1.6785,0.6665,0.308,0.46,11),
(1034,'M',0.65,0.525,0.185,1.622,0.6645,0.3225,0.477,10),
(1035,'F',0.655,0.46,0.16,1.494,0.6895,0.331,0.1825,9),
(1036,'F',0.655,0.51,0.175,1.6525,0.8515,0.3365,0.403,10),
(1037,'F',0.66,0.505,0.185,1.528,0.69,0.3025,0.441,11),
(1038,'M',0.66,0.535,0.19,1.5905,0.6425,0.297,0.5175,9),
(1039,'M',0.66,0.495,0.195,1.6275,0.594,0.3595,0.485,10),
(1040,'F',0.66,0.475,0.18,1.3695,0.641,0.294,0.335,6),
(1041,'M',0.67,0.525,0.165,1.6085,0.682,0.3145,0.4005,11),
(1042,'F',0.675,0.57,0.225,1.587,0.739,0.2995,0.435,10),
(1043,'F',0.675,0.565,0.195,1.8375,0.7645,0.3615,0.553,12),
(1044,'M',0.68,0.535,0.185,1.607,0.7245,0.3215,0.498,12),
(1045,'M',0.69,0.525,0.175,1.7005,0.8255,0.362,0.405,8),
(1046,'M',0.69,0.505,0.2,1.872,0.893,0.4015,0.48,10),
(1047,'F',0.695,0.535,0.175,1.8385,0.8035,0.396,0.503,10),
(1048,'F',0.705,0.535,0.18,1.685,0.693,0.42,0.4045,12),
(1049,'M',0.71,0.565,0.205,2.198,1.012,0.5225,0.5475,11),
(1050,'M',0.715,0.565,0.175,1.9525,0.7645,0.4185,0.4135,10),
(1051,'F',0.715,0.525,0.185,1.56,0.6655,0.383,0.405,11),
(1052,'F',0.735,0.6,0.22,2.555,1.1335,0.44,0.6,11),
(1053,'M',0.765,0.6,0.22,2.302,1.007,0.509,0.6205,12),
(1054,'I',0.185,0.13,0.045,0.029,0.012,0.0075,0.0095,4),
(1055,'I',0.195,0.15,0.045,0.0375,0.018,0.006,0.011,3),
(1056,'I',0.195,0.135,0.04,0.0325,0.0135,0.005,0.0095,4),
(1057,'I',0.2,0.155,0.04,0.0435,0.0155,0.009,0.007,4),
(1058,'I',0.225,0.165,0.055,0.059,0.027,0.0125,0.015,4),
(1059,'I',0.245,0.18,0.065,0.071,0.03,0.013,0.0215,4),
(1060,'I',0.25,0.18,0.065,0.0685,0.0245,0.0155,0.0225,5),
(1061,'I',0.265,0.195,0.055,0.084,0.0365,0.0175,0.025,7),
(1062,'I',0.275,0.195,0.065,0.106,0.054,0.02,0.028,6),
(1063,'I',0.28,0.21,0.085,0.1075,0.0415,0.024,0.034,5),
(1064,'I',0.285,0.22,0.065,0.096,0.0405,0.0205,0.03,5),
(1065,'I',0.3,0.22,0.08,0.1255,0.055,0.0265,0.039,6),
(1066,'I',0.315,0.235,0.055,0.151,0.065,0.027,0.039,6),
(1067,'I',0.32,0.225,0.085,0.1415,0.0675,0.0295,0.0405,6),
(1068,'I',0.34,0.265,0.08,0.2015,0.09,0.0475,0.055,5),
(1069,'I',0.37,0.28,0.1,0.221,0.1165,0.0265,0.0635,6),
(1070,'I',0.375,0.28,0.08,0.2345,0.1125,0.0455,0.067,6),
(1071,'I',0.375,0.275,0.1,0.2325,0.1165,0.042,0.065,6),
(1072,'I',0.385,0.29,0.08,0.2485,0.122,0.0495,0.065,7),
(1073,'I',0.4,0.32,0.095,0.348,0.194,0.053,0.087,6),
(1074,'I',0.405,0.3,0.11,0.32,0.172,0.044,0.093,7),
(1075,'I',0.41,0.3,0.1,0.282,0.1255,0.057,0.0875,7),
(1076,'I',0.41,0.325,0.1,0.3245,0.132,0.072,0.106,6),
(1077,'I',0.42,0.3,0.105,0.316,0.1255,0.07,0.1035,7),
(1078,'I',0.42,0.32,0.11,0.3625,0.174,0.0635,0.105,7),
(1079,'I',0.42,0.31,0.095,0.279,0.1255,0.051,0.088,6),
(1080,'I',0.425,0.325,0.115,0.3685,0.162,0.0865,0.1045,7),
(1081,'M',0.43,0.335,0.12,0.397,0.1985,0.0865,0.1035,7),
(1082,'I',0.435,0.33,0.11,0.413,0.2055,0.096,0.096,6),
(1083,'I',0.435,0.345,0.115,0.418,0.222,0.0735,0.106,7),
(1084,'I',0.44,0.33,0.11,0.3705,0.1545,0.084,0.12,7),
(1085,'I',0.445,0.345,0.105,0.409,0.1675,0.1015,0.117,7),
(1086,'I',0.445,0.34,0.145,0.434,0.1945,0.0905,0.13,7),
(1087,'I',0.445,0.335,0.11,0.411,0.1985,0.0935,0.109,8),
(1088,'I',0.45,0.365,0.125,0.462,0.2135,0.0985,0.1315,8),
(1089,'I',0.45,0.34,0.12,0.4925,0.241,0.1075,0.12,6),
(1090,'I',0.45,0.33,0.105,0.3715,0.1865,0.0785,0.0975,7),
(1091,'I',0.45,0.33,0.1,0.411,0.1945,0.1,0.098,6),
(1092,'I',0.45,0.33,0.11,0.3685,0.16,0.0885,0.102,6),
(1093,'I',0.46,0.35,0.115,0.4155,0.18,0.098,0.1175,7),
(1094,'M',0.47,0.36,0.105,0.544,0.27,0.1395,0.129,7),
(1095,'I',0.47,0.38,0.125,0.4845,0.211,0.1075,0.142,6),
(1096,'I',0.475,0.35,0.11,0.4565,0.206,0.099,0.13,6),
(1097,'I',0.475,0.35,0.1,0.4545,0.2165,0.111,0.115,7),
(1098,'I',0.48,0.38,0.125,0.6245,0.3395,0.1085,0.1665,8),
(1099,'M',0.49,0.465,0.125,0.5225,0.235,0.13,0.141,7),
(1100,'I',0.5,0.375,0.14,0.5495,0.248,0.112,0.1585,7),
(1101,'I',0.5,0.375,0.12,0.542,0.215,0.116,0.17,9),
(1102,'I',0.5,0.38,0.125,0.519,0.2485,0.1135,0.134,8),
(1103,'M',0.5,0.39,0.125,0.5215,0.2485,0.117,0.131,6),
(1104,'F',0.505,0.39,0.125,0.5445,0.246,0.15,0.1405,7),
(1105,'I',0.51,0.405,0.125,0.6795,0.3465,0.1395,0.182,8),
(1106,'F',0.51,0.4,0.125,0.545,0.261,0.115,0.1385,6),
(1107,'I',0.51,0.4,0.125,0.5575,0.2615,0.1195,0.1525,9),
(1108,'I',0.51,0.38,0.115,0.5155,0.215,0.1135,0.166,8),
(1109,'I',0.515,0.385,0.125,0.6115,0.3175,0.1265,0.15,8),
(1110,'M',0.52,0.4,0.145,0.7765,0.3525,0.1845,0.185,9),
(1111,'I',0.52,0.38,0.135,0.5395,0.2295,0.133,0.157,8),
(1112,'I',0.52,0.38,0.125,0.5545,0.288,0.1295,0.167,8),
(1113,'F',0.52,0.46,0.15,1.019,0.523,0.1985,0.254,7),
(1114,'I',0.525,0.4,0.13,0.6455,0.325,0.1245,0.17,8),
(1115,'I',0.525,0.4,0.14,0.601,0.2625,0.1285,0.1835,9),
(1116,'M',0.525,0.405,0.12,0.7555,0.3755,0.1555,0.201,9),
(1117,'I',0.525,0.395,0.12,0.608,0.297,0.1395,0.1405,8),
(1118,'I',0.53,0.4,0.125,0.617,0.279,0.127,0.19,8),
(1119,'I',0.535,0.39,0.125,0.599,0.2595,0.149,0.169,9),
(1120,'I',0.54,0.42,0.14,0.6665,0.3125,0.138,0.1895,10),
(1121,'M',0.545,0.39,0.135,0.7835,0.4225,0.1815,0.156,7),
(1122,'M',0.545,0.41,0.12,0.793,0.434,0.1405,0.19,9),
(1123,'M',0.545,0.415,0.14,0.82,0.4615,0.127,0.218,9),
(1124,'F',0.55,0.415,0.135,0.8145,0.427,0.1855,0.175,8),
(1125,'F',0.55,0.43,0.15,0.84,0.395,0.195,0.223,8),
(1126,'M',0.55,0.425,0.15,0.8315,0.411,0.1765,0.2165,10),
(1127,'M',0.56,0.43,0.145,0.8995,0.464,0.1775,0.234,9),
(1128,'M',0.56,0.445,0.16,0.8965,0.42,0.2175,0.2215,8),
(1129,'F',0.56,0.44,0.155,0.6405,0.336,0.1765,0.245,8),
(1130,'M',0.56,0.415,0.145,0.852,0.43,0.1885,0.205,8),
(1131,'M',0.565,0.455,0.15,0.9595,0.4565,0.2395,0.23,9),
(1132,'M',0.565,0.435,0.15,0.99,0.5795,0.1825,0.206,8),
(1133,'F',0.565,0.45,0.175,1.0095,0.447,0.2375,0.2645,9),
(1134,'M',0.57,0.46,0.15,1.0375,0.5415,0.2035,0.25,9),
(1135,'F',0.57,0.445,0.145,0.8775,0.412,0.217,0.22,8),
(1136,'I',0.57,0.44,0.15,0.755,0.3425,0.16,0.224,8),
(1137,'F',0.575,0.46,0.145,0.9945,0.466,0.229,0.265,7),
(1138,'F',0.575,0.45,0.16,1.068,0.556,0.214,0.2575,10),
(1139,'M',0.575,0.435,0.14,0.8455,0.401,0.191,0.222,9),
(1140,'F',0.575,0.47,0.165,0.869,0.435,0.197,0.238,9),
(1141,'M',0.575,0.455,0.135,0.907,0.4245,0.197,0.26,9),
(1142,'I',0.575,0.435,0.13,0.805,0.3155,0.2155,0.245,10),
(1143,'M',0.575,0.445,0.17,1.0225,0.549,0.2175,0.228,9),
(1144,'M',0.575,0.445,0.145,0.847,0.415,0.1945,0.22,9),
(1145,'M',0.58,0.455,0.15,1.114,0.4765,0.2155,0.265,8),
(1146,'M',0.58,0.455,0.195,1.859,0.945,0.426,0.441,9),
(1147,'M',0.58,0.445,0.135,0.814,0.3775,0.1915,0.22,9),
(1148,'M',0.58,0.45,0.14,0.9615,0.486,0.1815,0.253,9),
(1149,'M',0.58,0.45,0.145,1.0025,0.547,0.1975,0.2295,8),
(1150,'F',0.58,0.45,0.155,0.93,0.385,0.246,0.265,9),
(1151,'M',0.585,0.46,0.145,0.9335,0.478,0.1825,0.235,9),
(1152,'M',0.585,0.465,0.16,0.9555,0.4595,0.236,0.265,7),
(1153,'M',0.59,0.47,0.15,0.9955,0.481,0.232,0.24,8),
(1154,'F',0.6,0.475,0.16,1.0265,0.485,0.2495,0.2565,9),
(1155,'M',0.6,0.455,0.17,1.1915,0.696,0.2395,0.24,8),
(1156,'F',0.6,0.465,0.15,1.1025,0.5455,0.262,0.25,8),
(1157,'M',0.6,0.465,0.155,1.0165,0.512,0.2465,0.225,10),
(1158,'F',0.605,0.47,0.165,1.1775,0.611,0.2275,0.292,9),
(1159,'M',0.605,0.475,0.14,1.1175,0.555,0.257,0.274,9),
(1160,'M',0.605,0.48,0.17,1.1835,0.582,0.2365,0.317,10),
(1161,'F',0.605,0.475,0.165,1.056,0.433,0.2195,0.357,9),
(1162,'M',0.61,0.485,0.16,1.0145,0.5315,0.212,0.2415,8),
(1163,'M',0.61,0.485,0.145,1.3305,0.783,0.2255,0.2865,9),
(1164,'M',0.61,0.47,0.165,1.052,0.498,0.242,0.267,9),
(1165,'M',0.615,0.46,0.17,1.0565,0.4815,0.272,0.27,10),
(1166,'F',0.615,0.465,0.15,0.923,0.4615,0.1825,0.2415,9),
(1167,'F',0.615,0.475,0.155,1.027,0.447,0.25,0.285,9),
(1168,'M',0.62,0.47,0.135,1.0195,0.5315,0.2005,0.2475,8),
(1169,'M',0.62,0.45,0.2,0.858,0.4285,0.1525,0.2405,8),
(1170,'F',0.62,0.48,0.16,1.1125,0.5635,0.2445,0.281,8),
(1171,'F',0.625,0.485,0.175,1.3745,0.7335,0.2715,0.332,9),
(1172,'M',0.625,0.48,0.185,1.2065,0.587,0.29,0.286,8),
(1173,'M',0.63,0.47,0.155,1.1325,0.589,0.211,0.287,8),
(1174,'M',0.63,0.5,0.175,1.2645,0.5635,0.3065,0.3425,10),
(1175,'F',0.635,0.495,0.015,1.1565,0.5115,0.308,0.2885,9),
(1176,'M',0.64,0.515,0.165,1.369,0.632,0.3415,0.358,10),
(1177,'M',0.645,0.53,0.195,1.39,0.6465,0.2945,0.3735,10),
(1178,'F',0.645,0.48,0.17,1.1345,0.528,0.254,0.305,10),
(1179,'F',0.65,0.5,0.19,1.464,0.6415,0.339,0.4245,9),
(1180,'M',0.65,0.5,0.155,1.202,0.565,0.3135,0.294,11),
(1181,'M',0.655,0.515,0.16,1.31,0.553,0.369,0.345,11),
(1182,'F',0.655,0.51,0.175,1.415,0.5885,0.3725,0.364,10),
(1183,'F',0.66,0.53,0.185,1.346,0.546,0.2705,0.476,11),
(1184,'M',0.665,0.525,0.16,1.363,0.629,0.279,0.34,8),
(1185,'I',0.665,0.5,0.17,1.2975,0.6035,0.291,0.3595,9),
(1186,'F',0.67,0.505,0.205,1.3645,0.6075,0.3025,0.353,9),
(1187,'F',0.685,0.54,0.215,1.7025,0.664,0.3655,0.4735,14),
(1188,'M',0.685,0.52,0.165,1.519,0.699,0.3685,0.4,10),
(1189,'F',0.69,0.54,0.155,1.454,0.624,0.3105,0.39,9),
(1190,'M',0.69,0.53,0.21,1.583,0.7355,0.405,0.3865,12),
(1191,'F',0.69,0.53,0.17,1.5535,0.7945,0.3485,0.3695,9),
(1192,'M',0.695,0.56,0.185,1.74,0.885,0.3715,0.4375,10),
(1193,'M',0.7,0.565,0.18,1.751,0.895,0.3355,0.446,9),
(1194,'M',0.7,0.575,0.19,2.273,1.095,0.418,0.638,12),
(1195,'F',0.7,0.525,0.19,1.6465,0.8545,0.307,0.3995,9),
(1196,'F',0.705,0.55,0.17,1.219,0.6395,0.236,0.301,9),
(1197,'F',0.71,0.56,0.18,1.652,0.735,0.381,0.4525,11),
(1198,'M',0.715,0.55,0.19,2.0045,1.0465,0.407,0.5075,12),
(1199,'M',0.715,0.535,0.19,1.6755,0.889,0.313,0.42,10),
(1200,'F',0.72,0.58,0.195,2.103,1.0265,0.48,0.5375,10),
(1201,'F',0.72,0.55,0.2,1.9965,0.9035,0.469,0.5215,10),
(1202,'M',0.72,0.565,0.145,1.187,0.691,0.1945,0.2685,8),
(1203,'M',0.725,0.505,0.185,1.978,1.026,0.4255,0.4505,12),
(1204,'F',0.73,0.575,0.185,1.8795,0.931,0.38,0.4825,12),
(1205,'M',0.735,0.585,0.185,2.124,0.952,0.55,0.5,11),
(1206,'M',0.745,0.565,0.215,1.931,0.896,0.4585,0.5,11),
(1207,'F',0.75,0.57,0.21,2.236,1.109,0.5195,0.545,11),
(1208,'F',0.755,0.625,0.21,2.505,1.1965,0.513,0.6785,11),
(1209,'M',0.755,0.58,0.205,2.0065,0.8295,0.4015,0.595,10),
(1210,'F',0.78,0.63,0.215,2.657,1.488,0.4985,0.586,11),
(1211,'I',0.185,0.375,0.12,0.4645,0.196,0.1045,0.15,6),
(1212,'I',0.245,0.205,0.06,0.0765,0.034,0.014,0.0215,4),
(1213,'I',0.25,0.185,0.065,0.0685,0.0295,0.014,0.0225,5),
(1214,'I',0.25,0.19,0.065,0.0835,0.039,0.015,0.025,5),
(1215,'I',0.275,0.195,0.09,0.1125,0.0545,0.0295,0.0355,6),
(1216,'I',0.305,0.215,0.065,0.1075,0.044,0.0205,0.038,5),
(1217,'I',0.31,0.225,0.07,0.1055,0.435,0.015,0.04,5),
(1218,'I',0.315,0.23,0.08,0.1375,0.0545,0.031,0.0445,5),
(1219,'I',0.315,0.23,0.07,0.1145,0.046,0.0235,0.0385,5),
(1220,'I',0.325,0.225,0.075,0.139,0.0565,0.032,0.09,6),
(1221,'I',0.33,0.25,0.095,0.2085,0.102,0.0395,0.052,7),
(1222,'I',0.33,0.205,0.095,0.1595,0.077,0.032,0.0435,5),
(1223,'I',0.335,0.245,0.09,0.2015,0.096,0.0405,0.048,7),
(1224,'I',0.34,0.25,0.09,0.179,0.0775,0.033,0.055,6),
(1225,'I',0.345,0.255,0.095,0.1945,0.0925,0.037,0.055,6),
(1226,'I',0.345,0.255,0.085,0.2005,0.105,0.037,0.05,5),
(1227,'I',0.35,0.27,0.075,0.215,0.1,0.036,0.065,6),
(1228,'I',0.35,0.255,0.09,0.1785,0.0855,0.0305,0.0525,8),
(1229,'I',0.36,0.27,0.085,0.196,0.0875,0.035,0.064,4),
(1230,'I',0.365,0.27,0.085,0.1875,0.081,0.042,0.058,6),
(1231,'I',0.365,0.27,0.085,0.196,0.0825,0.0375,0.06,7),
(1232,'I',0.365,0.265,0.085,0.213,0.0945,0.049,0.06,7),
(1233,'I',0.37,0.29,0.09,0.2445,0.089,0.0655,0.075,7),
(1234,'I',0.37,0.28,0.085,0.217,0.1095,0.035,0.062,6),
(1235,'I',0.375,0.29,0.095,0.213,0.096,0.041,0.061,5),
(1236,'I',0.375,0.29,0.085,0.2385,0.118,0.045,0.0695,7),
(1237,'I',0.375,0.275,0.09,0.218,0.093,0.0405,0.0755,6),
(1238,'I',0.375,0.275,0.095,0.2465,0.11,0.0415,0.0775,6),
(1239,'I',0.375,0.28,0.08,0.2025,0.0825,0.048,0.065,8),
(1240,'I',0.375,0.27,0.085,0.218,0.0945,0.039,0.07,7),
(1241,'I',0.38,0.275,0.11,0.256,0.11,0.0535,0.0755,6),
(1242,'I',0.38,0.27,0.08,0.2105,0.0865,0.042,0.07,8),
(1243,'I',0.385,0.29,0.09,0.2615,0.111,0.0595,0.0745,9),
(1244,'I',0.385,0.28,0.085,0.2175,0.097,0.038,0.067,8),
(1245,'I',0.385,0.3,0.095,0.302,0.152,0.0615,0.0735,7),
(1246,'I',0.385,0.28,0.09,0.228,0.1025,0.042,0.0655,5),
(1247,'I',0.39,0.3,0.095,0.3265,0.1665,0.0575,0.089,7),
(1248,'I',0.395,0.305,0.105,0.284,0.1135,0.0595,0.0945,8),
(1249,'I',0.395,0.295,0.095,0.2725,0.115,0.0625,0.085,8),
(1250,'I',0.395,0.27,0.1,0.2985,0.1445,0.061,0.082,5),
(1251,'I',0.4,0.29,0.1,0.2675,0.1205,0.0605,0.0765,5),
(1252,'I',0.405,0.285,0.09,0.2645,0.1265,0.0505,0.075,6),
(1253,'I',0.41,0.335,0.11,0.33,0.157,0.0705,0.17,7),
(1254,'I',0.42,0.305,0.09,0.328,0.168,0.0615,0.082,6),
(1255,'I',0.425,0.325,0.11,0.3335,0.173,0.045,0.1,7),
(1256,'I',0.425,0.32,0.1,0.3055,0.126,0.06,0.106,7),
(1257,'I',0.425,0.31,0.09,0.301,0.1385,0.065,0.08,7),
(1258,'I',0.43,0.34,0,0.428,0.2065,0.086,0.115,8),
(1259,'I',0.43,0.315,0.095,0.378,0.175,0.08,0.1045,8),
(1260,'I',0.435,0.315,0.11,0.3685,0.1615,0.0715,0.12,7),
(1261,'I',0.44,0.34,0.12,0.438,0.2115,0.083,0.12,9),
(1262,'I',0.45,0.33,0.105,0.448,0.208,0.089,0.12,9),
(1263,'I',0.455,0.345,0.105,0.4005,0.164,0.0755,0.126,8),
(1264,'F',0.455,0.365,0.115,0.4305,0.184,0.108,0.1245,8),
(1265,'I',0.455,0.33,0.1,0.372,0.358,0.0775,0.11,8),
(1266,'I',0.46,0.36,0.105,0.466,0.2225,0.099,0.11,7),
(1267,'I',0.46,0.35,0.105,0.3705,0.1575,0.077,0.114,9),
(1268,'F',0.46,0.365,0.125,0.4785,0.206,0.1045,0.141,8),
(1269,'I',0.465,0.34,0.11,0.346,0.1425,0.073,0.113,11),
(1270,'I',0.47,0.365,0.1,0.411,0.175,0.0855,0.135,8),
(1271,'I',0.47,0.355,0.18,0.48,0.2055,0.105,0.1505,8),
(1272,'I',0.47,0.355,0.12,0.393,0.167,0.0885,0.115,8),
(1273,'I',0.475,0.355,0.1,0.5035,0.2535,0.091,0.14,8),
(1274,'I',0.475,0.38,0.12,0.441,0.1785,0.0885,0.1505,8),
(1275,'I',0.475,0.36,0.11,0.492,0.211,0.11,0.15,8),
(1276,'I',0.48,0.37,0.125,0.5435,0.244,0.101,0.165,9),
(1277,'I',0.48,0.355,0.115,0.4725,0.2065,0.112,0.132,8),
(1278,'I',0.48,0.365,0.1,0.461,0.2205,0.0835,0.135,8),
(1279,'I',0.495,0.355,0.12,0.4965,0.214,0.1045,0.1495,8),
(1280,'I',0.495,0.38,0.13,0.5125,0.2185,0.116,0.16,7),
(1281,'M',0.495,0.395,0.12,0.553,0.224,0.1375,0.167,8),
(1282,'I',0.5,0.38,0.135,0.594,0.2945,0.104,0.1565,9),
(1283,'M',0.5,0.42,0.135,0.6765,0.302,0.1415,0.2065,9),
(1284,'I',0.5,0.375,0.145,0.5795,0.239,0.1375,0.185,9),
(1285,'I',0.5,0.41,0.14,0.6615,0.2585,0.1625,0.196,9),
(1286,'I',0.5,0.375,0.125,0.5695,0.259,0.124,0.157,7),
(1287,'I',0.5,0.395,0.14,0.6215,0.2925,0.1205,0.195,9),
(1288,'I',0.505,0.405,0.13,0.6015,0.3015,0.11,0.18,8),
(1289,'I',0.505,0.38,0.12,0.594,0.2595,0.1435,0.18,7),
(1290,'I',0.505,0.395,0.105,0.551,0.248,0.103,0.171,8),
(1291,'I',0.515,0.38,0.12,0.625,0.3265,0.1295,0.16,7),
(1292,'I',0.515,0.42,0.135,0.711,0.337,0.144,0.205,13),
(1293,'I',0.515,0.4,0.135,0.6965,0.32,0.1255,0.175,9),
(1294,'I',0.52,0.4,0.13,0.5825,0.233,0.1365,0.18,10),
(1295,'I',0.52,0.395,0.125,0.663,0.3005,0.131,0.1905,9),
(1296,'I',0.525,0.4,0.125,0.6965,0.369,0.1385,0.164,9),
(1297,'M',0.525,0.42,0.155,0.842,0.428,0.1415,0.2045,9),
(1298,'I',0.53,0.415,0.13,0.694,0.3905,0.111,0.167,9),
(1299,'I',0.53,0.42,0.155,0.81,0.4725,0.111,0.192,10),
(1300,'I',0.53,0.415,0.11,0.5745,0.2525,0.1235,0.189,9),
(1301,'I',0.53,0.425,0.13,0.7675,0.419,0.1205,0.21,9),
(1302,'I',0.535,0.4,0.135,0.6025,0.2895,0.121,0.154,9),
(1303,'I',0.535,0.415,0.15,0.5765,0.3595,0.135,0.225,8),
(1304,'F',0.535,0.41,0.13,0.7145,0.335,0.144,0.2075,9),
(1305,'M',0.535,0.435,0.15,0.717,0.3475,0.1445,0.194,9),
(1306,'F',0.54,0.42,0.145,0.8655,0.4315,0.163,0.2175,10),
(1307,'I',0.54,0.42,0.14,0.7265,0.3205,0.1445,0.229,9),
(1308,'I',0.545,0.435,0.135,0.7715,0.372,0.148,0.227,8),
(1309,'F',0.545,0.445,0.15,0.8,0.3535,0.163,0.207,9),
(1310,'I',0.545,0.43,0.15,0.7285,0.302,0.1315,0.2545,10),
(1311,'I',0.545,0.405,0.135,0.5945,0.27,0.1185,0.185,8),
(1312,'I',0.55,0.43,0.145,0.7895,0.3745,0.171,0.223,11),
(1313,'F',0.55,0.405,0.125,0.651,0.2965,0.137,0.2,9),
(1314,'M',0.55,0.43,0.15,0.8745,0.413,0.1905,0.248,9),
(1315,'I',0.55,0.435,0.14,0.7535,0.3285,0.1555,0.2325,10),
(1316,'I',0.55,0.425,0.135,0.7305,0.3325,0.1545,0.215,9),
(1317,'M',0.555,0.44,0.14,0.8705,0.407,0.156,0.255,9),
(1318,'I',0.555,0.43,0.155,0.7395,0.3135,0.1435,0.28,10),
(1319,'I',0.555,0.43,0.14,0.7665,0.341,0.165,0.23,9),
(1320,'I',0.555,0.425,0.145,0.7905,0.3485,0.1765,0.225,9),
(1321,'I',0.56,0.425,0.135,0.8205,0.3715,0.185,0.236,9),
(1322,'I',0.56,0.425,0.145,0.688,0.3095,0.1305,0.2165,9),
(1323,'F',0.56,0.445,0.155,1.224,0.5565,0.3225,0.2695,10),
(1324,'I',0.56,0.455,0.145,0.974,0.547,0.1615,0.235,9),
(1325,'I',0.565,0.44,0.175,0.8735,0.414,0.21,0.21,11),
(1326,'F',0.565,0.45,0.145,0.8495,0.4215,0.1685,0.225,8),
(1327,'M',0.565,0.445,0.15,0.796,0.3635,0.184,0.219,8),
(1328,'M',0.565,0.39,0.125,0.744,0.352,0.13,0.1685,11),
(1329,'I',0.57,0.45,0.145,0.751,0.2825,0.2195,0.2215,10),
(1330,'I',0.57,0.45,0.135,0.794,0.3815,0.1415,0.245,8),
(1331,'F',0.57,0.46,0.135,0.9795,0.397,0.2525,0.2655,9),
(1332,'M',0.57,0.435,0.17,0.873,0.382,0.183,0.2705,10),
(1333,'I',0.57,0.44,0.13,0.7665,0.347,0.1785,0.202,10),
(1334,'M',0.57,0.435,0.125,0.8965,0.383,0.1835,0.275,9),
(1335,'F',0.575,0.42,0.135,0.857,0.461,0.147,0.2125,10),
(1336,'F',0.575,0.48,0.165,1.078,0.511,0.2095,0.306,9),
(1337,'M',0.575,0.46,0.155,0.892,0.4415,0.176,0.22,10),
(1338,'M',0.58,0.46,0.155,1.4395,0.6715,0.273,0.2955,10),
(1339,'M',0.58,0.455,0.135,0.7955,0.405,0.167,0.204,10),
(1340,'F',0.58,0.445,0.15,0.858,0.4,0.156,0.253,8),
(1341,'M',0.585,0.465,0.155,0.9145,0.4555,0.1965,0.235,9),
(1342,'M',0.585,0.49,0.185,1.171,0.522,0.2535,0.335,10),
(1343,'I',0.585,0.475,0.16,1.0505,0.48,0.234,0.285,10),
(1344,'M',0.585,0.46,0.165,1.1135,0.5825,0.2345,0.274,10),
(1345,'M',0.585,0.47,0.165,1.409,0.8,0.229,0.295,10),
(1346,'M',0.585,0.475,0.15,1.065,0.5315,0.199,0.2885,10),
(1347,'M',0.585,0.45,0.18,0.7995,0.336,0.1855,0.237,8),
(1348,'I',0.59,0.445,0.135,0.7715,0.328,0.1745,0.23,9),
(1349,'M',0.59,0.47,0.18,1.187,0.5985,0.227,0.31,9),
(1350,'M',0.59,0.455,0.155,0.8855,0.388,0.188,0.275,10),
(1351,'F',0.595,0.465,0.15,0.98,0.4115,0.196,0.2255,10),
(1352,'F',0.595,0.465,0.155,1.026,0.4645,0.112,0.305,12),
(1353,'M',0.6,0.475,0.17,1.1315,0.508,0.272,0.309,10),
(1354,'M',0.6,0.48,0.155,1.014,0.451,0.1885,0.325,11),
(1355,'I',0.6,0.475,0.15,1.12,0.565,0.2465,0.27,10),
(1356,'F',0.6,0.465,0.155,1.04,0.4755,0.25,0.28,11),
(1357,'F',0.6,0.455,0.145,0.8895,0.419,0.1715,0.269,10),
(1358,'M',0.6,0.46,0.155,0.9595,0.4455,0.189,0.295,11),
(1359,'I',0.605,0.485,0.15,1.238,0.6315,0.226,0.33,11),
(1360,'M',0.605,0.49,0.14,0.9755,0.419,0.206,0.315,10),
(1361,'I',0.605,0.435,0.13,0.9025,0.432,0.174,0.26,11),
(1362,'F',0.605,0.475,0.175,1.076,0.463,0.2195,0.335,9),
(1363,'F',0.605,0.47,0.16,1.0835,0.5405,0.2215,0.275,12),
(1364,'M',0.61,0.45,0.15,0.871,0.407,0.1835,0.25,10),
(1365,'M',0.61,0.48,0.165,1.244,0.6345,0.257,0.305,12),
(1366,'M',0.61,0.475,0.17,1.0265,0.435,0.2335,0.3035,10),
(1367,'I',0.61,0.465,0.15,0.9605,0.4495,0.1725,0.286,9),
(1368,'M',0.61,0.48,0.17,1.137,0.4565,0.29,0.347,10),
(1369,'M',0.61,0.46,0.16,1,0.494,0.197,0.275,10),
(1370,'F',0.615,0.475,0.155,1.004,0.4475,0.193,0.2895,10),
(1371,'M',0.615,0.47,0.165,1.128,0.4465,0.2195,0.34,10),
(1372,'M',0.615,0.5,0.17,1.054,0.4845,0.228,0.295,10),
(1373,'F',0.615,0.475,0.165,1.023,0.4905,0.1955,0.3035,12),
(1374,'M',0.615,0.475,0.17,1.129,0.4795,0.302,0.3,10),
(1375,'M',0.615,0.48,0.175,1.118,0.446,0.3195,0.3,9),
(1376,'F',0.615,0.475,0.155,1.115,0.484,0.2115,0.355,10),
(1377,'M',0.62,0.51,0.175,1.2815,0.5715,0.2385,0.39,10),
(1378,'M',0.62,0.495,0.18,1.2555,0.5765,0.254,0.355,12),
(1379,'F',0.62,0.5,0.15,1.293,0.596,0.3135,0.354,10),
(1380,'F',0.62,0.475,0.16,1.1295,0.463,0.2685,0.33,10),
(1381,'M',0.625,0.455,0.17,1.082,0.4955,0.2345,0.315,9),
(1382,'F',0.625,0.505,0.175,1.15,0.5475,0.256,0.3045,11),
(1383,'F',0.625,0.515,0.16,1.264,0.5715,0.326,0.321,9),
(1384,'F',0.625,0.48,0.155,1.2035,0.5865,0.239,0.3185,12),
(1385,'F',0.63,0.485,0.17,1.3205,0.5945,0.345,0.345,9),
(1386,'I',0.63,0.505,0.18,1.272,0.6025,0.295,0.315,11),
(1387,'M',0.63,0.485,0.145,1.062,0.5065,0.1785,0.3365,12),
(1388,'I',0.63,0.475,0.145,1.0605,0.5165,0.2195,0.28,10),
(1389,'M',0.63,0.495,0.16,1.093,0.497,0.221,0.315,12),
(1390,'M',0.635,0.49,0.16,1.101,0.534,0.1865,0.3455,10),
(1391,'F',0.635,0.5,0.165,1.4595,0.705,0.2645,0.39,9),
(1392,'F',0.635,0.495,0.175,1.211,0.707,0.2725,0.323,9),
(1393,'M',0.635,0.475,0.17,1.1935,0.5205,0.2695,0.3665,10),
(1394,'M',0.635,0.51,0.155,0.986,0.405,0.2255,0.31,10),
(1395,'M',0.64,0.565,0.23,1.521,0.644,0.372,0.406,15),
(1396,'M',0.64,0.525,0.18,1.3135,0.4865,0.2995,0.4075,10),
(1397,'M',0.645,0.51,0.16,1.1835,0.556,0.2385,0.345,11),
(1398,'M',0.645,0.5,0.195,1.401,0.6165,0.3515,0.3725,10),
(1399,'M',0.645,0.525,0.16,1.5075,0.7455,0.245,0.4325,11),
(1400,'F',0.65,0.505,0.165,1.16,0.4785,0.274,0.349,11),
(1401,'F',0.65,0.59,0.22,1.662,0.77,0.378,0.435,11),
(1402,'M',0.65,0.525,0.175,1.5365,0.6865,0.3585,0.405,11),
(1403,'M',0.65,0.51,0.19,1.542,0.7155,0.3735,0.375,9),
(1404,'F',0.65,0.51,0.17,1.567,0.7245,0.349,0.391,10),
(1405,'F',0.655,0.525,0.19,1.3595,0.564,0.3215,0.3985,10),
(1406,'M',0.655,0.535,0.205,1.6445,0.7305,0.3595,0.46,13),
(1407,'F',0.655,0.52,0.19,1.4545,0.6,0.3865,0.383,10),
(1408,'M',0.655,0.49,0.175,1.3585,0.6395,0.294,0.365,10),
(1409,'F',0.66,0.495,0.21,1.548,0.724,0.3525,0.3925,10),
(1410,'F',0.66,0.515,0.17,1.337,0.615,0.3125,0.3575,10),
(1411,'F',0.665,0.53,0.18,1.491,0.6345,0.342,0.435,10),
(1412,'F',0.67,0.53,0.225,1.5615,0.63,0.487,0.3725,11),
(1413,'F',0.67,0.505,0.175,1.0145,0.4375,0.271,0.3745,10),
(1414,'M',0.675,0.545,0.185,1.7375,0.876,0.3135,0.469,13),
(1415,'M',0.685,0.545,0.205,1.7925,0.8145,0.416,0.461,9),
(1416,'F',0.695,0.565,0.19,1.7635,0.7465,0.399,0.4975,11),
(1417,'F',0.7,0.545,0.13,1.556,0.6725,0.374,0.195,12),
(1418,'M',0.705,0.565,0.515,2.21,1.1075,0.4865,0.512,10),
(1419,'M',0.705,0.555,0.215,2.141,1.0465,0.383,0.528,11),
(1420,'F',0.705,0.57,0.18,1.5345,0.96,0.4195,0.43,12),
(1421,'F',0.71,0.55,0.17,1.614,0.743,0.345,0.45,11),
(1422,'F',0.72,0.575,0.17,1.9335,0.913,0.389,0.51,13),
(1423,'M',0.72,0.575,0.215,2.173,0.9515,0.564,0.5365,12),
(1424,'F',0.725,0.6,0.2,1.737,0.697,0.3585,0.595,11),
(1425,'F',0.73,0.58,0.19,1.7375,0.6785,0.4345,0.52,11),
(1426,'F',0.735,0.565,0.205,2.1275,0.949,0.46,0.565,12),
(1427,'F',0.745,0.57,0.215,2.25,1.1565,0.446,0.558,9),
(1428,'F',0.75,0.61,0.235,2.5085,1.232,0.519,0.612,14),
(1429,'F',0.815,0.65,0.25,2.255,0.8905,0.42,0.7975,14),
(1430,'I',0.14,0.105,0.035,0.014,0.0055,0.0025,0.004,3),
(1431,'I',0.23,0.165,0.06,0.0515,0.019,0.0145,0.036,4),
(1432,'I',0.365,0.265,0.135,0.2215,0.105,0.047,0.0605,7),
(1433,'I',0.365,0.255,0.08,0.1985,0.0785,0.0345,0.053,5),
(1434,'I',0.37,0.27,0.095,0.232,0.1325,0.041,0.0615,6),
(1435,'I',0.375,0.28,0.085,0.3155,0.187,0.046,0.067,7),
(1436,'I',0.385,0.3,0.09,0.247,0.1225,0.044,0.0675,5),
(1437,'I',0.395,0.295,0.09,0.3025,0.143,0.0665,0.0765,5),
(1438,'I',0.4,0.29,0.11,0.329,0.188,0.0455,0.0825,6),
(1439,'I',0.4,0.3,0.09,0.2815,0.1185,0.061,0.08,7),
(1440,'I',0.405,0.31,0.095,0.3425,0.1785,0.064,0.0855,8),
(1441,'I',0.405,0.29,0.09,0.2825,0.112,0.075,0.0815,7),
(1442,'I',0.405,0.3,0.105,0.304,0.1455,0.061,0.0805,6),
(1443,'I',0.41,0.32,0.095,0.2905,0.141,0.063,0.073,5),
(1444,'M',0.415,0.315,0.115,0.3895,0.2015,0.065,0.103,9),
(1445,'I',0.425,0.34,0.105,0.389,0.2015,0.0905,0.088,6),
(1446,'I',0.43,0.34,0.105,0.4405,0.2385,0.0745,0.1075,6),
(1447,'I',0.44,0.34,0.105,0.369,0.164,0.08,0.1015,5),
(1448,'M',0.44,0.32,0.12,0.4565,0.2435,0.092,0.1025,8),
(1449,'I',0.44,0.365,0.11,0.4465,0.213,0.089,0.1135,9),
(1450,'M',0.45,0.335,0.125,0.4475,0.2165,0.126,0.11,6),
(1451,'I',0.455,0.335,0.135,0.501,0.274,0.0995,0.1065,7),
(1452,'I',0.46,0.355,0.11,0.436,0.1975,0.096,0.125,8),
(1453,'I',0.47,0.345,0.14,0.4615,0.229,0.1105,0.116,9),
(1454,'I',0.47,0.35,0.125,0.4315,0.19,0.1165,0.1175,6),
(1455,'I',0.47,0.355,0.12,0.3685,0.126,0.0835,0.1365,6),
(1456,'M',0.475,0.37,0.125,0.649,0.347,0.136,0.142,8),
(1457,'I',0.475,0.365,0.115,0.459,0.2175,0.093,0.1165,7),
(1458,'F',0.475,0.365,0.115,0.566,0.281,0.117,0.1335,7),
(1459,'I',0.48,0.36,0.125,0.542,0.2795,0.1025,0.147,7),
(1460,'I',0.485,0.38,0.12,0.4725,0.2075,0.1075,0.147,6),
(1461,'M',0.485,0.39,0.085,0.6435,0.2945,0.103,0.198,8),
(1462,'M',0.485,0.37,0.13,0.526,0.2485,0.105,0.1555,6),
(1463,'F',0.495,0.38,0.12,0.573,0.2655,0.1285,0.144,7),
(1464,'M',0.505,0.385,0.105,0.5525,0.239,0.1245,0.1555,9),
(1465,'F',0.505,0.38,0.135,0.6855,0.361,0.1565,0.161,9),
(1466,'I',0.515,0.395,0.125,0.556,0.2695,0.096,0.17,8),
(1467,'M',0.515,0.425,0.145,0.9365,0.497,0.181,0.2185,8),
(1468,'I',0.515,0.4,0.125,0.5625,0.25,0.1245,0.17,7),
(1469,'M',0.52,0.4,0.125,0.559,0.254,0.139,0.149,8),
(1470,'M',0.525,0.4,0.14,0.7205,0.3685,0.145,0.1735,8),
(1471,'I',0.53,0.43,0.13,0.7045,0.346,0.1415,0.189,9),
(1472,'M',0.53,0.4,0.125,0.7575,0.398,0.151,0.175,8),
(1473,'F',0.545,0.41,0.14,0.7405,0.3565,0.1775,0.203,9),
(1474,'F',0.55,0.43,0.14,0.84,0.375,0.218,0.1945,8),
(1475,'M',0.55,0.425,0.16,0.793,0.343,0.2035,0.215,9),
(1476,'F',0.56,0.43,0.15,0.8745,0.453,0.161,0.22,8),
(1477,'F',0.56,0.435,0.15,0.8715,0.4755,0.1835,0.1835,9),
(1478,'M',0.57,0.445,0.15,0.9875,0.504,0.207,0.249,8),
(1479,'M',0.575,0.465,0.15,1.08,0.595,0.2065,0.238,9),
(1480,'M',0.575,0.46,0.165,0.9155,0.4005,0.2465,0.2385,8),
(1481,'F',0.58,0.46,0.175,1.165,0.65,0.2205,0.3055,9),
(1482,'F',0.58,0.435,0.14,0.953,0.475,0.2165,0.2095,9),
(1483,'M',0.585,0.455,0.15,0.906,0.4095,0.23,0.2335,8),
(1484,'M',0.59,0.44,0.15,0.8725,0.387,0.215,0.245,8),
(1485,'F',0.59,0.465,0.15,1.151,0.613,0.239,0.2515,9),
(1486,'F',0.59,0.46,0.145,0.9905,0.453,0.2205,0.275,8),
(1487,'F',0.595,0.455,0.16,1.04,0.452,0.2655,0.288,9),
(1488,'M',0.6,0.455,0.155,0.945,0.4365,0.2085,0.25,8),
(1489,'M',0.6,0.465,0.2,1.259,0.6405,0.1985,0.357,9),
(1490,'F',0.605,0.485,0.165,0.9515,0.4535,0.193,0.2765,11),
(1491,'F',0.605,0.485,0.16,1.201,0.417,0.2875,0.38,9),
(1492,'F',0.605,0.515,0.17,1.289,0.6,0.2945,0.3315,9),
(1493,'F',0.61,0.485,0.17,1.1005,0.5125,0.229,0.305,11),
(1494,'I',0.615,0.475,0.13,0.8425,0.353,0.1915,0.251,8),
(1495,'M',0.62,0.485,0.155,1.049,0.462,0.231,0.25,10),
(1496,'F',0.62,0.435,0.155,1.012,0.477,0.236,0.275,8),
(1497,'M',0.62,0.48,0.165,1.0725,0.4815,0.235,0.312,9),
(1498,'M',0.625,0.52,0.175,1.4105,0.691,0.322,0.3465,10),
(1499,'M',0.625,0.47,0.18,1.136,0.451,0.3245,0.305,11),
(1500,'M',0.63,0.47,0.145,1.1005,0.52,0.26,0.276,9),
(1501,'F',0.63,0.5,0.175,1.1105,0.467,0.268,0.329,10),
(1502,'M',0.63,0.455,0.15,1.1315,0.481,0.2745,0.305,9),
(1503,'M',0.63,0.48,0.15,1.271,0.6605,0.2425,0.31,11),
(1504,'F',0.63,0.49,0.225,1.336,0.6805,0.259,0.3245,10),
(1505,'F',0.635,0.505,0.145,1.1345,0.505,0.2655,0.315,10),
(1506,'M',0.635,0.51,0.185,1.308,0.544,0.318,0.377,8),
(1507,'F',0.64,0.515,0.205,1.5335,0.6635,0.3345,0.4025,9),
(1508,'F',0.645,0.515,0.175,1.546,0.7035,0.365,0.415,10),
(1509,'M',0.645,0.51,0.155,1.539,0.6405,0.3585,0.43,11),
(1510,'F',0.645,0.505,0.165,1.318,0.55,0.3015,0.335,11),
(1511,'F',0.65,0.545,0.175,1.5245,0.59,0.326,0.495,10),
(1512,'M',0.65,0.515,0.175,1.466,0.677,0.3045,0.4,10),
(1513,'F',0.65,0.5,0.16,1.3825,0.702,0.304,0.3195,9),
(1514,'M',0.65,0.485,0.14,1.175,0.475,0.2435,0.215,8),
(1515,'F',0.655,0.54,0.215,1.5555,0.695,0.296,0.444,11),
(1516,'M',0.655,0.51,0.215,1.7835,0.8885,0.4095,0.4195,11),
(1517,'M',0.66,0.505,0.165,1.374,0.589,0.351,0.345,10),
(1518,'F',0.665,0.515,0.18,1.389,0.5945,0.324,0.395,10),
(1519,'M',0.67,0.545,0.2,1.7025,0.833,0.374,0.41,11),
(1520,'M',0.67,0.51,0.175,1.5265,0.651,0.4475,0.345,10),
(1521,'M',0.67,0.5,0.19,1.519,0.616,0.388,0.415,10),
(1522,'F',0.68,0.5,0.185,1.741,0.7665,0.3255,0.4685,12),
(1523,'M',0.68,0.515,0.17,1.6115,0.8415,0.306,0.395,11),
(1524,'M',0.69,0.525,0.2,1.7825,0.9165,0.3325,0.461,12),
(1525,'F',0.7,0.55,0.17,1.684,0.7535,0.3265,0.32,11),
(1526,'M',0.7,0.555,0.2,1.858,0.73,0.3665,0.595,11),
(1527,'M',0.705,0.56,0.165,1.675,0.797,0.4095,0.388,10),
(1528,'M',0.72,0.565,0.2,2.1055,1.017,0.363,0.494,12),
(1529,'M',0.725,0.575,0.24,2.21,1.351,0.413,0.5015,13),
(1530,'M',0.74,0.57,0.18,1.8725,0.9115,0.427,0.446,10),
(1531,'M',0.75,0.55,0.18,1.893,0.942,0.397,0.445,11),
(1532,'I',0.21,0.17,0.045,0.0475,0.019,0.011,0.013,5),
(1533,'I',0.285,0.21,0.055,0.101,0.0415,0.017,0.0335,5),
(1534,'I',0.295,0.215,0.07,0.121,0.047,0.0155,0.0405,6),
(1535,'I',0.3,0.23,0.085,0.117,0.05,0.0175,0.0415,6),
(1536,'I',0.305,0.225,0.09,0.1465,0.063,0.034,0.0415,6),
(1537,'I',0.335,0.255,0.08,0.168,0.079,0.0355,0.05,5),
(1538,'I',0.35,0.26,0.075,0.18,0.09,0.0245,0.055,5),
(1539,'I',0.355,0.27,0.075,0.1775,0.079,0.0315,0.054,6),
(1540,'I',0.355,0.26,0.09,0.1985,0.0715,0.0495,0.058,7),
(1541,'I',0.36,0.27,0.095,0.2,0.073,0.056,0.061,8),
(1542,'I',0.36,0.275,0.075,0.2205,0.0985,0.044,0.066,7),
(1543,'I',0.36,0.265,0.075,0.1845,0.083,0.0365,0.055,7),
(1544,'I',0.365,0.27,0.085,0.2225,0.0935,0.0525,0.066,7),
(1545,'I',0.37,0.27,0.095,0.2175,0.097,0.046,0.065,6),
(1546,'I',0.375,0.28,0.08,0.2165,0.0935,0.0925,0.07,7),
(1547,'I',0.38,0.285,0.095,0.243,0.0895,0.0665,0.075,7),
(1548,'I',0.38,0.29,0.1,0.237,0.108,0.0395,0.082,6),
(1549,'I',0.385,0.29,0.09,0.2365,0.1,0.0505,0.076,8),
(1550,'I',0.385,0.28,0.095,0.257,0.119,0.059,0.07,7),
(1551,'I',0.385,0.3,0.09,0.308,0.1525,0.056,0.0835,8),
(1552,'I',0.39,0.3,0.09,0.252,0.1065,0.053,0.08,7),
(1553,'I',0.39,0.285,0.1,0.281,0.1275,0.062,0.077,7),
(1554,'I',0.39,0.29,0.1,0.2225,0.095,0.0465,0.073,7),
(1555,'I',0.41,0.3,0.09,0.304,0.129,0.071,0.0955,8),
(1556,'I',0.41,0.3,0.09,0.28,0.141,0.0575,0.075,8),
(1557,'I',0.415,0.325,0.1,0.313,0.139,0.0625,0.0965,7),
(1558,'I',0.425,0.325,0.11,0.317,0.135,0.048,0.09,8),
(1559,'I',0.425,0.315,0.08,0.303,0.131,0.0585,0.095,7),
(1560,'I',0.435,0.335,0.1,0.3295,0.129,0.07,0.11,7),
(1561,'I',0.435,0.325,0.11,0.367,0.1595,0.08,0.105,6),
(1562,'I',0.45,0.34,0.095,0.3245,0.1385,0.064,0.105,8),
(1563,'I',0.45,0.335,0.11,0.4195,0.181,0.085,0.1345,7),
(1564,'I',0.455,0.36,0.115,0.457,0.2085,0.0855,0.147,10),
(1565,'I',0.46,0.35,0.11,0.4,0.176,0.083,0.1205,7),
(1566,'I',0.46,0.355,0.11,0.4255,0.2015,0.081,0.13,7),
(1567,'I',0.465,0.37,0.12,0.4365,0.188,0.0815,0.147,9),
(1568,'I',0.465,0.345,0.11,0.393,0.1825,0.0735,0.12,8),
(1569,'I',0.47,0.355,0.125,0.499,0.21,0.0985,0.155,8),
(1570,'I',0.475,0.36,0.145,0.6325,0.2825,0.137,0.19,8),
(1571,'M',0.475,0.36,0.1,0.4285,0.1965,0.099,0.112,7),
(1572,'I',0.475,0.36,0.125,0.4905,0.205,0.1305,0.125,8),
(1573,'I',0.48,0.37,0.125,0.474,0.179,0.1035,0.175,9),
(1574,'I',0.48,0.37,0.12,0.536,0.251,0.114,0.15,8),
(1575,'M',0.48,0.355,0.16,0.464,0.221,0.106,0.239,8),
(1576,'I',0.485,0.375,0.13,0.6025,0.2935,0.1285,0.16,7),
(1577,'I',0.49,0.375,0.115,0.4615,0.204,0.0945,0.143,8),
(1578,'I',0.49,0.4,0.135,0.624,0.3035,0.1285,0.169,8),
(1579,'I',0.495,0.37,0.125,0.4715,0.2075,0.091,0.15,8),
(1580,'I',0.495,0.4,0.105,0.602,0.2505,0.1265,0.19,8),
(1581,'I',0.5,0.4,0.12,0.616,0.261,0.143,0.1935,8),
(1582,'I',0.5,0.39,0.12,0.5955,0.2455,0.147,0.173,8),
(1583,'I',0.5,0.375,0.14,0.559,0.2375,0.135,0.169,9),
(1584,'I',0.51,0.395,0.13,0.6025,0.281,0.143,0.162,7),
(1585,'F',0.515,0.375,0.11,0.6065,0.3005,0.131,0.15,6),
(1586,'I',0.515,0.36,0.125,0.4725,0.1815,0.125,0.138,9),
(1587,'I',0.515,0.35,0.105,0.4745,0.213,0.123,0.1275,10),
(1588,'I',0.515,0.395,0.125,0.6635,0.32,0.14,0.17,8),
(1589,'I',0.515,0.39,0.125,0.5705,0.238,0.1265,0.185,8),
(1590,'I',0.52,0.41,0.145,0.646,0.2965,0.1595,0.165,9),
(1591,'I',0.52,0.39,0.13,0.5545,0.2355,0.1095,0.1895,7),
(1592,'M',0.525,0.415,0.145,0.845,0.3525,0.1635,0.2875,8),
(1593,'I',0.525,0.39,0.12,0.664,0.3115,0.147,0.178,9),
(1594,'I',0.525,0.38,0.135,0.615,0.261,0.159,0.175,8),
(1595,'I',0.525,0.4,0.14,0.654,0.305,0.16,0.169,7),
(1596,'M',0.525,0.4,0.155,0.707,0.282,0.1605,0.225,9),
(1597,'I',0.53,0.42,0.12,0.5965,0.2555,0.141,0.177,7),
(1598,'I',0.53,0.43,0.135,0.6255,0.245,0.1455,0.2135,10),
(1599,'I',0.53,0.4,0.145,0.555,0.1935,0.1305,0.195,9),
(1600,'I',0.53,0.42,0.13,0.8365,0.3745,0.167,0.249,11),
(1601,'I',0.535,0.4,0.13,0.657,0.2835,0.162,0.175,7),
(1602,'I',0.54,0.43,0.17,0.836,0.3725,0.1815,0.24,9),
(1603,'I',0.54,0.425,0.14,0.742,0.32,0.1395,0.25,9),
(1604,'I',0.54,0.43,0.14,0.8195,0.3935,0.1725,0.2295,9),
(1605,'M',0.54,0.455,0.14,0.972,0.419,0.255,0.269,10),
(1606,'I',0.54,0.42,0.14,0.6275,0.2505,0.1175,0.235,9),
(1607,'I',0.54,0.425,0.13,0.7205,0.2955,0.169,0.225,10),
(1608,'I',0.54,0.425,0.135,0.686,0.3475,0.1545,0.213,8),
(1609,'I',0.545,0.4,0.13,0.686,0.3285,0.1455,0.18,9),
(1610,'I',0.545,0.375,0.12,0.543,0.2375,0.1155,0.1725,8),
(1611,'I',0.545,0.42,0.125,0.717,0.358,0.112,0.22,8),
(1612,'M',0.55,0.435,0.14,0.7625,0.327,0.1685,0.259,10),
(1613,'I',0.55,0.425,0.15,0.639,0.269,0.1345,0.217,9),
(1614,'I',0.55,0.42,0.135,0.816,0.3995,0.1485,0.23,12),
(1615,'I',0.55,0.415,0.145,0.7815,0.373,0.16,0.2215,8),
(1616,'I',0.55,0.425,0.15,0.7665,0.339,0.176,0.21,8),
(1617,'I',0.555,0.395,0.13,0.5585,0.222,0.1245,0.17,9),
(1618,'I',0.555,0.435,0.14,0.765,0.3945,0.15,0.206,8),
(1619,'I',0.555,0.46,0.145,0.9005,0.3845,0.158,0.2765,11),
(1620,'I',0.56,0.445,0.15,0.8225,0.3685,0.187,0.236,10),
(1621,'I',0.56,0.44,0.13,0.7235,0.349,0.149,0.2,8),
(1622,'M',0.56,0.425,0.135,0.849,0.3265,0.221,0.2645,10),
(1623,'I',0.565,0.42,0.155,0.743,0.31,0.186,0.231,9),
(1624,'F',0.565,0.44,0.15,0.863,0.435,0.149,0.27,9),
(1625,'M',0.565,0.44,0.125,0.802,0.3595,0.1825,0.215,9),
(1626,'M',0.565,0.43,0.15,0.831,0.4245,0.1735,0.219,10),
(1627,'F',0.57,0.45,0.135,0.7805,0.3345,0.185,0.21,8),
(1628,'M',0.57,0.45,0.14,0.795,0.3385,0.148,0.245,9),
(1629,'I',0.57,0.435,0.17,0.848,0.4,0.166,0.25,9),
(1630,'I',0.57,0.43,0.145,0.833,0.354,0.144,0.2815,10),
(1631,'I',0.57,0.445,0.155,0.867,0.3705,0.1705,0.28,9),
(1632,'I',0.57,0.445,0.145,0.7405,0.306,0.172,0.1825,12),
(1633,'M',0.575,0.455,0.165,0.867,0.3765,0.1805,0.268,8),
(1634,'I',0.575,0.425,0.135,0.7965,0.364,0.196,0.239,10),
(1635,'F',0.575,0.47,0.155,1.116,0.509,0.238,0.34,10),
(1636,'I',0.575,0.45,0.125,0.78,0.3275,0.188,0.235,9),
(1637,'M',0.575,0.47,0.185,0.985,0.3745,0.2175,0.355,10),
(1638,'F',0.575,0.465,0.195,0.9965,0.417,0.247,0.47,8),
(1639,'I',0.575,0.445,0.17,0.8015,0.3475,0.1465,0.25,9),
(1640,'I',0.575,0.45,0.135,0.807,0.3615,0.176,0.254,10),
(1641,'F',0.575,0.435,0.15,1.0305,0.4605,0.218,0.36,8),
(1642,'M',0.575,0.445,0.16,0.839,0.4005,0.198,0.239,9),
(1643,'M',0.575,0.44,0.16,0.9615,0.483,0.166,0.275,13),
(1644,'F',0.58,0.435,0.15,0.834,0.428,0.1515,0.23,8),
(1645,'M',0.58,0.46,0.155,1.0335,0.469,0.2225,0.295,10),
(1646,'M',0.58,0.43,0.13,0.798,0.365,0.173,0.2285,10),
(1647,'I',0.58,0.445,0.125,0.7095,0.303,0.1405,0.235,9),
(1648,'F',0.585,0.445,0.14,0.913,0.4305,0.2205,0.253,10),
(1649,'M',0.59,0.49,0.165,1.207,0.559,0.235,0.309,10),
(1650,'I',0.59,0.45,0.145,1.022,0.428,0.268,0.265,10),
(1651,'I',0.59,0.46,0.145,0.9015,0.419,0.1785,0.26,11),
(1652,'F',0.595,0.435,0.15,0.9,0.4175,0.17,0.265,8),
(1653,'M',0.595,0.45,0.14,0.838,0.3965,0.194,0.217,10),
(1654,'M',0.595,0.45,0.145,0.959,0.463,0.2065,0.2535,10),
(1655,'I',0.595,0.46,0.15,0.8335,0.377,0.1925,0.235,8),
(1656,'F',0.6,0.46,0.155,0.9735,0.427,0.2045,0.3,8),
(1657,'F',0.6,0.475,0.15,1.13,0.575,0.196,0.305,9),
(1658,'M',0.6,0.48,0.165,0.9165,0.4135,0.1965,0.2725,9),
(1659,'I',0.6,0.48,0.17,0.9175,0.38,0.2225,0.29,8),
(1660,'F',0.6,0.48,0.18,1.0645,0.4495,0.2455,0.325,10),
(1661,'M',0.6,0.47,0.165,1.059,0.504,0.241,0.275,9),
(1662,'M',0.6,0.47,0.16,1.194,0.5625,0.3045,0.2635,10),
(1663,'F',0.605,0.455,0.145,0.9775,0.468,0.1775,0.275,9),
(1664,'M',0.605,0.475,0.145,0.884,0.3835,0.1905,0.27,8),
(1665,'I',0.605,0.47,0.145,0.8025,0.379,0.2265,0.22,9),
(1666,'F',0.605,0.48,0.14,0.991,0.4735,0.2345,0.24,8),
(1667,'F',0.605,0.47,0.155,0.974,0.393,0.224,0.3345,9),
(1668,'F',0.605,0.505,0.18,1.434,0.7285,0.264,0.431,11),
(1669,'M',0.61,0.475,0.155,0.983,0.4565,0.228,0.266,10),
(1670,'F',0.61,0.465,0.16,1.0725,0.4835,0.2515,0.28,10),
(1671,'F',0.61,0.485,0.15,1.2405,0.6025,0.2915,0.3085,12),
(1672,'M',0.61,0.47,0.16,1.022,0.449,0.2345,0.2945,9),
(1673,'F',0.61,0.475,0.16,1.1155,0.3835,0.223,0.379,10),
(1674,'I',0.61,0.465,0.125,0.9225,0.436,0.19,0.26,9),
(1675,'M',0.61,0.47,0.17,1.1185,0.5225,0.2405,0.31,9),
(1676,'F',0.61,0.485,0.18,1.2795,0.5735,0.2855,0.355,7),
(1677,'M',0.615,0.47,0.16,1.0175,0.473,0.2395,0.28,10),
(1678,'M',0.615,0.475,0.175,1.224,0.6035,0.261,0.311,9),
(1679,'I',0.62,0.485,0.18,1.154,0.4935,0.256,0.315,12),
(1680,'F',0.62,0.515,0.155,1.3255,0.6685,0.2605,0.335,12),
(1681,'M',0.62,0.515,0.175,1.221,0.535,0.241,0.395,13),
(1682,'F',0.62,0.54,0.165,1.139,0.4995,0.2435,0.357,11),
(1683,'I',0.62,0.49,0.16,1.066,0.446,0.246,0.305,11),
(1684,'F',0.62,0.48,0.18,1.2215,0.582,0.2695,0.313,12),
(1685,'I',0.62,0.47,0.14,0.8565,0.3595,0.16,0.295,9),
(1686,'I',0.62,0.45,0.135,0.924,0.358,0.2265,0.2965,10),
(1687,'M',0.62,0.48,0.15,1.266,0.6285,0.2575,0.309,12),
(1688,'F',0.62,0.48,0.175,1.0405,0.464,0.2225,0.3,9),
(1689,'M',0.625,0.49,0.165,1.1165,0.4895,0.2615,0.3325,11),
(1690,'M',0.625,0.475,0.16,1.0845,0.5005,0.2355,0.3105,10),
(1691,'M',0.625,0.5,0.17,1.0985,0.4645,0.22,0.354,9),
(1692,'I',0.625,0.47,0.155,1.1955,0.643,0.2055,0.3145,12),
(1693,'F',0.625,0.485,0.175,1.362,0.6765,0.2615,0.3705,10),
(1694,'I',0.625,0.485,0.15,1.044,0.438,0.2865,0.278,9),
(1695,'M',0.63,0.505,0.17,1.0915,0.4615,0.266,0.3,9),
(1696,'F',0.63,0.5,0.18,1.1965,0.514,0.2325,0.3995,8),
(1697,'M',0.63,0.49,0.17,1.1745,0.5255,0.273,0.339,11),
(1698,'M',0.63,0.485,0.165,1.233,0.6565,0.2315,0.3035,10),
(1699,'M',0.63,0.495,0.175,1.2695,0.605,0.271,0.328,11),
(1700,'I',0.635,0.5,0.165,1.489,0.715,0.3445,0.3615,13),
(1701,'M',0.635,0.5,0.17,1.4345,0.611,0.309,0.418,12),
(1702,'F',0.635,0.49,0.175,1.2435,0.5805,0.313,0.305,10),
(1703,'F',0.635,0.49,0.17,1.2615,0.5385,0.2665,0.38,9),
(1704,'F',0.64,0.505,0.165,1.2235,0.5215,0.2695,0.36,10),
(1705,'M',0.64,0.515,0.18,1.247,0.5475,0.2925,0.3685,10),
(1706,'M',0.64,0.525,0.185,1.707,0.763,0.4205,0.4435,11),
(1707,'M',0.645,0.505,0.15,1.1605,0.519,0.2615,0.335,10),
(1708,'M',0.645,0.5,0.175,1.286,0.5645,0.288,0.386,12),
(1709,'M',0.645,0.5,0.19,1.5595,0.741,0.3715,0.3845,14),
(1710,'M',0.645,0.51,0.19,1.4745,0.605,0.345,0.48,9),
(1711,'M',0.645,0.51,0.195,1.226,0.5885,0.2215,0.3745,10),
(1712,'M',0.645,0.51,0.16,1.33,0.6665,0.309,0.317,9),
(1713,'F',0.645,0.51,0.16,1.2415,0.5815,0.276,0.315,9),
(1714,'M',0.645,0.5,0.175,1.3375,0.554,0.308,0.415,10),
(1715,'F',0.645,0.51,0.19,1.363,0.573,0.362,0.36,10),
(1716,'M',0.645,0.485,0.15,1.2215,0.5695,0.2735,0.33,9),
(1717,'F',0.645,0.48,0.19,1.371,0.6925,0.2905,0.35,12),
(1718,'F',0.65,0.495,0.155,1.337,0.615,0.3195,0.335,9),
(1719,'M',0.65,0.505,0.19,1.274,0.59,0.23,0.391,11),
(1720,'M',0.65,0.525,0.185,1.488,0.665,0.337,0.378,11),
(1721,'M',0.65,0.51,0.16,1.3835,0.6385,0.2905,0.3665,9),
(1722,'M',0.655,0.55,0.18,1.274,0.586,0.281,0.365,10),
(1723,'F',0.655,0.51,0.15,1.043,0.4795,0.223,0.305,9),
(1724,'F',0.655,0.505,0.19,1.3485,0.5935,0.2745,0.425,12),
(1725,'F',0.655,0.505,0.195,1.4405,0.688,0.3805,0.363,11),
(1726,'M',0.66,0.5,0.165,1.3195,0.667,0.269,0.341,9),
(1727,'F',0.66,0.535,0.175,1.5175,0.711,0.3125,0.415,12),
(1728,'M',0.66,0.53,0.195,1.5505,0.6505,0.3295,0.495,10),
(1729,'M',0.66,0.51,0.165,1.6375,0.7685,0.3545,0.3925,14),
(1730,'M',0.665,0.525,0.175,1.443,0.6635,0.3845,0.353,11),
(1731,'M',0.665,0.505,0.16,1.289,0.6145,0.253,0.3665,11),
(1732,'F',0.665,0.505,0.16,1.2915,0.631,0.2925,0.32,11),
(1733,'M',0.665,0.52,0.175,1.3725,0.606,0.32,0.395,12),
(1734,'M',0.665,0.5,0.175,1.2975,0.6075,0.314,0.315,9),
(1735,'M',0.67,0.505,0.16,1.2585,0.6255,0.311,0.308,12),
(1736,'M',0.67,0.52,0.165,1.39,0.711,0.2865,0.3,11),
(1737,'F',0.67,0.52,0.19,1.32,0.5235,0.3095,0.4275,13),
(1738,'F',0.67,0.55,0.155,1.566,0.858,0.339,0.354,10),
(1739,'F',0.67,0.54,0.195,1.619,0.74,0.3305,0.465,11),
(1740,'M',0.675,0.525,0.16,1.2835,0.572,0.2755,0.3545,13),
(1741,'F',0.675,0.51,0.195,1.382,0.6045,0.3175,0.3965,10),
(1742,'M',0.68,0.52,0.195,1.4535,0.592,0.391,0.4125,10),
(1743,'F',0.68,0.51,0.2,1.6075,0.714,0.339,0.4705,11),
(1744,'M',0.685,0.52,0.15,1.3735,0.7185,0.293,0.32,11),
(1745,'F',0.685,0.565,0.175,1.638,0.7775,0.375,0.438,11),
(1746,'F',0.69,0.55,0.2,1.569,0.687,0.3675,0.46,12),
(1747,'M',0.7,0.565,0.175,1.8565,0.8445,0.3935,0.54,10),
(1748,'F',0.7,0.535,0.175,1.773,0.6805,0.48,0.512,15),
(1749,'F',0.705,0.545,0.17,1.58,0.6435,0.4565,0.265,11),
(1750,'M',0.71,0.575,0.215,2.009,0.9895,0.4475,0.502,11),
(1751,'F',0.71,0.57,0.195,1.9805,0.9925,0.4925,0.48,12),
(1752,'F',0.71,0.54,0.205,1.5805,0.802,0.287,0.435,10),
(1753,'M',0.71,0.56,0.22,2.015,0.9215,0.454,0.566,11),
(1754,'M',0.72,0.57,0.2,1.8275,0.919,0.366,0.485,10),
(1755,'M',0.72,0.55,0.205,2.125,1.1455,0.4425,0.511,13),
(1756,'F',0.72,0.525,0.18,1.445,0.631,0.3215,0.435,7),
(1757,'F',0.725,0.565,0.21,2.1425,1.03,0.487,0.503,14),
(1758,'F',0.73,0.56,0.19,1.9425,0.799,0.5195,0.5655,11),
(1759,'M',0.735,0.59,0.215,1.747,0.7275,0.403,0.557,11),
(1760,'F',0.74,0.565,0.205,2.119,0.9655,0.5185,0.482,12),
(1761,'F',0.75,0.565,0.215,1.938,0.7735,0.4825,0.575,11),
(1762,'M',0.75,0.595,0.205,2.2205,1.083,0.421,0.63,12),
(1763,'M',0.77,0.62,0.195,2.5155,1.1155,0.6415,0.642,12),
(1764,'M',0.775,0.63,0.25,2.7795,1.3485,0.76,0.578,12),
(1765,'I',0.275,0.175,0.09,0.2315,0.096,0.057,0.0705,5),
(1766,'I',0.375,0.245,0.1,0.394,0.166,0.091,0.1125,6),
(1767,'F',0.375,0.27,0.135,0.597,0.272,0.131,0.1675,7),
(1768,'M',0.39,0.28,0.125,0.564,0.3035,0.0955,0.143,7),
(1769,'I',0.435,0.3,0.12,0.5965,0.259,0.139,0.1645,8),
(1770,'M',0.445,0.32,0.12,0.414,0.199,0.09,0.117,7),
(1771,'I',0.455,0.335,0.105,0.422,0.229,0.0865,0.1,6),
(1772,'I',0.455,0.325,0.135,0.82,0.4005,0.1715,0.211,8),
(1773,'I',0.455,0.345,0.11,0.434,0.207,0.0855,0.1215,8),
(1774,'I',0.465,0.325,0.14,0.7615,0.362,0.1535,0.209,10),
(1775,'M',0.465,0.36,0.115,0.5795,0.295,0.1395,0.12,7),
(1776,'I',0.485,0.365,0.105,0.5205,0.195,0.123,0.182,8),
(1777,'M',0.485,0.37,0.155,0.968,0.419,0.2455,0.2365,9),
(1778,'I',0.485,0.345,0.16,0.869,0.3085,0.185,0.319,9),
(1779,'F',0.49,0.355,0.16,0.8795,0.3485,0.215,0.2825,8),
(1780,'M',0.5,0.37,0.15,1.0615,0.494,0.223,0.296,9),
(1781,'M',0.515,0.35,0.155,0.9225,0.4185,0.198,0.273,9),
(1782,'M',0.515,0.395,0.135,1.007,0.472,0.2495,0.252,8),
(1783,'M',0.525,0.365,0.17,0.9605,0.438,0.2225,0.276,10),
(1784,'M',0.525,0.38,0.125,0.65,0.303,0.155,0.159,7),
(1785,'M',0.53,0.41,0.14,0.7545,0.3495,0.1715,0.2105,8),
(1786,'F',0.535,0.425,0.135,0.771,0.3765,0.1815,0.1795,8),
(1787,'I',0.535,0.385,0.18,1.0835,0.4955,0.2295,0.304,8),
(1788,'I',0.545,0.42,0.165,0.8935,0.4235,0.2195,0.228,8),
(1789,'F',0.545,0.415,0.2,1.358,0.567,0.318,0.403,10),
(1790,'F',0.545,0.385,0.15,1.1185,0.5425,0.2445,0.2845,9),
(1791,'F',0.55,0.38,0.165,1.205,0.543,0.294,0.3345,10),
(1792,'M',0.55,0.42,0.16,1.3405,0.6325,0.311,0.344,10),
(1793,'M',0.57,0.455,0.175,1.02,0.4805,0.2145,0.29,9),
(1794,'M',0.575,0.44,0.185,1.025,0.5075,0.2245,0.2485,10),
(1795,'I',0.575,0.45,0.13,0.8145,0.403,0.1715,0.213,10),
(1796,'F',0.58,0.43,0.17,1.48,0.6535,0.324,0.4155,10),
(1797,'M',0.585,0.455,0.145,0.953,0.3945,0.2685,0.258,10),
(1798,'I',0.585,0.45,0.15,0.8915,0.3975,0.2035,0.253,8),
(1799,'M',0.6,0.495,0.175,1.3005,0.6195,0.284,0.3285,11),
(1800,'M',0.6,0.465,0.165,1.038,0.4975,0.2205,0.251,9),
(1801,'M',0.605,0.475,0.175,1.2525,0.5575,0.3055,0.343,9),
(1802,'M',0.605,0.475,0.15,1.15,0.575,0.232,0.297,10),
(1803,'F',0.61,0.475,0.15,1.1135,0.5195,0.2575,0.3005,11),
(1804,'F',0.615,0.455,0.145,1.1155,0.5045,0.238,0.315,10),
(1805,'M',0.62,0.47,0.145,1.0865,0.511,0.2715,0.2565,10),
(1806,'M',0.625,0.495,0.175,1.254,0.5815,0.286,0.3185,9),
(1807,'M',0.625,0.49,0.185,1.169,0.5275,0.2535,0.344,11),
(1808,'M',0.635,0.495,0.195,1.172,0.445,0.3115,0.3475,11),
(1809,'F',0.635,0.475,0.15,1.1845,0.533,0.307,0.291,10),
(1810,'F',0.64,0.475,0.14,1.0725,0.4895,0.2295,0.31,8),
(1811,'M',0.645,0.5,0.16,1.3815,0.672,0.326,0.315,9),
(1812,'M',0.65,0.525,0.19,1.6125,0.777,0.3685,0.3965,11),
(1813,'M',0.65,0.485,0.16,1.7395,0.5715,0.2785,0.3075,10),
(1814,'F',0.655,0.52,0.2,1.5475,0.713,0.314,0.466,9),
(1815,'M',0.655,0.545,0.19,1.4245,0.6325,0.333,0.378,10),
(1816,'F',0.665,0.515,0.185,1.3405,0.5595,0.293,0.4375,11),
(1817,'F',0.675,0.53,0.175,1.4465,0.6775,0.33,0.389,10),
(1818,'F',0.685,0.535,0.175,1.5845,0.7175,0.3775,0.4215,9),
(1819,'F',0.695,0.55,0.185,1.679,0.805,0.4015,0.3965,10),
(1820,'M',0.695,0.53,0.19,1.726,0.7625,0.436,0.455,11),
(1821,'F',0.705,0.545,0.18,1.5395,0.6075,0.3675,0.4645,13),
(1822,'F',0.72,0.55,0.195,2.073,1.0715,0.4265,0.5015,9),
(1823,'M',0.72,0.56,0.18,1.5865,0.691,0.375,0.4425,11),
(1824,'M',0.73,0.575,0.21,2.069,0.9285,0.409,0.643,11),
(1825,'I',0.185,0.135,0.04,0.027,0.0105,0.0055,0.009,5),
(1826,'I',0.24,0.18,0.055,0.0555,0.0235,0.013,0.018,4),
(1827,'I',0.31,0.215,0.075,0.1275,0.0565,0.0275,0.036,7),
(1828,'I',0.34,0.26,0.085,0.1885,0.0815,0.0335,0.06,6),
(1829,'I',0.35,0.265,0.08,0.2,0.09,0.042,0.06,7),
(1830,'I',0.365,0.27,0.085,0.197,0.0815,0.0325,0.065,6),
(1831,'I',0.365,0.275,0.085,0.223,0.098,0.0375,0.075,7),
(1832,'I',0.365,0.27,0.075,0.2215,0.095,0.0445,0.07,6),
(1833,'I',0.39,0.31,0.105,0.2665,0.1185,0.0525,0.081,8),
(1834,'I',0.405,0.3,0.09,0.269,0.103,0.067,0.11,6),
(1835,'I',0.41,0.315,0.095,0.2805,0.114,0.0345,0.11,7),
(1836,'I',0.41,0.335,0.105,0.3305,0.1405,0.064,0.105,7),
(1837,'I',0.415,0.31,0.09,0.2815,0.1245,0.0615,0.085,6),
(1838,'I',0.415,0.31,0.1,0.2805,0.114,0.0565,0.0975,6),
(1839,'I',0.415,0.31,0.095,0.311,0.1125,0.0625,0.115,8),
(1840,'I',0.42,0.325,0.1,0.368,0.1675,0.0625,0.1135,11),
(1841,'I',0.43,0.34,0.1,0.3405,0.1395,0.0665,0.12,8),
(1842,'I',0.435,0.335,0.1,0.3245,0.135,0.0785,0.098,7),
(1843,'I',0.435,0.33,0.11,0.38,0.1515,0.0945,0.11,7),
(1844,'I',0.435,0.33,0.105,0.335,0.156,0.0555,0.105,8),
(1845,'I',0.435,0.345,0.12,0.3215,0.13,0.056,0.1185,7),
(1846,'I',0.445,0.33,0.11,0.358,0.1525,0.067,0.1185,8),
(1847,'I',0.465,0.37,0.11,0.445,0.1635,0.096,0.166,7),
(1848,'I',0.47,0.375,0.12,0.487,0.196,0.099,0.135,8),
(1849,'I',0.475,0.34,0.105,0.4535,0.203,0.08,0.1465,9),
(1850,'I',0.485,0.385,0.13,0.568,0.2505,0.178,0.154,7),
(1851,'I',0.485,0.36,0.12,0.5155,0.2465,0.1025,0.147,8),
(1852,'I',0.485,0.37,0.115,0.457,0.1885,0.0965,0.15,9),
(1853,'I',0.495,0.38,0.135,0.5095,0.2065,0.1165,0.165,8),
(1854,'I',0.495,0.38,0.145,0.5,0.205,0.148,0.1505,8),
(1855,'I',0.495,0.375,0.14,0.494,0.181,0.0975,0.191,8),
(1856,'I',0.5,0.38,0.11,0.5605,0.28,0.106,0.15,9),
(1857,'I',0.505,0.405,0.13,0.599,0.2245,0.1175,0.225,11),
(1858,'I',0.505,0.4,0.145,0.7045,0.334,0.1425,0.207,8),
(1859,'F',0.51,0.4,0.12,0.7005,0.347,0.1105,0.195,10),
(1860,'I',0.515,0.415,0.135,0.7125,0.285,0.152,0.245,10),
(1861,'I',0.515,0.42,0.15,0.6725,0.2555,0.1335,0.235,10),
(1862,'M',0.515,0.385,0.11,0.5785,0.253,0.16,0.14,8),
(1863,'I',0.52,0.41,0.11,0.5185,0.2165,0.0915,0.184,8),
(1864,'I',0.52,0.415,0.14,0.6375,0.308,0.1335,0.168,9),
(1865,'I',0.52,0.395,0.125,0.5805,0.2445,0.146,0.165,9),
(1866,'I',0.52,0.38,0.115,0.6645,0.3285,0.17,0.1425,7),
(1867,'I',0.52,0.385,0.115,0.581,0.2555,0.156,0.143,10),
(1868,'I',0.525,0.415,0.12,0.596,0.2805,0.12,0.1695,9),
(1869,'I',0.525,0.405,0.145,0.6965,0.3045,0.1535,0.21,8),
(1870,'I',0.525,0.4,0.145,0.6095,0.248,0.159,0.175,9),
(1871,'I',0.53,0.43,0.14,0.677,0.298,0.0965,0.23,8),
(1872,'I',0.53,0.43,0.16,0.7245,0.321,0.1275,0.24,9),
(1873,'I',0.53,0.395,0.13,0.575,0.247,0.115,0.183,9),
(1874,'I',0.53,0.405,0.12,0.632,0.2715,0.148,0.1875,9),
(1875,'I',0.535,0.455,0.14,1.0015,0.53,0.1765,0.244,9),
(1876,'F',0.54,0.425,0.16,0.9455,0.3675,0.2005,0.295,9),
(1877,'I',0.54,0.395,0.135,0.6555,0.2705,0.155,0.192,9),
(1878,'I',0.54,0.39,0.125,0.6255,0.2525,0.158,0.19,8),
(1879,'I',0.545,0.425,0.14,0.8145,0.305,0.231,0.244,10),
(1880,'I',0.545,0.43,0.14,0.687,0.2615,0.1405,0.25,9),
(1881,'I',0.55,0.435,0.14,0.7995,0.295,0.1905,0.238,10),
(1882,'I',0.55,0.45,0.13,0.804,0.3375,0.1405,0.23,6),
(1883,'M',0.555,0.435,0.14,0.7495,0.341,0.1645,0.214,8),
(1884,'M',0.555,0.41,0.125,0.599,0.2345,0.1465,0.194,8),
(1885,'M',0.555,0.4,0.13,0.7075,0.332,0.1585,0.18,7),
(1886,'I',0.555,0.45,0.175,0.738,0.304,0.1755,0.22,9),
(1887,'M',0.555,0.455,0.135,0.837,0.382,0.171,0.235,9),
(1888,'I',0.56,0.445,0.165,0.832,0.3455,0.179,0.279,9),
(1889,'F',0.565,0.445,0.125,0.8305,0.3135,0.1785,0.23,11),
(1890,'M',0.565,0.415,0.125,0.667,0.302,0.1545,0.185,7),
(1891,'M',0.565,0.455,0.155,0.9355,0.421,0.183,0.26,11),
(1892,'I',0.565,0.435,0.145,0.8445,0.3975,0.158,0.255,9),
(1893,'M',0.565,0.45,0.16,0.895,0.415,0.195,0.246,9),
(1894,'I',0.565,0.46,0.155,0.8715,0.3755,0.215,0.25,10),
(1895,'M',0.57,0.46,0.155,1.0005,0.454,0.205,0.265,11),
(1896,'M',0.57,0.455,0.155,0.832,0.3585,0.174,0.277,11),
(1897,'M',0.57,0.44,0.175,0.9415,0.3805,0.2285,0.283,9),
(1898,'M',0.57,0.415,0.13,0.88,0.4275,0.1955,0.238,13),
(1899,'F',0.57,0.44,0.12,0.803,0.382,0.1525,0.234,9),
(1900,'M',0.575,0.45,0.13,0.785,0.318,0.193,0.2265,9),
(1901,'M',0.575,0.45,0.155,0.9765,0.495,0.2145,0.235,9),
(1902,'M',0.575,0.435,0.135,0.992,0.432,0.2225,0.239,10),
(1903,'M',0.575,0.455,0.155,1.013,0.4685,0.2085,0.295,11),
(1904,'M',0.575,0.445,0.145,0.876,0.3795,0.1615,0.27,10),
(1905,'F',0.575,0.465,0.175,1.099,0.4735,0.202,0.35,9),
(1906,'I',0.575,0.45,0.135,0.8715,0.45,0.162,0.225,10),
(1907,'I',0.575,0.45,0.135,0.8245,0.3375,0.2115,0.239,11),
(1908,'F',0.575,0.43,0.155,0.7955,0.3485,0.1925,0.22,9),
(1909,'M',0.575,0.475,0.145,0.857,0.3665,0.173,0.269,9),
(1910,'F',0.58,0.45,0.195,0.8265,0.4035,0.173,0.225,9),
(1911,'F',0.58,0.5,0.165,0.925,0.37,0.185,0.3005,10),
(1912,'M',0.58,0.44,0.15,1.0465,0.518,0.2185,0.2795,10),
(1913,'I',0.58,0.44,0.145,0.7905,0.3525,0.1645,0.242,10),
(1914,'M',0.58,0.44,0.16,0.8295,0.3365,0.2005,0.2485,9),
(1915,'M',0.595,0.455,0.15,0.886,0.4315,0.201,0.223,10),
(1916,'F',0.6,0.47,0.135,0.97,0.4655,0.1955,0.264,11),
(1917,'M',0.6,0.46,0.17,1.1805,0.456,0.337,0.329,11),
(1918,'M',0.6,0.475,0.15,0.99,0.386,0.2195,0.3105,10),
(1919,'F',0.6,0.465,0.16,1.133,0.466,0.2885,0.298,11),
(1920,'I',0.605,0.49,0.165,1.071,0.482,0.1935,0.352,10),
(1921,'F',0.605,0.455,0.145,0.862,0.334,0.1985,0.3,9),
(1922,'M',0.605,0.47,0.18,1.1155,0.479,0.2565,0.321,10),
(1923,'M',0.61,0.48,0.14,1.031,0.4375,0.2615,0.27,8),
(1924,'F',0.61,0.46,0.145,1.1185,0.478,0.2945,0.2985,10),
(1925,'F',0.61,0.46,0.155,0.957,0.4255,0.1975,0.265,8),
(1926,'F',0.61,0.47,0.165,1.1785,0.566,0.2785,0.294,11),
(1927,'M',0.615,0.47,0.145,1.0285,0.4435,0.2825,0.285,11),
(1928,'M',0.615,0.47,0.15,1.0875,0.4975,0.283,0.2685,9),
(1929,'F',0.615,0.495,0.16,1.255,0.5815,0.3195,0.3225,12),
(1930,'M',0.615,0.495,0.2,1.219,0.564,0.227,0.3885,10),
(1931,'M',0.62,0.49,0.16,1.035,0.44,0.2525,0.285,11),
(1932,'M',0.62,0.49,0.15,1.195,0.4605,0.302,0.355,9),
(1933,'F',0.62,0.495,0.17,1.062,0.372,0.213,0.34,11),
(1934,'M',0.62,0.495,0.195,1.5145,0.579,0.346,0.5195,15),
(1935,'M',0.62,0.47,0.15,1.309,0.587,0.4405,0.325,9),
(1936,'M',0.62,0.485,0.155,1.0295,0.425,0.2315,0.335,12),
(1937,'M',0.625,0.495,0.155,1.0485,0.487,0.212,0.3215,11),
(1938,'M',0.625,0.515,0.17,1.331,0.5725,0.3005,0.361,9),
(1939,'M',0.625,0.505,0.185,1.1565,0.52,0.2405,0.3535,10),
(1940,'F',0.625,0.445,0.16,1.09,0.46,0.2965,0.304,11),
(1941,'F',0.625,0.52,0.18,1.354,0.4845,0.351,0.375,11),
(1942,'F',0.625,0.47,0.145,0.984,0.475,0.2,0.265,11),
(1943,'M',0.63,0.49,0.155,1.2525,0.63,0.246,0.289,9),
(1944,'F',0.635,0.485,0.165,1.2695,0.5635,0.3065,0.3395,11),
(1945,'F',0.635,0.52,0.165,1.3405,0.5065,0.296,0.412,11),
(1946,'F',0.635,0.505,0.155,1.2895,0.594,0.314,0.345,11),
(1947,'M',0.635,0.525,0.16,1.195,0.5435,0.246,0.335,12),
(1948,'M',0.635,0.5,0.165,1.273,0.6535,0.213,0.365,12),
(1949,'M',0.635,0.515,0.165,1.229,0.5055,0.2975,0.3535,10),
(1950,'M',0.64,0.53,0.165,1.1895,0.4765,0.3,0.35,11),
(1951,'F',0.64,0.48,0.145,1.1145,0.508,0.24,0.34,10),
(1952,'F',0.64,0.515,0.165,1.3115,0.4945,0.2555,0.41,10),
(1953,'I',0.64,0.49,0.135,1.1,0.488,0.2505,0.2925,10),
(1954,'M',0.64,0.49,0.155,1.1285,0.477,0.269,0.34,9),
(1955,'F',0.64,0.485,0.185,1.4195,0.6735,0.3465,0.3255,11),
(1956,'F',0.645,0.51,0.18,1.6195,0.7815,0.322,0.4675,12),
(1957,'M',0.645,0.49,0.175,1.32,0.6525,0.2375,0.3385,11),
(1958,'F',0.645,0.52,0.21,1.5535,0.616,0.3655,0.474,16),
(1959,'I',0.65,0.52,0.15,1.238,0.5495,0.296,0.3305,10),
(1960,'F',0.65,0.51,0.155,1.189,0.483,0.278,0.3645,13),
(1961,'F',0.65,0.51,0.185,1.375,0.531,0.384,0.3985,10),
(1962,'F',0.655,0.515,0.18,1.412,0.6195,0.2485,0.497,11),
(1963,'F',0.655,0.525,0.175,1.348,0.5855,0.2605,0.394,10),
(1964,'M',0.655,0.52,0.17,1.1445,0.53,0.223,0.348,9),
(1965,'F',0.66,0.535,0.205,1.4415,0.5925,0.2775,0.49,10),
(1966,'M',0.66,0.51,0.175,1.218,0.5055,0.303,0.37,11),
(1967,'F',0.665,0.5,0.15,1.2475,0.4625,0.2955,0.3595,10),
(1968,'M',0.665,0.515,0.2,1.2695,0.5115,0.2675,0.436,12),
(1969,'M',0.665,0.525,0.18,1.429,0.6715,0.29,0.4,12),
(1970,'F',0.67,0.53,0.205,1.4015,0.643,0.2465,0.416,12),
(1971,'M',0.675,0.515,0.15,1.312,0.556,0.2845,0.4115,11),
(1972,'F',0.675,0.51,0.185,1.473,0.6295,0.3025,0.4245,11),
(1973,'M',0.68,0.54,0.19,1.623,0.7165,0.354,0.4715,12),
(1974,'M',0.68,0.54,0.155,1.534,0.671,0.379,0.384,10),
(1975,'M',0.685,0.535,0.155,1.3845,0.6615,0.2145,0.4075,10),
(1976,'M',0.69,0.55,0.18,1.6915,0.6655,0.402,0.5,11),
(1977,'M',0.695,0.545,0.185,1.5715,0.6645,0.3835,0.4505,13),
(1978,'F',0.7,0.575,0.205,1.773,0.605,0.447,0.538,13),
(1979,'M',0.7,0.55,0.175,1.4405,0.6565,0.2985,0.375,12),
(1980,'M',0.7,0.55,0.195,1.6245,0.675,0.347,0.535,13),
(1981,'F',0.705,0.535,0.22,1.866,0.929,0.3835,0.4395,10),
(1982,'F',0.72,0.575,0.18,1.6705,0.732,0.3605,0.501,12),
(1983,'M',0.72,0.565,0.19,2.081,1.0815,0.4305,0.503,11),
(1984,'F',0.725,0.57,0.205,1.6195,0.744,0.315,0.488,11),
(1985,'F',0.75,0.55,0.195,1.8325,0.83,0.366,0.44,11),
(1986,'M',0.76,0.605,0.215,2.173,0.801,0.4915,0.646,13),
(1987,'I',0.135,0.13,0.04,0.029,0.0125,0.0065,0.008,4),
(1988,'I',0.16,0.11,0.025,0.0195,0.0075,0.005,0.006,4),
(1989,'I',0.21,0.15,0.055,0.0465,0.017,0.012,0.015,5),
(1990,'I',0.28,0.21,0.075,0.1195,0.053,0.0265,0.03,6),
(1991,'I',0.28,0.2,0.065,0.0895,0.036,0.0185,0.03,7),
(1992,'I',0.285,0.215,0.06,0.0935,0.031,0.023,0.03,6),
(1993,'I',0.29,0.21,0.07,0.1115,0.048,0.0205,0.03,5),
(1994,'I',0.29,0.21,0.06,0.1195,0.056,0.0235,0.03,6),
(1995,'I',0.29,0.21,0.065,0.097,0.0375,0.022,0.03,6),
(1996,'I',0.32,0.24,0.07,0.133,0.0585,0.0255,0.041,6),
(1997,'I',0.325,0.25,0.07,0.1745,0.0875,0.0355,0.04,7),
(1998,'I',0.335,0.25,0.08,0.1695,0.0695,0.044,0.0495,6),
(1999,'I',0.35,0.235,0.08,0.17,0.0725,0.0465,0.0495,7),
(2000,'I',0.35,0.25,0.07,0.1605,0.0715,0.0335,0.046,6),
(2001,'I',0.355,0.27,0.105,0.271,0.1425,0.0525,0.0735,9),
(2002,'I',0.36,0.27,0.085,0.2185,0.1065,0.038,0.062,6),
(2003,'I',0.36,0.27,0.085,0.196,0.0905,0.034,0.053,7),
(2004,'I',0.375,0.28,0.08,0.226,0.105,0.047,0.065,6),
(2005,'I',0.375,0.275,0.085,0.22,0.109,0.05,0.0605,7),
(2006,'I',0.395,0.29,0.095,0.3,0.158,0.068,0.078,7),
(2007,'I',0.405,0.25,0.09,0.2875,0.128,0.063,0.0805,7),
(2008,'I',0.415,0.325,0.11,0.316,0.1385,0.0795,0.0925,8),
(2009,'I',0.425,0.315,0.095,0.3675,0.1865,0.0675,0.0985,7),
(2010,'I',0.43,0.32,0.11,0.3675,0.1675,0.102,0.105,8),
(2011,'I',0.435,0.325,0.12,0.346,0.159,0.084,0.095,7),
(2012,'M',0.45,0.33,0.105,0.4955,0.2575,0.082,0.129,8),
(2013,'I',0.46,0.35,0.11,0.4675,0.2125,0.099,0.1375,7),
(2014,'M',0.47,0.365,0.135,0.522,0.2395,0.1525,0.145,10),
(2015,'I',0.47,0.375,0.105,0.441,0.167,0.0865,0.145,10),
(2016,'I',0.475,0.365,0.12,0.5185,0.268,0.1095,0.1365,8),
(2017,'M',0.505,0.39,0.12,0.653,0.3315,0.1385,0.167,9),
(2018,'M',0.505,0.395,0.135,0.5915,0.288,0.1315,0.185,12),
(2019,'M',0.505,0.385,0.115,0.4825,0.21,0.1035,0.1535,10),
(2020,'I',0.51,0.455,0.135,0.6855,0.2875,0.154,0.2035,9),
(2021,'M',0.515,0.4,0.14,0.6335,0.288,0.145,0.168,9),
(2022,'M',0.525,0.41,0.13,0.6875,0.3435,0.1495,0.1765,9),
(2023,'F',0.53,0.43,0.15,0.741,0.325,0.1855,0.196,9),
(2024,'F',0.53,0.405,0.13,0.6355,0.2635,0.1565,0.185,9),
(2025,'M',0.545,0.44,0.14,0.8395,0.356,0.1905,0.2385,11),
(2026,'F',0.55,0.47,0.15,0.9205,0.381,0.2435,0.2675,10),
(2027,'F',0.56,0.41,0.16,0.8215,0.342,0.184,0.253,9),
(2028,'M',0.565,0.445,0.145,0.9255,0.4345,0.212,0.2475,9),
(2029,'F',0.57,0.435,0.15,0.8295,0.3875,0.156,0.245,10),
(2030,'M',0.58,0.46,0.16,1.063,0.513,0.2705,0.2625,9),
(2031,'M',0.59,0.465,0.165,1.115,0.5165,0.273,0.275,10),
(2032,'F',0.6,0.45,0.14,0.837,0.37,0.177,0.2425,10),
(2033,'M',0.605,0.445,0.14,0.982,0.4295,0.2085,0.295,12),
(2034,'M',0.61,0.49,0.16,1.112,0.465,0.228,0.341,10),
(2035,'F',0.625,0.515,0.18,1.3485,0.5255,0.252,0.3925,14),
(2036,'M',0.66,0.515,0.195,1.5655,0.7345,0.353,0.386,9),
(2037,'I',0.255,0.19,0.06,0.086,0.04,0.0185,0.025,5),
(2038,'I',0.27,0.195,0.065,0.1065,0.0475,0.0225,0.0285,5),
(2039,'I',0.28,0.215,0.08,0.132,0.072,0.022,0.033,5),
(2040,'I',0.285,0.215,0.07,0.1075,0.051,0.0225,0.027,6),
(2041,'I',0.32,0.255,0.085,0.1745,0.072,0.033,0.057,8),
(2042,'I',0.325,0.24,0.07,0.152,0.0565,0.0305,0.054,8),
(2043,'I',0.385,0.28,0.1,0.2755,0.1305,0.061,0.0725,8),
(2044,'I',0.395,0.295,0.1,0.293,0.14,0.062,0.082,7),
(2045,'F',0.4,0.305,0.16,0.368,0.173,0.0705,0.105,7),
(2046,'I',0.405,0.31,0.09,0.312,0.138,0.06,0.087,8),
(2047,'I',0.415,0.305,0.12,0.336,0.165,0.076,0.0805,7),
(2048,'I',0.42,0.315,0.115,0.355,0.1895,0.065,0.087,6),
(2049,'I',0.44,0.305,0.115,0.379,0.162,0.091,0.11,9),
(2050,'I',0.445,0.32,0.12,0.378,0.152,0.0825,0.12,8),
(2051,'M',0.45,0.35,0.13,0.4655,0.2075,0.1045,0.135,8),
(2052,'F',0.455,0.355,1.13,0.594,0.332,0.116,0.1335,8),
(2053,'M',0.46,0.345,0.12,0.4935,0.2435,0.1175,0.132,8),
(2054,'M',0.46,0.345,0.11,0.4595,0.235,0.0885,0.116,7),
(2055,'M',0.465,0.36,0.11,0.4955,0.2665,0.085,0.121,7),
(2056,'I',0.465,0.355,0.09,0.4325,0.2005,0.074,0.1275,9),
(2057,'F',0.475,0.38,0.14,0.689,0.3165,0.1315,0.1955,7),
(2058,'I',0.48,0.35,0.135,0.5465,0.2735,0.0995,0.158,8),
(2059,'M',0.485,0.39,0.135,0.617,0.25,0.1345,0.1635,8),
(2060,'I',0.49,0.37,0.11,0.538,0.271,0.1035,0.139,8),
(2061,'M',0.5,0.39,0.135,0.7815,0.361,0.1575,0.2385,9),
(2062,'F',0.5,0.38,0.14,0.6355,0.277,0.143,0.1785,8),
(2063,'M',0.505,0.385,0.13,0.6435,0.3135,0.149,0.1515,7),
(2064,'M',0.525,0.385,0.1,0.5115,0.246,0.1005,0.1455,8),
(2065,'M',0.535,0.42,0.125,0.738,0.355,0.1895,0.1795,8),
(2066,'F',0.535,0.42,0.13,0.699,0.3125,0.1565,0.2035,8),
(2067,'F',0.54,0.385,0.14,0.7655,0.3265,0.116,0.2365,10),
(2068,'F',0.54,0.42,0.13,0.7505,0.368,0.1675,0.1845,9),
(2069,'F',0.545,0.43,0.16,0.844,0.3945,0.1855,0.231,9),
(2070,'M',0.55,0.41,0.13,0.8705,0.4455,0.2115,0.213,9),
(2071,'I',0.55,0.42,0.115,0.668,0.2925,0.137,0.209,11),
(2072,'F',0.565,0.44,0.135,0.83,0.393,0.1735,0.238,9),
(2073,'M',0.58,0.45,0.12,0.8685,0.418,0.1475,0.2605,8),
(2074,'F',0.58,0.435,0.15,0.839,0.3485,0.207,0.192,7),
(2075,'F',0.585,0.485,0.15,1.079,0.4145,0.2115,0.356,11),
(2076,'M',0.595,0.465,0.15,0.919,0.4335,0.1765,0.262,9),
(2077,'F',0.6,0.47,0.19,1.1345,0.492,0.2595,0.3375,10),
(2078,'F',0.61,0.43,0.14,0.909,0.438,0.2,0.22,8),
(2079,'M',0.61,0.48,0.165,1.2435,0.5575,0.2675,0.372,8),
(2080,'F',0.62,0.49,0.16,1.056,0.493,0.244,0.2725,9),
(2081,'M',0.645,0.495,0.15,1.2095,0.603,0.2225,0.339,9),
(2082,'M',0.65,0.5,0.14,1.238,0.6165,0.2355,0.32,8),
(2083,'F',0.665,0.525,0.21,1.644,0.818,0.3395,0.4275,10),
(2084,'M',0.685,0.55,0.2,1.7725,0.813,0.387,0.49,11),
(2085,'F',0.69,0.54,0.195,1.2525,0.73,0.3975,0.462,12),
(2086,'F',0.705,0.57,0.185,1.761,0.747,0.3725,0.488,10),
(2087,'F',0.71,0.5,0.15,1.3165,0.6835,0.2815,0.28,10),
(2088,'M',0.72,0.585,0.22,1.914,0.9155,0.448,0.479,11),
(2089,'F',0.72,0.575,0.215,2.1,0.8565,0.4825,0.602,12),
(2090,'F',0.73,0.555,0.18,1.6895,0.6555,0.1965,0.4935,10),
(2091,'M',0.775,0.57,0.22,2.032,0.735,0.4755,0.6585,17),
(2092,'F',0.505,0.39,0.115,0.66,0.3045,0.1555,0.175,8),
(2093,'M',0.53,0.425,0.13,0.7455,0.2995,0.1355,0.245,10),
(2094,'F',0.505,0.385,0.115,0.616,0.243,0.1075,0.21,11),
(2095,'I',0.405,0.305,0.09,0.2825,0.114,0.0575,0.095,7),
(2096,'M',0.415,0.3,0.1,0.3355,0.1545,0.0685,0.095,7),
(2097,'M',0.5,0.39,0.145,0.651,0.273,0.132,0.22,11),
(2098,'M',0.425,0.33,0.08,0.361,0.134,0.0825,0.125,7),
(2099,'M',0.47,0.35,0.1,0.4775,0.1885,0.0885,0.175,8),
(2100,'F',0.4,0.31,0.115,0.3465,0.1475,0.0695,0.115,10),
(2101,'I',0.37,0.29,0.1,0.25,0.1025,0.0505,0.085,10),
(2102,'M',0.5,0.38,0.155,0.66,0.2655,0.1365,0.215,19),
(2103,'I',0.41,0.31,0.11,0.315,0.124,0.082,0.095,9),
(2104,'M',0.375,0.29,0.1,0.276,0.1175,0.0565,0.085,9),
(2105,'F',0.49,0.385,0.125,0.5395,0.2175,0.128,0.165,11),
(2106,'M',0.585,0.48,0.185,1.04,0.434,0.265,0.285,10),
(2107,'M',0.595,0.455,0.155,1.041,0.416,0.2105,0.365,14),
(2108,'F',0.675,0.55,0.18,1.6885,0.562,0.3705,0.6,15),
(2109,'M',0.665,0.535,0.225,2.1835,0.7535,0.391,0.885,27),
(2110,'M',0.62,0.49,0.17,1.2105,0.5185,0.2555,0.335,13),
(2111,'I',0.325,0.25,0.055,0.166,0.076,0.051,0.045,5),
(2112,'I',0.455,0.355,0.08,0.452,0.2165,0.0995,0.125,9),
(2113,'M',0.525,0.405,0.13,0.7185,0.3265,0.1975,0.175,8),
(2114,'I',0.385,0.29,0.09,0.232,0.0855,0.0495,0.08,7),
(2115,'I',0.13,0.095,0.035,0.0105,0.005,0.0065,0.0035,4),
(2116,'I',0.18,0.13,0.045,0.0275,0.0125,0.01,0.009,3),
(2117,'I',0.31,0.225,0.05,0.1445,0.0675,0.0385,0.045,6),
(2118,'F',0.375,0.29,0.08,0.282,0.1405,0.0725,0.08,7),
(2119,'F',0.48,0.38,0.12,0.608,0.2705,0.1405,0.185,8),
(2120,'I',0.455,0.37,0.125,0.433,0.201,0.1265,0.145,9),
(2121,'M',0.425,0.325,0.1,0.3295,0.1365,0.0725,0.11,7),
(2122,'I',0.475,0.36,0.11,0.4555,0.177,0.0965,0.145,9),
(2123,'F',0.435,0.35,0.12,0.4585,0.192,0.1,0.13,11),
(2124,'F',0.29,0.21,0.075,0.275,0.113,0.0675,0.035,6),
(2125,'M',0.385,0.295,0.095,0.335,0.147,0.094,0.09,7),
(2126,'M',0.47,0.375,0.115,0.4265,0.1685,0.0755,0.15,8),
(2127,'F',0.5,0.4,0.125,0.5765,0.2395,0.126,0.185,10),
(2128,'I',0.4,0.31,0.1,0.127,0.106,0.071,0.085,7),
(2129,'M',0.62,0.51,0.175,1.1505,0.4375,0.2265,0.4,12),
(2130,'M',0.595,0.47,0.15,0.8915,0.359,0.2105,0.245,12),
(2131,'M',0.585,0.455,0.14,0.97,0.462,0.185,0.295,9),
(2132,'M',0.32,0.24,0.08,0.18,0.08,0.0385,0.055,6),
(2133,'F',0.52,0.41,0.125,0.6985,0.2945,0.1625,0.215,10),
(2134,'M',0.44,0.35,0.11,0.4585,0.2,0.0885,0.13,9),
(2135,'F',0.44,0.33,0.115,0.4005,0.143,0.113,0.12,8),
(2136,'M',0.565,0.425,0.1,0.7145,0.3055,0.166,0.18,12),
(2137,'F',0.56,0.425,0.125,0.932,0.361,0.213,0.335,9),
(2138,'F',0.59,0.455,0.175,0.966,0.391,0.2455,0.31,10),
(2139,'F',0.57,0.465,0.18,0.9995,0.405,0.277,0.295,16),
(2140,'M',0.68,0.53,0.205,1.496,0.5825,0.337,0.465,14),
(2141,'F',0.45,0.36,0.125,0.5065,0.222,0.105,0.16,10),
(2142,'I',0.32,0.24,0.075,0.1735,0.076,0.0355,0.05,7),
(2143,'I',0.46,0.35,0.11,0.3945,0.1685,0.0865,0.125,9),
(2144,'M',0.47,0.37,0.105,0.4665,0.2025,0.1015,0.155,10),
(2145,'M',0.455,0.35,0.105,0.401,0.1575,0.083,0.135,9),
(2146,'F',0.415,0.325,0.115,0.3455,0.1405,0.0765,0.11,9),
(2147,'M',0.465,0.35,0.12,0.5205,0.2015,0.1625,0.185,11),
(2148,'M',0.46,0.375,0.135,0.4935,0.186,0.0845,0.17,12),
(2149,'M',0.415,0.31,0.09,0.3245,0.1305,0.0735,0.115,8),
(2150,'M',0.27,0.195,0.07,0.106,0.0465,0.018,0.036,7),
(2151,'M',0.445,0.355,0.11,0.4415,0.1805,0.1035,0.1505,10),
(2152,'F',0.745,0.585,0.19,1.966,0.8435,0.437,0.5855,18),
(2153,'F',0.4,0.3,0.115,0.3025,0.1335,0.0465,0.0935,8),
(2154,'I',0.28,0.2,0.075,0.1225,0.0545,0.0115,0.035,5),
(2155,'M',0.55,0.44,0.135,0.879,0.368,0.2095,0.265,10),
(2156,'M',0.58,0.46,0.165,1.2275,0.473,0.1965,0.435,16),
(2157,'M',0.61,0.5,0.165,1.2715,0.4915,0.185,0.49,12),
(2158,'M',0.62,0.495,0.175,1.806,0.643,0.3285,0.725,17),
(2159,'M',0.56,0.42,0.195,0.8085,0.3025,0.1795,0.285,14),
(2160,'F',0.64,0.51,0.2,1.3905,0.61,0.3315,0.41,12),
(2161,'M',0.69,0.55,0.2,1.8465,0.732,0.472,0.57,19),
(2162,'F',0.715,0.565,0.24,2.1995,0.7245,0.465,0.885,17),
(2163,'F',0.71,0.565,0.195,1.817,0.785,0.492,0.49,11),
(2164,'F',0.55,0.47,0.15,0.897,0.377,0.184,0.29,9),
(2165,'M',0.375,0.305,0.09,0.3245,0.1395,0.0565,0.095,5),
(2166,'F',0.61,0.45,0.16,1.136,0.414,0.311,0.3,9),
(2167,'I',0.38,0.28,0.085,0.2735,0.115,0.061,0.085,6),
(2168,'F',0.37,0.275,0.085,0.2405,0.104,0.0535,0.07,5),
(2169,'M',0.335,0.235,0.085,0.1545,0.066,0.0345,0.045,6),
(2170,'I',0.165,0.115,0.015,0.0145,0.0055,0.003,0.005,4),
(2171,'M',0.285,0.21,0.075,0.1185,0.055,0.0285,0.04,7),
(2172,'I',0.19,0.13,0.03,0.0295,0.0155,0.015,0.01,6),
(2173,'I',0.215,0.15,0.03,0.0385,0.0115,0.005,0.01,5),
(2174,'M',0.595,0.465,0.125,0.799,0.3245,0.2,0.23,10),
(2175,'F',0.645,0.5,0.17,1.1845,0.4805,0.274,0.355,13),
(2176,'M',0.575,0.45,0.185,0.925,0.342,0.197,0.35,12),
(2177,'F',0.57,0.45,0.17,1.098,0.414,0.187,0.405,20),
(2178,'F',0.58,0.45,0.235,1.071,0.3,0.206,0.395,14),
(2179,'F',0.595,0.48,0.2,0.975,0.358,0.2035,0.34,15),
(2180,'F',0.595,0.47,0.25,1.283,0.462,0.2475,0.445,14),
(2181,'F',0.625,0.42,0.165,1.0595,0.358,0.165,0.445,21),
(2182,'M',0.535,0.42,0.165,0.9195,0.3355,0.1985,0.26,16),
(2183,'M',0.55,0.43,0.16,0.9295,0.317,0.1735,0.355,13),
(2184,'M',0.495,0.4,0.155,0.8085,0.2345,0.1155,0.35,6),
(2185,'I',0.32,0.235,0.08,0.1485,0.064,0.031,0.045,6),
(2186,'M',0.445,0.34,0.12,0.4475,0.193,0.1035,0.13,9),
(2187,'F',0.52,0.4,0.125,0.6865,0.295,0.1715,0.185,9),
(2188,'M',0.495,0.385,0.135,0.6335,0.2,0.1225,0.26,14),
(2189,'M',0.47,0.37,0.135,0.547,0.222,0.1325,0.17,12),
(2190,'F',0.49,0.37,0.14,0.585,0.243,0.115,0.195,10),
(2191,'M',0.58,0.47,0.165,0.927,0.3215,0.1985,0.315,11),
(2192,'M',0.645,0.495,0.185,1.4935,0.5265,0.2785,0.455,15),
(2193,'F',0.575,0.485,0.165,1.0405,0.419,0.264,0.3,14),
(2194,'I',0.215,0.17,0.055,0.0605,0.0205,0.014,0.02,6),
(2195,'I',0.43,0.325,0.11,0.3675,0.1355,0.0935,0.12,13),
(2196,'I',0.26,0.215,0.08,0.099,0.037,0.0255,0.045,5),
(2197,'I',0.37,0.28,0.09,0.233,0.0905,0.0545,0.07,11),
(2198,'I',0.405,0.305,0.105,0.3625,0.1565,0.0705,0.125,10),
(2199,'I',0.27,0.19,0.08,0.081,0.0265,0.0195,0.03,6),
(2200,'F',0.68,0.55,0.2,1.596,0.525,0.4075,0.585,21),
(2201,'F',0.65,0.515,0.195,1.4005,0.5195,0.36,0.44,13),
(2202,'F',0.645,0.49,0.215,1.406,0.4265,0.2285,0.51,25),
(2203,'M',0.57,0.405,0.16,0.9245,0.3445,0.2185,0.295,19),
(2204,'M',0.615,0.48,0.19,1.36,0.5305,0.2375,0.47,18),
(2205,'M',0.42,0.345,0.105,0.43,0.175,0.096,0.13,7),
(2206,'I',0.275,0.22,0.08,0.1365,0.0565,0.0285,0.042,6),
(2207,'F',0.29,0.225,0.075,0.14,0.0515,0.0235,0.04,5),
(2208,'M',0.42,0.34,0.115,0.4215,0.175,0.093,0.135,8),
(2209,'F',0.625,0.525,0.215,1.5765,0.5115,0.2595,0.665,16),
(2210,'F',0.55,0.465,0.18,1.2125,0.3245,0.205,0.525,27),
(2211,'M',0.66,0.505,0.2,1.6305,0.4865,0.297,0.61,18),
(2212,'M',0.565,0.47,0.195,1.142,0.387,0.258,0.35,17),
(2213,'F',0.595,0.495,0.235,1.366,0.5065,0.219,0.52,13),
(2214,'M',0.63,0.51,0.23,1.539,0.5635,0.2815,0.57,17),
(2215,'F',0.43,0.325,0.12,0.445,0.165,0.0995,0.155,8),
(2216,'F',0.455,0.35,0.14,0.5725,0.1965,0.1325,0.175,10),
(2217,'I',0.33,0.26,0.08,0.19,0.0765,0.0385,0.065,7),
(2218,'F',0.515,0.415,0.13,0.764,0.276,0.196,0.25,13),
(2219,'M',0.495,0.39,0.15,0.853,0.3285,0.189,0.27,14),
(2220,'F',0.485,0.375,0.145,0.5885,0.2385,0.1155,0.19,13),
(2221,'F',0.535,0.46,0.145,0.7875,0.3395,0.2005,0.2,8),
(2222,'M',0.58,0.465,0.175,1.035,0.401,0.1865,0.385,17),
(2223,'F',0.625,0.525,0.195,1.352,0.4505,0.2445,0.53,13),
(2224,'F',0.555,0.455,0.18,0.958,0.296,0.195,0.39,14),
(2225,'F',0.55,0.425,0.145,0.797,0.297,0.15,0.265,9),
(2226,'M',0.59,0.475,0.155,0.857,0.356,0.174,0.28,13),
(2227,'I',0.355,0.28,0.11,0.2235,0.0815,0.0525,0.08,7),
(2228,'I',0.275,0.2,0.075,0.086,0.0305,0.019,0.03,7),
(2229,'F',0.505,0.39,0.175,0.692,0.267,0.15,0.215,12),
(2230,'M',0.37,0.28,0.095,0.2225,0.0805,0.051,0.075,7),
(2231,'M',0.555,0.43,0.165,0.7575,0.2735,0.1635,0.275,13),
(2232,'F',0.505,0.4,0.165,0.729,0.2675,0.155,0.25,9),
(2233,'F',0.56,0.445,0.18,0.903,0.3575,0.2045,0.295,9),
(2234,'M',0.595,0.475,0.17,1.0965,0.419,0.229,0.35,17),
(2235,'F',0.57,0.45,0.165,0.903,0.3305,0.1845,0.295,14),
(2236,'M',0.6,0.48,0.175,1.229,0.4125,0.2735,0.415,13),
(2237,'F',0.56,0.435,0.185,1.106,0.422,0.2435,0.33,15),
(2238,'M',0.585,0.465,0.19,1.171,0.3905,0.2355,0.4,17),
(2239,'I',0.46,0.335,0.11,0.444,0.225,0.0745,0.11,8),
(2240,'F',0.46,0.36,0.115,0.4755,0.2105,0.105,0.16,8),
(2241,'M',0.415,0.315,0.125,0.388,0.068,0.09,0.125,12),
(2242,'F',0.435,0.32,0.12,0.3785,0.152,0.0915,0.125,11),
(2243,'F',0.475,0.38,0.135,0.486,0.1735,0.07,0.185,7),
(2244,'M',0.465,0.36,0.13,0.5265,0.2105,0.1185,0.165,10),
(2245,'I',0.355,0.28,0.1,0.2275,0.0935,0.0455,0.085,11),
(2246,'M',0.46,0.375,0.14,0.5105,0.192,0.1045,0.205,9),
(2247,'F',0.38,0.325,0.11,0.3105,0.12,0.074,0.105,10),
(2248,'F',0.47,0.365,0.12,0.543,0.2295,0.1495,0.15,9),
(2249,'M',0.36,0.27,0.09,0.2225,0.083,0.053,0.075,6),
(2250,'F',0.585,0.455,0.165,0.998,0.345,0.2495,0.315,12),
(2251,'M',0.655,0.59,0.2,1.5455,0.654,0.3765,0.415,11),
(2252,'M',0.6,0.485,0.175,1.2675,0.4995,0.2815,0.38,13),
(2253,'F',0.57,0.46,0.17,1.1,0.4125,0.2205,0.38,14),
(2254,'F',0.645,0.5,0.2,1.4285,0.639,0.305,0.36,11),
(2255,'M',0.65,0.495,0.18,1.793,0.8005,0.339,0.53,14),
(2256,'M',0.51,0.395,0.145,0.6185,0.216,0.1385,0.24,12),
(2257,'M',0.52,0.38,0.135,0.5825,0.2505,0.1565,0.175,8),
(2258,'M',0.495,0.415,0.165,0.7485,0.264,0.134,0.285,13),
(2259,'M',0.43,0.335,0.115,0.406,0.166,0.0935,0.135,8),
(2260,'F',0.59,0.465,0.16,1.1005,0.506,0.2525,0.295,13),
(2261,'M',0.55,0.46,0.175,0.869,0.3155,0.1825,0.32,10),
(2262,'M',0.585,0.43,0.16,0.955,0.3625,0.176,0.27,11),
(2263,'F',0.58,0.455,0.16,0.9215,0.312,0.196,0.3,17),
(2264,'F',0.62,0.51,0.15,1.456,0.581,0.2875,0.32,13),
(2265,'I',0.59,0.45,0.16,0.893,0.2745,0.2185,0.345,14),
(2266,'F',0.72,0.575,0.215,2.226,0.8955,0.405,0.62,13),
(2267,'F',0.635,0.51,0.175,1.2125,0.5735,0.261,0.36,14),
(2268,'F',0.61,0.48,0.175,1.0675,0.391,0.216,0.42,15),
(2269,'F',0.545,0.445,0.175,0.8525,0.3465,0.189,0.295,13),
(2270,'M',0.57,0.45,0.16,0.8615,0.3725,0.2175,0.255,12),
(2271,'F',0.6,0.475,0.18,1.162,0.511,0.2675,0.32,18),
(2272,'F',0.52,0.41,0.17,0.8705,0.3735,0.219,0.25,14),
(2273,'M',0.635,0.51,0.21,1.598,0.6535,0.2835,0.58,15),
(2274,'F',0.67,0.52,0.15,1.406,0.519,0.348,0.37,13),
(2275,'M',0.695,0.57,0.2,2.033,0.751,0.4255,0.685,15),
(2276,'M',0.655,0.525,0.185,1.259,0.487,0.2215,0.445,20),
(2277,'F',0.62,0.48,0.23,1.0935,0.403,0.245,0.355,14),
(2278,'F',0.6,0.475,0.18,1.1805,0.4345,0.2475,0.425,19),
(2279,'M',0.51,0.405,0.13,0.7175,0.3725,0.158,0.17,9),
(2280,'M',0.525,0.405,0.135,0.7575,0.3305,0.216,0.195,10),
(2281,'M',0.44,0.375,0.13,0.487,0.226,0.0965,0.155,9),
(2282,'I',0.485,0.415,0.14,0.5705,0.25,0.134,0.185,8),
(2283,'F',0.495,0.385,0.13,0.6905,0.3125,0.179,0.175,10),
(2284,'I',0.435,0.345,0.12,0.4475,0.221,0.112,0.125,7),
(2285,'I',0.405,0.315,0.105,0.347,0.1605,0.0785,0.1,9),
(2286,'I',0.42,0.33,0.1,0.352,0.1635,0.089,0.1,9),
(2287,'F',0.5,0.395,0.15,0.7145,0.3235,0.173,0.195,9),
(2288,'F',0.385,0.305,0.105,0.3315,0.1365,0.0745,0.1,7),
(2289,'I',0.33,0.265,0.09,0.18,0.068,0.036,0.06,6),
(2290,'F',0.58,0.475,0.155,0.974,0.4305,0.23,0.285,10),
(2291,'I',0.325,0.27,0.1,0.185,0.08,0.0435,0.065,6),
(2292,'M',0.475,0.375,0.12,0.563,0.2525,0.1205,0.185,10),
(2293,'F',0.38,0.3,0.09,0.3215,0.1545,0.075,0.095,9),
(2294,'I',0.34,0.26,0.09,0.179,0.076,0.0525,0.055,6),
(2295,'M',0.525,0.425,0.12,0.702,0.3335,0.1465,0.22,12),
(2296,'F',0.52,0.415,0.145,0.8045,0.3325,0.1725,0.285,10),
(2297,'F',0.535,0.45,0.135,0.8075,0.322,0.181,0.25,13),
(2298,'M',0.475,0.36,0.12,0.578,0.2825,0.12,0.17,8),
(2299,'I',0.415,0.325,0.1,0.385,0.167,0.08,0.125,7),
(2300,'I',0.495,0.385,0.125,0.585,0.2755,0.1235,0.165,8),
(2301,'F',0.48,0.405,0.13,0.6375,0.277,0.1445,0.21,10),
(2302,'F',0.52,0.425,0.15,0.813,0.385,0.2015,0.23,10),
(2303,'M',0.46,0.375,0.13,0.5735,0.2505,0.119,0.195,9),
(2304,'F',0.58,0.455,0.12,0.94,0.399,0.257,0.265,11),
(2305,'M',0.59,0.49,0.135,1.008,0.422,0.2245,0.285,11),
(2306,'F',0.55,0.415,0.135,0.775,0.302,0.179,0.26,23),
(2307,'F',0.65,0.5,0.165,1.1445,0.485,0.218,0.365,12),
(2308,'F',0.465,0.375,0.135,0.6,0.2225,0.129,0.23,16),
(2309,'M',0.455,0.355,0.13,0.515,0.2,0.1275,0.175,11),
(2310,'M',0.47,0.375,0.13,0.5795,0.2145,0.164,0.195,13),
(2311,'F',0.435,0.35,0.11,0.384,0.143,0.1005,0.125,13),
(2312,'M',0.35,0.265,0.11,0.2965,0.1365,0.063,0.085,7),
(2313,'I',0.315,0.24,0.07,0.137,0.0545,0.0315,0.04,8),
(2314,'M',0.595,0.47,0.145,0.991,0.4035,0.1505,0.34,16),
(2315,'F',0.58,0.475,0.135,0.925,0.391,0.165,0.275,14),
(2316,'M',0.575,0.435,0.15,0.805,0.293,0.1625,0.27,17),
(2317,'M',0.535,0.435,0.155,0.8915,0.3415,0.177,0.25,13),
(2318,'M',0.515,0.42,0.14,0.769,0.2505,0.154,0.29,13),
(2319,'F',0.505,0.385,0.135,0.6185,0.251,0.1175,0.2,12),
(2320,'F',0.505,0.395,0.145,0.6515,0.2695,0.153,0.205,15),
(2321,'I',0.4,0.31,0.1,0.2875,0.1145,0.0635,0.095,10),
(2322,'M',0.49,0.395,0.135,0.5545,0.213,0.0925,0.215,14),
(2323,'M',0.53,0.435,0.135,0.7365,0.3275,0.1315,0.22,12),
(2324,'I',0.395,0.325,0.105,0.306,0.111,0.0735,0.095,8),
(2325,'F',0.665,0.535,0.19,1.496,0.5775,0.2815,0.475,17),
(2326,'F',0.415,0.305,0.105,0.3605,0.12,0.082,0.1,10),
(2327,'M',0.43,0.345,0.115,0.3045,0.0925,0.055,0.12,11),
(2328,'M',0.475,0.395,0.135,0.592,0.2465,0.1645,0.2,13),
(2329,'F',0.525,0.425,0.145,0.7995,0.3345,0.209,0.24,15),
(2330,'I',0.48,0.39,0.145,0.5825,0.2315,0.121,0.255,15),
(2331,'I',0.42,0.345,0.115,0.3435,0.1515,0.0795,0.115,9),
(2332,'M',0.59,0.46,0.155,0.906,0.327,0.1485,0.335,15),
(2333,'F',0.515,0.42,0.135,0.6295,0.2815,0.127,0.215,9),
(2334,'M',0.695,0.55,0.22,1.5515,0.566,0.3835,0.445,13),
(2335,'F',0.8,0.63,0.195,2.526,0.933,0.59,0.62,23),
(2336,'M',0.61,0.49,0.15,1.103,0.425,0.2025,0.36,23),
(2337,'F',0.565,0.48,0.175,0.957,0.3885,0.215,0.275,18),
(2338,'M',0.56,0.455,0.165,0.86,0.4015,0.1695,0.245,11),
(2339,'M',0.655,0.485,0.195,1.62,0.6275,0.358,0.485,17),
(2340,'M',0.64,0.52,0.2,1.407,0.566,0.304,0.455,17),
(2341,'F',0.59,0.47,0.17,0.9,0.355,0.1905,0.25,11),
(2342,'I',0.31,0.24,0.09,0.1455,0.0605,0.0315,0.045,7),
(2343,'I',0.255,0.185,0.07,0.075,0.028,0.018,0.025,6),
(2344,'I',0.17,0.125,0.055,0.0235,0.009,0.0055,0.008,6),
(2345,'M',0.67,0.55,0.17,1.247,0.472,0.2455,0.4,21),
(2346,'F',0.71,0.565,0.195,1.7265,0.638,0.3365,0.565,17),
(2347,'F',0.56,0.43,0.125,0.8025,0.313,0.1715,0.263,13),
(2348,'M',0.505,0.4,0.13,0.764,0.3035,0.189,0.2175,11),
(2349,'M',0.525,0.43,0.165,0.8645,0.376,0.1945,0.2515,16),
(2350,'F',0.45,0.36,0.105,0.4715,0.2035,0.0935,0.149,9),
(2351,'F',0.515,0.435,0.17,0.631,0.2765,0.111,0.216,12),
(2352,'M',0.59,0.475,0.16,0.9455,0.3815,0.184,0.27,19),
(2353,'M',0.7,0.53,0.19,1.3185,0.548,0.233,0.42,18),
(2354,'F',0.72,0.56,0.175,1.7265,0.637,0.3415,0.525,17),
(2355,'M',0.635,0.495,0.15,1.081,0.4825,0.242,0.31,11),
(2356,'M',0.555,0.44,0.135,0.9025,0.3805,0.2105,0.28,13),
(2357,'M',0.575,0.47,0.15,1.1415,0.4515,0.204,0.4,13),
(2358,'M',0.585,0.455,0.125,1.027,0.391,0.212,0.25,17),
(2359,'F',0.61,0.485,0.21,1.3445,0.535,0.2205,0.515,20),
(2360,'F',0.645,0.525,0.2,1.449,0.601,0.2565,0.505,13),
(2361,'F',0.545,0.44,0.175,0.7745,0.2985,0.1875,0.265,11),
(2362,'M',0.55,0.45,0.155,0.7895,0.343,0.159,0.25,12),
(2363,'F',0.66,0.525,0.205,1.3665,0.5005,0.291,0.41,18),
(2364,'M',0.57,0.475,0.195,1.0295,0.4635,0.1905,0.305,18),
(2365,'F',0.6,0.47,0.2,1.031,0.392,0.2035,0.29,15),
(2366,'F',0.63,0.505,0.165,1.065,0.4595,0.216,0.315,12),
(2367,'M',0.695,0.57,0.23,1.885,0.8665,0.435,0.5,19),
(2368,'M',0.65,0.545,0.16,1.2425,0.487,0.296,0.48,15),
(2369,'F',0.72,0.595,0.225,1.969,0.8045,0.423,0.66,16),
(2370,'I',0.56,0.44,0.17,0.9445,0.3545,0.2175,0.3,12),
(2371,'I',0.42,0.325,0.115,0.354,0.1625,0.064,0.105,8),
(2372,'M',0.18,0.125,0.05,0.023,0.0085,0.0055,0.01,3),
(2373,'F',0.405,0.325,0.11,0.3575,0.145,0.0725,0.11,12),
(2374,'F',0.5,0.405,0.15,0.5965,0.253,0.126,0.185,12),
(2375,'I',0.435,0.335,0.11,0.383,0.1555,0.0675,0.135,12),
(2376,'M',0.34,0.275,0.09,0.2065,0.0725,0.043,0.07,10),
(2377,'F',0.43,0.34,0.11,0.382,0.154,0.0955,0.109,8),
(2378,'I',0.535,0.41,0.155,0.6315,0.2745,0.1415,0.1815,12),
(2379,'I',0.415,0.325,0.115,0.3285,0.1405,0.051,0.106,12),
(2380,'F',0.36,0.265,0.09,0.2165,0.096,0.037,0.0735,10),
(2381,'M',0.175,0.135,0.04,0.0305,0.011,0.0075,0.01,5),
(2382,'M',0.155,0.115,0.025,0.024,0.009,0.005,0.0075,5),
(2383,'I',0.525,0.43,0.15,0.7365,0.3225,0.161,0.215,11),
(2384,'F',0.525,0.39,0.135,0.6005,0.2265,0.131,0.21,16),
(2385,'F',0.44,0.345,0.105,0.4285,0.165,0.083,0.132,11),
(2386,'F',0.45,0.345,0.115,0.496,0.1905,0.117,0.14,12),
(2387,'F',0.485,0.365,0.14,0.6195,0.2595,0.1445,0.177,14),
(2388,'I',0.47,0.35,0.135,0.567,0.2315,0.1465,0.1525,11),
(2389,'I',0.515,0.375,0.14,0.6505,0.2495,0.141,0.2215,10),
(2390,'M',0.42,0.34,0.125,0.4495,0.165,0.1125,0.144,11),
(2391,'F',0.455,0.35,0.125,0.4485,0.1585,0.102,0.1335,16),
(2392,'M',0.37,0.29,0.09,0.241,0.11,0.045,0.069,10),
(2393,'M',0.33,0.25,0.09,0.197,0.085,0.041,0.0605,10),
(2394,'I',0.3,0.22,0.09,0.1425,0.057,0.0335,0.043,7),
(2395,'I',0.625,0.46,0.16,1.2395,0.55,0.273,0.38,14),
(2396,'I',0.61,0.475,0.17,1.0385,0.4435,0.241,0.32,14),
(2397,'I',0.625,0.465,0.155,0.972,0.404,0.1845,0.35,14),
(2398,'I',0.635,0.505,0.19,1.3315,0.5805,0.252,0.435,17),
(2399,'I',0.5,0.385,0.155,0.762,0.3795,0.161,0.19,14),
(2400,'F',0.53,0.43,0.17,0.775,0.35,0.152,0.235,17),
(2401,'I',0.445,0.33,0.1,0.437,0.163,0.0755,0.17,13),
(2402,'F',0.585,0.415,0.155,0.6985,0.3,0.146,0.195,12),
(2403,'I',0.44,0.355,0.165,0.435,0.159,0.105,0.14,16),
(2404,'M',0.29,0.225,0.08,0.1295,0.0535,0.026,0.045,10),
(2405,'I',0.555,0.455,0.17,0.8435,0.309,0.1905,0.3,15),
(2406,'I',0.655,0.515,0.145,1.25,0.5265,0.283,0.315,15),
(2407,'F',0.58,0.46,0.185,1.017,0.3515,0.2,0.32,10),
(2408,'I',0.625,0.43,0.175,1.411,0.572,0.297,0.395,12),
(2409,'I',0.62,0.485,0.17,1.208,0.4805,0.3045,0.33,15),
(2410,'F',0.64,0.5,0.15,1.0705,0.371,0.2705,0.36,8),
(2411,'F',0.505,0.375,0.115,0.5895,0.2635,0.12,0.167,10),
(2412,'I',0.5,0.395,0.12,0.537,0.2165,0.1085,0.1785,9),
(2413,'M',0.31,0.245,0.095,0.15,0.0525,0.034,0.048,7),
(2414,'F',0.505,0.38,0.145,0.651,0.2935,0.19,0.17,12),
(2415,'I',0.42,0.305,0.11,0.28,0.094,0.0785,0.0955,9),
(2416,'M',0.4,0.315,0.105,0.287,0.1135,0.037,0.113,10),
(2417,'M',0.425,0.315,0.125,0.3525,0.1135,0.0565,0.13,18),
(2418,'M',0.31,0.235,0.06,0.12,0.0415,0.033,0.04,11),
(2419,'F',0.465,0.35,0.13,0.494,0.1945,0.103,0.155,18),
(2420,'F',0.465,0.36,0.12,0.4765,0.192,0.1125,0.16,10),
(2421,'M',0.35,0.255,0.085,0.2145,0.1,0.0465,0.06,13),
(2422,'I',0.52,0.415,0.16,0.595,0.2105,0.142,0.26,15),
(2423,'F',0.475,0.365,0.13,0.4805,0.1905,0.114,0.1475,12),
(2424,'F',0.41,0.315,0.11,0.321,0.1255,0.0655,0.095,10),
(2425,'M',0.26,0.2,0.065,0.096,0.044,0.027,0.03,6),
(2426,'I',0.575,0.45,0.17,0.9315,0.358,0.2145,0.26,13),
(2427,'I',0.565,0.435,0.155,0.782,0.2715,0.168,0.285,14),
(2428,'M',0.26,0.19,0.075,0.0945,0.0445,0.02,0.03,6),
(2429,'F',0.53,0.385,0.125,0.6695,0.289,0.151,0.18,10),
(2430,'M',0.34,0.255,0.095,0.213,0.081,0.034,0.07,9),
(2431,'I',0.52,0.38,0.14,0.525,0.1775,0.115,0.185,11),
(2432,'F',0.635,0.5,0.18,1.312,0.529,0.2485,0.485,18),
(2433,'F',0.61,0.485,0.165,1.087,0.4255,0.232,0.38,11),
(2434,'F',0.66,0.515,0.18,1.523,0.54,0.3365,0.555,16),
(2435,'I',0.635,0.5,0.18,1.319,0.5485,0.292,0.49,16),
(2436,'F',0.465,0.38,0.135,0.579,0.208,0.1095,0.22,14),
(2437,'M',0.515,0.4,0.16,0.8175,0.2515,0.156,0.3,23),
(2438,'I',0.335,0.24,0.095,0.17,0.062,0.039,0.055,9),
(2439,'F',0.515,0.4,0.17,0.796,0.258,0.1755,0.28,16),
(2440,'F',0.345,0.255,0.1,0.197,0.071,0.051,0.06,9),
(2441,'M',0.465,0.355,0.125,0.5255,0.2025,0.135,0.145,13),
(2442,'M',0.54,0.415,0.17,0.879,0.339,0.208,0.255,10),
(2443,'M',0.475,0.355,0.125,0.4625,0.186,0.107,0.145,9),
(2444,'F',0.445,0.335,0.14,0.4565,0.1785,0.114,0.14,11),
(2445,'M',0.5,0.355,0.14,0.528,0.2125,0.149,0.14,9),
(2446,'M',0.5,0.38,0.135,0.5835,0.2295,0.1265,0.18,12),
(2447,'F',0.55,0.435,0.17,0.884,0.2875,0.1645,0.28,14),
(2448,'I',0.275,0.205,0.08,0.096,0.036,0.0185,0.03,6),
(2449,'F',0.35,0.265,0.09,0.1855,0.0745,0.0415,0.06,7),
(2450,'F',0.37,0.285,0.105,0.27,0.1125,0.0585,0.0835,9),
(2451,'F',0.42,0.33,0.125,0.463,0.186,0.11,0.145,10),
(2452,'M',0.35,0.26,0.09,0.198,0.0725,0.056,0.06,10),
(2453,'M',0.395,0.305,0.105,0.282,0.0975,0.065,0.096,9),
(2454,'I',0.325,0.2,0.08,0.0995,0.0395,0.0225,0.032,8),
(2455,'I',0.275,0.2,0.065,0.092,0.0385,0.0235,0.027,5),
(2456,'I',0.235,0.17,0.065,0.0625,0.023,0.014,0.022,6),
(2457,'I',0.25,0.18,0.06,0.073,0.028,0.017,0.0225,5),
(2458,'I',0.25,0.185,0.065,0.071,0.027,0.0185,0.0225,5),
(2459,'I',0.2,0.145,0.05,0.036,0.0125,0.008,0.011,4),
(2460,'F',0.585,0.47,0.17,1.099,0.3975,0.2325,0.358,20),
(2461,'M',0.445,0.35,0.14,0.5905,0.2025,0.158,0.19,14),
(2462,'F',0.5,0.385,0.13,0.768,0.2625,0.095,0.27,13),
(2463,'M',0.44,0.325,0.08,0.413,0.144,0.1015,0.13,8),
(2464,'M',0.515,0.405,0.14,0.8505,0.312,0.146,0.315,17),
(2465,'F',0.52,0.405,0.14,0.6915,0.276,0.137,0.215,11),
(2466,'M',0.5,0.39,0.13,0.709,0.275,0.168,0.18,11),
(2467,'M',0.425,0.325,0.12,0.3755,0.142,0.1065,0.105,9),
(2468,'M',0.51,0.415,0.14,0.8185,0.3025,0.2155,0.235,16),
(2469,'F',0.37,0.275,0.08,0.227,0.093,0.0625,0.07,8),
(2470,'M',0.54,0.415,0.13,0.8245,0.272,0.226,0.24,13),
(2471,'M',0.615,0.475,0.17,1.1825,0.474,0.2895,0.24,11),
(2472,'M',0.565,0.44,0.175,1.122,0.393,0.2,0.375,20),
(2473,'M',0.645,0.515,0.175,1.6115,0.6745,0.384,0.385,14),
(2474,'F',0.615,0.47,0.175,1.2985,0.5135,0.343,0.32,14),
(2475,'M',0.605,0.49,0.145,1.3,0.517,0.3285,0.31,14),
(2476,'F',0.59,0.455,0.165,1.161,0.38,0.2455,0.28,12),
(2477,'M',0.645,0.485,0.155,1.489,0.5915,0.312,0.38,18),
(2478,'M',0.57,0.42,0.155,1.008,0.377,0.193,0.34,13),
(2479,'F',0.47,0.355,0.18,0.441,0.1525,0.1165,0.135,8),
(2480,'F',0.5,0.44,0.155,0.742,0.2025,0.2005,0.2115,14),
(2481,'F',0.52,0.425,0.145,0.7,0.207,0.1905,0.24,13),
(2482,'M',0.39,0.285,0.095,0.271,0.11,0.06,0.08,8),
(2483,'M',0.52,0.4,0.165,0.8565,0.2745,0.201,0.21,12),
(2484,'F',0.54,0.415,0.175,0.8975,0.275,0.241,0.275,14),
(2485,'M',0.46,0.36,0.135,0.6105,0.1955,0.107,0.235,14),
(2486,'I',0.355,0.26,0.09,0.1925,0.077,0.038,0.065,8),
(2487,'F',0.49,0.4,0.145,0.6635,0.21,0.1295,0.2515,13),
(2488,'F',0.63,0.51,0.185,1.235,0.5115,0.349,0.3065,11),
(2489,'M',0.5,0.385,0.145,0.7615,0.246,0.195,0.204,14),
(2490,'M',0.49,0.39,0.135,0.592,0.242,0.096,0.1835,15),
(2491,'M',0.44,0.325,0.115,0.39,0.163,0.087,0.113,7),
(2492,'F',0.515,0.395,0.165,0.7565,0.1905,0.17,0.3205,10),
(2493,'F',0.475,0.38,0.145,0.57,0.167,0.118,0.187,11),
(2494,'I',0.42,0.31,0.1,0.2865,0.115,0.0735,0.085,8),
(2495,'M',0.4,0.305,0.13,0.2935,0.096,0.0675,0.105,9),
(2496,'M',0.45,0.36,0.16,0.567,0.174,0.1245,0.225,12),
(2497,'F',0.52,0.4,0.13,0.6245,0.215,0.2065,0.17,15),
(2498,'M',0.505,0.4,0.155,0.8415,0.2715,0.1775,0.285,12),
(2499,'M',0.495,0.4,0.14,0.7775,0.2015,0.18,0.25,15),
(2500,'M',0.54,0.41,0.145,0.989,0.2815,0.213,0.355,19),
(2501,'F',0.48,0.39,0.125,0.6905,0.219,0.155,0.2,12),
(2502,'F',0.33,0.26,0.08,0.2,0.0625,0.05,0.07,9),
(2503,'I',0.285,0.21,0.07,0.109,0.044,0.0265,0.033,5),
(2504,'I',0.3,0.23,0.075,0.127,0.052,0.03,0.0345,6),
(2505,'I',0.31,0.24,0.105,0.2885,0.118,0.065,0.083,6),
(2506,'I',0.34,0.255,0.075,0.18,0.0745,0.04,0.0525,6),
(2507,'I',0.375,0.3,0.075,0.144,0.059,0.03,0.044,7),
(2508,'I',0.415,0.325,0.1,0.4665,0.2285,0.1065,0.114,7),
(2509,'I',0.415,0.315,0.105,0.33,0.1405,0.0705,0.095,6),
(2510,'I',0.415,0.315,0.09,0.3625,0.175,0.0835,0.093,6),
(2511,'I',0.42,0.32,0.1,0.34,0.1745,0.05,0.0945,8),
(2512,'I',0.425,0.31,0.105,0.365,0.159,0.0825,0.105,6),
(2513,'M',0.465,0.375,0.11,0.5,0.21,0.113,0.1505,8),
(2514,'F',0.465,0.35,0.135,0.6265,0.259,0.1445,0.175,8),
(2515,'I',0.47,0.37,0.11,0.5555,0.25,0.115,0.163,8),
(2516,'F',0.47,0.375,0.12,0.6015,0.2765,0.1455,0.135,8),
(2517,'I',0.475,0.365,0.12,0.53,0.2505,0.0975,0.1625,10),
(2518,'M',0.48,0.37,0.135,0.6315,0.3445,0.1015,0.161,7),
(2519,'M',0.5,0.4,0.13,0.7715,0.37,0.16,0.211,8),
(2520,'I',0.505,0.39,0.185,0.6125,0.267,0.142,0.172,7),
(2521,'M',0.525,0.425,0.19,0.872,0.4625,0.1725,0.199,9),
(2522,'M',0.54,0.42,0.12,0.8115,0.392,0.1455,0.2235,9),
(2523,'M',0.545,0.45,0.15,0.8795,0.387,0.15,0.2625,11),
(2524,'F',0.565,0.44,0.15,0.983,0.4475,0.2355,0.2485,9),
(2525,'M',0.58,0.46,0.18,1.145,0.48,0.277,0.325,11),
(2526,'M',0.59,0.455,0.16,1.09,0.5,0.2215,0.292,9),
(2527,'M',0.59,0.48,0.16,1.262,0.5685,0.2725,0.335,9),
(2528,'M',0.595,0.49,0.185,1.185,0.482,0.2015,0.361,10),
(2529,'F',0.6,0.475,0.135,1.4405,0.5885,0.191,0.3175,9),
(2530,'F',0.6,0.5,0.155,1.332,0.6235,0.2835,0.35,8),
(2531,'F',0.6,0.485,0.165,1.1405,0.587,0.2175,0.288,9),
(2532,'M',0.605,0.475,0.175,1.201,0.5395,0.275,0.309,10),
(2533,'F',0.625,0.49,0.155,1.33,0.6675,0.259,0.33,10),
(2534,'M',0.63,0.5,0.185,1.362,0.5785,0.3125,0.384,10),
(2535,'M',0.64,0.585,0.195,1.647,0.7225,0.331,0.471,12),
(2536,'F',0.64,0.5,0.18,1.4995,0.593,0.314,0.431,11),
(2537,'F',0.655,0.545,0.165,1.6225,0.6555,0.299,0.513,12),
(2538,'I',0.66,0.525,0.215,1.786,0.6725,0.3615,0.4065,11),
(2539,'M',0.66,0.535,0.2,1.791,0.733,0.318,0.54,15),
(2540,'F',0.675,0.555,0.205,1.925,0.713,0.358,0.4535,13),
(2541,'F',0.675,0.55,0.175,1.689,0.694,0.371,0.474,13),
(2542,'F',0.69,0.55,0.18,1.659,0.8715,0.2655,0.4395,9),
(2543,'F',0.695,0.53,0.2,2.0475,0.75,0.4195,0.6095,14),
(2544,'F',0.7,0.525,0.19,1.6015,0.707,0.365,0.43,10),
(2545,'F',0.73,0.57,0.165,2.0165,1.0685,0.418,0.435,10),
(2546,'I',0.205,0.15,0.065,0.04,0.02,0.011,0.013,4),
(2547,'I',0.225,0.17,0.07,0.0565,0.024,0.013,0.016,4),
(2548,'I',0.23,0.18,0.05,0.064,0.0215,0.0135,0.02,5),
(2549,'I',0.275,0.195,0.07,0.0875,0.0345,0.022,0.0255,4),
(2550,'I',0.28,0.21,0.055,0.106,0.0415,0.0265,0.031,5),
(2551,'I',0.28,0.22,0.08,0.1315,0.066,0.024,0.03,5),
(2552,'I',0.295,0.22,0.07,0.126,0.0515,0.0275,0.035,6),
(2553,'I',0.31,0.225,0.075,0.155,0.065,0.037,0.0365,6),
(2554,'I',0.315,0.235,0.07,0.149,0.058,0.0325,0.047,7),
(2555,'I',0.34,0.265,0.07,0.185,0.0625,0.0395,0.07,7),
(2556,'I',0.37,0.29,0.08,0.2545,0.108,0.0565,0.07,6),
(2557,'I',0.38,0.285,0.085,0.237,0.115,0.0405,0.07,6),
(2558,'I',0.39,0.295,0.1,0.279,0.1155,0.059,0.08,7),
(2559,'I',0.405,0.31,0.065,0.3205,0.1575,0.066,0.088,6),
(2560,'I',0.415,0.325,0.1,0.3335,0.1445,0.0715,0.095,7),
(2561,'I',0.44,0.335,0.11,0.3885,0.175,0.0835,0.111,7),
(2562,'I',0.44,0.345,0.115,0.545,0.269,0.111,0.1305,6),
(2563,'I',0.44,0.325,0.1,0.4165,0.185,0.0865,0.11,6),
(2564,'I',0.44,0.355,0.12,0.495,0.231,0.11,0.125,7),
(2565,'I',0.45,0.35,0.125,0.4775,0.2235,0.089,0.118,6),
(2566,'I',0.45,0.35,0.12,0.468,0.2005,0.1065,0.1325,8),
(2567,'F',0.455,0.35,0.12,0.4555,0.1945,0.1045,0.1375,7),
(2568,'F',0.46,0.35,0.115,0.46,0.2025,0.1115,0.1165,6),
(2569,'I',0.46,0.345,0.12,0.4155,0.198,0.0885,0.107,7),
(2570,'I',0.46,0.345,0.115,0.4215,0.1895,0.102,0.111,6),
(2571,'I',0.465,0.355,0.11,0.474,0.23,0.1005,0.12,7),
(2572,'M',0.465,0.34,0.105,0.486,0.231,0.1035,0.1225,9),
(2573,'I',0.475,0.385,0.11,0.5735,0.311,0.1025,0.136,7),
(2574,'I',0.475,0.355,0.105,0.468,0.201,0.1115,0.12,8),
(2575,'M',0.48,0.37,0.1,0.5135,0.243,0.1015,0.135,8),
(2576,'M',0.5,0.375,0.145,0.6215,0.274,0.166,0.1485,7),
(2577,'I',0.5,0.38,0.11,0.494,0.218,0.09,0.1325,7),
(2578,'I',0.505,0.385,0.12,0.6005,0.239,0.142,0.185,7),
(2579,'M',0.515,0.395,0.12,0.646,0.285,0.1365,0.172,9),
(2580,'M',0.525,0.415,0.135,0.7945,0.394,0.189,0.202,7),
(2581,'M',0.525,0.425,0.125,0.812,0.4035,0.1705,0.195,8),
(2582,'F',0.53,0.42,0.17,0.828,0.41,0.208,0.1505,6),
(2583,'M',0.53,0.41,0.14,0.681,0.3095,0.1415,0.1835,6),
(2584,'F',0.53,0.405,0.15,0.889,0.4055,0.2275,0.215,8),
(2585,'M',0.54,0.435,0.14,0.7345,0.33,0.1595,0.213,9),
(2586,'F',0.55,0.425,0.125,0.964,0.5475,0.159,0.215,8),
(2587,'F',0.555,0.425,0.14,0.963,0.44,0.224,0.24,7),
(2588,'F',0.57,0.445,0.15,0.995,0.504,0.185,0.2505,9),
(2589,'F',0.57,0.435,0.14,0.8585,0.3905,0.196,0.2295,8),
(2590,'M',0.575,0.45,0.155,0.948,0.429,0.206,0.259,7),
(2591,'F',0.58,0.445,0.145,0.888,0.41,0.1815,0.2425,8),
(2592,'F',0.585,0.45,0.16,0.9045,0.405,0.2215,0.2335,8),
(2593,'M',0.59,0.465,0.14,1.046,0.4695,0.263,0.263,7),
(2594,'F',0.595,0.47,0.155,1.1775,0.542,0.269,0.31,9),
(2595,'F',0.595,0.465,0.15,1.0765,0.491,0.22,0.287,9),
(2596,'F',0.595,0.465,0.15,1.0255,0.412,0.2745,0.289,11),
(2597,'F',0.6,0.46,0.145,0.9325,0.3985,0.2245,0.248,8),
(2598,'F',0.6,0.46,0.15,1.235,0.6025,0.274,0.29,8),
(2599,'M',0.6,0.46,0.15,1.247,0.5335,0.2735,0.29,9),
(2600,'M',0.61,0.48,0.15,1.1495,0.564,0.274,0.264,8),
(2601,'F',0.615,0.485,0.16,1.1575,0.5005,0.2495,0.315,10),
(2602,'F',0.615,0.5,0.165,1.327,0.6,0.3015,0.355,10),
(2603,'M',0.615,0.47,0.155,1.2,0.5085,0.32,0.292,8),
(2604,'F',0.62,0.51,0.175,1.2705,0.5415,0.323,0.3225,9),
(2605,'F',0.62,0.485,0.175,1.2155,0.545,0.253,0.345,10),
(2606,'F',0.62,0.475,0.16,1.3245,0.6865,0.233,0.3275,9),
(2607,'M',0.625,0.48,0.17,1.3555,0.671,0.268,0.3385,10),
(2608,'F',0.625,0.49,0.165,1.127,0.477,0.2365,0.3185,9),
(2609,'F',0.625,0.49,0.175,1.1075,0.4485,0.2165,0.3595,8),
(2610,'F',0.63,0.495,0.2,1.4255,0.659,0.336,0.38,11),
(2611,'F',0.63,0.495,0.145,1.147,0.5455,0.266,0.2885,9),
(2612,'M',0.63,0.48,0.165,1.286,0.604,0.271,0.35,8),
(2613,'F',0.635,0.495,0.18,1.596,0.617,0.317,0.37,11),
(2614,'F',0.635,0.495,0.195,1.297,0.556,0.2985,0.37,11),
(2615,'M',0.645,0.49,0.16,1.251,0.5355,0.3345,0.3165,9),
(2616,'M',0.645,0.5,0.175,1.5105,0.6735,0.3755,0.3775,12),
(2617,'F',0.65,0.5,0.185,1.4415,0.741,0.2955,0.341,9),
(2618,'M',0.67,0.52,0.19,1.6385,0.8115,0.369,0.391,9),
(2619,'F',0.69,0.545,0.205,1.933,0.7855,0.429,0.498,13),
(2620,'M',0.69,0.54,0.185,1.71,0.7725,0.3855,0.4325,8),
(2621,'F',0.695,0.55,0.155,1.8495,0.767,0.442,0.4175,10),
(2622,'M',0.695,0.525,0.175,1.742,0.696,0.389,0.505,12),
(2623,'F',0.7,0.575,0.205,1.7975,0.7295,0.3935,0.5165,13),
(2624,'F',0.705,0.56,0.205,2.381,0.9915,0.5005,0.624,10),
(2625,'M',0.765,0.585,0.18,2.398,1.128,0.512,0.5335,12),
(2626,'M',0.77,0.6,0.215,2.1945,1.0515,0.482,0.584,10),
(2627,'I',0.22,0.16,0.05,0.049,0.0215,0.01,0.015,4),
(2628,'I',0.275,0.205,0.07,0.1055,0.495,0.019,0.0315,5),
(2629,'I',0.29,0.21,0.06,0.1045,0.0415,0.022,0.035,5),
(2630,'I',0.33,0.24,0.075,0.163,0.0745,0.033,0.048,6),
(2631,'I',0.355,0.285,0.095,0.2275,0.0955,0.0475,0.0715,6),
(2632,'I',0.375,0.29,0.1,0.219,0.0925,0.038,0.075,6),
(2633,'I',0.415,0.315,0.1,0.3645,0.1765,0.0795,0.095,8),
(2634,'I',0.425,0.33,0.115,0.3265,0.1315,0.077,0.103,6),
(2635,'I',0.425,0.34,0.1,0.3515,0.1625,0.082,0.094,7),
(2636,'I',0.43,0.32,0.1,0.3465,0.1635,0.08,0.09,7),
(2637,'I',0.44,0.34,0.1,0.407,0.209,0.0735,0.103,7),
(2638,'I',0.44,0.335,0.115,0.4215,0.173,0.0765,0.113,7),
(2639,'I',0.46,0.345,0.11,0.3755,0.1525,0.058,0.125,7),
(2640,'I',0.46,0.37,0.12,0.5335,0.2645,0.108,0.1345,6),
(2641,'I',0.465,0.355,0.105,0.442,0.2085,0.0975,0.1185,7),
(2642,'I',0.475,0.365,0.1,0.1315,0.2025,0.0875,0.123,7),
(2643,'I',0.475,0.375,0.115,0.5205,0.233,0.119,0.1455,7),
(2644,'I',0.485,0.375,0.13,0.5535,0.266,0.112,0.157,8),
(2645,'I',0.49,0.375,0.125,0.5445,0.279,0.115,0.13,8),
(2646,'M',0.49,0.38,0.11,0.554,0.2935,0.1005,0.15,8),
(2647,'I',0.495,0.38,0.12,0.512,0.233,0.1205,0.136,7),
(2648,'I',0.5,0.39,0.125,0.583,0.294,0.132,0.1605,8),
(2649,'M',0.5,0.38,0.12,0.5765,0.273,0.135,0.145,9),
(2650,'M',0.505,0.4,0.135,0.723,0.377,0.149,0.178,7),
(2651,'I',0.51,0.395,0.155,0.5395,0.2465,0.1085,0.167,8),
(2652,'I',0.51,0.385,0.15,0.625,0.3095,0.119,0.1725,8),
(2653,'I',0.515,0.4,0.125,0.5925,0.265,0.1175,0.168,9),
(2654,'I',0.52,0.395,0.135,0.633,0.2985,0.1295,0.175,9),
(2655,'F',0.545,0.43,0.14,0.832,0.4355,0.17,0.201,9),
(2656,'M',0.545,0.42,0.145,0.778,0.3745,0.1545,0.205,7),
(2657,'M',0.545,0.42,0.12,0.7865,0.403,0.185,0.17,7),
(2658,'F',0.545,0.4,0.14,0.778,0.368,0.215,0.18,9),
(2659,'I',0.55,0.42,0.13,0.636,0.294,0.144,0.1755,8),
(2660,'F',0.55,0.44,0.135,0.8435,0.434,0.1995,0.185,8),
(2661,'I',0.555,0.425,0.13,0.648,0.2835,0.133,0.2105,8),
(2662,'M',0.565,0.43,0.13,0.784,0.3495,0.1885,0.213,9),
(2663,'F',0.57,0.45,0.18,0.908,0.4015,0.217,0.255,9),
(2664,'M',0.57,0.45,0.135,1.02,0.546,0.204,0.25,9),
(2665,'F',0.57,0.43,0.16,0.811,0.3875,0.159,0.2285,9),
(2666,'F',0.575,0.48,0.15,0.897,0.4235,0.1905,0.248,8),
(2667,'M',0.58,0.455,0.13,0.852,0.41,0.1725,0.225,8),
(2668,'F',0.585,0.45,0.15,0.938,0.467,0.203,0.225,7),
(2669,'F',0.585,0.435,0.14,0.6955,0.3085,0.129,0.2245,8),
(2670,'M',0.59,0.47,0.15,0.861,0.413,0.164,0.249,8),
(2671,'M',0.59,0.46,0.14,1.004,0.496,0.2165,0.26,9),
(2672,'F',0.59,0.46,0.16,1.0115,0.445,0.2615,0.2565,8),
(2673,'F',0.595,0.465,0.15,1.1005,0.5415,0.166,0.265,8),
(2674,'M',0.595,0.47,0.165,1.108,0.4915,0.2325,0.3345,9),
(2675,'M',0.595,0.46,0.14,0.852,0.4215,0.2255,0.227,9),
(2676,'M',0.6,0.49,0.21,1.9875,1.005,0.419,0.491,10),
(2677,'F',0.605,0.48,0.15,1.079,0.4505,0.2835,0.293,10),
(2678,'F',0.615,0.475,0.17,1.055,0.543,0.246,0.2345,9),
(2679,'M',0.615,0.45,0.15,1.198,0.707,0.2095,0.2505,7),
(2680,'F',0.615,0.47,0.155,1.084,0.5885,0.209,0.246,9),
(2681,'M',0.615,0.475,0.175,1.103,0.4635,0.3095,0.2725,10),
(2682,'M',0.62,0.49,0.155,1.1,0.505,0.2475,0.31,9),
(2683,'M',0.62,0.48,0.15,1.1015,0.4965,0.243,0.305,10),
(2684,'M',0.625,0.495,0.185,1.3835,0.7105,0.3005,0.345,11),
(2685,'F',0.625,0.49,0.155,1.115,0.484,0.277,0.3095,9),
(2686,'M',0.625,0.48,0.145,1.085,0.4645,0.2445,0.327,10),
(2687,'M',0.63,0.505,0.15,1.3165,0.6325,0.2465,0.37,11),
(2688,'M',0.63,0.51,0.175,1.3415,0.6575,0.262,0.375,10),
(2689,'M',0.63,0.465,0.15,1.027,0.537,0.188,0.176,8),
(2690,'M',0.645,0.515,0.16,1.1845,0.506,0.311,0.335,9),
(2691,'M',0.645,0.48,0.15,1.192,0.6055,0.2595,0.285,9),
(2692,'F',0.645,0.52,0.18,1.285,0.5775,0.352,0.317,9),
(2693,'M',0.65,0.515,0.125,1.1805,0.5235,0.283,0.3275,9),
(2694,'M',0.65,0.52,0.175,1.2655,0.615,0.2775,0.336,9),
(2695,'F',0.65,0.535,0.175,1.2895,0.6095,0.2765,0.344,10),
(2696,'M',0.65,0.51,0.155,1.407,0.7215,0.298,0.335,9),
(2697,'F',0.65,0.49,0.155,1.122,0.545,0.228,0.3055,9),
(2698,'M',0.66,0.515,0.165,1.4465,0.694,0.298,0.3755,10),
(2699,'F',0.665,0.505,0.165,1.349,0.5985,0.3175,0.36,9),
(2700,'M',0.67,0.5,0.2,1.269,0.576,0.2985,0.351,11),
(2701,'M',0.67,0.51,0.18,1.68,0.926,0.2975,0.3935,13),
(2702,'F',0.675,0.55,0.19,1.551,0.7105,0.3685,0.412,13),
(2703,'M',0.68,0.52,0.165,1.4775,0.724,0.279,0.406,11),
(2704,'M',0.68,0.53,0.18,1.529,0.7635,0.3115,0.4025,11),
(2705,'M',0.7,0.525,0.175,1.7585,0.8745,0.3615,0.47,10),
(2706,'M',0.7,0.55,0.2,1.523,0.693,0.306,0.4405,13),
(2707,'F',0.725,0.53,0.19,1.7315,0.83,0.398,0.405,11),
(2708,'M',0.725,0.55,0.2,1.51,0.8735,0.4265,0.5085,9),
(2709,'M',0.735,0.57,0.175,1.88,0.9095,0.387,0.488,11),
(2710,'F',0.74,0.575,0.22,2.012,0.8915,0.5265,0.471,12),
(2711,'M',0.75,0.555,0.215,2.201,1.0615,0.5235,0.5285,11),
(2712,'I',0.19,0.14,0.03,0.0315,0.0125,0.005,0.0105,3),
(2713,'I',0.21,0.15,0.045,0.04,0.0135,0.008,0.0105,4),
(2714,'I',0.25,0.175,0.06,0.0635,0.0275,0.008,0.02,4),
(2715,'I',0.29,0.215,0.065,0.0985,0.0425,0.021,0.031,5),
(2716,'I',0.335,0.25,0.08,0.167,0.0675,0.0325,0.0575,6),
(2717,'I',0.34,0.245,0.085,0.2015,0.1005,0.038,0.053,6),
(2718,'I',0.345,0.255,0.095,0.183,0.075,0.0385,0.06,6),
(2719,'I',0.355,0.255,0.08,0.187,0.078,0.0505,0.058,7),
(2720,'I',0.36,0.26,0.08,0.1795,0.074,0.0315,0.06,5),
(2721,'I',0.37,0.275,0.09,0.2065,0.096,0.0395,0.058,7),
(2722,'I',0.375,0.29,0.14,0.3,0.14,0.0625,0.0825,8),
(2723,'I',0.375,0.275,0.095,0.2295,0.095,0.0545,0.066,7),
(2724,'I',0.385,0.3,0.125,0.343,0.1705,0.0735,0.081,7),
(2725,'I',0.385,0.285,0.085,0.244,0.1215,0.0445,0.068,8),
(2726,'I',0.395,0.32,0.1,0.3075,0.149,0.0535,0.09,8),
(2727,'I',0.4,0.305,0.1,0.3415,0.176,0.0625,0.0865,7),
(2728,'I',0.405,0.305,0.1,0.271,0.0965,0.061,0.091,7),
(2729,'I',0.405,0.31,0.11,0.91,0.416,0.2075,0.0995,8),
(2730,'I',0.405,0.305,0.1,0.268,0.1145,0.053,0.085,7),
(2731,'I',0.405,0.3,0.09,0.2885,0.138,0.0635,0.0765,6),
(2732,'I',0.41,0.315,0.1,0.3,0.124,0.0575,0.1,8),
(2733,'I',0.41,0.325,0.11,0.326,0.1325,0.075,0.101,8),
(2734,'I',0.415,0.335,0.1,0.358,0.169,0.067,0.105,7),
(2735,'I',0.42,0.325,0.115,0.314,0.1295,0.0635,0.1,8),
(2736,'I',0.42,0.315,0.11,0.4025,0.1855,0.083,0.1015,8),
(2737,'I',0.43,0.34,0.11,0.3645,0.159,0.0855,0.105,7),
(2738,'I',0.445,0.36,0.11,0.4235,0.182,0.0765,0.14,9),
(2739,'M',0.45,0.325,0.115,0.4305,0.2235,0.0785,0.1155,8),
(2740,'I',0.45,0.335,0.095,0.3505,0.1615,0.0625,0.1185,7),
(2741,'I',0.455,0.34,0.115,0.486,0.261,0.0655,0.1315,8),
(2742,'I',0.46,0.35,0.1,0.471,0.252,0.077,0.123,8),
(2743,'I',0.46,0.345,0.105,0.415,0.187,0.087,0.11,8),
(2744,'I',0.475,0.355,0.115,0.5195,0.279,0.088,0.1325,7),
(2745,'M',0.48,0.375,0.12,0.5895,0.2535,0.128,0.172,11),
(2746,'I',0.485,0.38,0.125,0.5215,0.2215,0.118,0.16,8),
(2747,'I',0.485,0.365,0.14,0.4475,0.1895,0.0925,0.2305,8),
(2748,'I',0.49,0.365,0.125,0.5585,0.252,0.126,0.1615,10),
(2749,'I',0.505,0.385,0.125,0.596,0.245,0.097,0.21,9),
(2750,'I',0.505,0.38,0.135,0.5385,0.2645,0.095,0.165,9),
(2751,'I',0.51,0.385,0.145,0.7665,0.3985,0.14,0.1805,8),
(2752,'F',0.515,0.395,0.135,0.516,0.2015,0.132,0.162,9),
(2753,'M',0.515,0.41,0.14,0.7355,0.3065,0.137,0.2,7),
(2754,'I',0.515,0.39,0.11,0.531,0.2415,0.098,0.1615,8),
(2755,'I',0.525,0.385,0.13,0.607,0.2355,0.125,0.195,8),
(2756,'F',0.525,0.415,0.15,0.7055,0.329,0.147,0.199,10),
(2757,'I',0.525,0.4,0.13,0.6445,0.345,0.1285,0.2,8),
(2758,'I',0.525,0.375,0.12,0.6315,0.3045,0.114,0.19,9),
(2759,'M',0.535,0.43,0.155,0.7845,0.3285,0.169,0.245,10),
(2760,'F',0.545,0.44,0.15,0.9475,0.366,0.239,0.275,8),
(2761,'I',0.55,0.43,0.145,0.712,0.3025,0.152,0.225,10),
(2762,'I',0.55,0.425,0.145,0.89,0.4325,0.171,0.236,10),
(2763,'I',0.55,0.42,0.155,0.912,0.495,0.1805,0.205,9),
(2764,'I',0.55,0.425,0.135,0.656,0.257,0.17,0.203,10),
(2765,'I',0.55,0.465,0.15,0.936,0.481,0.174,0.2435,9),
(2766,'I',0.555,0.435,0.145,0.6975,0.262,0.1575,0.24,11),
(2767,'F',0.555,0.445,0.175,1.1465,0.551,0.244,0.2785,8),
(2768,'I',0.56,0.44,0.14,0.825,0.402,0.139,0.245,10),
(2769,'I',0.56,0.435,0.135,0.72,0.329,0.103,0.251,11),
(2770,'I',0.565,0.43,0.15,0.8215,0.332,0.1685,0.29,11),
(2771,'F',0.57,0.445,0.155,1.017,0.5265,0.2025,0.265,10),
(2772,'F',0.575,0.435,0.155,0.8975,0.4115,0.2325,0.23,9),
(2773,'M',0.58,0.44,0.175,1.2255,0.5405,0.2705,0.3265,10),
(2774,'F',0.58,0.465,0.145,0.9865,0.47,0.2155,0.25,11),
(2775,'F',0.58,0.425,0.15,0.844,0.3645,0.185,0.2705,9),
(2776,'I',0.585,0.46,0.145,0.8465,0.339,0.167,0.295,10),
(2777,'M',0.585,0.465,0.165,0.885,0.4025,0.1625,0.274,10),
(2778,'I',0.585,0.42,0.145,0.6735,0.2895,0.1345,0.22,9),
(2779,'F',0.585,0.455,0.13,0.8755,0.411,0.2065,0.225,8),
(2780,'M',0.59,0.47,0.145,0.9235,0.4545,0.173,0.254,9),
(2781,'M',0.59,0.475,0.14,0.977,0.4625,0.2025,0.275,10),
(2782,'M',0.595,0.475,0.14,1.0305,0.4925,0.217,0.278,10),
(2783,'M',0.6,0.48,0.09,1.05,0.457,0.2685,0.28,8),
(2784,'M',0.6,0.495,0.185,1.1145,0.5055,0.2635,0.367,11),
(2785,'M',0.6,0.45,0.145,0.877,0.4325,0.155,0.24,9),
(2786,'M',0.6,0.51,0.185,1.285,0.6095,0.2745,0.315,9),
(2787,'M',0.61,0.48,0.185,1.3065,0.6895,0.2915,0.29,10),
(2788,'F',0.61,0.45,0.13,0.8725,0.389,0.1715,0.272,11),
(2789,'F',0.615,0.46,0.15,1.0265,0.4935,0.201,0.2745,10),
(2790,'F',0.62,0.465,0.14,1.1605,0.6005,0.2195,0.307,9),
(2791,'F',0.62,0.48,0.165,1.0125,0.5325,0.4365,0.324,10),
(2792,'M',0.625,0.5,0.14,1.096,0.5445,0.2165,0.295,10),
(2793,'M',0.625,0.49,0.165,1.205,0.5175,0.3105,0.3465,10),
(2794,'M',0.63,0.505,0.175,1.221,0.555,0.252,0.34,12),
(2795,'F',0.63,0.475,0.155,1.0005,0.452,0.252,0.265,10),
(2796,'M',0.63,0.47,0.15,1.1355,0.539,0.2325,0.3115,12),
(2797,'M',0.63,0.525,0.195,1.3135,0.4935,0.2565,0.465,10),
(2798,'M',0.64,0.505,0.155,1.1955,0.5565,0.211,0.346,11),
(2799,'M',0.64,0.485,0.15,1.098,0.5195,0.222,0.3175,10),
(2800,'M',0.64,0.495,0.17,1.139,0.5395,0.282,0.285,10),
(2801,'F',0.64,0.495,0.17,1.2265,0.49,0.377,0.2875,11),
(2802,'M',0.64,0.515,0.08,1.042,0.515,0.1755,0.175,10),
(2803,'M',0.65,0.52,0.155,1.368,0.6185,0.288,0.365,9),
(2804,'M',0.65,0.51,0.175,1.446,0.6485,0.2705,0.45,12),
(2805,'F',0.66,0.505,0.19,1.4045,0.6255,0.3375,0.3745,9),
(2806,'F',0.66,0.525,0.2,1.463,0.6525,0.2995,0.422,11),
(2807,'F',0.675,0.525,0.17,1.711,0.8365,0.352,0.475,9),
(2808,'M',0.7,0.54,0.205,1.74,0.7885,0.373,0.4865,13),
(2809,'F',0.705,0.54,0.205,1.757,0.8265,0.417,0.461,9),
(2810,'M',0.71,0.565,0.2,1.601,0.706,0.321,0.45,11),
(2811,'M',0.72,0.55,0.205,2.165,1.1055,0.525,0.404,10),
(2812,'M',0.725,0.57,0.19,2.3305,1.253,0.541,0.52,9),
(2813,'I',0.24,0.17,0.05,0.0545,0.0205,0.016,0.0155,5),
(2814,'I',0.255,0.195,0.055,0.0725,0.0285,0.017,0.021,4),
(2815,'I',0.275,0.2,0.055,0.0925,0.038,0.021,0.026,4),
(2816,'I',0.32,0.235,0.09,0.183,0.098,0.0335,0.042,7),
(2817,'I',0.325,0.24,0.075,0.1525,0.072,0.0645,0.043,6),
(2818,'I',0.33,0.225,0.075,0.187,0.0945,0.0395,0.0425,7),
(2819,'I',0.36,0.27,0.09,0.232,0.12,0.0435,0.056,8),
(2820,'I',0.375,0.265,0.095,0.196,0.085,0.042,0.0585,5),
(2821,'I',0.375,0.285,0.09,0.2545,0.119,0.0595,0.0675,6),
(2822,'I',0.39,0.29,0.09,0.2625,0.117,0.054,0.077,7),
(2823,'I',0.45,0.335,0.105,0.362,0.1575,0.0795,0.1095,7),
(2824,'I',0.455,0.35,0.105,0.4445,0.213,0.107,0.1115,7),
(2825,'I',0.46,0.365,0.115,0.511,0.2365,0.118,0.123,7),
(2826,'I',0.495,0.375,0.12,0.589,0.3075,0.1215,0.1405,8),
(2827,'M',0.5,0.365,0.13,0.5945,0.309,0.1085,0.1535,9),
(2828,'I',0.5,0.375,0.12,0.529,0.2235,0.123,0.16,8),
(2829,'M',0.52,0.4,0.105,0.872,0.4515,0.1615,0.1985,9),
(2830,'I',0.52,0.395,0.145,0.77,0.424,0.142,0.1895,7),
(2831,'F',0.525,0.43,0.135,0.8435,0.4325,0.18,0.1815,9),
(2832,'M',0.535,0.405,0.14,0.818,0.402,0.1715,0.189,7),
(2833,'F',0.54,0.42,0.14,0.8035,0.38,0.1805,0.21,9),
(2834,'F',0.54,0.415,0.15,0.8115,0.3875,0.1875,0.2035,9),
(2835,'F',0.57,0.425,0.13,0.782,0.3695,0.1745,0.1965,8),
(2836,'M',0.57,0.42,0.14,0.8745,0.416,0.165,0.25,8),
(2837,'M',0.58,0.445,0.16,0.984,0.49,0.201,0.27,9),
(2838,'F',0.58,0.445,0.135,0.95,0.484,0.182,0.2325,8),
(2839,'M',0.59,0.47,0.155,1.1735,0.6245,0.233,0.2595,9),
(2840,'F',0.59,0.455,0.15,0.976,0.465,0.2055,0.2765,10),
(2841,'M',0.59,0.485,0.155,1.0785,0.4535,0.2435,0.31,9),
(2842,'M',0.595,0.435,0.16,1.057,0.4255,0.224,0.31,9),
(2843,'M',0.6,0.475,0.175,1.11,0.5105,0.256,0.285,9),
(2844,'M',0.6,0.45,0.16,1.142,0.539,0.225,0.307,10),
(2845,'M',0.605,0.475,0.19,1.1255,0.59,0.247,0.26,10),
(2846,'F',0.62,0.48,0.17,1.1045,0.535,0.25,0.287,10),
(2847,'M',0.625,0.475,0.175,1.3405,0.656,0.283,0.337,10),
(2848,'M',0.625,0.5,0.13,1.082,0.5785,0.2045,0.25,8),
(2849,'F',0.625,0.485,0.16,1.254,0.591,0.259,0.3485,9),
(2850,'M',0.63,0.49,0.165,1.2005,0.575,0.273,0.294,10),
(2851,'M',0.63,0.485,0.16,1.243,0.623,0.275,0.3,10),
(2852,'F',0.635,0.51,0.185,1.286,0.526,0.295,0.4105,12),
(2853,'F',0.645,0.49,0.16,1.1665,0.4935,0.3155,0.299,9),
(2854,'F',0.645,0.49,0.16,1.144,0.5015,0.289,0.319,8),
(2855,'F',0.65,0.525,0.19,1.385,0.8875,0.3095,0.405,11),
(2856,'F',0.655,0.515,0.155,1.309,0.524,0.346,0.385,11),
(2857,'F',0.655,0.515,0.17,1.527,0.8485,0.2635,0.331,11),
(2858,'M',0.665,0.515,0.19,1.6385,0.831,0.3575,0.371,11),
(2859,'M',0.695,0.54,0.195,1.691,0.768,0.363,0.4755,11),
(2860,'F',0.72,0.565,0.18,1.719,0.8465,0.407,0.3875,11),
(2861,'F',0.72,0.55,0.18,1.52,0.637,0.325,0.435,10),
(2862,'F',0.72,0.565,0.17,1.613,0.723,0.3255,0.4945,12),
(2863,'M',0.735,0.57,0.21,2.2355,1.1705,0.463,0.5315,10),
(2864,'M',0.74,0.595,0.19,2.3235,1.1495,0.5115,0.505,11),
(2865,'I',0.31,0.23,0.07,0.1245,0.0505,0.0265,0.038,6),
(2866,'I',0.315,0.235,0.075,0.1285,0.051,0.028,0.0405,4),
(2867,'I',0.32,0.205,0.08,0.181,0.088,0.034,0.0495,5),
(2868,'I',0.325,0.25,0.075,0.1585,0.075,0.0305,0.0455,6),
(2869,'I',0.335,0.26,0.09,0.1965,0.0875,0.041,0.056,7),
(2870,'I',0.37,0.28,0.085,0.198,0.0805,0.0455,0.058,5),
(2871,'I',0.37,0.27,0.09,0.1855,0.07,0.0425,0.065,7),
(2872,'I',0.375,0.28,0.085,0.2145,0.0855,0.0485,0.072,7),
(2873,'I',0.4,0.315,0.09,0.3245,0.151,0.073,0.088,8),
(2874,'I',0.41,0.305,0.095,0.2625,0.1,0.0515,0.09,6),
(2875,'I',0.425,0.34,0.1,0.371,0.15,0.0865,0.115,8),
(2876,'I',0.435,0.335,0.095,0.298,0.109,0.058,0.115,7),
(2877,'I',0.445,0.31,0.09,0.336,0.1555,0.09,0.0855,7),
(2878,'I',0.46,0.36,0.14,0.447,0.161,0.087,0.16,9),
(2879,'F',0.465,0.35,0.11,0.4085,0.165,0.102,0.131,8),
(2880,'I',0.47,0.385,0.13,0.587,0.264,0.117,0.174,8),
(2881,'I',0.475,0.375,0.11,0.494,0.211,0.109,0.1545,8),
(2882,'I',0.495,0.375,0.12,0.614,0.2855,0.1365,0.161,8),
(2883,'I',0.5,0.39,0.13,0.5075,0.2115,0.104,0.1755,9),
(2884,'I',0.5,0.37,0.12,0.5445,0.249,0.1065,0.152,8),
(2885,'I',0.505,0.425,0.125,0.6115,0.245,0.1375,0.2,9),
(2886,'I',0.505,0.4,0.125,0.5605,0.2255,0.1435,0.17,8),
(2887,'M',0.505,0.365,0.115,0.521,0.25,0.096,0.15,8),
(2888,'I',0.51,0.4,0.145,0.5775,0.231,0.143,0.177,9),
(2889,'I',0.51,0.4,0.125,0.5935,0.239,0.13,0.204,8),
(2890,'I',0.52,0.4,0.11,0.597,0.2935,0.1155,0.16,8),
(2891,'M',0.52,0.465,0.15,0.9505,0.456,0.199,0.255,8),
(2892,'I',0.53,0.38,0.125,0.616,0.292,0.113,0.185,8),
(2893,'M',0.53,0.405,0.15,0.8315,0.352,0.187,0.2525,10),
(2894,'F',0.535,0.445,0.125,0.8725,0.417,0.199,0.24,8),
(2895,'I',0.54,0.425,0.13,0.8155,0.3675,0.1365,0.246,11),
(2896,'I',0.54,0.415,0.11,0.619,0.2755,0.15,0.1765,10),
(2897,'I',0.545,0.43,0.13,0.7595,0.358,0.153,0.2055,8),
(2898,'I',0.545,0.43,0.15,0.742,0.3525,0.158,0.208,10),
(2899,'I',0.55,0.435,0.165,0.804,0.34,0.194,0.244,8),
(2900,'I',0.55,0.425,0.13,0.664,0.2695,0.163,0.21,8),
(2901,'F',0.55,0.435,0.14,0.745,0.347,0.174,0.2265,9),
(2902,'I',0.56,0.43,0.13,0.728,0.3355,0.1435,0.2175,8),
(2903,'I',0.56,0.435,0.13,0.777,0.354,0.173,0.222,9),
(2904,'F',0.575,0.425,0.15,0.8765,0.455,0.18,0.228,8),
(2905,'I',0.575,0.455,0.16,0.9895,0.495,0.195,0.246,9),
(2906,'M',0.575,0.45,0.165,0.9655,0.498,0.19,0.23,8),
(2907,'M',0.58,0.465,0.15,0.9065,0.371,0.1965,0.29,8),
(2908,'M',0.58,0.46,0.15,1.049,0.5205,0.1935,0.305,10),
(2909,'F',0.58,0.45,0.17,0.9705,0.4615,0.232,0.248,9),
(2910,'F',0.58,0.45,0.15,0.92,0.393,0.212,0.2895,9),
(2911,'M',0.58,0.445,0.15,0.9525,0.4315,0.1945,0.287,11),
(2912,'F',0.58,0.44,0.125,0.7855,0.363,0.1955,0.195,11),
(2913,'I',0.585,0.45,0.135,0.855,0.3795,0.187,0.26,9),
(2914,'M',0.59,0.5,0.15,1.142,0.485,0.265,0.345,9),
(2915,'I',0.59,0.46,0.125,0.755,0.334,0.15,0.238,9),
(2916,'I',0.59,0.475,0.145,0.9745,0.4675,0.207,0.259,10),
(2917,'M',0.595,0.47,0.155,1.2015,0.492,0.3865,0.265,10),
(2918,'M',0.595,0.46,0.17,1.1295,0.57,0.2555,0.265,10),
(2919,'I',0.6,0.445,0.135,0.9205,0.445,0.2035,0.253,9),
(2920,'F',0.6,0.48,0.17,1.056,0.4575,0.2435,0.3135,10),
(2921,'M',0.6,0.45,0.195,1.34,0.617,0.3255,0.3605,10),
(2922,'F',0.6,0.45,0.15,0.9625,0.4375,0.2225,0.2775,9),
(2923,'M',0.6,0.465,0.165,1.0475,0.465,0.2345,0.315,11),
(2924,'F',0.605,0.495,0.17,1.0915,0.4365,0.2715,0.335,13),
(2925,'M',0.605,0.49,0.18,1.167,0.457,0.29,0.3745,9),
(2926,'I',0.605,0.48,0.155,0.9995,0.425,0.1985,0.3,10),
(2927,'I',0.61,0.425,0.155,1.0485,0.507,0.1955,0.274,11),
(2928,'F',0.61,0.47,0.195,1.2735,0.469,0.3315,0.398,12),
(2929,'M',0.61,0.48,0.14,1.0625,0.516,0.225,0.2915,11),
(2930,'I',0.61,0.49,0.16,1.1545,0.5865,0.2385,0.2915,11),
(2931,'F',0.615,0.475,0.175,1.194,0.559,0.259,0.3165,11),
(2932,'F',0.615,0.515,0.135,1.1215,0.545,0.2305,0.29,9),
(2933,'M',0.615,0.455,0.15,0.9335,0.382,0.247,0.2615,10),
(2934,'F',0.615,0.495,0.165,1.198,0.5415,0.2865,0.3185,10),
(2935,'F',0.62,0.475,0.15,0.9545,0.455,0.1865,0.277,9),
(2936,'M',0.62,0.475,0.195,1.3585,0.5935,0.3365,0.3745,10),
(2937,'M',0.625,0.495,0.175,1.2075,0.531,0.281,0.3525,11),
(2938,'M',0.625,0.515,0.165,1.217,0.667,0.2065,0.3115,10),
(2939,'F',0.625,0.5,0.16,1.217,0.5725,0.207,0.355,11),
(2940,'F',0.625,0.49,0.145,0.92,0.437,0.1735,0.28,10),
(2941,'M',0.625,0.49,0.12,0.8765,0.456,0.18,0.233,10),
(2942,'F',0.63,0.48,0.165,1.2615,0.5505,0.277,0.3885,10),
(2943,'M',0.63,0.53,0.18,1.2795,0.618,0.256,0.315,9),
(2944,'F',0.63,0.485,0.185,1.167,0.548,0.2485,0.34,10),
(2945,'M',0.63,0.51,0.17,1.1885,0.4915,0.3065,0.348,7),
(2946,'F',0.635,0.485,0.19,1.3765,0.634,0.2885,0.406,11),
(2947,'M',0.635,0.52,0.175,1.292,0.6,0.269,0.367,11),
(2948,'M',0.635,0.485,0.18,1.1795,0.4785,0.2775,0.355,10),
(2949,'F',0.635,0.5,0.19,1.29,0.593,0.3045,0.352,8),
(2950,'M',0.635,0.515,0.16,1.2075,0.5385,0.282,0.345,11),
(2951,'M',0.64,0.505,0.18,1.297,0.59,0.3125,0.363,11),
(2952,'M',0.64,0.575,0.175,1.4585,0.625,0.266,0.4395,11),
(2953,'F',0.645,0.485,0.15,1.151,0.5935,0.2315,0.293,12),
(2954,'F',0.645,0.52,0.17,1.197,0.526,0.2925,0.317,11),
(2955,'M',0.645,0.495,0.19,1.539,0.6115,0.408,0.445,12),
(2956,'M',0.65,0.52,0.195,1.676,0.693,0.44,0.47,15),
(2957,'F',0.65,0.565,0.2,1.6645,0.753,0.367,0.43,12),
(2958,'F',0.655,0.5,0.205,1.528,0.6215,0.3725,0.4535,11),
(2959,'F',0.655,0.515,0.2,1.494,0.7255,0.309,0.405,12),
(2960,'F',0.66,0.525,0.16,1.277,0.4975,0.319,0.394,13),
(2961,'F',0.66,0.525,0.18,1.5965,0.7765,0.397,0.3605,10),
(2962,'F',0.665,0.51,0.175,1.3805,0.675,0.2985,0.325,10),
(2963,'I',0.67,0.485,0.175,1.2565,0.5355,0.322,0.386,9),
(2964,'F',0.67,0.525,0.19,1.527,0.5755,0.353,0.44,12),
(2965,'M',0.67,0.525,0.17,1.4005,0.715,0.3025,0.387,9),
(2966,'M',0.67,0.525,0.195,1.4405,0.6595,0.2675,0.425,9),
(2967,'M',0.67,0.54,0.175,1.482,0.739,0.2925,0.365,10),
(2968,'M',0.68,0.515,0.16,1.2345,0.618,0.2625,0.325,11),
(2969,'F',0.68,0.505,0.17,1.3435,0.657,0.297,0.355,12),
(2970,'M',0.685,0.505,0.19,1.533,0.667,0.4055,0.41,10),
(2971,'M',0.69,0.515,0.18,1.8445,0.9815,0.4655,0.341,13),
(2972,'M',0.715,0.55,0.175,1.825,0.938,0.3805,0.44,11),
(2973,'M',0.72,0.58,0.19,2.0885,0.9955,0.478,0.5305,13),
(2974,'M',0.735,0.59,0.205,2.087,0.909,0.474,0.625,12),
(2975,'M',0.745,0.575,0.2,1.884,0.954,0.336,0.495,12),
(2976,'I',0.32,0.215,0.095,0.305,0.14,0.067,0.0885,6),
(2977,'I',0.43,0.345,0.115,0.4295,0.212,0.108,0.109,8),
(2978,'I',0.43,0.33,0.1,0.449,0.254,0.0825,0.097,6),
(2979,'M',0.485,0.365,0.155,1.029,0.4235,0.2285,0.313,8),
(2980,'M',0.49,0.355,0.155,0.981,0.465,0.2015,0.2505,8),
(2981,'I',0.5,0.37,0.115,0.5745,0.306,0.112,0.141,7),
(2982,'F',0.505,0.38,0.13,0.693,0.391,0.1195,0.1515,8),
(2983,'F',0.51,0.37,0.21,1.183,0.508,0.292,0.343,9),
(2984,'F',0.525,0.41,0.135,0.7905,0.4065,0.198,0.177,8),
(2985,'F',0.535,0.4,0.15,1.224,0.618,0.275,0.2875,10),
(2986,'I',0.535,0.4,0.135,0.775,0.368,0.208,0.2055,8),
(2987,'M',0.535,0.405,0.175,1.2705,0.548,0.3265,0.337,13),
(2988,'M',0.555,0.405,0.19,1.406,0.6115,0.342,0.389,10),
(2989,'M',0.555,0.425,0.15,0.873,0.4625,0.1845,0.1965,9),
(2990,'M',0.56,0.425,0.135,0.9415,0.509,0.2015,0.1975,9),
(2991,'F',0.59,0.44,0.14,1.007,0.4775,0.2105,0.2925,9),
(2992,'M',0.595,0.485,0.15,1.0835,0.5305,0.231,0.276,8),
(2993,'I',0.595,0.43,0.165,0.9845,0.4525,0.207,0.2725,8),
(2994,'F',0.595,0.43,0.21,1.5245,0.653,0.396,0.41,11),
(2995,'M',0.61,0.475,0.175,1.024,0.409,0.261,0.322,9),
(2996,'M',0.61,0.485,0.17,1.281,0.597,0.3035,0.33,9),
(2997,'F',0.62,0.5,0.17,1.148,0.5475,0.22,0.3315,10),
(2998,'F',0.625,0.49,0.11,1.136,0.5265,0.1915,0.2925,9),
(2999,'F',0.635,0.51,0.17,1.2235,0.532,0.271,0.354,9),
(3000,'F',0.635,0.525,0.18,1.3695,0.634,0.318,0.363,11),
(3001,'M',0.64,0.485,0.16,1.006,0.456,0.2245,0.2835,9),
(3002,'M',0.64,0.495,0.165,1.307,0.678,0.292,0.266,11),
(3003,'M',0.645,0.505,0.185,1.463,0.592,0.3905,0.416,10),
(3004,'F',0.655,0.505,0.175,1.2905,0.6205,0.2965,0.326,10),
(3005,'F',0.67,0.515,0.17,1.4265,0.6605,0.3395,0.37,11),
(3006,'M',0.68,0.54,0.21,1.7885,0.8345,0.408,0.437,13),
(3007,'M',0.7,0.545,0.185,1.6135,0.75,0.4035,0.3685,11),
(3008,'M',0.73,0.585,0.225,2.2305,1.2395,0.422,0.563,14),
(3009,'F',0.75,0.615,0.205,2.2635,0.821,0.423,0.726,12),
(3010,'I',0.255,0.185,0.065,0.074,0.0305,0.0165,0.02,4),
(3011,'I',0.375,0.26,0.08,0.2075,0.09,0.0415,0.07,6),
(3012,'I',0.375,0.285,0.09,0.237,0.106,0.0395,0.08,8),
(3013,'I',0.39,0.3,0.1,0.2665,0.1105,0.059,0.084,7),
(3014,'I',0.39,0.28,0.09,0.215,0.0845,0.034,0.079,8),
(3015,'I',0.395,0.3,0.09,0.253,0.1155,0.05,0.075,6),
(3016,'I',0.42,0.32,0.11,0.309,0.115,0.0645,0.0945,6),
(3017,'I',0.435,0.335,0.105,0.3535,0.156,0.05,0.1135,7),
(3018,'I',0.435,0.325,0.105,0.335,0.136,0.065,0.115,8),
(3019,'I',0.44,0.32,0.105,0.3875,0.1755,0.074,0.12,9),
(3020,'I',0.45,0.33,0.115,0.365,0.14,0.0825,0.1245,8),
(3021,'I',0.45,0.34,0.125,0.4045,0.171,0.07,0.1345,8),
(3022,'I',0.455,0.355,0.105,0.372,0.138,0.0765,0.135,9),
(3023,'I',0.46,0.37,0.11,0.3965,0.1485,0.0855,0.1455,8),
(3024,'I',0.47,0.375,0.125,0.5225,0.2265,0.104,0.162,8),
(3025,'I',0.475,0.375,0.11,0.456,0.182,0.099,0.16,9),
(3026,'I',0.495,0.33,0.1,0.44,0.177,0.095,0.15,7),
(3027,'I',0.495,0.375,0.115,0.507,0.241,0.103,0.15,8),
(3028,'I',0.5,0.38,0.135,0.5285,0.226,0.123,0.209,8),
(3029,'I',0.515,0.385,0.125,0.572,0.237,0.1435,0.165,7),
(3030,'I',0.52,0.41,0.14,0.6625,0.2775,0.1555,0.196,11),
(3031,'I',0.52,0.395,0.115,0.6445,0.3155,0.1245,0.186,11),
(3032,'I',0.525,0.4,0.11,0.6275,0.3015,0.126,0.18,8),
(3033,'I',0.535,0.42,0.145,0.6885,0.273,0.1515,0.237,9),
(3034,'M',0.535,0.41,0.12,0.6835,0.3125,0.1655,0.159,8),
(3035,'M',0.54,0.42,0.19,0.6855,0.293,0.163,0.38,10),
(3036,'I',0.55,0.405,0.15,0.6755,0.3015,0.1465,0.21,10),
(3037,'I',0.55,0.445,0.145,0.783,0.3045,0.157,0.265,11),
(3038,'M',0.56,0.45,0.145,0.894,0.3885,0.2095,0.264,9),
(3039,'I',0.565,0.44,0.135,0.768,0.3305,0.1385,0.2475,9),
(3040,'M',0.57,0.45,0.145,0.95,0.4005,0.2235,0.2845,10),
(3041,'F',0.57,0.47,0.14,0.871,0.385,0.211,0.2315,10),
(3042,'M',0.575,0.47,0.15,0.9785,0.4505,0.196,0.276,9),
(3043,'I',0.575,0.43,0.13,0.7425,0.2895,0.2005,0.22,8),
(3044,'M',0.575,0.445,0.14,0.737,0.325,0.1405,0.237,10),
(3045,'I',0.575,0.445,0.16,0.9175,0.45,0.1935,0.24,9),
(3046,'F',0.58,0.435,0.155,0.8785,0.425,0.1685,0.2425,10),
(3047,'M',0.585,0.45,0.175,1.1275,0.4925,0.262,0.335,11),
(3048,'M',0.59,0.435,0.165,0.9765,0.4525,0.2395,0.235,9),
(3049,'I',0.59,0.47,0.145,0.974,0.453,0.236,0.289,8),
(3050,'M',0.59,0.405,0.15,0.853,0.326,0.2615,0.245,9),
(3051,'M',0.595,0.47,0.175,0.991,0.382,0.2395,0.5,12),
(3052,'M',0.595,0.48,0.14,0.9125,0.4095,0.1825,0.289,9),
(3053,'F',0.595,0.46,0.16,0.921,0.4005,0.2025,0.2875,9),
(3054,'F',0.6,0.45,0.14,0.869,0.3425,0.195,0.291,11),
(3055,'M',0.6,0.45,0.15,0.8665,0.3695,0.1955,0.255,12),
(3056,'F',0.61,0.495,0.16,1.089,0.469,0.198,0.384,11),
(3057,'M',0.615,0.485,0.215,0.9615,0.422,0.176,0.29,11),
(3058,'M',0.615,0.49,0.17,1.145,0.4915,0.208,0.343,13),
(3059,'I',0.62,0.475,0.16,0.907,0.371,0.167,0.3075,11),
(3060,'F',0.625,0.515,0.155,1.1635,0.4875,0.259,0.355,11),
(3061,'M',0.63,0.515,0.175,1.1955,0.492,0.247,0.37,11),
(3062,'M',0.63,0.495,0.18,1.31,0.495,0.295,0.4695,10),
(3063,'F',0.635,0.505,0.165,1.251,0.577,0.227,0.3825,11),
(3064,'F',0.635,0.49,0.155,1.145,0.4775,0.3035,0.3155,9),
(3065,'M',0.635,0.5,0.18,1.154,0.4405,0.2315,0.387,9),
(3066,'F',0.64,0.485,0.145,1.1335,0.5525,0.2505,0.3015,11),
(3067,'F',0.64,0.5,0.15,1.2015,0.559,0.231,0.3355,9),
(3068,'M',0.65,0.505,0.17,1.5595,0.695,0.3515,0.395,11),
(3069,'M',0.65,0.51,0.175,1.3165,0.6345,0.2605,0.364,12),
(3070,'M',0.655,0.54,0.165,1.403,0.6955,0.2385,0.42,11),
(3071,'F',0.655,0.49,0.16,1.204,0.5455,0.2615,0.3225,9),
(3072,'F',0.655,0.455,0.17,1.2895,0.587,0.3165,0.3415,11),
(3073,'F',0.66,0.53,0.18,1.5175,0.7765,0.302,0.401,10),
(3074,'M',0.665,0.525,0.155,1.3575,0.5325,0.3045,0.4485,10),
(3075,'M',0.675,0.52,0.145,1.3645,0.557,0.3405,0.385,11),
(3076,'F',0.68,0.52,0.185,1.494,0.615,0.3935,0.406,11),
(3077,'F',0.68,0.56,0.195,1.664,0.58,0.3855,0.545,11),
(3078,'M',0.685,0.51,0.165,1.545,0.686,0.3775,0.4055,10),
(3079,'F',0.695,0.535,0.2,1.5855,0.667,0.334,0.471,11),
(3080,'F',0.7,0.555,0.22,1.666,0.647,0.4285,0.455,11),
(3081,'M',0.71,0.56,0.175,1.724,0.566,0.4575,0.4625,13),
(3082,'F',0.73,0.55,0.205,1.908,0.5415,0.3565,0.5965,14),
(3083,'F',0.755,0.575,0.2,2.073,1.0135,0.4655,0.48,11),
(3084,'I',0.225,0.17,0.05,0.0515,0.019,0.012,0.017,4),
(3085,'I',0.23,0.17,0.05,0.057,0.026,0.013,0.016,5),
(3086,'I',0.255,0.185,0.06,0.0925,0.039,0.021,0.025,6),
(3087,'I',0.355,0.27,0.075,0.204,0.3045,0.046,0.0595,7),
(3088,'I',0.425,0.31,0.095,0.3075,0.139,0.0745,0.093,7),
(3089,'I',0.425,0.32,0.085,0.262,0.1235,0.067,0.0725,8),
(3090,'M',0.455,0.35,0.11,0.458,0.2,0.111,0.1305,8),
(3091,'M',0.46,0.355,0.14,0.491,0.207,0.115,0.174,10),
(3092,'M',0.495,0.38,0.12,0.474,0.197,0.1065,0.1545,10),
(3093,'M',0.51,0.395,0.125,0.5805,0.244,0.1335,0.188,11),
(3094,'F',0.52,0.43,0.15,0.728,0.302,0.1575,0.235,11),
(3095,'M',0.525,0.4,0.13,0.622,0.2655,0.147,0.184,9),
(3096,'M',0.53,0.415,0.12,0.706,0.3355,0.1635,0.1345,9),
(3097,'F',0.53,0.395,0.115,0.5685,0.249,0.1375,0.161,9),
(3098,'M',0.545,0.435,0.145,0.9385,0.3685,0.1245,0.345,11),
(3099,'F',0.55,0.43,0.15,0.655,0.2635,0.122,0.221,8),
(3100,'M',0.575,0.48,0.15,0.9465,0.4355,0.2605,0.2505,9),
(3101,'M',0.58,0.43,0.125,0.9115,0.446,0.2075,0.121,10),
(3102,'M',0.595,0.455,0.145,0.942,0.43,0.182,0.277,11),
(3103,'M',0.6,0.465,0.18,1.193,0.5145,0.315,0.3055,8),
(3104,'M',0.645,0.5,0.18,1.461,0.5985,0.2425,0.439,11),
(3105,'M',0.66,0.525,0.2,1.489,0.6065,0.3795,0.421,10),
(3106,'I',0.29,0.215,0.06,0.1115,0.053,0.0185,0.032,5),
(3107,'I',0.3,0.22,0.065,0.1235,0.059,0.026,0.0315,5),
(3108,'I',0.37,0.275,0.1,0.2815,0.1505,0.0505,0.068,5),
(3109,'I',0.375,0.285,0.08,0.226,0.0975,0.04,0.0725,7),
(3110,'I',0.38,0.29,0.085,0.2285,0.088,0.0465,0.075,7),
(3111,'I',0.395,0.3,0.12,0.2995,0.1265,0.068,0.0895,8),
(3112,'I',0.41,0.325,0.105,0.361,0.1605,0.0665,0.103,8),
(3113,'I',0.415,0.32,0.115,0.3045,0.1215,0.0735,0.094,7),
(3114,'I',0.425,0.325,0.105,0.3975,0.1815,0.081,0.1175,7),
(3115,'I',0.44,0.34,0.1,0.379,0.1725,0.0815,0.101,7),
(3116,'I',0.44,0.34,0.12,0.4995,0.2965,0.0945,0.1185,6),
(3117,'M',0.465,0.405,0.135,0.7775,0.436,0.1715,0.1455,10),
(3118,'F',0.47,0.36,0.1,0.4705,0.1635,0.089,0.1385,8),
(3119,'M',0.51,0.415,0.145,0.751,0.3295,0.1835,0.203,8),
(3120,'F',0.525,0.4,0.135,0.714,0.318,0.138,0.208,10),
(3121,'F',0.525,0.4,0.13,0.6995,0.3115,0.131,0.223,9),
(3122,'F',0.55,0.425,0.14,0.952,0.4895,0.1945,0.2185,7),
(3123,'M',0.56,0.42,0.15,0.8755,0.44,0.1965,0.2315,8),
(3124,'M',0.575,0.45,0.135,0.9215,0.354,0.209,0.2365,9),
(3125,'F',0.575,0.45,0.135,0.8285,0.362,0.1655,0.236,10),
(3126,'M',0.585,0.46,0.15,1.206,0.581,0.216,0.323,10),
(3127,'M',0.615,0.495,0.155,1.2865,0.435,0.293,0.3245,11),
(3128,'F',0.62,0.485,0.155,1.1945,0.5105,0.271,0.352,9),
(3129,'F',0.63,0.495,0.19,1.1655,0.536,0.2115,0.1625,10),
(3130,'F',0.63,0.49,0.17,1.2155,0.4625,0.2045,0.3105,10),
(3131,'M',0.67,0.515,0.165,1.1735,0.526,0.285,0.316,11),
(3132,'M',0.675,0.505,0.16,1.532,0.74,0.357,0.3815,11),
(3133,'F',0.685,0.53,0.17,1.5105,0.7385,0.3525,0.3725,10),
(3134,'F',0.485,0.39,0.1,0.5565,0.2215,0.1155,0.185,9),
(3135,'M',0.46,0.36,0.125,0.547,0.2165,0.1105,0.19,8),
(3136,'M',0.46,0.35,0.125,0.5165,0.1885,0.1145,0.185,9),
(3137,'M',0.535,0.42,0.125,0.764,0.312,0.1505,0.265,11),
(3138,'M',0.465,0.36,0.105,0.488,0.188,0.0845,0.19,10),
(3139,'M',0.51,0.4,0.14,0.6905,0.259,0.151,0.23,10),
(3140,'I',0.335,0.26,0.09,0.1835,0.078,0.024,0.065,11),
(3141,'M',0.55,0.425,0.16,0.97,0.2885,0.139,0.48,20),
(3142,'I',0.18,0.135,0.08,0.033,0.0145,0.007,0.01,5),
(3143,'I',0.215,0.165,0.055,0.059,0.0265,0.0125,0.0185,5),
(3144,'I',0.2,0.15,0.04,0.046,0.021,0.007,0.0065,4),
(3145,'F',0.625,0.48,0.2,1.3235,0.6075,0.3055,0.355,9),
(3146,'M',0.55,0.42,0.17,0.8465,0.336,0.2405,0.245,13),
(3147,'M',0.585,0.45,0.15,1.047,0.4315,0.276,0.315,14),
(3148,'F',0.645,0.5,0.18,1.2785,0.5345,0.2995,0.345,13),
(3149,'F',0.71,0.53,0.195,1.8745,0.6755,0.4065,0.6855,12),
(3150,'F',0.7,0.54,0.215,1.978,0.6675,0.3125,0.71,24),
(3151,'F',0.655,0.505,0.165,1.367,0.5835,0.3515,0.396,10),
(3152,'F',0.665,0.5,0.175,1.742,0.595,0.3025,0.725,21),
(3153,'F',0.47,0.375,0.105,0.513,0.232,0.142,0.13,11),
(3154,'M',0.425,0.335,0.1,0.4085,0.1755,0.092,0.135,9),
(3155,'M',0.54,0.41,0.13,0.56,0.2375,0.1065,0.175,7),
(3156,'M',0.505,0.395,0.125,0.635,0.29,0.1555,0.175,9),
(3157,'M',0.535,0.44,0.165,0.875,0.279,0.18,0.3,10),
(3158,'F',0.43,0.35,0.09,0.397,0.1575,0.089,0.12,9),
(3159,'M',0.55,0.435,0.11,0.806,0.3415,0.203,0.215,9),
(3160,'F',0.34,0.255,0.085,0.204,0.097,0.021,0.05,6),
(3161,'I',0.275,0.2,0.065,0.1165,0.0565,0.013,0.035,7),
(3162,'F',0.335,0.22,0.07,0.17,0.076,0.0365,0.05,6),
(3163,'M',0.64,0.49,0.14,1.194,0.4445,0.238,0.375,15),
(3164,'F',0.55,0.44,0.125,0.765,0.33,0.2125,0.245,9),
(3165,'F',0.64,0.475,0.19,1.151,0.4365,0.281,0.3805,13),
(3166,'F',0.545,0.41,0.115,0.6765,0.29,0.158,0.22,9),
(3167,'F',0.64,0.54,0.175,1.571,0.627,0.271,0.475,18),
(3168,'M',0.605,0.49,0.155,1.153,0.503,0.2505,0.295,15),
(3169,'M',0.605,0.47,0.115,1.114,0.3925,0.291,0.31,15),
(3170,'M',0.56,0.45,0.155,0.9125,0.3595,0.271,0.35,10),
(3171,'F',0.57,0.465,0.155,0.872,0.3245,0.239,0.285,14),
(3172,'M',0.525,0.405,0.16,0.792,0.316,0.1455,0.28,13),
(3173,'F',0.505,0.405,0.18,0.606,0.239,0.1235,0.18,11),
(3174,'M',0.35,0.265,0.09,0.2265,0.0995,0.0575,0.065,6),
(3175,'M',0.45,0.355,0.12,0.3955,0.147,0.0765,0.145,9),
(3176,'I',0.51,0.405,0.12,0.61,0.229,0.131,0.235,11),
(3177,'F',0.49,0.38,0.13,0.539,0.229,0.1355,0.165,12),
(3178,'F',0.505,0.41,0.135,0.657,0.291,0.133,0.195,15),
(3179,'M',0.38,0.3,0.1,0.2505,0.106,0.0535,0.0775,8),
(3180,'I',0.27,0.195,0.07,0.102,0.045,0.0135,0.034,8),
(3181,'F',0.37,0.295,0.1,0.2685,0.1165,0.056,0.0835,7),
(3182,'M',0.5,0.385,0.135,0.551,0.2245,0.0715,0.206,11),
(3183,'M',0.645,0.505,0.165,1.307,0.4335,0.262,0.52,10),
(3184,'M',0.565,0.44,0.115,0.9185,0.404,0.1785,0.29,11),
(3185,'F',0.67,0.545,0.175,1.707,0.6995,0.387,0.575,13),
(3186,'F',0.59,0.415,0.15,0.8805,0.3645,0.234,0.235,11),
(3187,'F',0.47,0.36,0.11,0.4965,0.237,0.127,0.13,6),
(3188,'F',0.51,0.385,0.135,0.632,0.282,0.145,0.17,8),
(3189,'M',0.72,0.575,0.23,2.2695,0.8835,0.3985,0.665,16),
(3190,'M',0.55,0.405,0.15,0.9235,0.412,0.2135,0.24,7),
(3191,'I',0.2,0.145,0.025,0.0345,0.011,0.0075,0.01,5),
(3192,'M',0.65,0.515,0.18,1.3315,0.5665,0.347,0.405,13),
(3193,'F',0.525,0.405,0.115,0.72,0.3105,0.1915,0.2,14),
(3194,'M',0.565,0.435,0.185,1.032,0.354,0.2045,0.31,20),
(3195,'F',0.61,0.47,0.16,1.017,0.426,0.2255,0.32,12),
(3196,'F',0.545,0.405,0.175,0.98,0.2585,0.207,0.38,18),
(3197,'I',0.325,0.245,0.075,0.1495,0.0605,0.033,0.045,5),
(3198,'I',0.31,0.235,0.075,0.1515,0.056,0.0315,0.05,7),
(3199,'M',0.45,0.335,0.14,0.478,0.1865,0.115,0.16,11),
(3200,'F',0.49,0.38,0.155,0.578,0.2395,0.1255,0.18,9),
(3201,'F',0.505,0.405,0.16,0.6835,0.271,0.145,0.215,10),
(3202,'F',0.385,0.3,0.1,0.2725,0.1115,0.057,0.08,6),
(3203,'F',0.62,0.485,0.22,1.511,0.5095,0.284,0.51,17),
(3204,'F',0.635,0.505,0.185,1.3035,0.501,0.295,0.41,17),
(3205,'F',0.665,0.53,0.185,1.3955,0.456,0.3205,0.49,15),
(3206,'M',0.335,0.265,0.095,0.1975,0.0795,0.0375,0.07,9),
(3207,'I',0.295,0.215,0.075,0.116,0.037,0.0295,0.04,8),
(3208,'I',0.48,0.38,0.125,0.523,0.2105,0.1045,0.175,15),
(3209,'I',0.32,0.25,0.08,0.1565,0.057,0.034,0.06,9),
(3210,'I',0.43,0.34,0.125,0.384,0.1375,0.061,0.146,14),
(3211,'M',0.565,0.45,0.14,1.0055,0.3785,0.244,0.265,12),
(3212,'F',0.6,0.48,0.165,1.1345,0.4535,0.27,0.335,10),
(3213,'F',0.585,0.46,0.17,1.0835,0.3745,0.326,0.325,14),
(3214,'F',0.555,0.42,0.14,0.868,0.33,0.243,0.21,13),
(3215,'F',0.57,0.495,0.16,1.0915,0.452,0.275,0.315,14),
(3216,'F',0.62,0.485,0.175,1.271,0.531,0.3075,0.37,11),
(3217,'M',0.63,0.51,0.19,1.4985,0.4125,0.3075,0.545,16),
(3218,'M',0.425,0.34,0.12,0.388,0.149,0.087,0.125,10),
(3219,'F',0.64,0.505,0.19,1.2355,0.4435,0.3105,0.365,14),
(3220,'M',0.675,0.525,0.175,1.402,0.483,0.3205,0.465,16),
(3221,'M',0.5,0.4,0.145,0.6025,0.216,0.138,0.21,11),
(3222,'M',0.385,0.305,0.09,0.2775,0.109,0.0515,0.1,9),
(3223,'M',0.52,0.435,0.195,0.973,0.2985,0.2135,0.355,18),
(3224,'M',0.52,0.415,0.175,0.753,0.258,0.171,0.255,8),
(3225,'M',0.64,0.525,0.2,1.3765,0.44,0.3075,0.47,16),
(3226,'I',0.44,0.35,0.12,0.375,0.1425,0.0965,0.115,9),
(3227,'F',0.42,0.32,0.13,0.4135,0.1645,0.106,0.119,10),
(3228,'F',0.45,0.35,0.135,0.56,0.231,0.137,0.145,13),
(3229,'I',0.42,0.325,0.125,0.3915,0.1575,0.1025,0.115,9),
(3230,'F',0.64,0.505,0.19,1.2765,0.4835,0.328,0.4,12),
(3231,'M',0.57,0.455,0.15,0.96,0.387,0.2385,0.275,11),
(3232,'M',0.41,0.325,0.12,0.3745,0.158,0.081,0.125,12),
(3233,'M',0.485,0.41,0.15,0.696,0.2405,0.1625,0.265,13),
(3234,'F',0.61,0.48,0.19,1.2955,0.5215,0.3225,0.365,12),
(3235,'F',0.59,0.485,0.205,1.2315,0.4525,0.238,0.42,13),
(3236,'M',0.665,0.535,0.155,1.383,0.596,0.2565,0.485,14),
(3237,'I',0.345,0.285,0.1,0.2225,0.0865,0.058,0.075,8),
(3238,'M',0.635,0.51,0.155,1.156,0.428,0.289,0.315,18),
(3239,'M',0.695,0.53,0.15,1.477,0.6375,0.3025,0.43,14),
(3240,'F',0.69,0.54,0.185,1.5715,0.6935,0.318,0.47,15),
(3241,'M',0.555,0.435,0.135,0.858,0.377,0.1585,0.29,15),
(3242,'M',0.65,0.525,0.19,1.4995,0.6265,0.4005,0.395,14),
(3243,'M',0.635,0.48,0.19,1.467,0.5825,0.303,0.42,15),
(3244,'F',0.655,0.51,0.16,1.092,0.396,0.2825,0.37,14),
(3245,'F',0.69,0.555,0.205,1.8165,0.7785,0.4395,0.515,19),
(3246,'F',0.695,0.55,0.16,1.6365,0.694,0.3005,0.44,13),
(3247,'M',0.55,0.435,0.16,0.906,0.342,0.219,0.295,13),
(3248,'F',0.61,0.495,0.19,1.213,0.464,0.306,0.365,15),
(3249,'M',0.595,0.5,0.165,1.06,0.402,0.28,0.275,11),
(3250,'M',0.3,0.24,0.09,0.161,0.0725,0.039,0.05,6),
(3251,'F',0.435,0.35,0.125,0.459,0.197,0.1145,0.145,9),
(3252,'I',0.455,0.375,0.125,0.533,0.233,0.106,0.185,8),
(3253,'M',0.48,0.38,0.13,0.6175,0.3,0.142,0.175,12),
(3254,'I',0.43,0.35,0.105,0.366,0.1705,0.0855,0.11,6),
(3255,'F',0.435,0.35,0.105,0.4195,0.194,0.1005,0.13,7),
(3256,'I',0.3,0.23,0.075,0.15,0.0605,0.042,0.045,5),
(3257,'F',0.575,0.48,0.15,0.8745,0.375,0.193,0.29,12),
(3258,'M',0.505,0.385,0.11,0.655,0.3185,0.15,0.185,9),
(3259,'M',0.455,0.375,0.125,0.484,0.2155,0.102,0.165,7),
(3260,'M',0.64,0.505,0.165,1.4435,0.6145,0.3035,0.39,18),
(3261,'F',0.56,0.435,0.125,0.8775,0.3345,0.2145,0.29,13),
(3262,'F',0.645,0.52,0.19,1.3105,0.58,0.288,0.37,12),
(3263,'F',0.595,0.485,0.145,1.2515,0.5035,0.2925,0.33,14),
(3264,'M',0.565,0.45,0.115,0.9085,0.398,0.197,0.29,17),
(3265,'F',0.655,0.5,0.14,1.1705,0.5405,0.3175,0.285,12),
(3266,'M',0.48,0.38,0.135,0.528,0.2,0.1395,0.16,14),
(3267,'F',0.495,0.385,0.135,0.6625,0.3005,0.1635,0.185,11),
(3268,'F',0.4,0.335,0.115,0.4335,0.2105,0.1205,0.12,10),
(3269,'M',0.41,0.31,0.125,0.3595,0.1415,0.0885,0.115,11),
(3270,'F',0.595,0.465,0.145,1.107,0.402,0.2415,0.31,12),
(3271,'F',0.625,0.475,0.13,0.8595,0.3195,0.1775,0.24,13),
(3272,'M',0.52,0.425,0.155,0.7735,0.297,0.123,0.255,17),
(3273,'M',0.465,0.36,0.125,0.4365,0.169,0.1075,0.145,11),
(3274,'F',0.475,0.375,0.14,0.501,0.192,0.1175,0.175,13),
(3275,'F',0.5,0.405,0.14,0.6735,0.265,0.124,0.25,18),
(3276,'M',0.46,0.355,0.11,0.415,0.215,0.082,0.13,12),
(3277,'M',0.485,0.385,0.125,0.4775,0.2,0.0785,0.17,12),
(3278,'F',0.465,0.39,0.14,0.5555,0.213,0.1075,0.215,15),
(3279,'M',0.525,0.415,0.16,0.6445,0.26,0.1575,0.22,12),
(3280,'F',0.655,0.53,0.19,1.428,0.493,0.318,0.565,18),
(3281,'M',0.69,0.54,0.185,1.6195,0.533,0.353,0.555,24),
(3282,'M',0.55,0.45,0.17,0.81,0.317,0.157,0.22,11),
(3283,'F',0.58,0.475,0.165,1.0385,0.414,0.26,0.305,13),
(3284,'F',0.59,0.475,0.155,0.9715,0.371,0.235,0.28,11),
(3285,'M',0.565,0.44,0.155,0.868,0.348,0.217,0.26,11),
(3286,'F',0.665,0.57,0.185,1.522,0.6965,0.3025,0.405,13),
(3287,'F',0.62,0.51,0.175,1.1255,0.4985,0.227,0.315,14),
(3288,'M',0.55,0.46,0.13,0.7085,0.305,0.1455,0.205,12),
(3289,'F',0.605,0.475,0.145,1.0185,0.4695,0.225,0.27,15),
(3290,'M',0.535,0.42,0.16,0.72,0.275,0.164,0.225,15),
(3291,'F',0.51,0.395,0.12,0.6175,0.262,0.122,0.193,12),
(3292,'M',0.53,0.405,0.13,0.738,0.2845,0.17,0.193,9),
(3293,'F',0.495,0.375,0.15,0.597,0.2615,0.135,0.178,11),
(3294,'M',0.575,0.455,0.185,1.156,0.5525,0.243,0.295,13),
(3295,'F',0.63,0.5,0.16,1.22,0.4905,0.3,0.345,14),
(3296,'M',0.59,0.45,0.12,0.7485,0.3345,0.1315,0.22,14),
(3297,'F',0.605,0.485,0.165,1.0735,0.437,0.205,0.33,14),
(3298,'M',0.645,0.5,0.19,1.229,0.524,0.278,0.395,17),
(3299,'F',0.62,0.5,0.175,1.146,0.477,0.23,0.39,13),
(3300,'M',0.605,0.485,0.175,1.145,0.4325,0.27,0.405,16),
(3301,'F',0.615,0.5,0.205,1.1055,0.4445,0.227,0.39,16),
(3302,'F',0.66,0.525,0.19,1.67,0.6525,0.4875,0.49,11),
(3303,'F',0.71,0.575,0.175,1.555,0.6465,0.3705,0.52,15),
(3304,'F',0.565,0.45,0.185,0.9285,0.302,0.1805,0.265,12),
(3305,'F',0.57,0.435,0.14,0.8085,0.3235,0.183,0.22,16),
(3306,'I',0.6,0.445,0.175,1.057,0.383,0.216,0.355,16),
(3307,'I',0.41,0.3,0.115,0.2595,0.097,0.0515,0.08,10),
(3308,'F',0.45,0.325,0.135,0.438,0.1805,0.1165,0.11,9),
(3309,'M',0.275,0.2,0.08,0.099,0.037,0.024,0.03,5),
(3310,'I',0.485,0.355,0.12,0.5085,0.21,0.122,0.135,9),
(3311,'F',0.62,0.485,0.165,1.166,0.483,0.238,0.355,13),
(3312,'F',0.48,0.38,0.135,0.507,0.1915,0.1365,0.155,12),
(3313,'F',0.505,0.41,0.15,0.6345,0.243,0.1335,0.215,17),
(3314,'M',0.4,0.31,0.11,0.314,0.138,0.057,0.1,11),
(3315,'I',0.45,0.355,0.115,0.4385,0.184,0.108,0.1125,11),
(3316,'M',0.35,0.26,0.09,0.195,0.0745,0.041,0.0655,9),
(3317,'M',0.44,0.35,0.14,0.451,0.171,0.0705,0.184,16),
(3318,'M',0.265,0.2,0.065,0.084,0.034,0.0105,0.03,7),
(3319,'M',0.165,0.125,0.04,0.0245,0.0095,0.0045,0.008,4),
(3320,'F',0.705,0.555,0.2,1.4685,0.4715,0.3235,0.52,19),
(3321,'F',0.535,0.425,0.155,0.7765,0.302,0.1565,0.25,16),
(3322,'I',0.49,0.385,0.14,0.5425,0.198,0.127,0.175,11),
(3323,'F',0.48,0.37,0.13,0.5885,0.2475,0.1505,0.1595,15),
(3324,'F',0.395,0.3,0.105,0.3375,0.1435,0.0755,0.098,12),
(3325,'I',0.375,0.28,0.1,0.2565,0.1165,0.0585,0.0725,12),
(3326,'M',0.345,0.265,0.09,0.163,0.0615,0.037,0.0485,10),
(3327,'I',0.55,0.415,0.135,0.8095,0.2985,0.2015,0.28,12),
(3328,'I',0.635,0.48,0.2,1.3655,0.6255,0.2595,0.425,16),
(3329,'I',0.575,0.475,0.17,0.967,0.3775,0.284,0.275,13),
(3330,'F',0.545,0.435,0.15,0.6855,0.2905,0.145,0.225,10),
(3331,'F',0.385,0.305,0.125,0.314,0.146,0.0555,0.08,10),
(3332,'F',0.51,0.34,0.18,0.7005,0.312,0.165,0.2,11),
(3333,'I',0.44,0.34,0.125,0.4895,0.1735,0.0875,0.2,13),
(3334,'I',0.45,0.36,0.125,0.45,0.191,0.0865,0.145,12),
(3335,'I',0.39,0.3,0.105,0.259,0.0955,0.038,0.085,8),
(3336,'F',0.425,0.325,0.135,0.382,0.1465,0.079,0.14,12),
(3337,'F',0.45,0.35,0.125,0.4435,0.185,0.09,0.145,11),
(3338,'I',0.66,0.525,0.18,1.6935,0.6025,0.4005,0.42,15),
(3339,'F',0.685,0.525,0.175,1.71,0.5415,0.309,0.58,16),
(3340,'F',0.585,0.475,0.185,0.8575,0.3465,0.1785,0.275,12),
(3341,'I',0.54,0.435,0.145,0.97,0.4285,0.22,0.264,17),
(3342,'F',0.49,0.39,0.135,0.59,0.215,0.125,0.1845,12),
(3343,'M',0.43,0.33,0.095,0.34,0.1315,0.085,0.112,14),
(3344,'F',0.455,0.365,0.11,0.385,0.166,0.046,0.1345,13),
(3345,'I',0.495,0.38,0.145,0.515,0.175,0.098,0.212,13),
(3346,'F',0.48,0.38,0.145,0.59,0.232,0.141,0.23,12),
(3347,'I',0.47,0.4,0.16,0.51,0.1615,0.073,0.198,14),
(3348,'M',0.415,0.32,0.1,0.3005,0.1215,0.0575,0.104,11),
(3349,'I',0.49,0.385,0.115,0.683,0.3265,0.1615,0.165,13),
(3350,'I',0.47,0.375,0.105,0.468,0.1665,0.108,0.17,10),
(3351,'I',0.445,0.345,0.13,0.4075,0.1365,0.0645,0.18,11),
(3352,'F',0.51,0.38,0.13,0.584,0.224,0.1355,0.185,13),
(3353,'F',0.52,0.405,0.145,0.829,0.3535,0.1685,0.205,15),
(3354,'I',0.475,0.365,0.14,0.4545,0.171,0.118,0.158,8),
(3355,'F',0.455,0.36,0.11,0.4385,0.206,0.098,0.125,10),
(3356,'I',0.435,0.34,0.11,0.407,0.1685,0.073,0.13,10),
(3357,'I',0.39,0.3,0.1,0.3085,0.1385,0.0735,0.085,6),
(3358,'I',0.375,0.285,0.1,0.239,0.105,0.0555,0.07,8),
(3359,'M',0.285,0.215,0.075,0.106,0.0415,0.023,0.035,5),
(3360,'I',0.58,0.445,0.17,1.178,0.3935,0.2165,0.315,20),
(3361,'F',0.58,0.44,0.175,1.073,0.4005,0.2345,0.335,19),
(3362,'M',0.41,0.315,0.095,0.306,0.121,0.0735,0.09,9),
(3363,'M',0.41,0.3,0.1,0.301,0.124,0.069,0.09,9),
(3364,'I',0.54,0.405,0.15,0.7585,0.307,0.2075,0.19,10),
(3365,'M',0.33,0.245,0.085,0.171,0.0655,0.0365,0.055,11),
(3366,'I',0.44,0.31,0.115,0.3625,0.134,0.082,0.12,11),
(3367,'M',0.28,0.21,0.065,0.0905,0.035,0.02,0.03,5),
(3368,'I',0.59,0.465,0.195,1.0885,0.3685,0.187,0.375,17),
(3369,'I',0.61,0.48,0.165,1.097,0.4215,0.264,0.335,13),
(3370,'I',0.61,0.46,0.17,1.278,0.41,0.257,0.37,17),
(3371,'M',0.455,0.345,0.125,0.44,0.169,0.1065,0.135,12),
(3372,'M',0.33,0.235,0.09,0.163,0.0615,0.034,0.055,10),
(3373,'I',0.44,0.33,0.135,0.522,0.17,0.0905,0.195,16),
(3374,'M',0.54,0.405,0.155,0.9715,0.3225,0.194,0.29,19),
(3375,'F',0.475,0.375,0.125,0.588,0.237,0.1715,0.155,10),
(3376,'F',0.46,0.33,0.15,0.5325,0.2085,0.1805,0.125,10),
(3377,'I',0.31,0.235,0.09,0.127,0.048,0.031,0.04,6),
(3378,'I',0.255,0.19,0.07,0.0815,0.028,0.016,0.031,5),
(3379,'M',0.335,0.255,0.075,0.1635,0.0615,0.0345,0.057,8),
(3380,'I',0.295,0.21,0.08,0.1,0.038,0.026,0.031,8),
(3381,'I',0.19,0.13,0.045,0.0265,0.009,0.005,0.009,5),
(3382,'M',0.545,0.435,0.165,0.9955,0.3245,0.2665,0.325,19),
(3383,'M',0.495,0.4,0.12,0.6605,0.2605,0.161,0.19,15),
(3384,'M',0.5,0.375,0.13,0.721,0.3055,0.1725,0.22,14),
(3385,'F',0.305,0.225,0.07,0.1485,0.0585,0.0335,0.045,7),
(3386,'F',0.475,0.35,0.115,0.487,0.194,0.1455,0.125,13),
(3387,'M',0.515,0.4,0.125,0.955,0.341,0.2535,0.26,13),
(3388,'M',0.545,0.41,0.145,0.873,0.3035,0.196,0.31,18),
(3389,'M',0.74,0.535,0.185,1.65,0.734,0.4505,0.335,13),
(3390,'M',0.565,0.465,0.15,1.1285,0.377,0.3525,0.33,16),
(3391,'M',0.56,0.44,0.16,1.1115,0.5035,0.2785,0.26,10),
(3392,'M',0.545,0.42,0.125,0.9745,0.353,0.174,0.305,13),
(3393,'M',0.645,0.515,0.185,1.4605,0.5835,0.3155,0.41,19),
(3394,'M',0.575,0.435,0.13,1.0105,0.368,0.222,0.32,10),
(3395,'M',0.62,0.48,0.16,1.0765,0.412,0.253,0.3,13),
(3396,'F',0.605,0.45,0.165,1.2225,0.357,0.202,0.385,13),
(3397,'M',0.605,0.475,0.16,1.616,0.5495,0.332,0.34,18),
(3398,'F',0.475,0.375,0.15,0.559,0.1955,0.1215,0.1945,12),
(3399,'M',0.365,0.285,0.085,0.2205,0.0855,0.0515,0.07,9),
(3400,'F',0.46,0.35,0.115,0.44,0.19,0.1025,0.13,8),
(3401,'M',0.53,0.43,0.135,0.879,0.28,0.2165,0.25,10),
(3402,'M',0.48,0.395,0.15,0.6815,0.2145,0.1405,0.2495,18),
(3403,'M',0.455,0.345,0.15,0.5795,0.1685,0.125,0.215,13),
(3404,'I',0.35,0.265,0.11,0.209,0.066,0.059,0.075,9),
(3405,'M',0.37,0.28,0.105,0.224,0.0815,0.0575,0.075,8),
(3406,'I',0.34,0.25,0.075,0.1765,0.0785,0.0405,0.05,7),
(3407,'I',0.35,0.28,0.075,0.196,0.082,0.04,0.064,8),
(3408,'I',0.35,0.265,0.08,0.192,0.081,0.0465,0.053,6),
(3409,'I',0.39,0.315,0.09,0.3095,0.147,0.05,0.09,7),
(3410,'I',0.395,0.31,0.095,0.313,0.131,0.072,0.093,7),
(3411,'I',0.415,0.31,0.105,0.3595,0.167,0.083,0.0915,6),
(3412,'I',0.43,0.32,0.1,0.3855,0.192,0.0745,0.1,7),
(3413,'I',0.48,0.355,0.115,0.5785,0.25,0.106,0.184,8),
(3414,'M',0.49,0.395,0.12,0.674,0.3325,0.1235,0.185,9),
(3415,'F',0.49,0.37,0.105,0.5265,0.249,0.1005,0.148,7),
(3416,'F',0.56,0.465,0.16,1.0315,0.432,0.2025,0.337,9),
(3417,'M',0.56,0.45,0.14,0.9,0.472,0.182,0.218,7),
(3418,'M',0.58,0.46,0.15,1.0165,0.491,0.221,0.265,9),
(3419,'F',0.58,0.48,0.18,1.2495,0.4945,0.27,0.371,8),
(3420,'M',0.59,0.47,0.135,1.1685,0.539,0.279,0.28,8),
(3421,'F',0.595,0.475,0.165,1.148,0.444,0.214,0.37,10),
(3422,'M',0.6,0.475,0.15,1.089,0.5195,0.223,0.292,11),
(3423,'M',0.61,0.47,0.155,1.0325,0.497,0.2175,0.2785,9),
(3424,'F',0.63,0.475,0.15,1.172,0.536,0.254,0.316,11),
(3425,'M',0.64,0.51,0.17,1.3715,0.567,0.307,0.409,10),
(3426,'F',0.65,0.545,0.185,1.5055,0.6565,0.341,0.43,10),
(3427,'M',0.71,0.55,0.2,1.9045,0.882,0.44,0.5,13),
(3428,'M',0.74,0.605,0.2,2.4925,1.1455,0.575,0.5235,13),
(3429,'I',0.25,0.18,0.065,0.0805,0.0345,0.0185,0.0215,4),
(3430,'I',0.28,0.21,0.065,0.111,0.0425,0.0285,0.03,6),
(3431,'I',0.325,0.24,0.075,0.152,0.065,0.0305,0.045,6),
(3432,'I',0.35,0.265,0.095,0.199,0.073,0.049,0.06,5),
(3433,'I',0.36,0.27,0.09,0.219,0.097,0.0405,0.065,6),
(3434,'I',0.365,0.27,0.105,0.2155,0.0915,0.0475,0.063,6),
(3435,'I',0.37,0.28,0.09,0.2565,0.1255,0.0645,0.0645,6),
(3436,'I',0.375,0.285,0.09,0.257,0.1045,0.062,0.075,7),
(3437,'I',0.38,0.275,0.095,0.2505,0.0945,0.0655,0.075,6),
(3438,'I',0.395,0.3,0.09,0.279,0.134,0.049,0.075,8),
(3439,'I',0.43,0.335,0.105,0.378,0.188,0.0785,0.09,6),
(3440,'I',0.44,0.35,0.125,0.456,0.21,0.0955,0.131,8),
(3441,'I',0.465,0.37,0.1,0.5055,0.234,0.11,0.14,7),
(3442,'F',0.465,0.355,0.115,0.4705,0.1955,0.118,0.126,7),
(3443,'M',0.48,0.37,0.13,0.643,0.349,0.1155,0.135,8),
(3444,'I',0.485,0.37,0.1,0.513,0.219,0.1075,0.13,7),
(3445,'F',0.49,0.4,0.115,0.569,0.256,0.1325,0.145,9),
(3446,'I',0.495,0.4,0.145,0.578,0.2545,0.1305,0.1645,8),
(3447,'I',0.5,0.385,0.11,0.596,0.3015,0.104,0.151,8),
(3448,'F',0.505,0.39,0.12,0.5725,0.2555,0.1325,0.146,8),
(3449,'M',0.52,0.39,0.12,0.6435,0.2885,0.157,0.161,7),
(3450,'M',0.52,0.395,0.125,0.8115,0.4035,0.166,0.2,7),
(3451,'F',0.525,0.44,0.125,0.7115,0.3205,0.159,0.1915,7),
(3452,'M',0.55,0.44,0.155,0.9155,0.3645,0.195,0.25,8),
(3453,'F',0.555,0.44,0.145,0.8815,0.43,0.1975,0.2155,8),
(3454,'F',0.555,0.42,0.11,0.931,0.4445,0.171,0.225,8),
(3455,'F',0.575,0.46,0.165,1.065,0.4985,0.2145,0.2815,8),
(3456,'M',0.6,0.475,0.155,1.1385,0.502,0.2295,0.31,9),
(3457,'F',0.61,0.48,0.16,1.234,0.598,0.238,0.315,12),
(3458,'F',0.61,0.495,0.175,1.2635,0.53,0.315,0.3455,10),
(3459,'F',0.61,0.47,0.16,1.0745,0.4925,0.236,0.29,8),
(3460,'M',0.615,0.505,0.19,1.403,0.6715,0.2925,0.365,8),
(3461,'M',0.62,0.485,0.165,1.1325,0.5235,0.2505,0.2825,9),
(3462,'F',0.625,0.495,0.16,1.1115,0.4495,0.2825,0.345,11),
(3463,'F',0.625,0.47,0.17,1.255,0.525,0.2415,0.405,10),
(3464,'M',0.625,0.485,0.17,1.437,0.5855,0.293,0.475,11),
(3465,'M',0.635,0.495,0.155,1.3635,0.583,0.2985,0.295,10),
(3466,'F',0.64,0.48,0.195,1.1435,0.4915,0.2345,0.353,9),
(3467,'M',0.64,0.5,0.17,1.4545,0.642,0.3575,0.354,9),
(3468,'M',0.66,0.525,0.18,1.478,0.5815,0.381,0.372,10),
(3469,'F',0.665,0.52,0.165,1.6885,0.7295,0.407,0.4265,11),
(3470,'F',0.715,0.585,0.23,2.0725,0.8655,0.4095,0.565,10),
(3471,'M',0.72,0.565,0.2,1.787,0.718,0.385,0.529,11),
(3472,'F',0.725,0.58,0.185,1.523,0.8045,0.3595,0.4375,9),
(3473,'I',0.165,0.12,0.05,0.021,0.0075,0.0045,0.014,3),
(3474,'I',0.21,0.15,0.055,0.0455,0.02,0.0065,0.013,4),
(3475,'I',0.355,0.265,0.085,0.2435,0.122,0.0525,0.06,6),
(3476,'I',0.4,0.315,0.085,0.2675,0.116,0.0585,0.0765,6),
(3477,'I',0.4,0.29,0.1,0.258,0.104,0.059,0.0815,7),
(3478,'I',0.4,0.3,0.11,0.2985,0.1375,0.071,0.075,6),
(3479,'I',0.435,0.335,0.11,0.411,0.2025,0.0945,0.1,7),
(3480,'I',0.44,0.33,0.11,0.38,0.197,0.079,0.09,7),
(3481,'I',0.45,0.34,0.105,0.4385,0.21,0.0925,0.12,8),
(3482,'I',0.465,0.345,0.105,0.4015,0.242,0.0345,0.109,6),
(3483,'I',0.47,0.355,0.145,0.4485,0.156,0.102,0.123,7),
(3484,'I',0.47,0.355,0.115,0.4155,0.167,0.084,0.139,7),
(3485,'I',0.475,0.42,0.16,0.7095,0.35,0.1505,0.1845,8),
(3486,'I',0.485,0.37,0.115,0.637,0.38,0.1335,0.128,7),
(3487,'F',0.505,0.475,0.16,1.1155,0.509,0.239,0.3065,8),
(3488,'I',0.51,0.405,0.13,0.599,0.3065,0.1155,0.1485,8),
(3489,'I',0.52,0.38,0.13,0.5345,0.2375,0.122,0.1535,8),
(3490,'F',0.53,0.42,0.14,0.627,0.2905,0.1165,0.183,8),
(3491,'M',0.535,0.42,0.16,0.7465,0.348,0.1515,0.2185,10),
(3492,'M',0.55,0.44,0.16,0.985,0.4645,0.201,0.27,8),
(3493,'M',0.555,0.44,0.145,0.85,0.4165,0.1685,0.23,8),
(3494,'M',0.555,0.44,0.15,0.838,0.4155,0.146,0.23,8),
(3495,'F',0.555,0.43,0.135,0.812,0.4055,0.163,0.2215,9),
(3496,'M',0.56,0.415,0.13,0.7615,0.3695,0.17,0.1955,8),
(3497,'M',0.575,0.44,0.145,0.87,0.3945,0.2195,0.225,8),
(3498,'F',0.585,0.45,0.145,0.9835,0.4845,0.242,0.22,9),
(3499,'M',0.59,0.46,0.145,0.929,0.38,0.24,0.255,10),
(3500,'F',0.595,0.47,0.165,1.0155,0.491,0.1905,0.289,9),
(3501,'M',0.6,0.41,0.145,0.939,0.4475,0.196,0.268,8),
(3502,'M',0.6,0.475,0.16,1.164,0.5045,0.2635,0.335,12),
(3503,'M',0.61,0.47,0.175,1.214,0.5315,0.2835,0.325,10),
(3504,'F',0.615,0.49,0.19,1.1345,0.4695,0.257,0.348,11),
(3505,'F',0.62,0.51,0.18,1.233,0.592,0.274,0.322,10),
(3506,'M',0.625,0.495,0.18,1.0815,0.4715,0.254,0.3135,10),
(3507,'M',0.625,0.47,0.175,1.179,0.605,0.258,0.271,9),
(3508,'F',0.64,0.5,0.165,1.1635,0.554,0.239,0.32,11),
(3509,'F',0.64,0.475,0.175,1.1545,0.4865,0.341,0.288,9),
(3510,'F',0.645,0.52,0.175,1.3345,0.667,0.2665,0.355,10),
(3511,'M',0.65,0.505,0.18,1.469,0.7115,0.3335,0.38,9),
(3512,'M',0.655,0.52,0.18,1.492,0.7185,0.36,0.355,11),
(3513,'F',0.655,0.54,0.175,1.5585,0.7285,0.402,0.385,11),
(3514,'F',0.66,0.5,0.175,1.3275,0.556,0.2805,0.4085,9),
(3515,'M',0.67,0.525,0.18,1.6615,0.8005,0.3645,0.43,10),
(3516,'F',0.69,0.525,0.19,1.492,0.6425,0.3905,0.42,12),
(3517,'F',0.7,0.575,0.2,1.7365,0.7755,0.3965,0.461,11),
(3518,'F',0.7,0.56,0.175,1.6605,0.8605,0.3275,0.398,11),
(3519,'M',0.71,0.57,0.195,1.348,0.8985,0.4435,0.4535,11),
(3520,'M',0.715,0.545,0.18,1.7405,0.871,0.347,0.449,10),
(3521,'F',0.72,0.545,0.185,1.7185,0.7925,0.401,0.468,11),
(3522,'I',0.215,0.15,0.055,0.041,0.015,0.009,0.0125,3),
(3523,'I',0.24,0.185,0.06,0.0655,0.0295,0.0005,0.02,4),
(3524,'I',0.26,0.205,0.07,0.097,0.0415,0.019,0.0305,4),
(3525,'I',0.32,0.24,0.085,0.131,0.0615,0.0265,0.038,6),
(3526,'I',0.33,0.23,0.085,0.1695,0.079,0.026,0.0505,6),
(3527,'I',0.335,0.26,0.085,0.192,0.097,0.03,0.054,6),
(3528,'I',0.35,0.26,0.09,0.1765,0.072,0.0355,0.0575,7),
(3529,'I',0.35,0.265,0.085,0.1735,0.0775,0.034,0.056,6),
(3530,'I',0.36,0.265,0.075,0.1785,0.0785,0.035,0.054,6),
(3531,'I',0.36,0.265,0.09,0.2055,0.096,0.037,0.0585,7),
(3532,'I',0.365,0.275,0.09,0.2345,0.108,0.051,0.0625,7),
(3533,'I',0.38,0.285,0.09,0.2305,0.1005,0.039,0.0775,7),
(3534,'I',0.4,0.31,0.115,0.314,0.1545,0.0595,0.087,6),
(3535,'I',0.4,0.315,0.09,0.33,0.151,0.068,0.08,6),
(3536,'I',0.4,0.265,0.1,0.2775,0.1245,0.0605,0.08,9),
(3537,'I',0.425,0.325,0.11,0.405,0.1695,0.092,0.1065,8),
(3538,'I',0.43,0.325,0.105,0.309,0.119,0.08,0.098,6),
(3539,'M',0.435,0.335,0.11,0.4385,0.2075,0.0715,0.1315,7),
(3540,'I',0.435,0.34,0.12,0.396,0.1775,0.081,0.125,8),
(3541,'I',0.445,0.355,0.095,0.3615,0.1415,0.0785,0.12,8),
(3542,'I',0.45,0.35,0.11,0.514,0.253,0.1045,0.14,8),
(3543,'I',0.455,0.435,0.11,0.4265,0.195,0.09,0.1205,8),
(3544,'I',0.46,0.34,0.09,0.384,0.1795,0.068,0.11,8),
(3545,'I',0.475,0.355,0.125,0.4865,0.2155,0.1105,0.142,9),
(3546,'I',0.475,0.36,0.135,0.4355,0.196,0.0925,0.125,8),
(3547,'I',0.475,0.35,0.115,0.498,0.2375,0.099,0.14,7),
(3548,'I',0.48,0.355,0.125,0.494,0.2385,0.0835,0.15,9),
(3549,'F',0.495,0.37,0.12,0.594,0.28,0.11,0.1375,7),
(3550,'I',0.5,0.365,0.125,0.528,0.229,0.103,0.1645,9),
(3551,'M',0.505,0.39,0.115,0.5585,0.2575,0.119,0.1535,8),
(3552,'I',0.515,0.4,0.135,0.636,0.3055,0.1215,0.1855,9),
(3553,'I',0.525,0.39,0.105,0.567,0.2875,0.1075,0.16,8),
(3554,'I',0.53,0.405,0.13,0.6615,0.2945,0.1395,0.19,9),
(3555,'I',0.53,0.42,0.13,0.658,0.296,0.1245,0.198,8),
(3556,'M',0.535,0.415,0.135,0.78,0.3165,0.169,0.2365,8),
(3557,'I',0.535,0.41,0.13,0.6075,0.268,0.1225,0.1975,9),
(3558,'I',0.54,0.41,0.135,0.7025,0.31,0.177,0.2,8),
(3559,'I',0.55,0.425,0.155,0.8725,0.412,0.187,0.2425,10),
(3560,'F',0.565,0.45,0.175,1.2365,0.5305,0.2455,0.308,10),
(3561,'M',0.57,0.47,0.155,1.186,0.6355,0.2315,0.277,10),
(3562,'I',0.57,0.42,0.13,0.7745,0.3535,0.1505,0.2365,9),
(3563,'F',0.57,0.42,0.16,0.8875,0.4315,0.1915,0.223,8),
(3564,'I',0.575,0.455,0.155,0.8725,0.349,0.2095,0.285,8),
(3565,'I',0.575,0.44,0.125,0.8515,0.4555,0.1715,0.1965,9),
(3566,'F',0.575,0.475,0.16,0.895,0.3605,0.221,0.271,9),
(3567,'M',0.575,0.45,0.155,0.886,0.3605,0.211,0.2575,9),
(3568,'I',0.58,0.46,0.14,0.9265,0.4135,0.1845,0.27,10),
(3569,'I',0.58,0.46,0.14,0.8295,0.3915,0.165,0.238,10),
(3570,'I',0.58,0.47,0.15,0.907,0.444,0.1855,0.2445,11),
(3571,'M',0.58,0.47,0.165,1.041,0.54,0.166,0.279,9),
(3572,'F',0.585,0.465,0.165,0.9355,0.4035,0.2275,0.259,9),
(3573,'F',0.585,0.46,0.165,1.058,0.486,0.25,0.294,9),
(3574,'F',0.595,0.465,0.145,0.7955,0.3425,0.1795,0.2425,10),
(3575,'F',0.6,0.47,0.17,1.0805,0.4995,0.2245,0.3205,9),
(3576,'M',0.6,0.47,0.15,0.928,0.4225,0.183,0.275,8),
(3577,'F',0.6,0.475,0.155,1.059,0.441,0.19,0.39,11),
(3578,'M',0.6,0.475,0.23,1.157,0.522,0.2235,0.36,11),
(3579,'F',0.6,0.475,0.17,1.088,0.4905,0.2475,0.31,10),
(3580,'F',0.6,0.485,0.145,0.776,0.3545,0.1585,0.239,9),
(3581,'F',0.62,0.48,0.165,1.043,0.4835,0.221,0.31,10),
(3582,'M',0.625,0.48,0.16,1.1415,0.5795,0.2145,0.29,9),
(3583,'F',0.625,0.475,0.16,1.3335,0.605,0.2875,0.319,10),
(3584,'F',0.625,0.5,0.175,1.273,0.564,0.302,0.374,9),
(3585,'M',0.625,0.49,0.165,1.1835,0.517,0.2375,0.39,11),
(3586,'M',0.625,0.485,0.16,1.2135,0.631,0.2235,0.302,9),
(3587,'I',0.63,0.465,0.15,1.0315,0.4265,0.24,0.325,11),
(3588,'M',0.635,0.495,0.17,1.3695,0.657,0.3055,0.365,10),
(3589,'M',0.65,0.515,0.185,1.3745,0.75,0.1805,0.369,12),
(3590,'M',0.65,0.515,0.18,1.463,0.658,0.3135,0.4115,11),
(3591,'F',0.65,0.52,0.195,1.6275,0.689,0.3905,0.432,11),
(3592,'F',0.65,0.475,0.165,1.3875,0.58,0.3485,0.3095,9),
(3593,'M',0.655,0.525,0.16,1.46,0.686,0.311,0.405,11),
(3594,'F',0.655,0.53,0.165,1.2835,0.583,0.1255,0.4,8),
(3595,'F',0.66,0.5,0.155,1.3765,0.6485,0.288,0.335,12),
(3596,'M',0.66,0.515,0.2,1.6465,0.749,0.422,0.401,11),
(3597,'M',0.675,0.515,0.145,1.265,0.6025,0.299,0.325,10),
(3598,'M',0.685,0.53,0.17,1.56,0.647,0.383,0.465,11),
(3599,'M',0.715,0.52,0.18,1.6,0.708,0.3525,0.445,12),
(3600,'M',0.735,0.555,0.22,2.333,1.2395,0.3645,0.6195,12),
(3601,'I',0.175,0.125,0.04,0.028,0.0095,0.008,0.009,4),
(3602,'I',0.37,0.285,0.095,0.226,0.1135,0.0515,0.0675,8),
(3603,'I',0.395,0.3,0.09,0.2855,0.1385,0.0625,0.077,5),
(3604,'I',0.42,0.325,0.11,0.325,0.1245,0.0755,0.1025,7),
(3605,'I',0.455,0.37,0.11,0.514,0.2385,0.1235,0.126,8),
(3606,'I',0.495,0.375,0.115,0.5755,0.31,0.1145,0.1395,8),
(3607,'F',0.51,0.375,0.11,0.5805,0.2865,0.118,0.148,7),
(3608,'M',0.515,0.39,0.14,0.678,0.341,0.1325,0.119,8),
(3609,'M',0.545,0.43,0.155,0.8035,0.409,0.144,0.228,7),
(3610,'F',0.555,0.405,0.12,0.913,0.4585,0.196,0.2065,9),
(3611,'M',0.58,0.45,0.16,0.8675,0.3935,0.221,0.215,9),
(3612,'F',0.59,0.465,0.17,1.0425,0.4635,0.24,0.27,10),
(3613,'M',0.6,0.46,0.18,1.14,0.423,0.2575,0.365,10),
(3614,'F',0.61,0.49,0.17,1.3475,0.7045,0.25,0.3045,11),
(3615,'M',0.615,0.475,0.155,1.0735,0.4375,0.2585,0.31,11),
(3616,'M',0.615,0.475,0.19,1.4335,0.7315,0.305,0.3285,9),
(3617,'M',0.615,0.495,0.2,1.304,0.5795,0.3115,0.371,14),
(3618,'M',0.62,0.46,0.16,0.9505,0.4915,0.2,0.228,9),
(3619,'M',0.63,0.515,0.17,1.385,0.6355,0.2955,0.38,11),
(3620,'F',0.64,0.5,0.17,1.12,0.4955,0.2645,0.32,12),
(3621,'F',0.64,0.5,0.17,1.2645,0.565,0.3375,0.315,9),
(3622,'F',0.655,0.455,0.17,1.275,0.583,0.303,0.333,8),
(3623,'M',0.655,0.505,0.165,1.27,0.6035,0.262,0.335,10),
(3624,'M',0.66,0.53,0.175,1.583,0.7395,0.3505,0.405,10),
(3625,'F',0.665,0.5,0.175,1.4355,0.643,0.345,0.37,9),
(3626,'F',0.67,0.525,0.195,1.42,0.573,0.368,0.3905,10),
(3627,'M',0.69,0.53,0.19,1.5955,0.678,0.331,0.48,10),
(3628,'M',0.715,0.525,0.2,1.89,0.95,0.436,0.4305,10),
(3629,'F',0.735,0.565,0.225,2.037,0.87,0.5145,0.5675,13),
(3630,'I',0.27,0.205,0.05,0.084,0.03,0.0185,0.029,6),
(3631,'I',0.285,0.225,0.07,0.1005,0.0425,0.0185,0.035,7),
(3632,'I',0.295,0.22,0.085,0.1285,0.0585,0.027,0.0365,5),
(3633,'I',0.3,0.225,0.075,0.1345,0.057,0.028,0.044,5),
(3634,'I',0.3,0.22,0.065,0.1195,0.052,0.0155,0.035,5),
(3635,'I',0.36,0.265,0.085,0.1895,0.0725,0.0515,0.055,6),
(3636,'I',0.37,0.275,0.095,0.257,0.1015,0.055,0.0825,6),
(3637,'I',0.39,0.29,0.09,0.2745,0.135,0.0455,0.078,8),
(3638,'I',0.435,0.325,0.1,0.342,0.1335,0.0835,0.105,6),
(3639,'I',0.44,0.34,0.105,0.344,0.123,0.081,0.125,8),
(3640,'I',0.44,0.32,0.095,0.3275,0.1495,0.059,0.1,8),
(3641,'I',0.445,0.345,0.12,0.4035,0.169,0.0825,0.13,7),
(3642,'I',0.465,0.37,0.115,0.4075,0.1515,0.0935,0.1455,9),
(3643,'I',0.465,0.355,0.12,0.4975,0.2375,0.099,0.14,8),
(3644,'I',0.47,0.345,0.12,0.3685,0.1525,0.0615,0.125,8),
(3645,'I',0.475,0.365,0.105,0.4175,0.1645,0.099,0.127,7),
(3646,'I',0.475,0.335,0.1,0.4425,0.1895,0.086,0.135,9),
(3647,'I',0.475,0.35,0.125,0.4225,0.1905,0.079,0.1355,9),
(3648,'I',0.485,0.365,0.125,0.426,0.163,0.0965,0.151,8),
(3649,'I',0.49,0.39,0.12,0.511,0.2205,0.103,0.1745,9),
(3650,'I',0.515,0.405,0.13,0.573,0.213,0.134,0.195,9),
(3651,'I',0.52,0.415,0.14,0.6385,0.2945,0.1405,0.171,8),
(3652,'I',0.525,0.405,0.125,0.657,0.2985,0.1505,0.168,10),
(3653,'F',0.525,0.425,0.14,0.8735,0.4205,0.182,0.2225,10),
(3654,'I',0.53,0.425,0.13,0.781,0.3905,0.2005,0.215,9),
(3655,'I',0.53,0.42,0.14,0.6765,0.256,0.1855,0.208,9),
(3656,'M',0.53,0.41,0.125,0.769,0.346,0.173,0.215,9),
(3657,'I',0.53,0.395,0.125,0.6235,0.2975,0.108,0.195,11),
(3658,'M',0.535,0.405,0.14,0.7315,0.336,0.156,0.19,7),
(3659,'I',0.535,0.45,0.155,0.8075,0.3655,0.148,0.2595,10),
(3660,'M',0.545,0.41,0.14,0.737,0.349,0.15,0.212,9),
(3661,'F',0.545,0.41,0.125,0.654,0.2945,0.1315,0.205,10),
(3662,'I',0.55,0.415,0.15,0.7915,0.3535,0.176,0.236,10),
(3663,'I',0.55,0.45,0.14,0.753,0.3445,0.1325,0.24,8),
(3664,'I',0.55,0.4,0.135,0.717,0.3315,0.1495,0.221,9),
(3665,'I',0.555,0.43,0.15,0.783,0.345,0.1755,0.247,9),
(3666,'I',0.575,0.45,0.145,0.872,0.4675,0.18,0.217,9),
(3667,'I',0.575,0.44,0.15,0.983,0.486,0.215,0.239,8),
(3668,'F',0.585,0.42,0.155,1.034,0.437,0.2225,0.32,11),
(3669,'F',0.585,0.465,0.145,0.9855,0.4325,0.2145,0.2845,10),
(3670,'I',0.585,0.46,0.14,0.7635,0.326,0.153,0.265,9),
(3671,'M',0.59,0.465,0.135,0.9895,0.4235,0.199,0.28,8),
(3672,'I',0.595,0.47,0.135,0.9365,0.434,0.184,0.287,10),
(3673,'F',0.595,0.44,0.135,0.964,0.5005,0.1715,0.2575,10),
(3674,'F',0.595,0.46,0.155,1.0455,0.4565,0.24,0.3085,10),
(3675,'F',0.595,0.45,0.165,1.081,0.49,0.2525,0.279,12),
(3676,'M',0.6,0.47,0.16,1.012,0.441,0.2015,0.305,10),
(3677,'F',0.6,0.5,0.16,1.122,0.5095,0.256,0.309,10),
(3678,'M',0.605,0.49,0.165,1.1245,0.492,0.222,0.3555,11),
(3679,'F',0.605,0.49,0.15,1.1345,0.4305,0.2525,0.35,10),
(3680,'M',0.61,0.45,0.19,1.0805,0.517,0.2495,0.2935,10),
(3681,'F',0.61,0.495,0.165,1.0835,0.4525,0.273,0.317,9),
(3682,'M',0.615,0.47,0.175,1.242,0.5675,0.287,0.317,11),
(3683,'M',0.62,0.5,0.18,1.3915,0.726,0.2795,0.332,11),
(3684,'M',0.62,0.525,0.155,1.085,0.454,0.1965,0.35,10),
(3685,'I',0.62,0.47,0.155,0.966,0.447,0.171,0.284,11),
(3686,'M',0.62,0.48,0.165,1.0855,0.481,0.2575,0.305,10),
(3687,'F',0.625,0.485,0.135,1.3025,0.61,0.2675,0.3605,14),
(3688,'I',0.625,0.485,0.16,1.15,0.5255,0.257,0.3315,11),
(3689,'I',0.63,0.49,0.17,1.217,0.5515,0.212,0.31,11),
(3690,'F',0.63,0.505,0.195,1.306,0.516,0.3305,0.375,9),
(3691,'M',0.64,0.5,0.175,1.273,0.5065,0.2925,0.405,13),
(3692,'M',0.645,0.51,0.19,1.4865,0.6445,0.296,0.425,12),
(3693,'M',0.65,0.52,0.17,1.3655,0.6155,0.2885,0.36,11),
(3694,'M',0.65,0.495,0.17,1.276,0.6215,0.2305,0.399,11),
(3695,'M',0.65,0.495,0.16,1.2075,0.55,0.2695,0.32,10),
(3696,'F',0.65,0.52,0.195,1.281,0.5985,0.246,0.3825,10),
(3697,'M',0.65,0.525,0.205,1.4275,0.69,0.306,0.4355,13),
(3698,'M',0.65,0.51,0.175,1.155,0.4955,0.2025,0.385,12),
(3699,'F',0.65,0.51,0.175,1.35,0.575,0.3155,0.3885,10),
(3700,'M',0.65,0.525,0.19,1.3685,0.5975,0.296,0.4,11),
(3701,'F',0.66,0.53,0.17,1.431,0.622,0.309,0.398,10),
(3702,'M',0.66,0.51,0.18,1.261,0.5,0.2335,0.339,10),
(3703,'F',0.665,0.54,0.195,1.764,0.8505,0.3615,0.47,11),
(3704,'F',0.67,0.51,0.155,1.278,0.5605,0.3045,0.358,11),
(3705,'M',0.67,0.54,0.195,1.217,0.532,0.2735,0.3315,11),
(3706,'F',0.67,0.54,0.2,1.46,0.6435,0.328,0.4165,9),
(3707,'F',0.675,0.535,0.185,1.5575,0.7035,0.402,0.4,11),
(3708,'M',0.675,0.51,0.17,1.527,0.809,0.318,0.341,11),
(3709,'F',0.675,0.53,0.195,1.4985,0.62,0.375,0.425,9),
(3710,'M',0.685,0.55,0.19,1.885,0.89,0.41,0.4895,10),
(3711,'M',0.685,0.535,0.175,1.432,0.637,0.247,0.46,11),
(3712,'M',0.705,0.55,0.21,1.4385,0.655,0.3255,0.462,11),
(3713,'F',0.705,0.53,0.17,1.564,0.612,0.394,0.44,10),
(3714,'M',0.71,0.555,0.175,2.14,1.2455,0.3725,0.434,11),
(3715,'F',0.725,0.56,0.185,1.792,0.873,0.367,0.435,11),
(3716,'M',0.78,0.6,0.21,2.548,1.1945,0.5745,0.6745,11),
(3717,'I',0.235,0.13,0.075,0.1585,0.0685,0.037,0.0465,5),
(3718,'I',0.35,0.25,0.1,0.4015,0.1725,0.063,0.1255,7),
(3719,'I',0.36,0.25,0.115,0.465,0.21,0.1055,0.128,7),
(3720,'I',0.38,0.28,0.095,0.2885,0.165,0.0435,0.067,7),
(3721,'F',0.38,0.32,0.115,0.6475,0.323,0.1325,0.164,7),
(3722,'M',0.43,0.31,0.13,0.6485,0.2735,0.163,0.184,9),
(3723,'I',0.465,0.36,0.105,0.452,0.22,0.159,0.1035,9),
(3724,'I',0.47,0.355,0.12,0.4915,0.1765,0.1125,0.1325,9),
(3725,'F',0.485,0.365,0.15,0.9145,0.4145,0.199,0.273,7),
(3726,'M',0.495,0.375,0.155,0.976,0.45,0.2285,0.2475,9),
(3727,'I',0.5,0.395,0.145,0.7865,0.332,0.1815,0.2455,8),
(3728,'M',0.505,0.4,0.15,0.775,0.3445,0.157,0.185,7),
(3729,'I',0.51,0.375,0.15,0.8415,0.3845,0.156,0.255,10),
(3730,'M',0.51,0.38,0.135,0.681,0.3435,0.142,0.17,9),
(3731,'M',0.515,0.37,0.115,0.6145,0.3415,0.155,0.146,9),
(3732,'F',0.55,0.415,0.18,1.1655,0.502,0.301,0.311,9),
(3733,'F',0.575,0.42,0.19,1.764,0.914,0.377,0.4095,10),
(3734,'M',0.605,0.455,0.16,1.1215,0.533,0.273,0.271,10),
(3735,'M',0.615,0.505,0.165,1.167,0.4895,0.2955,0.345,10),
(3736,'M',0.615,0.475,0.15,1.0375,0.476,0.2325,0.283,9),
(3737,'M',0.625,0.48,0.18,1.223,0.565,0.2975,0.3375,10),
(3738,'M',0.625,0.47,0.15,1.124,0.556,0.2315,0.287,9),
(3739,'F',0.635,0.505,0.17,1.2635,0.512,0.322,0.355,9),
(3740,'F',0.65,0.525,0.165,1.238,0.647,0.2485,0.3005,9),
(3741,'F',0.65,0.5,0.17,1.4045,0.694,0.318,0.3235,11),
(3742,'F',0.67,0.525,0.195,1.37,0.6065,0.2955,0.407,12),
(3743,'F',0.695,0.525,0.205,1.8185,0.819,0.4025,0.4525,13),
(3744,'F',0.705,0.555,0.195,1.7525,0.7105,0.4215,0.516,12),
(3745,'I',0.275,0.205,0.065,0.101,0.041,0.021,0.034,5),
(3746,'I',0.285,0.205,0.07,0.106,0.039,0.0285,0.034,5),
(3747,'I',0.36,0.265,0.085,0.1865,0.0675,0.037,0.0615,7),
(3748,'I',0.385,0.29,0.1,0.2575,0.1,0.061,0.086,6),
(3749,'I',0.4,0.315,0.1,0.3225,0.143,0.0735,0.091,6),
(3750,'I',0.43,0.33,0.095,0.32,0.118,0.065,0.123,7),
(3751,'I',0.435,0.375,0.11,0.4155,0.17,0.076,0.145,8),
(3752,'I',0.45,0.335,0.115,0.3935,0.195,0.071,0.11,7),
(3753,'I',0.475,0.355,0.135,0.4775,0.2145,0.09,0.1435,8),
(3754,'I',0.475,0.36,0.11,0.452,0.191,0.099,0.13,8),
(3755,'I',0.485,0.37,0.14,0.5065,0.2425,0.088,0.1465,8),
(3756,'I',0.51,0.395,0.105,0.5525,0.234,0.127,0.165,8),
(3757,'I',0.515,0.39,0.12,0.565,0.235,0.135,0.179,9),
(3758,'I',0.52,0.41,0.14,0.699,0.3395,0.129,0.1945,10),
(3759,'I',0.525,0.4,0.14,0.6055,0.2605,0.108,0.21,9),
(3760,'M',0.53,0.425,0.155,0.7905,0.307,0.171,0.2595,9),
(3761,'M',0.53,0.425,0.13,0.702,0.2975,0.1395,0.22,9),
(3762,'M',0.53,0.42,0.135,0.675,0.294,0.156,0.1825,10),
(3763,'I',0.53,0.395,0.115,0.475,0.2025,0.101,0.148,8),
(3764,'I',0.53,0.41,0.15,0.612,0.2435,0.1525,0.1895,11),
(3765,'I',0.535,0.4,0.145,0.705,0.3065,0.1365,0.22,10),
(3766,'I',0.535,0.45,0.135,0.728,0.2845,0.1845,0.265,9),
(3767,'F',0.555,0.44,0.14,0.846,0.346,0.1715,0.2735,10),
(3768,'M',0.555,0.46,0.16,0.86,0.3345,0.1935,0.275,10),
(3769,'M',0.56,0.465,0.145,0.8875,0.3345,0.22,0.2695,9),
(3770,'F',0.56,0.43,0.145,0.898,0.3895,0.2325,0.245,9),
(3771,'I',0.565,0.43,0.125,0.6545,0.2815,0.139,0.21,9),
(3772,'I',0.575,0.45,0.145,0.795,0.364,0.1505,0.26,10),
(3773,'M',0.575,0.465,0.12,1.0535,0.516,0.2185,0.235,9),
(3774,'F',0.575,0.46,0.15,0.927,0.333,0.207,0.2985,9),
(3775,'I',0.58,0.42,0.14,0.701,0.3285,0.102,0.2255,9),
(3776,'M',0.58,0.45,0.155,0.8275,0.321,0.1975,0.2445,8),
(3777,'F',0.585,0.42,0.155,0.9845,0.442,0.2155,0.2875,13),
(3778,'M',0.585,0.47,0.145,0.9565,0.4025,0.2365,0.265,9),
(3779,'I',0.59,0.45,0.125,0.86,0.437,0.1515,0.245,9),
(3780,'M',0.595,0.48,0.185,1.1785,0.526,0.2975,0.314,10),
(3781,'M',0.615,0.48,0.185,1.2205,0.4985,0.315,0.33,10),
(3782,'M',0.615,0.455,0.13,0.9685,0.49,0.182,0.2655,10),
(3783,'F',0.62,0.5,0.175,1.107,0.4895,0.24,0.343,11),
(3784,'I',0.62,0.48,0.18,1.1305,0.5285,0.2655,0.306,12),
(3785,'M',0.62,0.48,0.155,1.2555,0.527,0.374,0.3175,11),
(3786,'M',0.625,0.495,0.155,1.177,0.5055,0.278,0.345,9),
(3787,'M',0.625,0.5,0.185,1.2425,0.5995,0.248,0.335,10),
(3788,'M',0.63,0.49,0.16,1.09,0.407,0.224,0.354,12),
(3789,'F',0.63,0.475,0.15,1.072,0.433,0.2975,0.315,8),
(3790,'F',0.645,0.51,0.155,1.129,0.5015,0.24,0.342,10),
(3791,'F',0.65,0.505,0.175,1.2075,0.5105,0.262,0.39,10),
(3792,'F',0.65,0.495,0.175,1.227,0.528,0.258,0.37,11),
(3793,'F',0.655,0.52,0.175,1.472,0.6275,0.27,0.45,13),
(3794,'F',0.665,0.525,0.18,1.5785,0.678,0.229,0.456,14),
(3795,'M',0.67,0.52,0.175,1.4755,0.6275,0.379,0.374,10),
(3796,'M',0.675,0.54,0.175,1.5545,0.6645,0.278,0.512,12),
(3797,'F',0.675,0.54,0.21,1.593,0.686,0.318,0.45,11),
(3798,'M',0.695,0.58,0.2,1.8995,0.675,0.478,0.5295,13),
(3799,'F',0.695,0.535,0.175,1.361,0.5465,0.2815,0.465,10),
(3800,'F',0.705,0.56,0.17,1.4575,0.607,0.318,0.44,11),
(3801,'M',0.74,0.58,0.205,2.381,0.8155,0.4695,0.488,12),
(3802,'I',0.205,0.155,0.045,0.0495,0.0235,0.011,0.014,3),
(3803,'I',0.305,0.23,0.075,0.1455,0.0595,0.0305,0.05,6),
(3804,'I',0.32,0.23,0.06,0.129,0.0615,0.0275,0.0355,7),
(3805,'I',0.355,0.27,0.1,0.2255,0.11,0.042,0.064,7),
(3806,'M',0.425,0.305,0.11,0.359,0.173,0.0875,0.0975,9),
(3807,'I',0.425,0.31,0.095,0.3505,0.1645,0.071,0.1,8),
(3808,'F',0.45,0.365,0.115,0.5885,0.318,0.121,0.1325,8),
(3809,'M',0.515,0.385,0.13,0.623,0.2855,0.1285,0.175,10),
(3810,'F',0.52,0.375,0.135,0.5375,0.221,0.117,0.17,8),
(3811,'I',0.525,0.4,0.125,0.5655,0.2435,0.119,0.175,8),
(3812,'M',0.555,0.445,0.13,0.8625,0.4225,0.155,0.24,9),
(3813,'F',0.61,0.49,0.17,1.137,0.4605,0.2825,0.344,12),
(3814,'I',0.35,0.26,0.095,0.221,0.0985,0.043,0.07,8),
(3815,'I',0.38,0.275,0.095,0.2425,0.106,0.0485,0.21,6),
(3816,'I',0.46,0.34,0.1,0.386,0.1805,0.0875,0.0965,8),
(3817,'M',0.465,0.355,0.12,0.5315,0.2725,0.097,0.1395,8),
(3818,'M',0.475,0.385,0.12,0.562,0.289,0.0905,0.153,8),
(3819,'M',0.565,0.445,0.14,0.836,0.406,0.1605,0.2245,9),
(3820,'M',0.57,0.45,0.14,0.9275,0.477,0.1605,0.2515,8),
(3821,'M',0.57,0.44,0.145,0.8815,0.3605,0.1955,0.2735,10),
(3822,'M',0.595,0.46,0.155,1.03,0.4275,0.207,0.3305,10),
(3823,'F',0.605,0.48,0.175,1.1685,0.4815,0.2305,0.356,9),
(3824,'F',0.615,0.455,0.135,1.059,0.4735,0.263,0.274,9),
(3825,'M',0.62,0.46,0.17,1.127,0.535,0.2635,0.296,7),
(3826,'M',0.625,0.47,0.17,1.1665,0.4605,0.2565,0.3945,11),
(3827,'F',0.68,0.52,0.185,1.541,0.5985,0.395,0.4575,10),
(3828,'M',0.68,0.54,0.195,1.7825,0.5565,0.3235,0.4285,11),
(3829,'M',0.68,0.52,0.175,1.543,0.7525,0.351,0.374,11),
(3830,'F',0.71,0.555,0.17,1.47,0.5375,0.38,0.431,12),
(3831,'M',0.5,0.385,0.12,0.6335,0.2305,0.125,0.235,14),
(3832,'F',0.545,0.42,0.175,0.754,0.256,0.1775,0.275,10),
(3833,'F',0.46,0.365,0.115,0.4485,0.165,0.083,0.17,14),
(3834,'M',0.535,0.41,0.15,0.8105,0.345,0.187,0.24,11),
(3835,'M',0.335,0.26,0.075,0.22,0.0855,0.04,0.085,6),
(3836,'F',0.425,0.35,0.1,0.4425,0.175,0.0755,0.175,7),
(3837,'M',0.41,0.325,0.1,0.3555,0.146,0.072,0.105,9),
(3838,'I',0.17,0.105,0.035,0.034,0.012,0.0085,0.005,4),
(3839,'I',0.335,0.25,0.095,0.185,0.0795,0.0495,0.055,8),
(3840,'M',0.52,0.425,0.125,0.79,0.372,0.205,0.19,8),
(3841,'F',0.53,0.41,0.145,0.8255,0.375,0.204,0.245,9),
(3842,'M',0.5,0.42,0.125,0.62,0.255,0.15,0.205,11),
(3843,'F',0.615,0.475,0.145,0.9525,0.3915,0.195,0.32,9),
(3844,'M',0.575,0.45,0.16,0.955,0.44,0.1685,0.27,16),
(3845,'M',0.57,0.45,0.155,0.91,0.326,0.1895,0.355,14),
(3846,'M',0.455,0.35,0.105,0.416,0.1625,0.097,0.145,11),
(3847,'I',0.37,0.275,0.085,0.2045,0.096,0.056,0.08,6),
(3848,'M',0.445,0.37,0.125,0.515,0.2495,0.087,0.159,9),
(3849,'F',0.675,0.535,0.22,1.604,0.6175,0.4255,0.453,14),
(3850,'M',0.385,0.3,0.115,0.3435,0.1645,0.085,0.1025,6),
(3851,'F',0.375,0.295,0.11,0.3005,0.1255,0.0575,0.1035,7),
(3852,'M',0.56,0.44,0.13,0.8255,0.2425,0.202,0.285,10),
(3853,'M',0.55,0.41,0.15,0.785,0.282,0.186,0.275,12),
(3854,'F',0.57,0.465,0.155,0.9685,0.446,0.261,0.255,9),
(3855,'F',0.485,0.4,0.155,0.731,0.236,0.183,0.255,11),
(3856,'M',0.41,0.335,0.115,0.4405,0.19,0.085,0.135,8),
(3857,'I',0.335,0.255,0.085,0.1785,0.071,0.0405,0.055,9),
(3858,'M',0.655,0.515,0.2,1.373,0.443,0.3375,0.49,16),
(3859,'F',0.565,0.45,0.165,0.9765,0.322,0.244,0.37,12),
(3860,'F',0.57,0.44,0.19,1.018,0.447,0.207,0.265,9),
(3861,'F',0.55,0.465,0.15,1.082,0.3575,0.194,0.19,14),
(3862,'F',0.63,0.475,0.175,1.423,0.4155,0.3385,0.49,14),
(3863,'M',0.475,0.37,0.125,0.655,0.266,0.1725,0.185,10),
(3864,'F',0.655,0.5,0.18,1.4155,0.508,0.314,0.445,18),
(3865,'I',0.32,0.235,0.065,0.1385,0.058,0.0225,0.05,5),
(3866,'M',0.525,0.395,0.165,0.782,0.285,0.1405,0.285,19),
(3867,'F',0.525,0.43,0.165,0.717,0.289,0.1745,0.195,10),
(3868,'F',0.5,0.39,0.13,0.6355,0.2505,0.1635,0.195,15),
(3869,'F',0.44,0.34,0.135,0.3975,0.1505,0.0945,0.135,8),
(3870,'F',0.49,0.385,0.16,0.656,0.2455,0.171,0.205,9),
(3871,'M',0.545,0.44,0.165,0.744,0.2875,0.204,0.25,15),
(3872,'F',0.45,0.36,0.11,0.447,0.203,0.082,0.13,12),
(3873,'F',0.515,0.4,0.115,0.578,0.191,0.1445,0.17,9),
(3874,'I',0.33,0.25,0.075,0.1405,0.056,0.035,0.05,5),
(3875,'F',0.525,0.41,0.15,0.708,0.274,0.151,0.25,12),
(3876,'M',0.295,0.225,0.09,0.1385,0.048,0.046,0.05,9),
(3877,'M',0.545,0.45,0.16,0.8615,0.2925,0.1545,0.365,16),
(3878,'F',0.645,0.5,0.225,1.626,0.587,0.4055,0.41,15),
(3879,'M',0.45,0.355,0.115,0.478,0.18,0.1185,0.155,10),
(3880,'F',0.61,0.49,0.17,1.1775,0.5655,0.2385,0.295,15),
(3881,'I',0.38,0.3,0.1,0.286,0.1305,0.056,0.09,7),
(3882,'F',0.565,0.455,0.13,1.058,0.439,0.2645,0.3,10),
(3883,'F',0.67,0.545,0.16,1.5415,0.5985,0.2565,0.495,15),
(3884,'M',0.54,0.425,0.12,0.817,0.2945,0.153,0.195,10),
(3885,'I',0.29,0.225,0.075,0.152,0.071,0.059,0.045,9),
(3886,'I',0.41,0.33,0.105,0.335,0.1525,0.074,0.11,7),
(3887,'F',0.46,0.375,0.12,0.4915,0.2205,0.088,0.17,7),
(3888,'F',0.56,0.44,0.155,0.9705,0.4315,0.263,0.255,9),
(3889,'F',0.575,0.45,0.1,0.9315,0.431,0.222,0.235,12),
(3890,'M',0.62,0.5,0.2,1.221,0.4605,0.263,0.43,12),
(3891,'M',0.515,0.4,0.14,0.7365,0.2955,0.184,0.185,16),
(3892,'F',0.56,0.46,0.18,0.97,0.342,0.196,0.355,12),
(3893,'F',0.5,0.4,0.15,0.8085,0.273,0.112,0.295,13),
(3894,'I',0.435,0.355,0.125,0.4075,0.1535,0.074,0.165,9),
(3895,'M',0.495,0.38,0.135,0.6295,0.263,0.1425,0.215,12),
(3896,'F',0.595,0.5,0.18,1.053,0.4405,0.192,0.39,13),
(3897,'M',0.76,0.575,0.19,1.829,0.7035,0.386,0.56,14),
(3898,'F',0.615,0.5,0.165,1.1765,0.488,0.244,0.345,17),
(3899,'F',0.565,0.46,0.15,0.8765,0.3455,0.1925,0.275,10),
(3900,'I',0.14,0.105,0.035,0.0145,0.005,0.0035,0.005,4),
(3901,'M',0.445,0.345,0.14,0.476,0.2055,0.1015,0.1085,15),
(3902,'F',0.525,0.43,0.125,0.813,0.3315,0.166,0.1775,12),
(3903,'I',0.16,0.12,0.02,0.018,0.0075,0.0045,0.005,4),
(3904,'M',0.635,0.48,0.235,1.064,0.413,0.228,0.36,16),
(3905,'M',0.575,0.47,0.165,0.853,0.292,0.179,0.35,16),
(3906,'M',0.38,0.27,0.095,0.219,0.0835,0.0515,0.07,6),
(3907,'M',0.245,0.18,0.065,0.0635,0.0245,0.0135,0.02,4),
(3908,'I',0.48,0.39,0.15,0.6275,0.276,0.134,0.185,13),
(3909,'I',0.455,0.365,0.135,0.441,0.1515,0.1165,0.145,9),
(3910,'F',0.455,0.375,0.125,0.458,0.1985,0.111,0.12,10),
(3911,'M',0.455,0.355,0.135,0.4745,0.1865,0.0935,0.168,13),
(3912,'I',0.355,0.27,0.1,0.216,0.083,0.037,0.075,10),
(3913,'I',0.52,0.405,0.14,0.6765,0.2865,0.146,0.205,15),
(3914,'I',0.54,0.4,0.145,0.757,0.315,0.181,0.215,11),
(3915,'I',0.52,0.39,0.14,0.7325,0.2415,0.144,0.26,19),
(3916,'I',0.56,0.445,0.165,1.0285,0.4535,0.253,0.275,11),
(3917,'F',0.52,0.41,0.16,0.712,0.2845,0.153,0.225,10),
(3918,'I',0.615,0.46,0.19,1.066,0.4335,0.226,0.33,13),
(3919,'F',0.645,0.49,0.19,1.3065,0.479,0.3565,0.345,18),
(3920,'I',0.565,0.43,0.135,0.8545,0.321,0.1775,0.275,11),
(3921,'M',0.295,0.23,0.085,0.125,0.042,0.0285,0.043,8),
(3922,'M',0.375,0.28,0.095,0.2225,0.0875,0.043,0.08,10),
(3923,'I',0.525,0.4,0.14,0.6955,0.2405,0.16,0.253,10),
(3924,'M',0.395,0.28,0.08,0.266,0.0995,0.066,0.09,12),
(3925,'F',0.5,0.4,0.165,0.7105,0.27,0.1455,0.225,20),
(3926,'F',0.47,0.35,0.115,0.487,0.1955,0.127,0.155,8),
(3927,'I',0.58,0.42,0.16,0.728,0.2725,0.19,0.19,14),
(3928,'I',0.5,0.38,0.155,0.6675,0.2745,0.156,0.18,12),
(3929,'I',0.725,0.55,0.22,2.0495,0.7735,0.4405,0.655,10),
(3930,'F',0.65,0.515,0.215,1.498,0.564,0.323,0.425,16),
(3931,'F',0.67,0.535,0.185,1.597,0.6275,0.35,0.47,21),
(3932,'I',0.55,0.44,0.165,0.8605,0.312,0.169,0.3,17),
(3933,'F',0.49,0.37,0.115,0.541,0.171,0.1175,0.185,11),
(3934,'I',0.235,0.18,0.06,0.058,0.022,0.0145,0.018,6),
(3935,'I',0.235,0.175,0.08,0.0645,0.0215,0.0175,0.0215,5),
(3936,'M',0.52,0.41,0.115,0.77,0.263,0.157,0.26,11),
(3937,'F',0.475,0.4,0.115,0.541,0.186,0.1025,0.21,13),
(3938,'M',0.53,0.425,0.11,0.739,0.237,0.161,0.295,13),
(3939,'F',0.35,0.275,0.065,0.205,0.0745,0.0465,0.07,10),
(3940,'M',0.555,0.42,0.145,0.8695,0.3075,0.2575,0.25,14),
(3941,'M',0.505,0.39,0.105,0.6555,0.2595,0.18,0.19,11),
(3942,'F',0.54,0.44,0.16,1.0905,0.391,0.2295,0.355,15),
(3943,'F',0.525,0.4,0.115,0.6295,0.2555,0.144,0.18,11),
(3944,'M',0.55,0.45,0.175,1.0985,0.3765,0.215,0.4,14),
(3945,'M',0.55,0.44,0.16,0.991,0.348,0.168,0.375,20),
(3946,'I',0.235,0.175,0.065,0.0615,0.0205,0.02,0.019,6),
(3947,'M',0.525,0.41,0.165,0.8005,0.2635,0.1985,0.25,13),
(3948,'M',0.475,0.365,0.14,0.6175,0.202,0.1445,0.19,16),
(3949,'F',0.53,0.4,0.165,0.772,0.2855,0.1975,0.23,12),
(3950,'F',0.525,0.415,0.15,0.7155,0.2355,0.171,0.27,13),
(3951,'F',0.53,0.425,0.13,0.717,0.2115,0.166,0.255,13),
(3952,'F',0.465,0.39,0.11,0.6355,0.1815,0.157,0.225,13),
(3953,'I',0.315,0.235,0.08,0.18,0.08,0.045,0.047,5),
(3954,'I',0.465,0.355,0.12,0.5805,0.255,0.0915,0.184,8),
(3955,'M',0.485,0.385,0.105,0.556,0.296,0.104,0.133,7),
(3956,'I',0.49,0.385,0.12,0.591,0.271,0.1125,0.1775,9),
(3957,'F',0.515,0.395,0.14,0.686,0.281,0.1255,0.22,12),
(3958,'F',0.555,0.44,0.155,1.016,0.4935,0.1855,0.263,10),
(3959,'F',0.61,0.5,0.18,1.438,0.5185,0.3735,0.3345,9),
(3960,'F',0.68,0.55,0.19,1.807,0.8225,0.3655,0.515,11),
(3961,'M',0.69,0.55,0.195,1.777,0.769,0.38,0.4305,11),
(3962,'M',0.695,0.55,0.205,2.173,1.133,0.4665,0.496,10),
(3963,'F',0.72,0.575,0.195,2.1505,1.0745,0.382,0.585,10),
(3964,'I',0.27,0.205,0.075,0.118,0.059,0.031,0.0305,4),
(3965,'I',0.27,0.19,0.06,0.099,0.0445,0.017,0.03,5),
(3966,'I',0.295,0.22,0.07,0.1365,0.0575,0.0295,0.035,6),
(3967,'I',0.295,0.22,0.065,0.1295,0.052,0.028,0.035,6),
(3968,'I',0.315,0.23,0.07,0.164,0.0625,0.04,0.045,6),
(3969,'I',0.375,0.29,0.095,0.2875,0.123,0.0605,0.08,6),
(3970,'I',0.38,0.3,0.09,0.277,0.1655,0.0625,0.082,6),
(3971,'I',0.385,0.285,0.09,0.248,0.0935,0.066,0.07,6),
(3972,'I',0.4,0.295,0.095,0.252,0.1105,0.0575,0.066,6),
(3973,'M',0.415,0.315,0.12,0.4015,0.199,0.087,0.097,8),
(3974,'I',0.415,0.33,0.1,0.3905,0.1925,0.0755,0.1025,7),
(3975,'I',0.42,0.32,0.115,0.409,0.2055,0.0935,0.105,8),
(3976,'I',0.44,0.33,0.135,0.4095,0.163,0.1005,0.119,6),
(3977,'I',0.45,0.35,0.135,0.494,0.2205,0.0945,0.1405,7),
(3978,'I',0.475,0.35,0.12,0.4905,0.2035,0.13,0.135,7),
(3979,'M',0.485,0.39,0.12,0.599,0.251,0.1345,0.169,8),
(3980,'M',0.495,0.375,0.115,0.6245,0.282,0.143,0.155,6),
(3981,'F',0.525,0.41,0.115,0.7745,0.416,0.163,0.18,7),
(3982,'M',0.565,0.455,0.15,0.9795,0.444,0.205,0.275,8),
(3983,'I',0.58,0.435,0.15,0.8915,0.363,0.1925,0.2515,6),
(3984,'F',0.585,0.45,0.125,0.874,0.3545,0.2075,0.225,6),
(3985,'M',0.6,0.465,0.155,1.262,0.6245,0.2455,0.33,10),
(3986,'M',0.63,0.48,0.185,1.21,0.53,0.2555,0.322,11),
(3987,'F',0.645,0.525,0.17,1.37,0.6135,0.283,0.34,10),
(3988,'F',0.655,0.545,0.185,1.759,0.6865,0.313,0.547,11),
(3989,'M',0.665,0.515,0.165,1.3855,0.621,0.302,0.3445,8),
(3990,'F',0.67,0.52,0.195,1.8065,0.758,0.3735,0.5055,11),
(3991,'M',0.67,0.51,0.2,1.5945,0.6705,0.3845,0.4505,10),
(3992,'M',0.685,0.51,0.18,1.4545,0.6315,0.3105,0.3725,9),
(3993,'M',0.7,0.6,0.23,2.003,0.8105,0.4045,0.5755,10),
(3994,'M',0.72,0.6,0.235,2.2385,0.984,0.411,0.621,12),
(3995,'I',0.185,0.135,0.045,0.032,0.011,0.0065,0.01,4),
(3996,'I',0.245,0.175,0.055,0.0785,0.04,0.018,0.02,5),
(3997,'I',0.315,0.23,0,0.134,0.0575,0.0285,0.3505,6),
(3998,'I',0.36,0.27,0.09,0.2075,0.098,0.039,0.062,6),
(3999,'I',0.375,0.28,0.08,0.2235,0.115,0.043,0.055,6),
(4000,'I',0.415,0.31,0.095,0.34,0.181,0.057,0.083,6),
(4001,'I',0.455,0.35,0.135,0.5365,0.2855,0.0855,0.1325,7),
(4002,'I',0.48,0.35,0.105,0.635,0.352,0.127,0.135,6),
(4003,'I',0.485,0.375,0.125,0.562,0.2505,0.1345,0.1525,8),
(4004,'I',0.51,0.39,0.125,0.597,0.293,0.1265,0.1555,8),
(4005,'M',0.52,0.395,0.125,0.5815,0.2565,0.1265,0.17,10),
(4006,'F',0.555,0.43,0.14,0.7545,0.3525,0.1835,0.2015,9),
(4007,'M',0.585,0.465,0.15,0.98,0.4315,0.2545,0.247,9),
(4008,'F',0.585,0.46,0.15,1.0035,0.503,0.2105,0.2515,11),
(4009,'M',0.585,0.455,0.155,1.133,0.5515,0.223,0.305,12),
(4010,'M',0.61,0.49,0.16,1.146,0.597,0.246,0.265,8),
(4011,'M',0.61,0.475,0.15,1.142,0.62,0.237,0.245,9),
(4012,'M',0.615,0.53,0.17,1.12,0.5775,0.2095,0.286,9),
(4013,'F',0.62,0.465,0.14,1.011,0.479,0.2385,0.255,8),
(4014,'M',0.625,0.505,0.175,1.131,0.5425,0.2265,0.323,8),
(4015,'M',0.625,0.48,0.175,1.065,0.4865,0.259,0.285,10),
(4016,'M',0.635,0.48,0.145,1.181,0.665,0.229,0.225,10),
(4017,'F',0.64,0.525,0.175,1.382,0.646,0.3115,0.37,9),
(4018,'M',0.66,0.505,0.19,1.4385,0.6775,0.285,0.178,11),
(4019,'M',0.66,0.485,0.155,1.2275,0.61,0.274,0.3,8),
(4020,'M',0.66,0.515,0.155,1.4415,0.7055,0.3555,0.335,10),
(4021,'F',0.68,0.55,0.175,1.473,0.713,0.282,0.4295,11),
(4022,'F',0.69,0.58,0.195,1.658,0.708,0.3615,0.4715,10),
(4023,'M',0.72,0.545,0.195,1.7475,0.8215,0.383,0.4705,11),
(4024,'I',0.275,0.2,0.07,0.096,0.037,0.0225,0.03,6),
(4025,'I',0.33,0.245,0.065,0.1445,0.058,0.032,0.0505,6),
(4026,'I',0.33,0.26,0.085,0.1965,0.0915,0.0425,0.055,7),
(4027,'I',0.365,0.28,0.09,0.196,0.0865,0.036,0.0605,7),
(4028,'I',0.365,0.27,0.09,0.2155,0.1005,0.049,0.0655,6),
(4029,'I',0.42,0.31,0.1,0.2805,0.1125,0.0615,0.0925,8),
(4030,'I',0.435,0.335,0.11,0.334,0.1355,0.0775,0.0965,7),
(4031,'I',0.435,0.325,0.1,0.366,0.174,0.0725,0.109,7),
(4032,'I',0.44,0.325,0.11,0.4965,0.258,0.1195,0.1075,8),
(4033,'I',0.485,0.365,0.09,0.651,0.3165,0.132,0.18,8),
(4034,'I',0.495,0.385,0.125,0.5125,0.2075,0.1155,0.172,10),
(4035,'M',0.51,0.405,0.125,0.6925,0.327,0.155,0.1805,7),
(4036,'I',0.52,0.41,0.14,0.5995,0.242,0.1375,0.182,11),
(4037,'I',0.54,0.42,0.14,0.74,0.3595,0.159,0.1985,8),
(4038,'I',0.54,0.415,0.155,0.702,0.322,0.167,0.19,10),
(4039,'I',0.55,0.445,0.125,0.672,0.288,0.1365,0.21,11),
(4040,'I',0.56,0.44,0.155,0.811,0.3685,0.178,0.235,11),
(4041,'F',0.575,0.45,0.12,0.9585,0.447,0.169,0.275,12),
(4042,'I',0.575,0.45,0.15,0.858,0.449,0.166,0.215,10),
(4043,'F',0.575,0.46,0.165,0.9575,0.4815,0.1945,0.236,10),
(4044,'F',0.58,0.46,0.135,0.926,0.4025,0.208,0.275,8),
(4045,'F',0.58,0.425,0.155,0.873,0.3615,0.249,0.239,10),
(4046,'M',0.59,0.45,0.16,0.998,0.445,0.214,0.301,9),
(4047,'M',0.6,0.46,0.155,0.6655,0.285,0.149,0.269,11),
(4048,'M',0.62,0.485,0.145,1.003,0.4655,0.2195,0.28,11),
(4049,'F',0.625,0.495,0.16,1.234,0.6335,0.192,0.35,13),
(4050,'M',0.625,0.495,0.155,1.025,0.46,0.1945,0.34,9),
(4051,'M',0.625,0.495,0.175,1.2935,0.5805,0.317,0.355,9),
(4052,'M',0.625,0.5,0.175,1.0565,0.4615,0.258,0.305,10),
(4053,'M',0.625,0.47,0.145,1.7855,0.675,0.247,0.3245,13),
(4054,'F',0.625,0.485,0.165,1.2255,0.5075,0.296,0.36,10),
(4055,'F',0.635,0.5,0.18,1.2565,0.539,0.292,0.35,10),
(4056,'F',0.645,0.5,0.15,1.159,0.4675,0.3355,0.31,9),
(4057,'M',0.645,0.51,0.165,1.403,0.5755,0.2515,0.4545,11),
(4058,'F',0.69,0.535,0.185,1.826,0.797,0.409,0.499,11),
(4059,'F',0.695,0.56,0.185,1.7715,0.8195,0.331,0.437,10),
(4060,'M',0.515,0.39,0.12,0.6125,0.302,0.1365,0.1415,8),
(4061,'I',0.545,0.405,0.13,0.658,0.327,0.1445,0.174,8),
(4062,'M',0.62,0.465,0.145,0.911,0.375,0.2145,0.278,10),
(4063,'M',0.63,0.49,0.15,1.1955,0.5845,0.257,0.3,9),
(4064,'F',0.63,0.515,0.16,1.336,0.553,0.3205,0.35,11),
(4065,'F',0.64,0.49,0.18,1.36,0.653,0.347,0.305,9),
(4066,'I',0.37,0.275,0.08,0.2325,0.093,0.056,0.072,6),
(4067,'I',0.395,0.31,0.085,0.317,0.153,0.0505,0.0935,7),
(4068,'I',0.4,0.3,0.115,0.318,0.1335,0.0725,0.0935,6),
(4069,'I',0.41,0.305,0.1,0.2645,0.1,0.0655,0.085,7),
(4070,'I',0.455,0.335,0.105,0.4055,0.175,0.092,0.1185,8),
(4071,'I',0.48,0.335,0.125,0.524,0.246,0.1095,0.145,7),
(4072,'I',0.485,0.375,0.11,0.464,0.2015,0.09,0.149,8),
(4073,'I',0.5,0.36,0.12,0.439,0.1875,0.1055,0.1305,8),
(4074,'I',0.515,0.395,0.125,0.5805,0.2365,0.1075,0.19,9),
(4075,'I',0.52,0.4,0.14,0.622,0.278,0.1455,0.169,8),
(4076,'M',0.545,0.45,0.15,0.7805,0.3795,0.1625,0.216,8),
(4077,'I',0.545,0.43,0.14,0.772,0.289,0.19,0.2615,8),
(4078,'I',0.55,0.435,0.125,0.741,0.348,0.1585,0.206,9),
(4079,'M',0.55,0.43,0.18,0.8265,0.4405,0.159,0.225,10),
(4080,'M',0.55,0.385,0.13,0.7275,0.343,0.1625,0.19,8),
(4081,'I',0.555,0.43,0.125,0.7005,0.3395,0.1355,0.2095,8),
(4082,'M',0.56,0.45,0.145,0.9355,0.425,0.1645,0.2725,11),
(4083,'I',0.565,0.465,0.15,1.1815,0.581,0.2215,0.3095,9),
(4084,'M',0.57,0.445,0.16,1.0145,0.516,0.164,0.3,10),
(4085,'F',0.575,0.48,0.17,1.1,0.506,0.2485,0.31,10),
(4086,'M',0.585,0.51,0.16,1.218,0.639,0.241,0.3,11),
(4087,'M',0.59,0.45,0.155,0.874,0.369,0.2135,0.24,8),
(4088,'I',0.595,0.475,0.155,0.984,0.4865,0.184,0.2755,10),
(4089,'M',0.6,0.47,0.13,1.0105,0.423,0.219,0.298,9),
(4090,'M',0.61,0.365,0.155,1.0765,0.488,0.249,0.27,9),
(4091,'M',0.615,0.475,0.205,1.337,0.5995,0.2815,0.37,11),
(4092,'M',0.625,0.5,0.18,1.3705,0.645,0.303,0.3705,12),
(4093,'F',0.625,0.49,0.19,1.7015,0.7465,0.4105,0.3855,11),
(4094,'M',0.63,0.485,0.18,1.2435,0.5175,0.308,0.37,11),
(4095,'M',0.63,0.53,0.175,1.4135,0.667,0.2945,0.3555,13),
(4096,'F',0.635,0.485,0.155,1.073,0.467,0.1975,0.35,11),
(4097,'F',0.635,0.5,0.175,1.477,0.684,0.3005,0.39,12),
(4098,'M',0.635,0.5,0.18,1.2915,0.594,0.2695,0.37,9),
(4099,'F',0.65,0.495,0.16,1.3105,0.577,0.3315,0.355,9),
(4100,'M',0.67,0.525,0.18,1.4915,0.728,0.343,0.381,9),
(4101,'F',0.675,0.52,0.175,1.494,0.7365,0.3055,0.37,9),
(4102,'F',0.675,0.51,0.15,1.1965,0.475,0.304,0.386,11),
(4103,'M',0.68,0.545,0.185,1.672,0.7075,0.364,0.48,11),
(4104,'M',0.7,0.545,0.215,1.9125,0.8825,0.4385,0.506,10),
(4105,'F',0.71,0.545,0.175,1.907,0.8725,0.4565,0.475,11),
(4106,'F',0.715,0.565,0.18,1.79,0.844,0.3535,0.5385,9),
(4107,'F',0.72,0.59,0.205,1.7495,0.7755,0.4225,0.48,11),
(4108,'I',0.42,0.305,0.1,0.3415,0.1645,0.0775,0.086,7),
(4109,'I',0.48,0.35,0.1,0.519,0.2365,0.1275,0.126,7),
(4110,'M',0.48,0.365,0.13,0.5305,0.2405,0.127,0.139,8),
(4111,'M',0.51,0.41,0.155,1.2825,0.569,0.291,0.3795,9),
(4112,'I',0.515,0.4,0.14,0.7165,0.3495,0.1595,0.1785,8),
(4113,'F',0.56,0.42,0.18,1.6645,0.7755,0.35,0.4525,9),
(4114,'I',0.56,0.42,0.14,0.837,0.414,0.214,0.2,8),
(4115,'F',0.57,0.45,0.15,0.9645,0.531,0.189,0.209,9),
(4116,'F',0.605,0.465,0.155,1.1,0.547,0.2665,0.2585,10),
(4117,'M',0.625,0.48,0.16,1.2415,0.6575,0.2625,0.2785,9),
(4118,'F',0.64,0.505,0.175,1.3185,0.6185,0.302,0.3315,9),
(4119,'M',0.65,0.525,0.185,1.3455,0.586,0.278,0.3865,9),
(4120,'I',0.3,0.215,0.05,0.1185,0.048,0.0225,0.042,4),
(4121,'M',0.35,0.265,0.09,0.197,0.073,0.0365,0.077,7),
(4122,'I',0.455,0.35,0.13,0.4725,0.215,0.0745,0.15,9),
(4123,'I',0.46,0.365,0.11,0.4495,0.1755,0.102,0.15,8),
(4124,'I',0.49,0.375,0.115,0.557,0.2275,0.1335,0.1765,8),
(4125,'I',0.5,0.385,0.12,0.516,0.197,0.1305,0.165,8),
(4126,'I',0.54,0.415,0.135,0.709,0.3195,0.174,0.185,9),
(4127,'M',0.55,0.42,0.145,0.7385,0.321,0.1485,0.252,11),
(4128,'I',0.55,0.445,0.11,0.7935,0.378,0.142,0.26,10),
(4129,'M',0.555,0.435,0.145,0.9205,0.404,0.2275,0.255,8),
(4130,'I',0.57,0.425,0.14,0.7655,0.331,0.14,0.24,10),
(4131,'M',0.58,0.45,0.14,0.824,0.3465,0.1765,0.263,10),
(4132,'I',0.58,0.425,0.145,0.83,0.379,0.1605,0.2575,11),
(4133,'I',0.585,0.47,0.17,0.985,0.3695,0.2395,0.315,10),
(4134,'M',0.585,0.45,0.15,0.997,0.4055,0.283,0.251,11),
(4135,'F',0.595,0.455,0.14,0.914,0.3895,0.2225,0.271,9),
(4136,'F',0.6,0.5,0.17,1.13,0.4405,0.267,0.335,11),
(4137,'F',0.615,0.495,0.155,1.0805,0.52,0.19,0.32,9),
(4138,'M',0.63,0.505,0.155,1.105,0.492,0.226,0.325,11),
(4139,'M',0.63,0.49,0.155,1.229,0.535,0.29,0.335,11),
(4140,'F',0.635,0.495,0.175,1.2355,0.5205,0.3085,0.347,10),
(4141,'F',0.645,0.535,0.19,1.2395,0.468,0.2385,0.424,10),
(4142,'F',0.65,0.505,0.165,1.357,0.5725,0.281,0.43,11),
(4143,'M',0.655,0.525,0.18,1.402,0.624,0.2935,0.365,13),
(4144,'F',0.655,0.5,0.22,1.359,0.642,0.3255,0.405,13),
(4145,'M',0.67,0.535,0.19,1.669,0.7465,0.2935,0.508,11),
(4146,'M',0.67,0.525,0.2,1.7405,0.6205,0.297,0.657,11),
(4147,'M',0.695,0.53,0.21,1.51,0.664,0.4095,0.385,10),
(4148,'M',0.695,0.55,0.195,1.6645,0.727,0.36,0.445,11),
(4149,'M',0.77,0.605,0.175,2.0505,0.8005,0.526,0.355,11),
(4150,'I',0.28,0.215,0.07,0.124,0.063,0.0215,0.03,6),
(4151,'I',0.33,0.23,0.08,0.14,0.0565,0.0365,0.046,7),
(4152,'I',0.35,0.25,0.075,0.1695,0.0835,0.0355,0.041,6),
(4153,'I',0.37,0.28,0.09,0.218,0.0995,0.0545,0.0615,7),
(4154,'I',0.43,0.315,0.115,0.384,0.1885,0.0715,0.11,8),
(4155,'I',0.435,0.33,0.095,0.393,0.219,0.075,0.0885,6),
(4156,'I',0.44,0.35,0.11,0.3805,0.1575,0.0895,0.115,6),
(4157,'M',0.475,0.37,0.11,0.4895,0.2185,0.107,0.146,8),
(4158,'M',0.475,0.36,0.14,0.5135,0.241,0.1045,0.155,8),
(4159,'I',0.48,0.355,0.11,0.4495,0.201,0.089,0.14,8),
(4160,'F',0.56,0.44,0.135,0.8025,0.35,0.1615,0.259,9),
(4161,'F',0.585,0.475,0.165,1.053,0.458,0.217,0.3,11),
(4162,'F',0.585,0.455,0.17,0.9945,0.4255,0.263,0.2845,11),
(4163,'M',0.385,0.255,0.1,0.3175,0.137,0.068,0.092,8),
(4164,'I',0.39,0.31,0.085,0.344,0.181,0.0695,0.079,7),
(4165,'I',0.39,0.29,0.1,0.2845,0.1255,0.0635,0.081,7),
(4166,'I',0.405,0.3,0.085,0.3035,0.15,0.0505,0.088,7),
(4167,'I',0.475,0.365,0.115,0.499,0.232,0.0885,0.156,10),
(4168,'M',0.5,0.38,0.125,0.577,0.269,0.1265,0.1535,9),
(4169,'F',0.515,0.4,0.125,0.615,0.2865,0.123,0.1765,8),
(4170,'M',0.52,0.385,0.165,0.791,0.375,0.18,0.1815,10),
(4171,'M',0.55,0.43,0.13,0.8395,0.3155,0.1955,0.2405,10),
(4172,'M',0.56,0.43,0.155,0.8675,0.4,0.172,0.229,8),
(4173,'F',0.565,0.45,0.165,0.887,0.37,0.239,0.249,11),
(4174,'M',0.59,0.44,0.135,0.966,0.439,0.2145,0.2605,10),
(4175,'M',0.6,0.475,0.205,1.176,0.5255,0.2875,0.308,9),
(4176,'F',0.625,0.485,0.15,1.0945,0.531,0.261,0.296,10),
(4177,'M',0.71,0.555,0.195,1.9485,0.9455,0.3765,0.495,12);

DROP TABLE IF EXISTS xgb_out, xgb_out_summary;
SELECT madlib.xgboost(
    'abalone',  -- Training table
    'xgb_out',  -- Grid search results table.
    'id',       -- Id column
    'sex',      -- Class label column
    '*',        -- Independent variables
    NULL,       -- Columns to exclude from features
    $$
    {
        'learning_rate': [0.01], #Regularization on weights (eta). For smaller values, increase n_estimators
        'max_depth': [9],#Larger values could lead to overfitting
        'subsample': [0.85],#introduce randomness in samples picked to prevent overfitting
        'colsample_bytree': [0.85],#introduce randomness in features picked to prevent overfitting
        'min_child_weight': [10],#larger values will prevent over-fitting
        'n_estimators':[100] #More estimators, lesser variance (better fit on test set)
    }
    $$,         -- XGBoost grid search parameters
    '',         -- Class weights
    0.8,        -- Training set size ratio
    NULL        -- Variable used to do the test/train split.
);

SELECT * FROM xgb_out_summary;

DROP TABLE IF EXISTS xgb_score_out, xgb_score_out_metrics, xgb_score_out_roc_curve;
SELECT madlib.xgboost_predict(
    'abalone',          -- test_table
    'xgb_out',          -- model_table
    'xgb_score_out',    -- predict_output_table
    'id',               -- id_column
    'sex'               -- class_label
);
SELECT * FROM xgb_score_out LIMIT 10;
SELECT * FROM xgb_score_out_roc_curve limit 10;
SELECT * FROM xgb_score_out_metrics;

DROP TABLE IF EXISTS xgb_out, xgb_out_summary;
SELECT madlib.xgboost(
    'abalone',  -- Training table
    'xgb_out',  -- Grid search results table.
    'id',       -- Id column
    'sex',      -- Class label column
    '*',        -- Independent variables
    NULL,       -- Columns to exclude from features
    $$
    {
        'learning_rate': [0.01,0.1], #Regularization on weights (eta). For smaller values, increase n_estimators
        'max_depth': [9,12],#Larger values could lead to overfitting
        'subsample': [0.85],#introduce randomness in samples picked to prevent overfitting
        'colsample_bytree': [0.85],#introduce randomness in features picked to prevent overfitting
        'min_child_weight': [10],#larger values will prevent over-fitting
        'n_estimators':[100] #More estimators, lesser variance (better fit on test set)
    }
    $$,         -- XGBoost grid search parameters
    '',         -- Class weights
    0.8,        -- Training set size ratio
    NULL        -- Variable used to do the test/train split.
);

SELECT * FROM xgb_out_summary;

DROP TABLE IF EXISTS xgb_score_out, xgb_score_out_metrics, xgb_score_out_roc_curve;
SELECT madlib.xgboost_predict(
    'abalone',          -- test_table
    'xgb_out',          -- model_table
    'xgb_score_out',    -- predict_output_table
    'id',               -- id_column
    'sex',              -- class_label
    2                   -- model_filters
);
SELECT * FROM xgb_score_out LIMIT 10;
