// Lucene version compatibility level 4.8.1
/*

Copyright (c) 2001, Dr Martin Porter
Copyright (c) 2002, Richard Boulton
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
    * this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    * notice, this list of conditions and the following disclaimer in the
    * documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the names of its contributors
    * may be used to endorse or promote products derived from this software
    * without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */

namespace Lucene.Net.Tartarus.Snowball.Ext
{
    /// <summary>
    /// This class was automatically generated by a Snowball to Java compiler
    /// It implements the stemming algorithm defined by a snowball script.
    /// </summary>
    public class FrenchStemmer : SnowballProgram
    {
        private readonly static FrenchStemmer methodObject = new FrenchStemmer();

        private readonly static Among[] a_0 = {
                    new Among ( "col", -1, -1, "", methodObject ),
                    new Among ( "par", -1, -1, "", methodObject ),
                    new Among ( "tap", -1, -1, "", methodObject )
                };

        private readonly static Among[] a_1 = {
                    new Among ( "", -1, 4, "", methodObject ),
                    new Among ( "I", 0, 1, "", methodObject ),
                    new Among ( "U", 0, 2, "", methodObject ),
                    new Among ( "Y", 0, 3, "", methodObject )
                };

        private readonly static Among[] a_2 = {
                    new Among ( "iqU", -1, 3, "", methodObject ),
                    new Among ( "abl", -1, 3, "", methodObject ),
                    new Among ( "I\u00E8r", -1, 4, "", methodObject ),
                    new Among ( "i\u00E8r", -1, 4, "", methodObject ),
                    new Among ( "eus", -1, 2, "", methodObject ),
                    new Among ( "iv", -1, 1, "", methodObject )
                };

        private readonly static Among[] a_3 = {
                    new Among ( "ic", -1, 2, "", methodObject ),
                    new Among ( "abil", -1, 1, "", methodObject ),
                    new Among ( "iv", -1, 3, "", methodObject )
                };

        private readonly static Among[] a_4 = {
                    new Among ( "iqUe", -1, 1, "", methodObject ),
                    new Among ( "atrice", -1, 2, "", methodObject ),
                    new Among ( "ance", -1, 1, "", methodObject ),
                    new Among ( "ence", -1, 5, "", methodObject ),
                    new Among ( "logie", -1, 3, "", methodObject ),
                    new Among ( "able", -1, 1, "", methodObject ),
                    new Among ( "isme", -1, 1, "", methodObject ),
                    new Among ( "euse", -1, 11, "", methodObject ),
                    new Among ( "iste", -1, 1, "", methodObject ),
                    new Among ( "ive", -1, 8, "", methodObject ),
                    new Among ( "if", -1, 8, "", methodObject ),
                    new Among ( "usion", -1, 4, "", methodObject ),
                    new Among ( "ation", -1, 2, "", methodObject ),
                    new Among ( "ution", -1, 4, "", methodObject ),
                    new Among ( "ateur", -1, 2, "", methodObject ),
                    new Among ( "iqUes", -1, 1, "", methodObject ),
                    new Among ( "atrices", -1, 2, "", methodObject ),
                    new Among ( "ances", -1, 1, "", methodObject ),
                    new Among ( "ences", -1, 5, "", methodObject ),
                    new Among ( "logies", -1, 3, "", methodObject ),
                    new Among ( "ables", -1, 1, "", methodObject ),
                    new Among ( "ismes", -1, 1, "", methodObject ),
                    new Among ( "euses", -1, 11, "", methodObject ),
                    new Among ( "istes", -1, 1, "", methodObject ),
                    new Among ( "ives", -1, 8, "", methodObject ),
                    new Among ( "ifs", -1, 8, "", methodObject ),
                    new Among ( "usions", -1, 4, "", methodObject ),
                    new Among ( "ations", -1, 2, "", methodObject ),
                    new Among ( "utions", -1, 4, "", methodObject ),
                    new Among ( "ateurs", -1, 2, "", methodObject ),
                    new Among ( "ments", -1, 15, "", methodObject ),
                    new Among ( "ements", 30, 6, "", methodObject ),
                    new Among ( "issements", 31, 12, "", methodObject ),
                    new Among ( "it\u00E9s", -1, 7, "", methodObject ),
                    new Among ( "ment", -1, 15, "", methodObject ),
                    new Among ( "ement", 34, 6, "", methodObject ),
                    new Among ( "issement", 35, 12, "", methodObject ),
                    new Among ( "amment", 34, 13, "", methodObject ),
                    new Among ( "emment", 34, 14, "", methodObject ),
                    new Among ( "aux", -1, 10, "", methodObject ),
                    new Among ( "eaux", 39, 9, "", methodObject ),
                    new Among ( "eux", -1, 1, "", methodObject ),
                    new Among ( "it\u00E9", -1, 7, "", methodObject )
                };

        private readonly static Among[] a_5 = {
                    new Among ( "ira", -1, 1, "", methodObject ),
                    new Among ( "ie", -1, 1, "", methodObject ),
                    new Among ( "isse", -1, 1, "", methodObject ),
                    new Among ( "issante", -1, 1, "", methodObject ),
                    new Among ( "i", -1, 1, "", methodObject ),
                    new Among ( "irai", 4, 1, "", methodObject ),
                    new Among ( "ir", -1, 1, "", methodObject ),
                    new Among ( "iras", -1, 1, "", methodObject ),
                    new Among ( "ies", -1, 1, "", methodObject ),
                    new Among ( "\u00EEmes", -1, 1, "", methodObject ),
                    new Among ( "isses", -1, 1, "", methodObject ),
                    new Among ( "issantes", -1, 1, "", methodObject ),
                    new Among ( "\u00EEtes", -1, 1, "", methodObject ),
                    new Among ( "is", -1, 1, "", methodObject ),
                    new Among ( "irais", 13, 1, "", methodObject ),
                    new Among ( "issais", 13, 1, "", methodObject ),
                    new Among ( "irions", -1, 1, "", methodObject ),
                    new Among ( "issions", -1, 1, "", methodObject ),
                    new Among ( "irons", -1, 1, "", methodObject ),
                    new Among ( "issons", -1, 1, "", methodObject ),
                    new Among ( "issants", -1, 1, "", methodObject ),
                    new Among ( "it", -1, 1, "", methodObject ),
                    new Among ( "irait", 21, 1, "", methodObject ),
                    new Among ( "issait", 21, 1, "", methodObject ),
                    new Among ( "issant", -1, 1, "", methodObject ),
                    new Among ( "iraIent", -1, 1, "", methodObject ),
                    new Among ( "issaIent", -1, 1, "", methodObject ),
                    new Among ( "irent", -1, 1, "", methodObject ),
                    new Among ( "issent", -1, 1, "", methodObject ),
                    new Among ( "iront", -1, 1, "", methodObject ),
                    new Among ( "\u00EEt", -1, 1, "", methodObject ),
                    new Among ( "iriez", -1, 1, "", methodObject ),
                    new Among ( "issiez", -1, 1, "", methodObject ),
                    new Among ( "irez", -1, 1, "", methodObject ),
                    new Among ( "issez", -1, 1, "", methodObject )
                };

        private readonly static Among[] a_6 = {
                    new Among ( "a", -1, 3, "", methodObject ),
                    new Among ( "era", 0, 2, "", methodObject ),
                    new Among ( "asse", -1, 3, "", methodObject ),
                    new Among ( "ante", -1, 3, "", methodObject ),
                    new Among ( "\u00E9e", -1, 2, "", methodObject ),
                    new Among ( "ai", -1, 3, "", methodObject ),
                    new Among ( "erai", 5, 2, "", methodObject ),
                    new Among ( "er", -1, 2, "", methodObject ),
                    new Among ( "as", -1, 3, "", methodObject ),
                    new Among ( "eras", 8, 2, "", methodObject ),
                    new Among ( "\u00E2mes", -1, 3, "", methodObject ),
                    new Among ( "asses", -1, 3, "", methodObject ),
                    new Among ( "antes", -1, 3, "", methodObject ),
                    new Among ( "\u00E2tes", -1, 3, "", methodObject ),
                    new Among ( "\u00E9es", -1, 2, "", methodObject ),
                    new Among ( "ais", -1, 3, "", methodObject ),
                    new Among ( "erais", 15, 2, "", methodObject ),
                    new Among ( "ions", -1, 1, "", methodObject ),
                    new Among ( "erions", 17, 2, "", methodObject ),
                    new Among ( "assions", 17, 3, "", methodObject ),
                    new Among ( "erons", -1, 2, "", methodObject ),
                    new Among ( "ants", -1, 3, "", methodObject ),
                    new Among ( "\u00E9s", -1, 2, "", methodObject ),
                    new Among ( "ait", -1, 3, "", methodObject ),
                    new Among ( "erait", 23, 2, "", methodObject ),
                    new Among ( "ant", -1, 3, "", methodObject ),
                    new Among ( "aIent", -1, 3, "", methodObject ),
                    new Among ( "eraIent", 26, 2, "", methodObject ),
                    new Among ( "\u00E8rent", -1, 2, "", methodObject ),
                    new Among ( "assent", -1, 3, "", methodObject ),
                    new Among ( "eront", -1, 2, "", methodObject ),
                    new Among ( "\u00E2t", -1, 3, "", methodObject ),
                    new Among ( "ez", -1, 2, "", methodObject ),
                    new Among ( "iez", 32, 2, "", methodObject ),
                    new Among ( "eriez", 33, 2, "", methodObject ),
                    new Among ( "assiez", 33, 3, "", methodObject ),
                    new Among ( "erez", 32, 2, "", methodObject ),
                    new Among ( "\u00E9", -1, 2, "", methodObject )
                };

        private readonly static Among[] a_7 = {
                    new Among ( "e", -1, 3, "", methodObject ),
                    new Among ( "I\u00E8re", 0, 2, "", methodObject ),
                    new Among ( "i\u00E8re", 0, 2, "", methodObject ),
                    new Among ( "ion", -1, 1, "", methodObject ),
                    new Among ( "Ier", -1, 2, "", methodObject ),
                    new Among ( "ier", -1, 2, "", methodObject ),
                    new Among ( "\u00EB", -1, 4, "", methodObject )
                };

        private readonly static Among[] a_8 = {
                    new Among ( "ell", -1, -1, "", methodObject ),
                    new Among ( "eill", -1, -1, "", methodObject ),
                    new Among ( "enn", -1, -1, "", methodObject ),
                    new Among ( "onn", -1, -1, "", methodObject ),
                    new Among ( "ett", -1, -1, "", methodObject )
                };

        private static readonly char[] g_v = { (char)17, (char)65, (char)16, (char)1, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)128, (char)130, (char)103, (char)8, (char)5 };

        private static readonly char[] g_keep_with_s = { (char)1, (char)65, (char)20, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)0, (char)128 };

        private int I_p2;
        private int I_p1;
        private int I_pV;

        private void copy_from(FrenchStemmer other)
        {
            I_p2 = other.I_p2;
            I_p1 = other.I_p1;
            I_pV = other.I_pV;
            base.CopyFrom(other);
        }

        private bool r_prelude()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            // repeat, line 38

            while (true)
            {
                v_1 = m_cursor;

                do
                {
                    // goto, line 38

                    while (true)
                    {
                        v_2 = m_cursor;

                        do
                        {
                            // (, line 38
                            // or, line 44

                            do
                            {
                                v_3 = m_cursor;

                                do
                                {
                                    // (, line 40
                                    if (!(InGrouping(g_v, 97, 251)))
                                    {
                                        goto lab5;
                                    }
                                    // [, line 40
                                    m_bra = m_cursor;
                                    // or, line 40

                                    do
                                    {
                                        v_4 = m_cursor;

                                        do
                                        {
                                            // (, line 40
                                            // literal, line 40
                                            if (!(Eq_S(1, "u")))
                                            {
                                                goto lab7;
                                            }
                                            // ], line 40
                                            m_ket = m_cursor;
                                            if (!(InGrouping(g_v, 97, 251)))
                                            {
                                                goto lab7;
                                            }
                                            // <-, line 40
                                            SliceFrom("U");
                                            goto lab6;
                                        } while (false);
                                        lab7:
                                        m_cursor = v_4;

                                        do
                                        {
                                            // (, line 41
                                            // literal, line 41
                                            if (!(Eq_S(1, "i")))
                                            {
                                                goto lab8;
                                            }
                                            // ], line 41
                                            m_ket = m_cursor;
                                            if (!(InGrouping(g_v, 97, 251)))
                                            {
                                                goto lab8;
                                            }
                                            // <-, line 41
                                            SliceFrom("I");
                                            goto lab6;
                                        } while (false);
                                        lab8:
                                        m_cursor = v_4;
                                        // (, line 42
                                        // literal, line 42
                                        if (!(Eq_S(1, "y")))
                                        {
                                            goto lab5;
                                        }
                                        // ], line 42
                                        m_ket = m_cursor;
                                        // <-, line 42
                                        SliceFrom("Y");
                                    } while (false);
                                    lab6:
                                    goto lab4;
                                } while (false);
                                lab5:
                                m_cursor = v_3;

                                do
                                {
                                    // (, line 45
                                    // [, line 45
                                    m_bra = m_cursor;
                                    // literal, line 45
                                    if (!(Eq_S(1, "y")))
                                    {
                                        goto lab9;
                                    }
                                    // ], line 45
                                    m_ket = m_cursor;
                                    if (!(InGrouping(g_v, 97, 251)))
                                    {
                                        goto lab9;
                                    }
                                    // <-, line 45
                                    SliceFrom("Y");
                                    goto lab4;
                                } while (false);
                                lab9:
                                m_cursor = v_3;
                                // (, line 47
                                // literal, line 47
                                if (!(Eq_S(1, "q")))
                                {
                                    goto lab3;
                                }
                                // [, line 47
                                m_bra = m_cursor;
                                // literal, line 47
                                if (!(Eq_S(1, "u")))
                                {
                                    goto lab3;
                                }
                                // ], line 47
                                m_ket = m_cursor;
                                // <-, line 47
                                SliceFrom("U");
                            } while (false);
                            lab4:
                            m_cursor = v_2;
                            goto golab2;
                        } while (false);
                        lab3:
                        m_cursor = v_2;
                        if (m_cursor >= m_limit)
                        {
                            goto lab1;
                        }
                        m_cursor++;
                    }
                    golab2:
                    // LUCENENET NOTE: continue label is not supported directly in .NET,
                    // so we just need to add another goto to get to the end of the outer loop.
                    // See: http://stackoverflow.com/a/359449/181087

                    // Original code:
                    //continue replab0;

                    goto end_of_outer_loop;

                } while (false);
                lab1:
                m_cursor = v_1;
                goto replab0;
                end_of_outer_loop: { }
            }
            replab0:
            return true;
        }

        private bool r_mark_regions()
        {
            int v_1;
            int v_2;
            int v_4;
            // (, line 50
            I_pV = m_limit;
            I_p1 = m_limit;
            I_p2 = m_limit;
            // do, line 56
            v_1 = m_cursor;

            do
            {
                // (, line 56
                // or, line 58

                do
                {
                    v_2 = m_cursor;

                    do
                    {
                        // (, line 57
                        if (!(InGrouping(g_v, 97, 251)))
                        {
                            goto lab2;
                        }
                        if (!(InGrouping(g_v, 97, 251)))
                        {
                            goto lab2;
                        }
                        // next, line 57
                        if (m_cursor >= m_limit)
                        {
                            goto lab2;
                        }
                        m_cursor++;
                        goto lab1;
                    } while (false);
                    lab2:
                    m_cursor = v_2;

                    do
                    {
                        // among, line 59
                        if (FindAmong(a_0, 3) == 0)
                        {
                            goto lab3;
                        }
                        goto lab1;
                    } while (false);
                    lab3:
                    m_cursor = v_2;
                    // (, line 66
                    // next, line 66
                    if (m_cursor >= m_limit)
                    {
                        goto lab0;
                    }
                    m_cursor++;
                    // gopast, line 66

                    while (true)
                    {

                        do
                        {
                            if (!(InGrouping(g_v, 97, 251)))
                            {
                                goto lab5;
                            }
                            goto golab4;
                        } while (false);
                        lab5:
                        if (m_cursor >= m_limit)
                        {
                            goto lab0;
                        }
                        m_cursor++;
                    }
                    golab4:;
                } while (false);
                lab1:
                // setmark pV, line 67
                I_pV = m_cursor;
            } while (false);
            lab0:
            m_cursor = v_1;
            // do, line 69
            v_4 = m_cursor;

            do
            {
                // (, line 69
                // gopast, line 70

                while (true)
                {

                    do
                    {
                        if (!(InGrouping(g_v, 97, 251)))
                        {
                            goto lab8;
                        }
                        goto golab7;
                    } while (false);
                    lab8:
                    if (m_cursor >= m_limit)
                    {
                        goto lab6;
                    }
                    m_cursor++;
                }
                golab7:
                // gopast, line 70

                while (true)
                {

                    do
                    {
                        if (!(OutGrouping(g_v, 97, 251)))
                        {
                            goto lab10;
                        }
                        goto golab9;
                    } while (false);
                    lab10:
                    if (m_cursor >= m_limit)
                    {
                        goto lab6;
                    }
                    m_cursor++;
                }
                golab9:
                // setmark p1, line 70
                I_p1 = m_cursor;
                // gopast, line 71

                while (true)
                {

                    do
                    {
                        if (!(InGrouping(g_v, 97, 251)))
                        {
                            goto lab12;
                        }
                        goto golab11;
                    } while (false);
                    lab12:
                    if (m_cursor >= m_limit)
                    {
                        goto lab6;
                    }
                    m_cursor++;
                }
                golab11:
                // gopast, line 71

                while (true)
                {

                    do
                    {
                        if (!(OutGrouping(g_v, 97, 251)))
                        {
                            goto lab14;
                        }
                        goto golab13;
                    } while (false);
                    lab14:
                    if (m_cursor >= m_limit)
                    {
                        goto lab6;
                    }
                    m_cursor++;
                }
                golab13:
                // setmark p2, line 71
                I_p2 = m_cursor;
            } while (false);
            lab6:
            m_cursor = v_4;
            return true;
        }

        private bool r_postlude()
        {
            int among_var;
            int v_1;
            // repeat, line 75

            while (true)
            {
                v_1 = m_cursor;

                do
                {
                    // (, line 75
                    // [, line 77
                    m_bra = m_cursor;
                    // substring, line 77
                    among_var = FindAmong(a_1, 4);
                    if (among_var == 0)
                    {
                        goto lab1;
                    }
                    // ], line 77
                    m_ket = m_cursor;
                    switch (among_var)
                    {
                        case 0:
                            goto lab1;
                        case 1:
                            // (, line 78
                            // <-, line 78
                            SliceFrom("i");
                            break;
                        case 2:
                            // (, line 79
                            // <-, line 79
                            SliceFrom("u");
                            break;
                        case 3:
                            // (, line 80
                            // <-, line 80
                            SliceFrom("y");
                            break;
                        case 4:
                            // (, line 81
                            // next, line 81
                            if (m_cursor >= m_limit)
                            {
                                goto lab1;
                            }
                            m_cursor++;
                            break;
                    }
                    // LUCENENET NOTE: continue label is not supported directly in .NET,
                    // so we just need to add another goto to get to the end of the outer loop.
                    // See: http://stackoverflow.com/a/359449/181087

                    // Original code:
                    //continue replab0;

                    goto end_of_outer_loop;

                } while (false);
                lab1:
                m_cursor = v_1;
                goto replab0;
                end_of_outer_loop: { }
            }
            replab0:
            return true;
        }

        private bool r_RV()
        {
            if (!(I_pV <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_R1()
        {
            if (!(I_p1 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_R2()
        {
            if (!(I_p2 <= m_cursor))
            {
                return false;
            }
            return true;
        }

        private bool r_standard_suffix()
        {
            int among_var;
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
            int v_8;
            int v_9;
            int v_10;
            int v_11;
            // (, line 91
            // [, line 92
            m_ket = m_cursor;
            // substring, line 92
            among_var = FindAmongB(a_4, 43);
            if (among_var == 0)
            {
                return false;
            }
            // ], line 92
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    return false;
                case 1:
                    // (, line 96
                    // call R2, line 96
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 96
                    SliceDel();
                    break;
                case 2:
                    // (, line 99
                    // call R2, line 99
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 99
                    SliceDel();
                    // try, line 100
                    v_1 = m_limit - m_cursor;

                    do
                    {
                        // (, line 100
                        // [, line 100
                        m_ket = m_cursor;
                        // literal, line 100
                        if (!(Eq_S_B(2, "ic")))
                        {
                            m_cursor = m_limit - v_1;
                            goto lab0;
                        }
                        // ], line 100
                        m_bra = m_cursor;
                        // or, line 100

                        do
                        {
                            v_2 = m_limit - m_cursor;

                            do
                            {
                                // (, line 100
                                // call R2, line 100
                                if (!r_R2())
                                {
                                    goto lab2;
                                }
                                // delete, line 100
                                SliceDel();
                                goto lab1;
                            } while (false);
                            lab2:
                            m_cursor = m_limit - v_2;
                            // <-, line 100
                            SliceFrom("iqU");
                        } while (false);
                        lab1:;
                    } while (false);
                    lab0:
                    break;
                case 3:
                    // (, line 104
                    // call R2, line 104
                    if (!r_R2())
                    {
                        return false;
                    }
                    // <-, line 104
                    SliceFrom("log");
                    break;
                case 4:
                    // (, line 107
                    // call R2, line 107
                    if (!r_R2())
                    {
                        return false;
                    }
                    // <-, line 107
                    SliceFrom("u");
                    break;
                case 5:
                    // (, line 110
                    // call R2, line 110
                    if (!r_R2())
                    {
                        return false;
                    }
                    // <-, line 110
                    SliceFrom("ent");
                    break;
                case 6:
                    // (, line 113
                    // call RV, line 114
                    if (!r_RV())
                    {
                        return false;
                    }
                    // delete, line 114
                    SliceDel();
                    // try, line 115
                    v_3 = m_limit - m_cursor;

                    do
                    {
                        // (, line 115
                        // [, line 116
                        m_ket = m_cursor;
                        // substring, line 116
                        among_var = FindAmongB(a_2, 6);
                        if (among_var == 0)
                        {
                            m_cursor = m_limit - v_3;
                            goto lab3;
                        }
                        // ], line 116
                        m_bra = m_cursor;
                        switch (among_var)
                        {
                            case 0:
                                m_cursor = m_limit - v_3;
                                goto lab3;
                            case 1:
                                // (, line 117
                                // call R2, line 117
                                if (!r_R2())
                                {
                                    m_cursor = m_limit - v_3;
                                    goto lab3;
                                }
                                // delete, line 117
                                SliceDel();
                                // [, line 117
                                m_ket = m_cursor;
                                // literal, line 117
                                if (!(Eq_S_B(2, "at")))
                                {
                                    m_cursor = m_limit - v_3;
                                    goto lab3;
                                }
                                // ], line 117
                                m_bra = m_cursor;
                                // call R2, line 117
                                if (!r_R2())
                                {
                                    m_cursor = m_limit - v_3;
                                    goto lab3;
                                }
                                // delete, line 117
                                SliceDel();
                                break;
                            case 2:
                                // (, line 118
                                // or, line 118

                                do
                                {
                                    v_4 = m_limit - m_cursor;

                                    do
                                    {
                                        // (, line 118
                                        // call R2, line 118
                                        if (!r_R2())
                                        {
                                            goto lab5;
                                        }
                                        // delete, line 118
                                        SliceDel();
                                        goto lab4;
                                    } while (false);
                                    lab5:
                                    m_cursor = m_limit - v_4;
                                    // (, line 118
                                    // call R1, line 118
                                    if (!r_R1())
                                    {
                                        m_cursor = m_limit - v_3;
                                        goto lab3;
                                    }
                                    // <-, line 118
                                    SliceFrom("eux");
                                } while (false);
                                lab4:
                                break;
                            case 3:
                                // (, line 120
                                // call R2, line 120
                                if (!r_R2())
                                {
                                    m_cursor = m_limit - v_3;
                                    goto lab3;
                                }
                                // delete, line 120
                                SliceDel();
                                break;
                            case 4:
                                // (, line 122
                                // call RV, line 122
                                if (!r_RV())
                                {
                                    m_cursor = m_limit - v_3;
                                    goto lab3;
                                }
                                // <-, line 122
                                SliceFrom("i");
                                break;
                        }
                    } while (false);
                    lab3:
                    break;
                case 7:
                    // (, line 128
                    // call R2, line 129
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 129
                    SliceDel();
                    // try, line 130
                    v_5 = m_limit - m_cursor;

                    do
                    {
                        // (, line 130
                        // [, line 131
                        m_ket = m_cursor;
                        // substring, line 131
                        among_var = FindAmongB(a_3, 3);
                        if (among_var == 0)
                        {
                            m_cursor = m_limit - v_5;
                            goto lab6;
                        }
                        // ], line 131
                        m_bra = m_cursor;
                        switch (among_var)
                        {
                            case 0:
                                m_cursor = m_limit - v_5;
                                goto lab6;
                            case 1:
                                // (, line 132
                                // or, line 132

                                do
                                {
                                    v_6 = m_limit - m_cursor;

                                    do
                                    {
                                        // (, line 132
                                        // call R2, line 132
                                        if (!r_R2())
                                        {
                                            goto lab8;
                                        }
                                        // delete, line 132
                                        SliceDel();
                                        goto lab7;
                                    } while (false);
                                    lab8:
                                    m_cursor = m_limit - v_6;
                                    // <-, line 132
                                    SliceFrom("abl");
                                } while (false);
                                lab7:
                                break;
                            case 2:
                                // (, line 133
                                // or, line 133

                                do
                                {
                                    v_7 = m_limit - m_cursor;

                                    do
                                    {
                                        // (, line 133
                                        // call R2, line 133
                                        if (!r_R2())
                                        {
                                            goto lab10;
                                        }
                                        // delete, line 133
                                        SliceDel();
                                        goto lab9;
                                    } while (false);
                                    lab10:
                                    m_cursor = m_limit - v_7;
                                    // <-, line 133
                                    SliceFrom("iqU");
                                } while (false);
                                lab9:
                                break;
                            case 3:
                                // (, line 134
                                // call R2, line 134
                                if (!r_R2())
                                {
                                    m_cursor = m_limit - v_5;
                                    goto lab6;
                                }
                                // delete, line 134
                                SliceDel();
                                break;
                        }
                    } while (false);
                    lab6:
                    break;
                case 8:
                    // (, line 140
                    // call R2, line 141
                    if (!r_R2())
                    {
                        return false;
                    }
                    // delete, line 141
                    SliceDel();
                    // try, line 142
                    v_8 = m_limit - m_cursor;

                    do
                    {
                        // (, line 142
                        // [, line 142
                        m_ket = m_cursor;
                        // literal, line 142
                        if (!(Eq_S_B(2, "at")))
                        {
                            m_cursor = m_limit - v_8;
                            goto lab11;
                        }
                        // ], line 142
                        m_bra = m_cursor;
                        // call R2, line 142
                        if (!r_R2())
                        {
                            m_cursor = m_limit - v_8;
                            goto lab11;
                        }
                        // delete, line 142
                        SliceDel();
                        // [, line 142
                        m_ket = m_cursor;
                        // literal, line 142
                        if (!(Eq_S_B(2, "ic")))
                        {
                            m_cursor = m_limit - v_8;
                            goto lab11;
                        }
                        // ], line 142
                        m_bra = m_cursor;
                        // or, line 142

                        do
                        {
                            v_9 = m_limit - m_cursor;

                            do
                            {
                                // (, line 142
                                // call R2, line 142
                                if (!r_R2())
                                {
                                    goto lab13;
                                }
                                // delete, line 142
                                SliceDel();
                                goto lab12;
                            } while (false);
                            lab13:
                            m_cursor = m_limit - v_9;
                            // <-, line 142
                            SliceFrom("iqU");
                        } while (false);
                        lab12:;
                    } while (false);
                    lab11:
                    break;
                case 9:
                    // (, line 144
                    // <-, line 144
                    SliceFrom("eau");
                    break;
                case 10:
                    // (, line 145
                    // call R1, line 145
                    if (!r_R1())
                    {
                        return false;
                    }
                    // <-, line 145
                    SliceFrom("al");
                    break;
                case 11:
                    // (, line 147
                    // or, line 147

                    do
                    {
                        v_10 = m_limit - m_cursor;

                        do
                        {
                            // (, line 147
                            // call R2, line 147
                            if (!r_R2())
                            {
                                goto lab15;
                            }
                            // delete, line 147
                            SliceDel();
                            goto lab14;
                        } while (false);
                        lab15:
                        m_cursor = m_limit - v_10;
                        // (, line 147
                        // call R1, line 147
                        if (!r_R1())
                        {
                            return false;
                        }
                        // <-, line 147
                        SliceFrom("eux");
                    } while (false);
                    lab14:
                    break;
                case 12:
                    // (, line 150
                    // call R1, line 150
                    if (!r_R1())
                    {
                        return false;
                    }
                    if (!(OutGroupingB(g_v, 97, 251)))
                    {
                        return false;
                    }
                    // delete, line 150
                    SliceDel();
                    break;
                case 13:
                    // (, line 155
                    // call RV, line 155
                    if (!r_RV())
                    {
                        return false;
                    }
                    // fail, line 155
                    // (, line 155
                    // <-, line 155
                    SliceFrom("ant");
                    return false;
                case 14:
                    // (, line 156
                    // call RV, line 156
                    if (!r_RV())
                    {
                        return false;
                    }
                    // fail, line 156
                    // (, line 156
                    // <-, line 156
                    SliceFrom("ent");
                    return false;
                case 15:
                    // (, line 158
                    // test, line 158
                    v_11 = m_limit - m_cursor;
                    // (, line 158
                    if (!(InGroupingB(g_v, 97, 251)))
                    {
                        return false;
                    }
                    // call RV, line 158
                    if (!r_RV())
                    {
                        return false;
                    }
                    m_cursor = m_limit - v_11;
                    // fail, line 158
                    // (, line 158
                    // delete, line 158
                    SliceDel();
                    return false;
            }
            return true;
        }

        private bool r_i_verb_suffix()
        {
            int among_var;
            int v_1;
            int v_2;
            // setlimit, line 163
            v_1 = m_limit - m_cursor;
            // tomark, line 163
            if (m_cursor < I_pV)
            {
                return false;
            }
            m_cursor = I_pV;
            v_2 = m_limit_backward;
            m_limit_backward = m_cursor;
            m_cursor = m_limit - v_1;
            // (, line 163
            // [, line 164
            m_ket = m_cursor;
            // substring, line 164
            among_var = FindAmongB(a_5, 35);
            if (among_var == 0)
            {
                m_limit_backward = v_2;
                return false;
            }
            // ], line 164
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    m_limit_backward = v_2;
                    return false;
                case 1:
                    // (, line 170
                    if (!(OutGroupingB(g_v, 97, 251)))
                    {
                        m_limit_backward = v_2;
                        return false;
                    }
                    // delete, line 170
                    SliceDel();
                    break;
            }
            m_limit_backward = v_2;
            return true;
        }

        private bool r_verb_suffix()
        {
            int among_var;
            int v_1;
            int v_2;
            int v_3;
            // setlimit, line 174
            v_1 = m_limit - m_cursor;
            // tomark, line 174
            if (m_cursor < I_pV)
            {
                return false;
            }
            m_cursor = I_pV;
            v_2 = m_limit_backward;
            m_limit_backward = m_cursor;
            m_cursor = m_limit - v_1;
            // (, line 174
            // [, line 175
            m_ket = m_cursor;
            // substring, line 175
            among_var = FindAmongB(a_6, 38);
            if (among_var == 0)
            {
                m_limit_backward = v_2;
                return false;
            }
            // ], line 175
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    m_limit_backward = v_2;
                    return false;
                case 1:
                    // (, line 177
                    // call R2, line 177
                    if (!r_R2())
                    {
                        m_limit_backward = v_2;
                        return false;
                    }
                    // delete, line 177
                    SliceDel();
                    break;
                case 2:
                    // (, line 185
                    // delete, line 185
                    SliceDel();
                    break;
                case 3:
                    // (, line 190
                    // delete, line 190
                    SliceDel();
                    // try, line 191
                    v_3 = m_limit - m_cursor;

                    do
                    {
                        // (, line 191
                        // [, line 191
                        m_ket = m_cursor;
                        // literal, line 191
                        if (!(Eq_S_B(1, "e")))
                        {
                            m_cursor = m_limit - v_3;
                            goto lab0;
                        }
                        // ], line 191
                        m_bra = m_cursor;
                        // delete, line 191
                        SliceDel();
                    } while (false);
                    lab0:
                    break;
            }
            m_limit_backward = v_2;
            return true;
        }

        private bool r_residual_suffix()
        {
            int among_var;
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            // (, line 198
            // try, line 199
            v_1 = m_limit - m_cursor;

            do
            {
                // (, line 199
                // [, line 199
                m_ket = m_cursor;
                // literal, line 199
                if (!(Eq_S_B(1, "s")))
                {
                    m_cursor = m_limit - v_1;
                    goto lab0;
                }
                // ], line 199
                m_bra = m_cursor;
                // test, line 199
                v_2 = m_limit - m_cursor;
                if (!(OutGroupingB(g_keep_with_s, 97, 232)))
                {
                    m_cursor = m_limit - v_1;
                    goto lab0;
                }
                m_cursor = m_limit - v_2;
                // delete, line 199
                SliceDel();
            } while (false);
            lab0:
            // setlimit, line 200
            v_3 = m_limit - m_cursor;
            // tomark, line 200
            if (m_cursor < I_pV)
            {
                return false;
            }
            m_cursor = I_pV;
            v_4 = m_limit_backward;
            m_limit_backward = m_cursor;
            m_cursor = m_limit - v_3;
            // (, line 200
            // [, line 201
            m_ket = m_cursor;
            // substring, line 201
            among_var = FindAmongB(a_7, 7);
            if (among_var == 0)
            {
                m_limit_backward = v_4;
                return false;
            }
            // ], line 201
            m_bra = m_cursor;
            switch (among_var)
            {
                case 0:
                    m_limit_backward = v_4;
                    return false;
                case 1:
                    // (, line 202
                    // call R2, line 202
                    if (!r_R2())
                    {
                        m_limit_backward = v_4;
                        return false;
                    }
                    // or, line 202

                    do
                    {
                        v_5 = m_limit - m_cursor;

                        do
                        {
                            // literal, line 202
                            if (!(Eq_S_B(1, "s")))
                            {
                                goto lab2;
                            }
                            goto lab1;
                        } while (false);
                        lab2:
                        m_cursor = m_limit - v_5;
                        // literal, line 202
                        if (!(Eq_S_B(1, "t")))
                        {
                            m_limit_backward = v_4;
                            return false;
                        }
                    } while (false);
                    lab1:
                    // delete, line 202
                    SliceDel();
                    break;
                case 2:
                    // (, line 204
                    // <-, line 204
                    SliceFrom("i");
                    break;
                case 3:
                    // (, line 205
                    // delete, line 205
                    SliceDel();
                    break;
                case 4:
                    // (, line 206
                    // literal, line 206
                    if (!(Eq_S_B(2, "gu")))
                    {
                        m_limit_backward = v_4;
                        return false;
                    }
                    // delete, line 206
                    SliceDel();
                    break;
            }
            m_limit_backward = v_4;
            return true;
        }

        private bool r_un_double()
        {
            int v_1;
            // (, line 211
            // test, line 212
            v_1 = m_limit - m_cursor;
            // among, line 212
            if (FindAmongB(a_8, 5) == 0)
            {
                return false;
            }
            m_cursor = m_limit - v_1;
            // [, line 212
            m_ket = m_cursor;
            // next, line 212
            if (m_cursor <= m_limit_backward)
            {
                return false;
            }
            m_cursor--;
            // ], line 212
            m_bra = m_cursor;
            // delete, line 212
            SliceDel();
            return true;
        }

        private bool r_un_accent()
        {
            int v_3;
            // (, line 215
            // atleast, line 216
            {
                int v_1 = 1;
                // atleast, line 216

                while (true)
                {

                    do
                    {
                        if (!(OutGroupingB(g_v, 97, 251)))
                        {
                            goto lab1;
                        }
                        v_1--;
                        // LUCENENET NOTE: continue label is not supported directly in .NET,
                        // so we just need to add another goto to get to the end of the outer loop.
                        // See: http://stackoverflow.com/a/359449/181087

                        // Original code:
                        //continue replab0;

                        goto end_of_outer_loop;

                    } while (false);
                    lab1:
                    goto replab0;
                    end_of_outer_loop: { }
                }
                replab0:
                if (v_1 > 0)
                {
                    return false;
                }
            }
            // [, line 217
            m_ket = m_cursor;
            // or, line 217

            do
            {
                v_3 = m_limit - m_cursor;

                do
                {
                    // literal, line 217
                    if (!(Eq_S_B(1, "\u00E9")))
                    {
                        goto lab3;
                    }
                    goto lab2;
                } while (false);
                lab3:
                m_cursor = m_limit - v_3;
                // literal, line 217
                if (!(Eq_S_B(1, "\u00E8")))
                {
                    return false;
                }
            } while (false);
            lab2:
            // ], line 217
            m_bra = m_cursor;
            // <-, line 217
            SliceFrom("e");
            return true;
        }


        public override bool Stem()
        {
            int v_1;
            int v_2;
            int v_3;
            int v_4;
            int v_5;
            int v_6;
            int v_7;
            int v_8;
            int v_9;
            int v_10;
            int v_11;
            // (, line 221
            // do, line 223
            v_1 = m_cursor;

            do
            {
                // call prelude, line 223
                if (!r_prelude())
                {
                    goto lab0;
                }
            } while (false);
            lab0:
            m_cursor = v_1;
            // do, line 224
            v_2 = m_cursor;

            do
            {
                // call mark_regions, line 224
                if (!r_mark_regions())
                {
                    goto lab1;
                }
            } while (false);
            lab1:
            m_cursor = v_2;
            // backwards, line 225
            m_limit_backward = m_cursor; m_cursor = m_limit;
            // (, line 225
            // do, line 227
            v_3 = m_limit - m_cursor;

            do
            {
                // (, line 227
                // or, line 237

                do
                {
                    v_4 = m_limit - m_cursor;

                    do
                    {
                        // (, line 228
                        // and, line 233
                        v_5 = m_limit - m_cursor;
                        // (, line 229
                        // or, line 229

                        do
                        {
                            v_6 = m_limit - m_cursor;

                            do
                            {
                                // call standard_suffix, line 229
                                if (!r_standard_suffix())
                                {
                                    goto lab6;
                                }
                                goto lab5;
                            } while (false);
                            lab6:
                            m_cursor = m_limit - v_6;

                            do
                            {
                                // call i_verb_suffix, line 230
                                if (!r_i_verb_suffix())
                                {
                                    goto lab7;
                                }
                                goto lab5;
                            } while (false);
                            lab7:
                            m_cursor = m_limit - v_6;
                            // call verb_suffix, line 231
                            if (!r_verb_suffix())
                            {
                                goto lab4;
                            }
                        } while (false);
                        lab5:
                        m_cursor = m_limit - v_5;
                        // try, line 234
                        v_7 = m_limit - m_cursor;

                        do
                        {
                            // (, line 234
                            // [, line 234
                            m_ket = m_cursor;
                            // or, line 234

                            do
                            {
                                v_8 = m_limit - m_cursor;

                                do
                                {
                                    // (, line 234
                                    // literal, line 234
                                    if (!(Eq_S_B(1, "Y")))
                                    {
                                        goto lab10;
                                    }
                                    // ], line 234
                                    m_bra = m_cursor;
                                    // <-, line 234
                                    SliceFrom("i");
                                    goto lab9;
                                } while (false);
                                lab10:
                                m_cursor = m_limit - v_8;
                                // (, line 235
                                // literal, line 235
                                if (!(Eq_S_B(1, "\u00E7")))
                                {
                                    m_cursor = m_limit - v_7;
                                    goto lab8;
                                }
                                // ], line 235
                                m_bra = m_cursor;
                                // <-, line 235
                                SliceFrom("c");
                            } while (false);
                            lab9:;
                        } while (false);
                        lab8:
                        goto lab3;
                    } while (false);
                    lab4:
                    m_cursor = m_limit - v_4;
                    // call residual_suffix, line 238
                    if (!r_residual_suffix())
                    {
                        goto lab2;
                    }
                } while (false);
                lab3:;
            } while (false);
            lab2:
            m_cursor = m_limit - v_3;
            // do, line 243
            v_9 = m_limit - m_cursor;

            do
            {
                // call un_double, line 243
                if (!r_un_double())
                {
                    goto lab11;
                }
            } while (false);
            lab11:
            m_cursor = m_limit - v_9;
            // do, line 244
            v_10 = m_limit - m_cursor;

            do
            {
                // call un_accent, line 244
                if (!r_un_accent())
                {
                    goto lab12;
                }
            } while (false);
            lab12:
            m_cursor = m_limit - v_10;
            m_cursor = m_limit_backward;                    // do, line 246
            v_11 = m_cursor;

            do
            {
                // call postlude, line 246
                if (!r_postlude())
                {
                    goto lab13;
                }
            } while (false);
            lab13:
            m_cursor = v_11;
            return true;
        }

        public override bool Equals(object o)
        {
            return o is FrenchStemmer;
        }

        public override int GetHashCode()
        {
            return this.GetType().FullName.GetHashCode();
        }
    }
}