/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.IOException;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.Sequence;
import opennlp.tools.ml.model.SequenceStream;
import opennlp.tools.postag.DefaultPOSContextGenerator;
import opennlp.tools.postag.POSContextGenerator;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSSampleEventStream;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.ObjectStream;

public class POSSampleSequenceStream
implements SequenceStream<POSSample> {
    private final POSContextGenerator pcg;
    private final ObjectStream<POSSample> psi;

    public POSSampleSequenceStream(ObjectStream<POSSample> psi) {
        this(psi, new DefaultPOSContextGenerator(null));
    }

    public POSSampleSequenceStream(ObjectStream<POSSample> psi, POSContextGenerator pcg) {
        this.psi = psi;
        this.pcg = pcg;
    }

    @Override
    public Event[] updateContext(Sequence<POSSample> pss, AbstractModel model) {
        POSTaggerME tagger = new POSTaggerME(new POSModel("x-unspecified", model, null, new POSTaggerFactory()));
        String[] sentence = pss.getSource().getSentence();
        String[][] ac = pss.getSource().getAdditionalContext();
        String[] tags = tagger.tag(pss.getSource().getSentence());
        Event[] events = new Event[sentence.length];
        POSSampleEventStream.generateEvents(sentence, tags, (Object[])ac, this.pcg).toArray(events);
        return events;
    }

    @Override
    public Sequence<POSSample> read() throws IOException {
        POSSample sample = this.psi.read();
        if (sample != null) {
            String[] sentence = sample.getSentence();
            String[] tags = sample.getTags();
            Event[] events = new Event[sentence.length];
            for (int i = 0; i < sentence.length; ++i) {
                CharSequence[] context = this.pcg.getContext(i, sentence, tags, (Object[])null);
                events[i] = new Event(tags[i], context);
            }
            return new Sequence<POSSample>(events, sample);
        }
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.psi.reset();
    }

    @Override
    public void close() throws IOException {
        this.psi.close();
    }
}

