/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.codecs.uniformsplit;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.lucene104.Lucene104PostingsReader;
import org.apache.lucene.codecs.lucene104.Lucene104PostingsWriter;
import org.apache.lucene.codecs.uniformsplit.BlockDecoder;
import org.apache.lucene.codecs.uniformsplit.BlockEncoder;
import org.apache.lucene.codecs.uniformsplit.IndexDictionary;
import org.apache.lucene.codecs.uniformsplit.UniformSplitTermsReader;
import org.apache.lucene.codecs.uniformsplit.UniformSplitTermsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.tests.codecs.uniformsplit.Rot13CypherTestUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public class UniformSplitRot13PostingsFormat
extends PostingsFormat {
    public static volatile boolean encoderCalled;
    public static volatile boolean decoderCalled;
    public static volatile boolean blocksEncoded;
    public static volatile boolean fieldsMetadataEncoded;
    public static volatile boolean dictionaryEncoded;
    protected final boolean dictionaryOnHeap;

    public UniformSplitRot13PostingsFormat() {
        this("UniformSplitRot13", false);
    }

    protected UniformSplitRot13PostingsFormat(String name, boolean dictionaryOnHeap) {
        super(name);
        this.dictionaryOnHeap = dictionaryOnHeap;
    }

    public static void resetEncodingFlags() {
        encoderCalled = false;
        decoderCalled = false;
        blocksEncoded = false;
        fieldsMetadataEncoded = false;
        dictionaryEncoded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsConsumer fieldsConsumer(SegmentWriteState segmentWriteState) throws IOException {
        FieldsConsumer fieldsConsumer;
        block3: {
            Lucene104PostingsWriter postingsWriter = new Lucene104PostingsWriter(segmentWriteState);
            boolean success = false;
            try {
                FieldsConsumer fieldsConsumer2 = this.createFieldsConsumer(segmentWriteState, (PostingsWriterBase)postingsWriter);
                success = true;
                fieldsConsumer = fieldsConsumer2;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsWriter});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsWriter});
        }
        return fieldsConsumer;
    }

    protected FieldsConsumer createFieldsConsumer(SegmentWriteState segmentWriteState, PostingsWriterBase postingsWriter) throws IOException {
        return new UniformSplitTermsWriter(postingsWriter, segmentWriteState, 32, 3, this.getBlockEncoder()){

            protected void writeDictionary(IndexDictionary.Builder dictionaryBuilder) throws IOException {
                UniformSplitRot13PostingsFormat.this.recordBlockEncodingCall();
                super.writeDictionary(dictionaryBuilder);
                UniformSplitRot13PostingsFormat.this.recordDictionaryEncodingCall();
            }

            protected void writeEncodedFieldsMetadata(ByteBuffersDataOutput fieldsOutput) throws IOException {
                super.writeEncodedFieldsMetadata(fieldsOutput);
                UniformSplitRot13PostingsFormat.this.recordFieldsMetadataEncodingCall();
            }
        };
    }

    protected void recordBlockEncodingCall() {
        if (encoderCalled) {
            blocksEncoded = true;
            encoderCalled = false;
        }
    }

    protected void recordFieldsMetadataEncodingCall() {
        if (encoderCalled) {
            fieldsMetadataEncoded = true;
            encoderCalled = false;
        }
    }

    protected void recordDictionaryEncodingCall() {
        if (encoderCalled) {
            dictionaryEncoded = true;
            encoderCalled = false;
        }
    }

    protected BlockEncoder getBlockEncoder() {
        return (blockBytes, length) -> {
            final byte[] encodedBytes = Rot13CypherTestUtil.encode(blockBytes, Math.toIntExact(length));
            return new BlockEncoder.WritableBytes(){

                public long size() {
                    return encodedBytes.length;
                }

                public void writeTo(DataOutput dataOutput) throws IOException {
                    encoderCalled = true;
                    dataOutput.writeBytes(encodedBytes, 0, encodedBytes.length);
                }
            };
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState segmentReadState) throws IOException {
        FieldsProducer fieldsProducer;
        block3: {
            Lucene104PostingsReader postingsReader = new Lucene104PostingsReader(segmentReadState);
            boolean success = false;
            try {
                FieldsProducer fieldsProducer2 = this.createFieldsProducer(segmentReadState, (PostingsReaderBase)postingsReader);
                success = true;
                fieldsProducer = fieldsProducer2;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsReader});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{postingsReader});
        }
        return fieldsProducer;
    }

    protected FieldsProducer createFieldsProducer(SegmentReadState segmentReadState, PostingsReaderBase postingsReader) throws IOException {
        return new UniformSplitTermsReader(postingsReader, segmentReadState, this.getBlockDecoder(), this.dictionaryOnHeap);
    }

    protected BlockDecoder getBlockDecoder() {
        return (blockBytes, length) -> {
            decoderCalled = true;
            return new BytesRef(Rot13CypherTestUtil.decode(blockBytes, length));
        };
    }
}

