/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.NeighborArray;

public final class OnHeapHnswGraph
extends HnswGraph
implements Accountable {
    private static final long RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(OnHeapHnswGraph.class);
    private static final int INIT_SIZE = 128;
    private final AtomicReference<EntryNode> entryNode;
    private NeighborArray[][] graph;
    private IntArrayList[] levelToNodes;
    private int lastFreezeSize;
    private final AtomicInteger size = new AtomicInteger(0);
    private final AtomicInteger nonZeroLevelSize = new AtomicInteger(0);
    private final AtomicInteger maxNodeId = new AtomicInteger(-1);
    private final int nsize;
    private final int nsize0;
    private final boolean noGrowth;
    private int upto;
    private NeighborArray cur;
    private volatile long graphRamBytesUsed;

    OnHeapHnswGraph(int M, int numNodes) {
        this.entryNode = new AtomicReference<EntryNode>(new EntryNode(-1, 1));
        this.nsize = M + 1;
        this.nsize0 = M * 2 + 1;
        boolean bl = this.noGrowth = numNodes != -1;
        if (!this.noGrowth) {
            numNodes = 128;
        }
        this.graph = new NeighborArray[numNodes][];
        this.graphRamBytesUsed = RAM_BYTES_USED + RamUsageEstimator.shallowSizeOf((Object[])this.graph);
    }

    public NeighborArray getNeighbors(int level, int node) {
        assert (node < this.graph.length);
        assert (level < this.graph[node].length) : "level=" + level + ", node has only " + this.graph[node].length + " levels";
        assert (this.graph[node][level] != null) : "node=" + node + ", level=" + level;
        return this.graph[node][level];
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public int maxNodeId() {
        if (this.noGrowth) {
            return this.graph.length - 1;
        }
        return this.maxNodeId.get();
    }

    public void addNode(int level, int node) {
        if (node >= this.graph.length) {
            if (this.noGrowth) {
                throw new IllegalStateException("The graph does not expect to grow when an initial size is given");
            }
            this.graph = (NeighborArray[][])ArrayUtil.grow(this.graph, node + 1);
        }
        assert (this.graph[node] == null || this.graph[node].length >= level) : "node must be inserted from the top level: ";
        if (this.graph[node] == null) {
            this.graph[node] = new NeighborArray[level + 1];
            this.size.incrementAndGet();
        } else if (this.graph[node].length <= level) {
            this.graph[node] = ArrayUtil.growExact(this.graph[node], level + 1);
        }
        if (level == 0) {
            this.graph[node][level] = new NeighborArray(this.nsize0, true, l -> {
                assert (l > 0L);
                long bytesUsed = this.graphRamBytesUsed;
                this.graphRamBytesUsed = bytesUsed + l;
            });
        } else {
            this.graph[node][level] = new NeighborArray(this.nsize, true, l -> {
                assert (l > 0L);
                long bytesUsed = this.graphRamBytesUsed;
                this.graphRamBytesUsed = bytesUsed + l;
            });
            this.nonZeroLevelSize.incrementAndGet();
        }
        this.maxNodeId.accumulateAndGet(node, Math::max);
    }

    @Override
    public void seek(int level, int targetNode) {
        this.cur = this.getNeighbors(level, targetNode);
        this.upto = -1;
    }

    @Override
    public int neighborCount() {
        return this.cur.size();
    }

    @Override
    public int nextNeighbor() {
        if (++this.upto < this.cur.size()) {
            return this.cur.nodes()[this.upto];
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int numLevels() {
        return this.entryNode.get().level + 1;
    }

    public boolean nodeExistAtLevel(int level, int node) {
        return this.graph[node] != null && this.graph[node].length > level;
    }

    @Override
    public int entryNode() {
        return this.entryNode.get().node;
    }

    @Override
    public int maxConn() {
        return this.nsize - 1;
    }

    public boolean trySetNewEntryNode(int node, int level) {
        EntryNode current = this.entryNode.get();
        if (current.node == -1) {
            return this.entryNode.compareAndSet(current, new EntryNode(node, level));
        }
        return false;
    }

    public boolean tryPromoteNewEntryNode(int node, int level, int expectOldLevel) {
        assert (level > expectOldLevel);
        EntryNode currentEntry = this.entryNode.get();
        if (currentEntry.level == expectOldLevel) {
            return this.entryNode.compareAndSet(currentEntry, new EntryNode(node, level));
        }
        return false;
    }

    @Override
    public HnswGraph.NodesIterator getNodesOnLevel(int level) {
        if (this.size() != this.maxNodeId() + 1) {
            throw new IllegalStateException("graph build not complete, size=" + this.size() + " maxNodeId=" + this.maxNodeId());
        }
        if (level == 0) {
            return new HnswGraph.DenseNodesIterator(this.size());
        }
        this.generateLevelToNodes();
        return new HnswGraph.CollectionNodesIterator(this.levelToNodes[level]);
    }

    private void generateLevelToNodes() {
        if (this.lastFreezeSize == this.size()) {
            return;
        }
        int maxLevels = this.numLevels();
        this.levelToNodes = new IntArrayList[maxLevels];
        for (int i = 1; i < maxLevels; ++i) {
            this.levelToNodes[i] = new IntArrayList();
        }
        int nonNullNode = 0;
        for (int node = 0; node < this.graph.length; ++node) {
            if (this.graph[node] == null) continue;
            ++nonNullNode;
            for (int i = 1; i < this.graph[node].length; ++i) {
                this.levelToNodes[i].add(node);
            }
            if (nonNullNode == this.size()) break;
        }
        this.lastFreezeSize = this.size();
    }

    @Override
    public long ramBytesUsed() {
        return this.graphRamBytesUsed;
    }

    public String toString() {
        return "OnHeapHnswGraph(size=" + this.size() + ", numLevels=" + this.numLevels() + ", entryNode=" + this.entryNode() + ")";
    }

    private record EntryNode(int node, int level) {
    }
}

