/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.cassandra;

import com.datastax.driver.core.BatchStatement;
import org.apache.logging.log4j.cassandra.CassandraManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseAppender;
import org.apache.logging.log4j.core.appender.db.AbstractDatabaseManager;
import org.apache.logging.log4j.core.appender.db.ColumnMapping;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.net.SocketAddress;

@Plugin(name="Cassandra", category="Core", elementType="appender", printObject=true)
public class CassandraAppender
extends AbstractDatabaseAppender<CassandraManager> {
    private CassandraAppender(String name, Filter filter, boolean ignoreExceptions, Property[] properties, CassandraManager manager) {
        super(name, filter, null, ignoreExceptions, properties, (AbstractDatabaseManager)manager);
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<CassandraAppender> {
        @PluginElement(value="ContactPoints")
        @Required(message="No Cassandra servers provided")
        private SocketAddress[] contactPoints = new SocketAddress[]{SocketAddress.getLoopback()};
        @PluginElement(value="Columns")
        @Required(message="No Cassandra columns provided")
        private ColumnMapping[] columns;
        @PluginBuilderAttribute
        private boolean useTls;
        @PluginBuilderAttribute
        @Required(message="No cluster name provided")
        private String clusterName;
        @PluginBuilderAttribute
        @Required(message="No keyspace provided")
        private String keyspace;
        @PluginBuilderAttribute
        @Required(message="No table name provided")
        private String table;
        @PluginBuilderAttribute
        private String username;
        @PluginBuilderAttribute(sensitive=true)
        private String password;
        @PluginBuilderAttribute
        private boolean useClockForTimestampGenerator;
        @PluginBuilderAttribute
        private int bufferSize;
        @PluginBuilderAttribute
        private boolean batched;
        @PluginBuilderAttribute
        private BatchStatement.Type batchType = BatchStatement.Type.LOGGED;

        public B setContactPoints(SocketAddress ... contactPoints) {
            this.contactPoints = contactPoints;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setColumns(ColumnMapping ... columns) {
            this.columns = columns;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setUseTls(boolean useTls) {
            this.useTls = useTls;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setClusterName(String clusterName) {
            this.clusterName = clusterName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setKeyspace(String keyspace) {
            this.keyspace = keyspace;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setTable(String table) {
            this.table = table;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setUsername(String username) {
            this.username = username;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setPassword(String password) {
            this.password = password;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setUseClockForTimestampGenerator(boolean useClockForTimestampGenerator) {
            this.useClockForTimestampGenerator = useClockForTimestampGenerator;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setBatched(boolean batched) {
            this.batched = batched;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setBatchType(BatchStatement.Type batchType) {
            this.batchType = batchType;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public CassandraAppender build() {
            CassandraManager manager = CassandraManager.getManager(this.getName(), this.contactPoints, this.columns, this.useTls, this.clusterName, this.keyspace, this.table, this.username, this.password, this.useClockForTimestampGenerator, this.bufferSize, this.batched, this.batchType);
            return new CassandraAppender(this.getName(), this.getFilter(), this.isIgnoreExceptions(), null, manager);
        }
    }
}

