/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.junit;

import java.util.Map;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.test.junit.ExtensionContextAnchor;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

class ThreadContextMapExtension
implements BeforeEachCallback {
    ThreadContextMapExtension() {
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        context.getStore(ExtensionContextAnchor.LOG4J2_NAMESPACE).getOrComputeIfAbsent(ThreadContextMapStore.class);
    }

    private static final class ThreadContextMapStore
    implements ExtensionContext.Store.CloseableResource {
        private final Map<String, String> previousMap = ThreadContext.getImmutableContext();

        private ThreadContextMapStore() {
            ThreadContext.clearMap();
        }

        public void close() throws Throwable {
            ThreadContext.clearMap();
            ThreadContext.putAll(this.previousMap);
        }
    }
}

