/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.audit.generator;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.audit.generator.Parameter;
import org.apache.logging.log4j.audit.util.NamingUtils;
import org.apache.logging.log4j.audit.util.StringUtil;

public class MethodDefinition
implements Comparable<MethodDefinition> {
    private String visibility = "public";
    private String name;
    private String returnType;
    private String annotation = null;
    private boolean isStatic = false;
    private boolean isFinal = false;
    private boolean isAbstract = false;
    private boolean isInterface = false;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<String> exceptions = new ArrayList<String>();
    private String content;
    private String javadocComments = null;
    private static MethodDefinition definition = new MethodDefinition("dumb", "dumb");

    public static MethodDefinition getStandardSingleton(String returnType, String name, List<String> parameters) {
        MethodDefinition methodDefinition = definition;
        methodDefinition.getClass();
        return methodDefinition.new StandardSingleton(returnType, name, parameters);
    }

    public MethodDefinition(String returnType, String name, String content) {
        this.returnType = returnType;
        this.name = name;
        if (content != null) {
            this.content = StringUtil.filterContent(content, name, returnType);
        } else {
            this.createStubContent();
        }
    }

    public MethodDefinition(String returnType, String name) {
        this(returnType, name, null);
    }

    private void createStubContent() {
        String content = "// default stub - please modify\n";
        this.setContent(content);
        if (!this.returnType.equals("void")) {
            if (this.returnType.equals("int")) {
                this.setContent(content + "return 0;");
            } else if (this.returnType.equals("boolean")) {
                this.setContent(content + "return false;");
            } else if (this.returnType.equals("double")) {
                this.setContent(content + "return 0.0;");
            } else if (this.returnType.equals("long")) {
                this.setContent(content + "return 0;");
            } else if (this.returnType.equals("float")) {
                this.setContent(content + "return 0.0;");
            } else if (this.returnType.equals("float")) {
                this.setContent(content + "return 0.0;");
            } else if (this.returnType.equals("char")) {
                this.setContent(content + "return ' ';");
            } else if (this.returnType.equals("short")) {
                this.setContent(content + "return 0;");
            } else {
                this.setContent(content + "return null;");
            }
        }
    }

    public MethodDefinition(Method method) {
        this(method, null);
    }

    public MethodDefinition(Method method, String content) {
        this.returnType = method.getReturnType().getName();
        this.name = method.getName();
        if (content == null) {
            this.createStubContent();
        } else {
            this.content = content;
        }
        int pName = 97;
        for (Class<?> param : method.getParameterTypes()) {
            this.addParameter(new Parameter(Character.toString((char)pName++), param.getName(), ""));
        }
        for (Class<?> param : method.getExceptionTypes()) {
            this.exceptions.add(param.getName());
        }
    }

    public void addParameter(Parameter paramater) {
        this.parameters.add(paramater);
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getContent() {
        return this.content;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getVisability() {
        return this.visibility;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setExceptions(List<String> exceptions) {
        this.exceptions = exceptions;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public void setInterface(boolean isInterface) {
        this.isInterface = isInterface;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public void setVisability(String visability) {
        this.visibility = visability;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    /**\n");
        if (this.getJavadocComments() != null) {
            sb.append("     * ").append(this.getJavadocComments());
        }
        if (this.getParameters() != null) {
            for (Parameter param : this.getParameters()) {
                sb.append("\n     * @param ").append(param.getName()).append(" ").append(param.getDescription());
            }
        }
        sb.append("\n     */\n");
        sb.append("    ");
        if (this.getAnnotation() != null) {
            sb.append(this.getAnnotation());
            sb.append("\n    ");
        }
        if (this.getVisability() != null) {
            sb.append(this.getVisability()).append(" ");
        }
        if (this.isFinal() && !this.isInterface()) {
            sb.append("final ");
        }
        if (this.isStatic() && !this.isInterface()) {
            sb.append("static ");
        }
        if (this.isAbstract() && !this.isInterface()) {
            sb.append("abstract ");
        }
        sb.append(this.returnType).append(" ");
        sb.append(this.getName()).append("(");
        if (this.getParameters() != null) {
            boolean first = true;
            for (Parameter parameter : this.getParameters()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(parameter);
                first = false;
            }
        }
        sb.append(")");
        if (this.getExceptions() != null && this.getExceptions().size() > 0) {
            sb.append(" throws ");
            boolean first = true;
            for (String string : this.getExceptions()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(string);
                first = false;
            }
        }
        if (this.isAbstract() || this.isInterface()) {
            sb.append(";");
            return sb.toString();
        }
        sb.append(" {\n");
        sb.append(this.getContent());
        sb.append("\n}");
        return sb.toString();
    }

    @Override
    public int compareTo(MethodDefinition arg0) {
        int res = NamingUtils.getMethodShortName(this.getName()).compareTo(NamingUtils.getMethodShortName(arg0.getName()));
        if (res == 0) {
            return this.getName().compareTo(arg0.getName());
        }
        return res;
    }

    public String getJavadocComments() {
        return this.javadocComments;
    }

    public void setJavadocComments(String javadocComments) {
        this.javadocComments = javadocComments;
    }

    public class StandardSingleton
    extends MethodDefinition {
        public StandardSingleton(String returnType, String name, List<String> parameters) {
            super(returnType, name);
            this.setStatic(true);
            String prefix = "get";
            this.setName(prefix + name.substring(0, 1).toUpperCase() + name.substring(1));
            StringBuilder sb = new StringBuilder();
            sb.append("\tif (").append(name).append(" == null) {\n");
            sb.append("\t\t").append(name).append(" = new ").append(returnType).append("(");
            boolean first = true;
            if (parameters != null) {
                for (String element : parameters) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(element);
                    first = false;
                }
            }
            sb.append(");\n\t}\n\treturn ").append(name).append(";");
            this.setContent(sb.toString());
        }
    }
}

