/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.git.dao;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.api.CatalogData;
import org.apache.logging.log4j.catalog.api.dao.AbstractCatalogReader;
import org.apache.logging.log4j.catalog.api.dao.CatalogDao;
import org.apache.logging.log4j.catalog.api.exception.CatalogModificationException;
import org.apache.logging.log4j.catalog.api.exception.CatalogNotFoundException;
import org.apache.logging.log4j.catalog.api.exception.CatalogReadException;
import org.apache.logging.log4j.catalog.api.util.CatalogEventFilter;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;

public class GitCatalogDao
extends AbstractCatalogReader
implements CatalogDao {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DEFAULT_CATALOG_PATH = "src/main/resources/catalog.json";
    private final ObjectMapper mapper;
    private CredentialsProvider credentialsProvider = null;
    private TransportConfigCallback transportConfigCallback = null;
    private String remoteRepoUri = null;
    private String localRepoPath = null;
    private String catalogPath = "src/main/resources/catalog.json";
    private String branch = null;
    private Repository localRepo = null;
    private Git git = null;
    private File catalogFile = null;

    public GitCatalogDao() {
        JsonFactory factory = new JsonFactory();
        factory.enable(JsonParser.Feature.ALLOW_COMMENTS);
        this.mapper = new ObjectMapper(factory).enable(SerializationFeature.INDENT_OUTPUT);
        SimpleFilterProvider filterProvider = new SimpleFilterProvider();
        filterProvider.addFilter("catalogEvent", (SimpleBeanPropertyFilter)new CatalogEventFilter());
        this.mapper.setFilterProvider((FilterProvider)filterProvider);
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public TransportConfigCallback getTransportConfigCallback() {
        return this.transportConfigCallback;
    }

    public void setTransportConfigCallback(TransportConfigCallback transportConfigCallback) {
        this.transportConfigCallback = transportConfigCallback;
    }

    public String getRemoteRepoUri() {
        return this.remoteRepoUri;
    }

    public void setRemoteRepoUri(String remoteRepoUri) {
        this.remoteRepoUri = remoteRepoUri;
    }

    public String getLocalRepoPath() {
        return this.localRepoPath;
    }

    public void setLocalRepoPath(String localRepoPath) {
        this.localRepoPath = localRepoPath;
    }

    public String getCatalogPath() {
        return this.catalogPath;
    }

    public void setCatalogPath(String catalogPath) {
        this.catalogPath = catalogPath;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public LocalDateTime getLastUpdated() {
        if (this.localRepo == null) {
            this.updateRepo();
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.catalogFile.lastModified()), ZoneId.systemDefault());
    }

    public synchronized CatalogData read() {
        this.updateRepo();
        if (this.catalogFile == null || !this.catalogFile.exists() || !this.catalogFile.canRead()) {
            throw new IllegalStateException("Catalog " + this.catalogFile.getAbsolutePath() + " is not readable.");
        }
        try {
            this.catalogData = (CatalogData)this.mapper.readValue(this.catalogFile, CatalogData.class);
            return this.catalogData;
        }
        catch (IOException ioe) {
            throw new CatalogReadException("Error reading catalog from " + this.catalogFile.getAbsolutePath());
        }
    }

    public void write(CatalogData data) {
        File localRepoFile = new File(this.localRepoPath);
        if (!localRepoFile.exists() || !localRepoFile.canWrite()) {
            throw new IllegalStateException("Catalog is not writable.");
        }
        OutputStreamWriter writer = null;
        try {
            String text = this.mapper.writeValueAsString((Object)data);
            writer = new FileWriter(this.catalogFile);
            writer.write(text);
        }
        catch (IOException ioException) {
            throw new CatalogModificationException("Unable to write catalog file.", (Throwable)ioException);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
        try (Git git = Git.open((File)localRepoFile);){
            git.add().addFilepattern(this.catalogPath).call();
            git.commit().setMessage("Catalog updated").call();
            this.updateRepo();
            PushCommand pushCommand = git.push();
            if (this.credentialsProvider != null) {
                pushCommand.setCredentialsProvider(this.credentialsProvider);
            }
            if (this.transportConfigCallback != null) {
                pushCommand.setTransportConfigCallback(this.transportConfigCallback);
            }
            pushCommand.call();
        }
        catch (IOException | GitAPIException ex) {
            throw new CatalogModificationException("Unable to modify catalog", ex);
        }
    }

    public String readCatalog() {
        return null;
    }

    private void updateRepo() {
        block24: {
            File localRepoFile = new File(this.localRepoPath);
            if (!localRepoFile.exists()) {
                LOGGER.debug("local git repo {} does not exist - creating it", (Object)this.localRepoPath);
                localRepoFile.getParentFile().mkdirs();
                CloneCommand cloneCommand = Git.cloneRepository().setURI(this.remoteRepoUri).setDirectory(localRepoFile);
                if (this.branch != null) {
                    cloneCommand.setBranch(this.branch);
                }
                if (this.credentialsProvider != null) {
                    cloneCommand.setCredentialsProvider(this.credentialsProvider);
                }
                if (this.transportConfigCallback != null) {
                    cloneCommand.setTransportConfigCallback(this.transportConfigCallback);
                }
                try (Git git = cloneCommand.call();){
                    this.catalogFile = new File(localRepoFile, this.catalogPath);
                    break block24;
                }
                catch (Exception ex) {
                    throw new CatalogNotFoundException("Unable to clone remote catalog at " + this.remoteRepoUri + " to " + this.localRepoPath, (Throwable)ex);
                }
            }
            try {
                LOGGER.debug("local git repo {} exists - updating", (Object)this.localRepoPath);
                this.localRepo = new FileRepository(this.localRepoPath + "/.git");
                this.catalogFile = new File(localRepoFile, this.catalogPath);
                this.git = new Git(this.localRepo);
                PullCommand pullCommand = this.git.pull();
                try {
                    if (this.credentialsProvider != null) {
                        pullCommand.setCredentialsProvider(this.credentialsProvider);
                    }
                    if (this.transportConfigCallback != null) {
                        pullCommand.setTransportConfigCallback(this.transportConfigCallback);
                    }
                    pullCommand.call();
                }
                catch (GitAPIException gitApiException) {
                    LOGGER.error("Exception", (Throwable)gitApiException);
                }
            }
            catch (Exception exception) {
                throw new CatalogReadException("Unable to pull remote catalog at " + this.remoteRepoUri + " to " + this.localRepoPath, (Throwable)exception);
            }
        }
    }
}

