/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.osx;

import java.awt.Desktop;
import org.apache.log4j.chainsaw.LogUI;

public class OSXIntegration {
    public static final boolean IS_OSX = System.getProperty("os.name").startsWith("Mac OS X");
    private static final Desktop desktop = Desktop.getDesktop();

    public static final void init(LogUI logUI) {
        if (desktop.isSupported(Desktop.Action.APP_ABOUT)) {
            desktop.setAboutHandler(e -> logUI.showAboutBox());
        }
        if (desktop.isSupported(Desktop.Action.APP_PREFERENCES)) {
            desktop.setPreferencesHandler(e -> logUI.showApplicationPreferences());
        }
        if (desktop.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
            desktop.setQuitHandler((e, r) -> {
                if (logUI.exit()) {
                    r.performQuit();
                } else {
                    r.cancelQuit();
                }
            });
        }
    }
}

