/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import org.apache.log4j.chainsaw.LogUI;
import org.apache.log4j.chainsaw.LoggingEventWrapper;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.xml.XMLLayout;

class FileSaveAction
extends AbstractAction {
    private LogUI parent;
    private JFileChooser chooser = null;

    public FileSaveAction(LogUI parent) {
        super("Save displayed events as...");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.putValue("MnemonicKey", new Integer(83));
        this.putValue("ShortDescription", "Saves displayed events for the current tab");
        this.putValue("SmallIcon", new ImageIcon(ChainsawIcons.FILE_SAVE_AS));
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setAcceptAllFileFilterUsed(true);
        this.chooser.setDialogTitle("Save displayed events (XML or .zipped XML)...");
        this.chooser.showSaveDialog(this.parent);
        File selectedFile = this.chooser.getSelectedFile();
        if (selectedFile != null) {
            List v = this.parent.getCurrentLogPanel().getFilteredEvents();
            if (v != null && v.size() == 0 || v == null) {
                return;
            }
            XMLLayout layout = new XMLLayout();
            layout.setProperties(true);
            boolean saveAsZip = selectedFile.getName().toLowerCase(Locale.ENGLISH).endsWith(".zip");
            Writer writer = null;
            try {
                if (saveAsZip) {
                    ZipOutputStream zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(selectedFile)));
                    ZipEntry entry = new ZipEntry(selectedFile.getName().substring(0, selectedFile.getName().length() - ".zip".length()) + ".xml");
                    zipOutput.putNextEntry(entry);
                    writer = new OutputStreamWriter(zipOutput);
                } else {
                    writer = new BufferedWriter(new FileWriter(selectedFile));
                }
                for (LoggingEventWrapper loggingEventWrapper : v) {
                    layout.setLocationInfo(loggingEventWrapper.getLoggingEvent().getThrowableInformation() != null);
                    writer.write(layout.format(loggingEventWrapper.getLoggingEvent()));
                }
            }
            catch (IOException ioe) {
                LogLog.warn((String)"Unable to save file", (Throwable)ioe);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

