/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.chainsaw.messages.MessageCenter;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.pattern.ClassNamePatternConverter;
import org.apache.log4j.pattern.DatePatternConverter;
import org.apache.log4j.pattern.FileLocationPatternConverter;
import org.apache.log4j.pattern.FullLocationPatternConverter;
import org.apache.log4j.pattern.LevelPatternConverter;
import org.apache.log4j.pattern.LineLocationPatternConverter;
import org.apache.log4j.pattern.LineSeparatorPatternConverter;
import org.apache.log4j.pattern.LiteralPatternConverter;
import org.apache.log4j.pattern.LoggerPatternConverter;
import org.apache.log4j.pattern.LoggingEventPatternConverter;
import org.apache.log4j.pattern.MessagePatternConverter;
import org.apache.log4j.pattern.MethodLocationPatternConverter;
import org.apache.log4j.pattern.NDCPatternConverter;
import org.apache.log4j.pattern.PatternParser;
import org.apache.log4j.pattern.PropertiesPatternConverter;
import org.apache.log4j.pattern.RelativeTimePatternConverter;
import org.apache.log4j.pattern.SequenceNumberPatternConverter;
import org.apache.log4j.pattern.ThreadPatternConverter;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.apache.log4j.xml.SAXErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LogFilePatternLayoutBuilder {
    public static String getLogFormatFromPatternLayout(String patternLayout) {
        String input = OptionConverter.convertSpecialChars(patternLayout);
        ArrayList converters = new ArrayList();
        ArrayList fields = new ArrayList();
        Map converterRegistry = null;
        PatternParser.parse(input, converters, fields, converterRegistry, PatternParser.getPatternLayoutRules());
        return LogFilePatternLayoutBuilder.getFormatFromConverters(converters);
    }

    public static String getTimeStampFormat(String patternLayout) {
        int basicIndex = patternLayout.indexOf("%d");
        if (basicIndex < 0) {
            return null;
        }
        int index = patternLayout.indexOf("%d{");
        if (index < 0) {
            return "yyyy-MM-dd HH:mm:ss,SSS";
        }
        int length = patternLayout.substring(index).indexOf("}");
        String timestampFormat = patternLayout.substring(index + "%d{".length(), index + length);
        if (timestampFormat.equals("ABSOLUTE")) {
            return "HH:mm:ss,SSS";
        }
        if (timestampFormat.equals("ISO8601")) {
            return "yyyy-MM-dd HH:mm:ss,SSS";
        }
        if (timestampFormat.equals("DATE")) {
            return "dd MMM yyyy HH:mm:ss,SSS";
        }
        return timestampFormat;
    }

    private static String getFormatFromConverters(List converters) {
        StringBuffer buffer = new StringBuffer();
        for (LoggingEventPatternConverter converter : converters) {
            if (converter instanceof DatePatternConverter) {
                buffer.append("TIMESTAMP");
                continue;
            }
            if (converter instanceof MessagePatternConverter) {
                buffer.append("MESSAGE");
                continue;
            }
            if (converter instanceof LoggerPatternConverter) {
                buffer.append("LOGGER");
                continue;
            }
            if (converter instanceof ClassNamePatternConverter) {
                buffer.append("CLASS");
                continue;
            }
            if (converter instanceof RelativeTimePatternConverter) {
                buffer.append("PROP(RELATIVETIME)");
                continue;
            }
            if (converter instanceof ThreadPatternConverter) {
                buffer.append("THREAD");
                continue;
            }
            if (converter instanceof NDCPatternConverter) {
                buffer.append("NDC");
                continue;
            }
            if (converter instanceof LiteralPatternConverter) {
                LiteralPatternConverter literal = (LiteralPatternConverter)converter;
                literal.format(null, buffer);
                continue;
            }
            if (converter instanceof SequenceNumberPatternConverter) {
                buffer.append("PROP(log4jid)");
                continue;
            }
            if (converter instanceof LevelPatternConverter) {
                buffer.append("LEVEL");
                continue;
            }
            if (converter instanceof MethodLocationPatternConverter) {
                buffer.append("METHOD");
                continue;
            }
            if (converter instanceof FullLocationPatternConverter) {
                buffer.append("PROP(locationInfo)");
                continue;
            }
            if (converter instanceof LineLocationPatternConverter) {
                buffer.append("LINE");
                continue;
            }
            if (converter instanceof FileLocationPatternConverter) {
                buffer.append("FILE");
                continue;
            }
            if (converter instanceof PropertiesPatternConverter) {
                buffer.append("PROP(PROPERTIES)");
                continue;
            }
            if (!(converter instanceof LineSeparatorPatternConverter)) continue;
        }
        return buffer.toString();
    }

    public static Map getAppenderConfiguration(File file) {
        try {
            return LogFilePatternLayoutBuilder.getXMLFileAppenderConfiguration(file);
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            return LogFilePatternLayoutBuilder.getPropertiesFileAppenderConfiguration(file);
        }
        catch (Exception exception) {
            return new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getPropertiesFileAppenderConfiguration(File propertyFile) throws IOException, ParserConfigurationException, SAXException {
        HashMap result = new HashMap();
        String appenderPrefix = "log4j.appender";
        Properties props = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(propertyFile);
            props.load(inputStream);
            Enumeration<?> propertyNames = props.propertyNames();
            HashMap<String, String> appenders = new HashMap<String, String>();
            while (propertyNames.hasMoreElements()) {
                String value;
                String propertyName = propertyNames.nextElement().toString();
                if (!propertyName.startsWith(appenderPrefix) || (value = propertyName.substring(appenderPrefix.length() + 1)).indexOf(".") != -1) continue;
                appenders.put(value, props.getProperty(propertyName).trim());
            }
            for (Map.Entry appenderEntry : appenders.entrySet()) {
                String layout;
                String appenderName = appenderEntry.getKey().toString();
                String appenderClassName = appenderEntry.getValue().toString();
                if (!appenderClassName.toLowerCase(Locale.ENGLISH).endsWith("fileappender") || (layout = props.getProperty(appenderPrefix + "." + appenderName + ".layout")) == null || !layout.trim().equals("org.apache.log4j.PatternLayout")) continue;
                String conversion = props.getProperty(appenderPrefix + "." + appenderName + ".layout.ConversionPattern");
                String file = props.getProperty(appenderPrefix + "." + appenderName + ".File");
                if (conversion == null || file == null) continue;
                HashMap<String, String> entry = new HashMap<String, String>();
                entry.put("file", file.trim());
                entry.put("conversion", conversion.trim());
                result.put(appenderName, entry);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getXMLFileAppenderConfiguration(File file) throws IOException, ParserConfigurationException, SAXException {
        InputStream stream = file.toURI().toURL().openStream();
        HashMap result = new HashMap();
        try {
            InputSource src = new InputSource(stream);
            src.setSystemId(file.toURI().toURL().toString());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            docBuilder.setErrorHandler(new SAXErrorHandler());
            docBuilder.setEntityResolver(new Log4jEntityResolver());
            Document doc = docBuilder.parse(src);
            NodeList appenders = doc.getElementsByTagName("appender");
            for (int i = 0; i < appenders.getLength(); ++i) {
                Node appender = appenders.item(i);
                NamedNodeMap appenderAttributes = appender.getAttributes();
                Node appenderClass = appenderAttributes.getNamedItem("class");
                if (appenderAttributes.getNamedItem("name") == null || appenderClass == null || appenderClass.getNodeValue() == null || !appenderClass.getNodeValue().toLowerCase(Locale.ENGLISH).endsWith("fileappender")) continue;
                String appenderName = appenderAttributes.getNamedItem("name").getNodeValue();
                HashMap<String, String> entry = new HashMap<String, String>();
                NodeList appenderChildren = appender.getChildNodes();
                for (int j = 0; j < appenderChildren.getLength(); ++j) {
                    NamedNodeMap layoutAttributes;
                    Node layoutNode;
                    Node fileValueNode;
                    Node fileNameNode;
                    Node appenderChild = appenderChildren.item(j);
                    if (appenderChild.getNodeName().equals("param") && appenderChild.hasAttributes() && (fileNameNode = appenderChild.getAttributes().getNamedItem("name")) != null && fileNameNode.getNodeValue().equalsIgnoreCase("file") && (fileValueNode = appenderChild.getAttributes().getNamedItem("value")) != null) {
                        entry.put("file", fileValueNode.getNodeValue());
                    }
                    if (!appenderChild.getNodeName().equalsIgnoreCase("layout") || !appenderChild.hasAttributes() || (layoutNode = (layoutAttributes = appenderChild.getAttributes()).getNamedItem("class")) == null || layoutNode.getNodeValue() == null || !layoutNode.getNodeValue().equalsIgnoreCase("org.apache.log4j.PatternLayout")) continue;
                    NodeList layoutChildren = appenderChild.getChildNodes();
                    for (int k = 0; k < layoutChildren.getLength(); ++k) {
                        Node conversionValue;
                        Node layoutName;
                        Node layoutChild = layoutChildren.item(k);
                        if (!layoutChild.getNodeName().equals("param") || !layoutChild.hasAttributes() || (layoutName = layoutChild.getAttributes().getNamedItem("name")) == null || layoutName.getNodeValue() == null || !layoutName.getNodeValue().equalsIgnoreCase("conversionpattern") || (conversionValue = layoutChild.getAttributes().getNamedItem("value")) == null) continue;
                        entry.put("conversion", conversionValue.getNodeValue());
                    }
                }
                result.put(appenderName, entry);
            }
        }
        finally {
            stream.close();
        }
        MessageCenter.getInstance().getLogger().info("getXMLFileAppenderConfiguration for file: " + file + ", result: " + result);
        return result;
    }
}

