/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.dev.failsafe.internal;

import java.time.Duration;
import org.apache.kyuubi.shade.dev.failsafe.ExecutionContext;
import org.apache.kyuubi.shade.dev.failsafe.event.EventListener;
import org.apache.kyuubi.shade.dev.failsafe.event.ExecutionAttemptedEvent;
import org.apache.kyuubi.shade.dev.failsafe.event.ExecutionCompletedEvent;
import org.apache.kyuubi.shade.dev.failsafe.event.ExecutionScheduledEvent;
import org.apache.kyuubi.shade.dev.failsafe.spi.ExecutionResult;

public interface EventHandler<R> {
    public void handle(ExecutionResult<R> var1, ExecutionContext<R> var2);

    public static <R> EventHandler<R> ofExecutionCompleted(EventListener<ExecutionCompletedEvent<R>> handler) {
        return handler == null ? null : (result, context) -> handler.acceptUnchecked(new ExecutionCompletedEvent(result.getResult(), result.getException(), context));
    }

    public static <R> EventHandler<R> ofExecutionAttempted(EventListener<ExecutionAttemptedEvent<R>> handler) {
        return handler == null ? null : (result, context) -> handler.acceptUnchecked(new ExecutionAttemptedEvent(result.getResult(), result.getException(), context));
    }

    public static <R> EventHandler<R> ofExecutionScheduled(EventListener<ExecutionScheduledEvent<R>> handler) {
        return handler == null ? null : (result, context) -> handler.acceptUnchecked(new ExecutionScheduledEvent(result.getResult(), result.getException(), Duration.ofNanos(result.getDelay()), context));
    }
}

