/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ha.client.zookeeper;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.CreateBuilder;
import org.apache.curator.framework.api.CreateModable;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreMutex;
import org.apache.curator.framework.recipes.nodes.PersistentNode;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.utils.ZKPaths;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClient$;
import org.apache.kyuubi.ha.client.ServiceDiscovery;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.apache.kyuubi.ha.client.zookeeper.ZookeeperClientProvider$;
import org.apache.kyuubi.ha.client.zookeeper.ZookeeperDiscoveryClient$;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.util.KyuubiHadoopUtils$;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tuh\u0001B\u001b7\u0001\rC\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\u0006+\u0002!\tA\u0016\u0005\b5\u0002\u0011\r\u0011\"\u0003\\\u0011\u0019!\u0007\u0001)A\u00059\"IQ\r\u0001a\u0001\u0002\u0004%IA\u001a\u0005\n_\u0002\u0001\r\u00111A\u0005\nAD\u0011B\u001e\u0001A\u0002\u0003\u0005\u000b\u0015B4\t\u0013m\u0004\u0001\u0019!a\u0001\n\u0013a\bbCA+\u0001\u0001\u0007\t\u0019!C\u0005\u0003/B!\"a\u0017\u0001\u0001\u0004\u0005\t\u0015)\u0003~\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!!\u0019\u0001\t\u0003\ty\u0006C\u0004\u0002d\u0001!\t!!\u001a\t\u0013\u0005e\u0004!%A\u0005\u0002\u0005m\u0004bBAI\u0001\u0011\u0005\u00111\u0013\u0005\b\u0003G\u0003A\u0011AAS\u0011\u001d\tY\f\u0001C\u0001\u0003{Cq!!1\u0001\t\u0003\t\u0019\rC\u0004\u0002H\u0002!\t!!3\t\u0013\u0005E\u0007!%A\u0005\u0002\u0005m\u0004bBAj\u0001\u0011\u0005\u0011Q\u001b\u0005\b\u00033\u0004A\u0011AAn\u0011\u001d\u0011y\u0001\u0001C\u0001\u0005#AqA!\u000b\u0001\t\u0003\u0011Y\u0003C\u0004\u00034\u0001!\tA!\u000e\t\u0013\t=\u0003!%A\u0005\u0002\tE\u0003\"\u0003B+\u0001E\u0005I\u0011AA>\u0011\u001d\u00119\u0006\u0001C\u0001\u00053B\u0011Ba\u001b\u0001#\u0003%\tA!\u001c\t\u0013\tE\u0004!%A\u0005\u0002\u0005m\u0004b\u0002B:\u0001\u0011\u0005\u0011q\f\u0005\b\u0005k\u0002A\u0011\u0001B<\u0011\u001d\u0011Y\b\u0001C\u0001\u0005{B\u0011B!#\u0001#\u0003%\tA!\u001c\t\u0013\t-\u0005!%A\u0005\u0002\u0005m\u0004b\u0002BG\u0001\u0011\u0005!q\u0012\u0005\n\u0005w\u0003\u0011\u0013!C\u0001\u0003wB\u0001B!0\u0001\t\u0003A$q\u0018\u0005\b\u0005\u000b\u0004A\u0011\u0002Bd\u0011%\u0011\u0019\u000eAI\u0001\n\u0013\u0011i\u0007C\u0005\u0003V\u0002\t\n\u0011\"\u0003\u0002|!9!q\u001b\u0001\u0005\n\u0005}c!B@\u0001\u0001\u0005\u0005\u0001BCA\u000fW\t\u0015\r\u0011\"\u0001\u0002 !Q\u0011qG\u0016\u0003\u0002\u0003\u0006I!!\t\t\u0015\u0005e2F!A!\u0002\u0013\tY\u0004\u0003\u0004VW\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u000fZC\u0011IA%\u000f\u001d\u0011IN\u000eE\u0001\u000574a!\u000e\u001c\t\u0002\tu\u0007BB+3\t\u0003\u00119\u000f\u0003\u0006\u0003jJB)\u0019!C\u0007\u0005W\u0014\u0001DW8pW\u0016,\u0007/\u001a:ESN\u001cwN^3ss\u000ec\u0017.\u001a8u\u0015\t9\u0004(A\u0005{_>\\W-\u001a9fe*\u0011\u0011HO\u0001\u0007G2LWM\u001c;\u000b\u0005mb\u0014A\u00015b\u0015\tid(\u0001\u0004lsV,(-\u001b\u0006\u0003\u007f\u0001\u000ba!\u00199bG\",'\"A!\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!%\n\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeI\u0001\u0004B]f\u0014VM\u001a\t\u0003\u00172k\u0011\u0001O\u0005\u0003\u001bb\u0012q\u0002R5tG>4XM]=DY&,g\u000e^\u0001\u0005G>tg\r\u0005\u0002Q'6\t\u0011K\u0003\u0002Sy\u000511m\u001c8gS\u001eL!\u0001V)\u0003\u0015-KX/\u001e2j\u0007>tg-\u0001\u0004=S:LGO\u0010\u000b\u0003/f\u0003\"\u0001\u0017\u0001\u000e\u0003YBQA\u0014\u0002A\u0002=\u000b\u0001B_6DY&,g\u000e^\u000b\u00029B\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\nMJ\fW.Z<pe.T!!\u0019 \u0002\u000f\r,(/\u0019;pe&\u00111M\u0018\u0002\u0011\u0007V\u0014\u0018\r^8s\rJ\fW.Z<pe.\f\u0011B_6DY&,g\u000e\u001e\u0011\u0002\u0017M,'O^5dK:{G-Z\u000b\u0002OB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\u0006]>$Wm\u001d\u0006\u0003Yz\u000bqA]3dSB,7/\u0003\u0002oS\nq\u0001+\u001a:tSN$XM\u001c;O_\u0012,\u0017aD:feZL7-\u001a(pI\u0016|F%Z9\u0015\u0005E$\bCA#s\u0013\t\u0019hI\u0001\u0003V]&$\bbB;\u0007\u0003\u0003\u0005\raZ\u0001\u0004q\u0012\n\u0014\u0001D:feZL7-\u001a(pI\u0016\u0004\u0003FA\u0004y!\t)\u00150\u0003\u0002{\r\nAao\u001c7bi&dW-A\u0004xCR\u001c\u0007.\u001a:\u0016\u0003u\u0004\"A`\u0016\u000e\u0003\u0001\u0011\u0011\u0003R3SK\u001eL7\u000f^3s/\u0006$8\r[3s'\u0015Y\u00131AA\n!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\tA\u0001\\1oO*\u0011\u0011QB\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0012\u0005\u001d!AB(cU\u0016\u001cG\u000f\u0005\u0003\u0002\u0016\u0005eQBAA\f\u0015\t9d(\u0003\u0003\u0002\u001c\u0005]!aB,bi\u000eDWM]\u0001\tS:\u001cH/\u00198dKV\u0011\u0011\u0011\u0005\t\u0005\u0003G\t\tD\u0004\u0003\u0002&\u00055\u0002cAA\u0014\r6\u0011\u0011\u0011\u0006\u0006\u0004\u0003W\u0011\u0015A\u0002\u001fs_>$h(C\u0002\u00020\u0019\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u001a\u0003k\u0011aa\u0015;sS:<'bAA\u0018\r\u0006I\u0011N\\:uC:\u001cW\rI\u0001\u0011g\u0016\u0014h/[2f\t&\u001c8m\u001c<fef\u00042aSA\u001f\u0013\r\ty\u0004\u000f\u0002\u0011'\u0016\u0014h/[2f\t&\u001c8m\u001c<fef$R!`A\"\u0003\u000bBq!!\b0\u0001\u0004\t\t\u0003C\u0004\u0002:=\u0002\r!a\u000f\u0002\u000fA\u0014xnY3tgR\u0019\u0011/a\u0013\t\u000f\u00055\u0003\u00071\u0001\u0002P\u0005)QM^3oiB!\u0011QCA)\u0013\u0011\t\u0019&a\u0006\u0003\u0019]\u000bGo\u00195fI\u00163XM\u001c;\u0002\u0017]\fGo\u00195fe~#S-\u001d\u000b\u0004c\u0006e\u0003bB;\n\u0003\u0003\u0005\r!`\u0001\to\u0006$8\r[3sA\u0005a1M]3bi\u0016\u001cE.[3oiR\t\u0011/A\u0006dY>\u001cXm\u00117jK:$\u0018AB2sK\u0006$X\r\u0006\u0005\u0002\"\u0005\u001d\u00141NA8\u0011\u001d\tI'\u0004a\u0001\u0003C\tA\u0001]1uQ\"9\u0011QN\u0007A\u0002\u0005\u0005\u0012\u0001B7pI\u0016D\u0011\"!\u001d\u000e!\u0003\u0005\r!a\u001d\u0002\u0019\r\u0014X-\u0019;f!\u0006\u0014XM\u001c;\u0011\u0007\u0015\u000b)(C\u0002\u0002x\u0019\u0013qAQ8pY\u0016\fg.\u0001\tde\u0016\fG/\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0010\u0016\u0005\u0003g\nyh\u000b\u0002\u0002\u0002B!\u00111QAG\u001b\t\t)I\u0003\u0003\u0002\b\u0006%\u0015!C;oG\",7m[3e\u0015\r\tYIR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAH\u0003\u000b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u001d9W\r\u001e#bi\u0006$B!!&\u0002\"B)Q)a&\u0002\u001c&\u0019\u0011\u0011\u0014$\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\u0015\u000bi*C\u0002\u0002 \u001a\u0013AAQ=uK\"9\u0011\u0011N\bA\u0002\u0005\u0005\u0012aC4fi\u000eC\u0017\u000e\u001c3sK:$B!a*\u0002:B1\u0011\u0011VAZ\u0003CqA!a+\u00020:!\u0011qEAW\u0013\u00059\u0015bAAY\r\u00069\u0001/Y2lC\u001e,\u0017\u0002BA[\u0003o\u0013A\u0001T5ti*\u0019\u0011\u0011\u0017$\t\u000f\u0005%\u0004\u00031\u0001\u0002\"\u0005Q\u0001/\u0019;i\u000bbL7\u000f^:\u0015\t\u0005M\u0014q\u0018\u0005\b\u0003S\n\u0002\u0019AA\u0011\u00035\u0001\u0018\r\u001e5O_:,\u00050[:ugR!\u00111OAc\u0011\u001d\tIG\u0005a\u0001\u0003C\ta\u0001Z3mKR,G#B9\u0002L\u00065\u0007bBA5'\u0001\u0007\u0011\u0011\u0005\u0005\n\u0003\u001f\u001c\u0002\u0013!a\u0001\u0003g\na\u0002Z3mKR,7\t[5mIJ,g.\u0001\teK2,G/\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u0005aQn\u001c8ji>\u00148\u000b^1uKR\u0019\u0011/a6\t\u000f\u0005eR\u00031\u0001\u0002<\u0005YAO]=XSRDGj\\2l+\u0011\ti.!:\u0015\r\u0005}'\u0011\u0001B\u0003)\u0011\t\t/a>\u0011\t\u0005\r\u0018Q\u001d\u0007\u0001\t\u001d\t9O\u0006b\u0001\u0003S\u0014\u0011\u0001V\t\u0005\u0003W\f\t\u0010E\u0002F\u0003[L1!a<G\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!RAz\u0013\r\t)P\u0012\u0002\u0004\u0003:L\b\u0002CA}-\u0011\u0005\r!a?\u0002\u0003\u0019\u0004R!RA\u007f\u0003CL1!a@G\u0005!a$-\u001f8b[\u0016t\u0004b\u0002B\u0002-\u0001\u0007\u0011\u0011E\u0001\tY>\u001c7\u000eU1uQ\"9!q\u0001\fA\u0002\t%\u0011a\u0002;j[\u0016|W\u000f\u001e\t\u0004\u000b\n-\u0011b\u0001B\u0007\r\n!Aj\u001c8h\u000359W\r^*feZ,'\u000fS8tiR!!1\u0003B\u0013!\u0015)%Q\u0003B\r\u0013\r\u00119B\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f\u0015\u0013Y\"!\t\u0003 %\u0019!Q\u0004$\u0003\rQ+\b\u000f\\33!\r)%\u0011E\u0005\u0004\u0005G1%aA%oi\"9!qE\fA\u0002\u0005\u0005\u0012!\u00038b[\u0016\u001c\b/Y2f\u0003A9W\r^#oO&tWMQ=SK\u001aLE\r\u0006\u0004\u0003\u0014\t5\"q\u0006\u0005\b\u0005OA\u0002\u0019AA\u0011\u0011\u001d\u0011\t\u0004\u0007a\u0001\u0003C\t1\"\u001a8hS:,'+\u001a4JI\u0006\u0019r-\u001a;TKJ4\u0018nY3O_\u0012,7/\u00138g_RA!q\u0007B\"\u0005\u000b\u0012Y\u0005\u0005\u0004\u0002*\ne\"QH\u0005\u0005\u0005w\t9LA\u0002TKF\u00042a\u0013B \u0013\r\u0011\t\u0005\u000f\u0002\u0010'\u0016\u0014h/[2f\u001d>$W-\u00138g_\"9!qE\rA\u0002\u0005\u0005\u0002\"\u0003B$3A\u0005\t\u0019\u0001B%\u0003\u001d\u0019\u0018N_3PaR\u0004R!\u0012B\u000b\u0005?A\u0011B!\u0014\u001a!\u0003\u0005\r!a\u001d\u0002\rMLG.\u001a8u\u0003u9W\r^*feZL7-\u001a(pI\u0016\u001c\u0018J\u001c4pI\u0011,g-Y;mi\u0012\u0012TC\u0001B*U\u0011\u0011I%a \u0002;\u001d,GoU3sm&\u001cWMT8eKNLeNZ8%I\u00164\u0017-\u001e7uIM\nqB]3hSN$XM]*feZL7-\u001a\u000b\fc\nm#Q\fB0\u0005C\u00129\u0007C\u0003O9\u0001\u0007q\nC\u0004\u0003(q\u0001\r!!\t\t\u000f\u0005eB\u00041\u0001\u0002<!I!1\r\u000f\u0011\u0002\u0003\u0007!QM\u0001\bm\u0016\u00148/[8o!\u0015)%QCA\u0011\u0011%\u0011I\u0007\bI\u0001\u0002\u0004\t\u0019(\u0001\u0005fqR,'O\\1m\u0003e\u0011XmZ5ti\u0016\u00148+\u001a:wS\u000e,G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t=$\u0006\u0002B3\u0003\u007f\n\u0011D]3hSN$XM]*feZL7-\u001a\u0013eK\u001a\fW\u000f\u001c;%k\u0005\tB-\u001a:fO&\u001cH/\u001a:TKJ4\u0018nY3\u0002+A|7\u000f\u001e#fe\u0016<\u0017n\u001d;feN+'O^5dKR!\u00111\u000fB=\u0011\u001d\u00119\u0003\ta\u0001\u0003C\tqc\u0019:fCR,\u0017I\u001c3HKR\u001cVM\u001d<jG\u0016tu\u000eZ3\u0015\u0019\u0005\u0005\"q\u0010BA\u0005\u0007\u0013)Ia\"\t\u000b9\u000b\u0003\u0019A(\t\u000f\t\u001d\u0012\u00051\u0001\u0002\"!9\u0011QD\u0011A\u0002\u0005\u0005\u0002\"\u0003B2CA\u0005\t\u0019\u0001B3\u0011%\u0011I'\tI\u0001\u0002\u0004\t\u0019(A\u0011de\u0016\fG/Z!oI\u001e+GoU3sm&\u001cWMT8eK\u0012\"WMZ1vYR$C'A\u0011de\u0016\fG/Z!oI\u001e+GoU3sm&\u001cWMT8eK\u0012\"WMZ1vYR$S'A\bti\u0006\u0014HoU3de\u0016$hj\u001c3f)%\t(\u0011\u0013BK\u00053\u0013i\nC\u0004\u0003\u0014\u0012\u0002\r!!\t\u0002\u0015\r\u0014X-\u0019;f\u001b>$W\rC\u0004\u0003\u0018\u0012\u0002\r!!\t\u0002\u0011\t\f7/\u001a)bi\"DqAa'%\u0001\u0004\t\t#\u0001\u0005j]&$H)\u0019;b\u0011%\u0011y\n\nI\u0001\u0002\u0004\t\u0019(A\u0007vg\u0016\u0004&o\u001c;fGRLwN\u001c\u0015\u0004I\t\r\u0006\u0003\u0002BS\u0005ok!Aa*\u000b\t\t%&1V\u0001\fC:tw\u000e^1uS>t7O\u0003\u0003\u0003.\n=\u0016AB2p[6|gN\u0003\u0003\u00032\nM\u0016AB4p_\u001edWM\u0003\u0002\u00036\u0006\u00191m\\7\n\t\te&q\u0015\u0002\u0012-&\u001c\u0018N\u00197f\r>\u0014H+Z:uS:<\u0017!G:uCJ$8+Z2sKRtu\u000eZ3%I\u00164\u0017-\u001e7uIQ\n\u0011#\u00193e\u0007>tgm\u001d+p!V\u0014G.[:i)\u0019\t\tC!1\u0003D\")aJ\na\u0001\u001f\"9\u0011Q\u0004\u0014A\u0002\u0005\u0005\u0012\u0001F2sK\u0006$X\rU3sg&\u001cH/\u001a8u\u001d>$W\rF\u0006h\u0005\u0013\u0014YM!4\u0003P\nE\u0007\"\u0002((\u0001\u0004y\u0005b\u0002B\u0014O\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003;9\u0003\u0019AA\u0011\u0011%\u0011\u0019g\nI\u0001\u0002\u0004\u0011)\u0007C\u0005\u0003j\u001d\u0002\n\u00111\u0001\u0002t\u0005q2M]3bi\u0016\u0004VM]:jgR,g\u000e\u001e(pI\u0016$C-\u001a4bk2$H\u0005N\u0001\u001fGJ,\u0017\r^3QKJ\u001c\u0018n\u001d;f]Rtu\u000eZ3%I\u00164\u0017-\u001e7uIU\n\u0011b^1uG\"tu\u000eZ3\u00021i{wn[3fa\u0016\u0014H)[:d_Z,'/_\"mS\u0016tG\u000f\u0005\u0002YeM!!\u0007\u0012Bp!\u0011\u0011\tOa9\u000e\u0003qJ1A!:=\u0005\u001daunZ4j]\u001e$\"Aa7\u0002#\r|gN\\3di&|gn\u00115fG.,'/\u0006\u0002\u0003nB!!q\u001eB}\u001b\t\u0011\tP\u0003\u0003\u0003t\nU\u0018AC2p]\u000e,(O]3oi*!!q_A\u0006\u0003\u0011)H/\u001b7\n\t\tm(\u0011\u001f\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007")
public class ZookeeperDiscoveryClient
implements DiscoveryClient {
    public final KyuubiConf org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$conf;
    private final CuratorFramework zkClient;
    private volatile PersistentNode serviceNode;
    private DeRegisterWatcher watcher;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private CuratorFramework zkClient() {
        return this.zkClient;
    }

    private PersistentNode serviceNode() {
        return this.serviceNode;
    }

    private void serviceNode_$eq(PersistentNode x$1) {
        this.serviceNode = x$1;
    }

    private DeRegisterWatcher watcher() {
        return this.watcher;
    }

    private void watcher_$eq(DeRegisterWatcher x$1) {
        this.watcher = x$1;
    }

    @Override
    public void createClient() {
        this.zkClient().start();
    }

    @Override
    public void closeClient() {
        block0: {
            if (this.zkClient() == null) break block0;
            this.zkClient().close();
        }
    }

    @Override
    public String create(String path, String mode, boolean createParent) {
        CreateBuilder builder = createParent ? this.zkClient().create().creatingParentsIfNeeded() : this.zkClient().create();
        return (String)((PathAndBytesable)((CreateModable)builder).withMode(CreateMode.valueOf((String)mode))).forPath(path);
    }

    @Override
    public boolean create$default$3() {
        return true;
    }

    @Override
    public byte[] getData(String path) {
        return (byte[])this.zkClient().getData().forPath(path);
    }

    @Override
    public List<String> getChildren(String path) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)this.zkClient().getChildren().forPath(path)).asScala()).toList();
    }

    @Override
    public boolean pathExists(String path) {
        return this.zkClient().checkExists().forPath(path) != null;
    }

    @Override
    public boolean pathNonExists(String path) {
        return this.zkClient().checkExists().forPath(path) == null;
    }

    @Override
    public void delete(String path, boolean deleteChildren) {
        if (deleteChildren) {
            this.zkClient().delete().deletingChildrenIfNeeded().forPath(path);
        } else {
            this.zkClient().delete().forPath(path);
        }
    }

    @Override
    public boolean delete$default$2() {
        return false;
    }

    @Override
    public void monitorState(ServiceDiscovery serviceDiscovery) {
        this.zkClient().getConnectionStateListenable().addListener((Object)new ConnectionStateListener(this, serviceDiscovery){
            private final AtomicBoolean org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$isConnected;
            private final /* synthetic */ ZookeeperDiscoveryClient $outer;
            public final ServiceDiscovery serviceDiscovery$1;

            public AtomicBoolean org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$isConnected() {
                return this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$isConnected;
            }

            public void stateChanged(CuratorFramework client, ConnectionState newState) {
                this.$outer.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Zookeeper client connection state changed to: ").append(newState).toString());
                ConnectionState connectionState = newState;
                boolean bl = ConnectionState.CONNECTED.equals(connectionState) ? true : ConnectionState.RECONNECTED.equals(connectionState);
                if (bl) {
                    this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$isConnected().set(true);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (ConnectionState.LOST.equals(connectionState)) {
                    this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$isConnected().set(false);
                    long delay = ZookeeperClientProvider$.MODULE$.getGracefulStopThreadDelay(this.$outer.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$conf);
                    ZookeeperDiscoveryClient$.MODULE$.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$connectionChecker().schedule(new Runnable(this, newState, delay){
                        private final /* synthetic */ $anon$1 $outer;
                        private final ConnectionState newState$1;
                        private final long delay$1;

                        public void run() {
                            block0: {
                                if (this.$outer.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$isConnected().get()) break block0;
                                this.$outer.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$$outer().error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(121).append("Zookeeper client connection state changed to: ").append($this.newState$1).append(",").append(" but failed to reconnect in ").append($this.delay$1 / 1000L).append(" seconds.").append(" Give up retry and stop gracefully . ").toString());
                                this.$outer.serviceDiscovery$1.stopGracefully(true);
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.newState$1 = newState$1;
                            this.delay$1 = delay$1;
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.kyuubi.ha.client.zookeeper.ZookeeperDiscoveryClient$$anon$1$$anon$2 )}, serializedLambda);
                        }
                    }, delay, TimeUnit.MILLISECONDS);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            public /* synthetic */ ZookeeperDiscoveryClient org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.serviceDiscovery$1 = serviceDiscovery$1;
                this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$anon$$isConnected = new AtomicBoolean(false);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$stateChanged$1(org.apache.curator.framework.state.ConnectionState )}, serializedLambda);
            }
        });
    }

    @Override
    public <T> T tryWithLock(String lockPath, long timeout, Function0<T> f) {
        Object object;
        InterProcessSemaphoreMutex lock = null;
        try {
            try {
                lock = new InterProcessSemaphoreMutex(this.zkClient(), lockPath);
                boolean acquired = lock.acquire(timeout, TimeUnit.MILLISECONDS);
                if (!acquired) {
                    throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(111).append("Timeout to lock on path [").append(lockPath).append("] after ").append(timeout).append(" ms. There would be some problem that other session may ").append("create engine timeout.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                }
            }
            catch (KyuubiSQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(22).append("Lock failed on path [").append(lockPath).append("]").toString(), (Throwable)e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }
            object = f.apply();
        }
        catch (Throwable throwable) {
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        Object object2 = object;
        try {
            if (lock != null) {
                lock.release();
            }
        }
        catch (Exception exception) {}
        return (T)object2;
    }

    @Override
    public Option<Tuple2<String, Object>> getServerHost(String namespace) {
        None$ none$;
        Seq<ServiceNodeInfo> seq = this.getServiceNodesInfo(namespace, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)1)), true);
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            ServiceNodeInfo sn = (ServiceNodeInfo)((SeqLike)some.get()).apply(0);
            none$ = new Some((Object)new Tuple2((Object)sn.host(), (Object)BoxesRunTime.boxToInteger((int)sn.port())));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Option<Tuple2<String, Object>> getEngineByRefId(String namespace, String engineRefId) {
        String x$12 = namespace;
        boolean x$2 = true;
        Option<Object> x$3 = this.getServiceNodesInfo$default$2();
        return this.getServiceNodesInfo(x$12, x$3, x$2).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZookeeperDiscoveryClient.$anonfun$getEngineByRefId$1(engineRefId, x$1))).map((Function1 & Serializable & scala.Serializable)data -> new Tuple2((Object)data.host(), (Object)BoxesRunTime.boxToInteger((int)data.port())));
    }

    @Override
    public Seq<ServiceNodeInfo> getServiceNodesInfo(String namespace, Option<Object> sizeOpt, boolean silent) {
        Nil$ nil$;
        try {
            java.util.List hosts = (java.util.List)this.zkClient().getChildren().forPath(namespace);
            int size = BoxesRunTime.unboxToInt((Object)sizeOpt.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> hosts.size()));
            nil$ = (Seq)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(hosts).asScala()).takeRight(size)).map((Function1 & Serializable & scala.Serializable)p -> {
                String path = ZKPaths.makePath((String)namespace, (String)p);
                String instance = new String((byte[])this.zkClient().getData().forPath(path), StandardCharsets.UTF_8);
                Tuple2<String, Object> tuple2 = DiscoveryClient$.MODULE$.parseInstanceHostPort(instance);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String host = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
                Tuple2 tuple23 = tuple22;
                String host2 = (String)tuple23._1();
                int port2 = tuple23._2$mcI$sp();
                Option version = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.split(";"))).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.startsWith("version="))).map((Function1 & Serializable & scala.Serializable)x$5 -> new StringOps(Predef$.MODULE$.augmentString(x$5)).stripPrefix("version="));
                Option engineRefId = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])p.split(";"))).find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.startsWith("refId="))).map((Function1 & Serializable & scala.Serializable)x$7 -> new StringOps(Predef$.MODULE$.augmentString(x$7)).stripPrefix("refId="));
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Get service instance:").append(instance).append(" and version:").append(version).append(" under ").append(namespace).toString());
                return new ServiceNodeInfo(namespace, (String)p, host2, port2, (Option<String>)version, (Option<String>)engineRefId);
            }, Buffer$.MODULE$.canBuildFrom());
        }
        catch (Exception exception) {
            if (silent) {
                nil$ = Nil$.MODULE$;
            } else {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Failed to get service node info", exception);
                nil$ = Nil$.MODULE$;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return nil$;
    }

    @Override
    public Option<Object> getServiceNodesInfo$default$2() {
        return None$.MODULE$;
    }

    @Override
    public boolean getServiceNodesInfo$default$3() {
        return false;
    }

    @Override
    public void registerService(KyuubiConf conf, String namespace, ServiceDiscovery serviceDiscovery, Option<String> version, boolean external) {
        String instance = serviceDiscovery.fe().connectionUrl();
        this.watcher_$eq(new DeRegisterWatcher(this, instance, serviceDiscovery));
        this.serviceNode_$eq(this.createPersistentNode(conf, namespace, instance, version, external));
        this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$watchNode();
    }

    @Override
    public Option<String> registerService$default$4() {
        return None$.MODULE$;
    }

    @Override
    public boolean registerService$default$5() {
        return false;
    }

    @Override
    public void deregisterService() {
        block7: {
            if (this.serviceNode() != null) {
                try {
                    try {
                        this.serviceNode().close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        boolean bl = throwable2 instanceof IOException ? true : throwable2 instanceof KeeperException;
                        if (bl) {
                            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Failed to close the persistent ephemeral znode").append(this.serviceNode().getActualPath()).toString(), throwable2);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.serviceNode_$eq(null);
                }
            }
        }
    }

    @Override
    public boolean postDeregisterService(String namespace) {
        boolean bl;
        if (namespace != null) {
            try {
                this.delete(namespace, true);
                bl = true;
            }
            catch (KeeperException e) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Failed to delete ").append(namespace).toString(), e);
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public String createAndGetServiceNode(KyuubiConf conf, String namespace, String instance, Option<String> version, boolean external) {
        return this.createPersistentNode(conf, namespace, instance, version, external).getActualPath();
    }

    @Override
    public Option<String> createAndGetServiceNode$default$4() {
        return None$.MODULE$;
    }

    @Override
    public boolean createAndGetServiceNode$default$5() {
        return false;
    }

    @Override
    @VisibleForTesting
    public void startSecretNode(String createMode, String basePath, String initData, boolean useProtection) {
        PersistentNode secretNode = new PersistentNode(this.zkClient(), CreateMode.valueOf((String)createMode), useProtection, basePath, initData.getBytes(StandardCharsets.UTF_8));
        secretNode.start();
    }

    @Override
    public boolean startSecretNode$default$4() {
        return false;
    }

    public String addConfsToPublish(KyuubiConf conf, String instance) {
        if (!instance.contains(":")) {
            return instance;
        }
        String[] hostPort = instance.split(":", 2);
        Map confsToPublish = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.thrift.bind.host"), (Object)hostPort[0]));
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.transport.mode"), (Object)"binary"));
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.thrift.port"), (Object)hostPort[1]));
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.thrift.sasl.qop"), conf.get(KyuubiConf$.MODULE$.SASL_QOP())));
        String authenticationMethod = ((TraversableOnce)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_METHOD())).mkString(",");
        confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.authentication"), (Object)authenticationMethod));
        Object object = authenticationMethod.equalsIgnoreCase("KERBEROS") ? confsToPublish.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hive.server2.authentication.kerberos.principal"), ((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_PRINCIPAL())).map((Function1 & Serializable & scala.Serializable)principal -> KyuubiHadoopUtils$.MODULE$.getServerPrincipal(principal)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""))) : BoxedUnit.UNIT;
        return ((TraversableOnce)confsToPublish.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(";");
    }

    private PersistentNode createPersistentNode(KyuubiConf conf, String namespace, String instance, Option<String> version, boolean external) {
        Object object;
        String ns = ZKPaths.makePath(null, (String)namespace);
        try {
            object = ((PathAndBytesable)this.zkClient().create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(ns);
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            object = BoxedUnit.UNIT;
        }
        catch (KeeperException e) {
            throw new KyuubiException(new StringBuilder(29).append("Failed to create namespace '").append(ns).append("'").toString(), (Throwable)e);
        }
        String session = (String)((Option)conf.get(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID())).map((Function1 & Serializable & scala.Serializable)refId -> new StringBuilder(7).append("refId=").append((String)refId).append(";").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String pathPrefix = ZKPaths.makePath((String)namespace, (String)new StringBuilder(30).append("serviceUri=").append(instance).append(";version=").append(version.getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.KYUUBI_VERSION())).append(";").append(session).append("sequence=").toString());
        ObjectRef localServiceNode = ObjectRef.create(null);
        CreateMode createMode = external ? CreateMode.PERSISTENT_SEQUENTIAL : CreateMode.EPHEMERAL_SEQUENTIAL;
        String znodeData = BoxesRunTime.unboxToBoolean((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_PUBLISH_CONFIGS())) && session.isEmpty() ? this.addConfsToPublish(conf, instance) : instance;
        try {
            localServiceNode.elem = new PersistentNode(this.zkClient(), createMode, false, pathPrefix, znodeData.getBytes(StandardCharsets.UTF_8));
            ((PersistentNode)localServiceNode.elem).start();
            long znodeTimeout = BoxesRunTime.unboxToLong((Object)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_NODE_TIMEOUT()));
            if (!((PersistentNode)localServiceNode.elem).waitForInitialCreate(znodeTimeout, TimeUnit.MILLISECONDS)) {
                throw new KyuubiException(new StringBuilder(41).append("Max znode creation wait time ").append(znodeTimeout).append(" s exhausted").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
            }
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Created a ").append(((PersistentNode)localServiceNode$1.elem).getActualPath()).append(" on ZooKeeper for KyuubiServer uri:").append(" ").append(instance).toString());
        }
        catch (Exception e) {
            if ((PersistentNode)localServiceNode.elem != null) {
                ((PersistentNode)localServiceNode.elem).close();
            }
            throw new KyuubiException(new StringBuilder(51).append("Unable to create a znode for this server instance: ").append(instance).toString(), (Throwable)e);
        }
        return (PersistentNode)localServiceNode.elem;
    }

    private Option<String> createPersistentNode$default$4() {
        return None$.MODULE$;
    }

    private boolean createPersistentNode$default$5() {
        return false;
    }

    public void org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$watchNode() {
        if (((Pathable)this.zkClient().checkExists().usingWatcher((Watcher)this.watcher())).forPath(this.serviceNode().getActualPath()) == null) {
            throw new KyuubiException(new StringBuilder(63).append("Unable to create znode for this Kyuubi ").append("instance[").append(this.watcher().instance()).append("] on ZooKeeper.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getEngineByRefId$1(String engineRefId$1, ServiceNodeInfo x$1) {
        return x$1.engineRefId().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equals(engineRefId$1)));
    }

    public ZookeeperDiscoveryClient(KyuubiConf conf) {
        this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$conf = conf;
        Logging.$init$((Logging)this);
        this.zkClient = ZookeeperClientProvider$.MODULE$.buildZookeeperClient(conf);
    }

    public class DeRegisterWatcher
    implements Watcher {
        private final String instance;
        private final ServiceDiscovery serviceDiscovery;
        public final /* synthetic */ ZookeeperDiscoveryClient $outer;

        public String instance() {
            return this.instance;
        }

        public void process(WatchedEvent event) {
            block1: {
                block0: {
                    Watcher.Event.EventType eventType = event.getType();
                    Watcher.Event.EventType eventType2 = Watcher.Event.EventType.NodeDeleted;
                    if (eventType != null ? !eventType.equals(eventType2) : eventType2 != null) break block0;
                    this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$DeRegisterWatcher$$$outer().warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(128).append("This Kyuubi instance ").append(this.instance()).append(" is now de-registered from").append(" ZooKeeper. The server will be shut down after the last client session completes.").toString());
                    this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$DeRegisterWatcher$$$outer().deregisterService();
                    this.serviceDiscovery.stopGracefully(this.serviceDiscovery.stopGracefully$default$1());
                    break block1;
                }
                Watcher.Event.EventType eventType = event.getType();
                Watcher.Event.EventType eventType3 = Watcher.Event.EventType.NodeDataChanged;
                if (eventType != null ? !eventType.equals(eventType3) : eventType3 != null) break block1;
                this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$DeRegisterWatcher$$$outer().warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("This Kyuubi instance ").append(this.instance()).append(" now receives the NodeDataChanged event").toString());
                this.org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$DeRegisterWatcher$$$outer().org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$$watchNode();
            }
        }

        public /* synthetic */ ZookeeperDiscoveryClient org$apache$kyuubi$ha$client$zookeeper$ZookeeperDiscoveryClient$DeRegisterWatcher$$$outer() {
            return this.$outer;
        }

        public DeRegisterWatcher(ZookeeperDiscoveryClient $outer, String instance, ServiceDiscovery serviceDiscovery) {
            this.instance = instance;
            this.serviceDiscovery = serviceDiscovery;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

