/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication;

import java.io.Serializable;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.authentication.EngineSecuritySecretProvider;
import org.apache.kyuubi.service.authentication.EngineSecuritySecretProvider$;
import org.apache.kyuubi.service.authentication.InternalSecurityAccessor$;
import org.apache.kyuubi.service.authentication.KyuubiInternalAccessIdentifier;
import org.apache.kyuubi.service.authentication.KyuubiInternalAccessIdentifier$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001\u0002\u0014(\u0001IB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0001\u0002\u0011)\u0019!C\u0001\u0003\"AQ\t\u0001B\u0001B\u0003%!\tC\u0003G\u0001\u0011\u0005q\tC\u0004M\u0001\t\u0007I\u0011A'\t\rE\u0003\u0001\u0015!\u0003O\u0011\u001d\u0011\u0006A1A\u0005\u00025Caa\u0015\u0001!\u0002\u0013q\u0005b\u0002+\u0001\u0005\u0004%\t!\u0016\u0005\u0007C\u0002\u0001\u000b\u0011\u0002,\t\u000f\t\u0004!\u0019!C\u0001+\"11\r\u0001Q\u0001\nYCq\u0001\u001a\u0001C\u0002\u0013%Q\r\u0003\u0004j\u0001\u0001\u0006IA\u001a\u0005\bU\u0002\u0011\r\u0011\"\u0003l\u0011\u0019y\u0007\u0001)A\u0005Y\"Q\u0001\u000f\u0001I\u0001\u0002\u0007\u0005\u000b\u0011B9\t\u000fq\u0004!\u0019!C\u0005{\"1a\u0010\u0001Q\u0001\nQDqa \u0001C\u0002\u0013%Q\u0010C\u0004\u0002\u0002\u0001\u0001\u000b\u0011\u0002;\t\u000f\u0005\r\u0001\u0001\"\u0003\u0002\u0006!9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\t\u0003C\u0001A\u0011A\u0014\u0002$!A\u0011\u0011\u0006\u0001\u0005\u0002\u001d\nY\u0003C\u0004\u00020\u0001!I!!\r\t\u000f\u0005U\u0002\u0001\"\u0003\u00028!9\u0011\u0011\n\u0001\u0005\n\u0005-saBA)O!\u0005\u00111\u000b\u0004\u0007M\u001dB\t!!\u0016\t\r\u0019{B\u0011AA0\u0011-\t\tg\ba\u0001\u0002\u0004%I!a\u0019\t\u0017\u0005\u0015t\u00041AA\u0002\u0013%\u0011q\r\u0005\u000b\u0003Wz\u0002\u0019!A!B\u0013A\u0005bBA;?\u0011\u0005\u0011q\u000f\u0005\b\u0003{zB\u0011AA@\u0005aIe\u000e^3s]\u0006d7+Z2ve&$\u00180Q2dKN\u001cxN\u001d\u0006\u0003Q%\na\"Y;uQ\u0016tG/[2bi&|gN\u0003\u0002+W\u000591/\u001a:wS\u000e,'B\u0001\u0017.\u0003\u0019Y\u00170^;cS*\u0011afL\u0001\u0007CB\f7\r[3\u000b\u0003A\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u001a\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\r\u0005s\u0017PU3g\u0003\u0011\u0019wN\u001c4\u0011\u0005mrT\"\u0001\u001f\u000b\u0005uZ\u0013AB2p]\u001aLw-\u0003\u0002@y\tQ1*_;vE&\u001cuN\u001c4\u0002\u0011%\u001c8+\u001a:wKJ,\u0012A\u0011\t\u0003i\rK!\u0001R\u001b\u0003\u000f\t{w\u000e\\3b]\u0006I\u0011n]*feZ,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007!S5\n\u0005\u0002J\u00015\tq\u0005C\u0003:\t\u0001\u0007!\bC\u0003A\t\u0001\u0007!)\u0001\u000bdef\u0004Ho\\&fs2+gn\u001a;i\u0005f$Xm]\u000b\u0002\u001dB\u0011AgT\u0005\u0003!V\u00121!\u00138u\u0003U\u0019'/\u001f9u_.+\u0017\u0010T3oORD')\u001f;fg\u0002\nab\u0019:zaR|\u0017J\u001e'f]\u001e$\b.A\bdef\u0004Ho\\%w\u0019\u0016tw\r\u001e5!\u0003I\u0019'/\u001f9u_.+\u00170\u00117h_JLG\u000f[7\u0016\u0003Y\u0003\"a\u00160\u000f\u0005ac\u0006CA-6\u001b\u0005Q&BA.2\u0003\u0019a$o\\8u}%\u0011Q,N\u0001\u0007!J,G-\u001a4\n\u0005}\u0003'AB*ue&twM\u0003\u0002^k\u0005\u00192M]=qi>\\U-_!mO>\u0014\u0018\u000e\u001e5nA\u0005a1M]=qi>\u001c\u0015\u000e\u001d5fe\u0006i1M]=qi>\u001c\u0015\u000e\u001d5fe\u0002\n\u0001\u0003^8lK:l\u0015\r\u001f'jM\u0016$\u0016.\\3\u0016\u0003\u0019\u0004\"\u0001N4\n\u0005!,$\u0001\u0002'p]\u001e\f\u0011\u0003^8lK:l\u0015\r\u001f'jM\u0016$\u0016.\\3!\u0003!\u0001(o\u001c<jI\u0016\u0014X#\u00017\u0011\u0005%k\u0017B\u00018(\u0005q)enZ5oKN+7-\u001e:jif\u001cVm\u0019:fiB\u0013xN^5eKJ\f\u0011\u0002\u001d:pm&$WM\u001d\u0011\u0002\u0007a$\u0013\u0007\u0005\u00035eR$\u0018BA:6\u0005\u0019!V\u000f\u001d7feA\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\u0007GJL\b\u000f^8\u000b\u0003e\fQA[1wCbL!a\u001f<\u0003\r\rK\u0007\u000f[3s\u0003%)gn\u0019:zaR|'/F\u0001u\u0003))gn\u0019:zaR|'\u000fI\u0001\nI\u0016\u001c'/\u001f9u_J\f!\u0002Z3def\u0004Ho\u001c:!\u0003EIg.\u001b;jC2L'0\u001a$pe\u0006+H\u000f\u001b\u000b\u0006c\u0006\u001d\u00111\u0002\u0005\u0007\u0003\u00131\u0002\u0019\u0001,\u0002\r\rL\u0007\u000f[3s\u0011\u0019\tiA\u0006a\u0001-\u000611/Z2sKR\f!\"[:tk\u0016$vn[3o)\u00051\u0016!C1vi\"$vn[3o)\u0011\t9\"!\b\u0011\u0007Q\nI\"C\u0002\u0002\u001cU\u0012A!\u00168ji\"1\u0011q\u0004\rA\u0002Y\u000b\u0001\u0002^8lK:\u001cFO]\u0001\bK:\u001c'/\u001f9u)\r1\u0016Q\u0005\u0005\u0007\u0003OI\u0002\u0019\u0001,\u0002\u000bY\fG.^3\u0002\u000f\u0011,7M]=qiR\u0019a+!\f\t\r\u0005\u001d\"\u00041\u0001W\u0003=qwN]7bY&TXmU3de\u0016$Hc\u0001,\u00024!1\u0011QB\u000eA\u0002Y\u000bA\u0003[3y'R\u0014\u0018N\\4U_\nKH/Z!se\u0006LH\u0003BA\u001d\u0003\u000b\u0002R\u0001NA\u001e\u0003\u007fI1!!\u00106\u0005\u0015\t%O]1z!\r!\u0014\u0011I\u0005\u0004\u0003\u0007*$\u0001\u0002\"zi\u0016Da!a\u0012\u001d\u0001\u00041\u0016aA:ue\u0006!\"-\u001f;f\u0003J\u0014\u0018-\u001f+p\u0011\u0016D8\u000b\u001e:j]\u001e$2AVA'\u0011\u001d\ty%\ba\u0001\u0003s\tQAY=uKN\f\u0001$\u00138uKJt\u0017\r\\*fGV\u0014\u0018\u000e^=BG\u000e,7o]8s!\tIud\u0005\u0003 g\u0005]\u0003\u0003BA-\u00037j\u0011aK\u0005\u0004\u0003;Z#a\u0002'pO\u001eLgn\u001a\u000b\u0003\u0003'\nqcX3oO&tWmU3dkJLG/_!dG\u0016\u001c8o\u001c:\u0016\u0003!\u000b1dX3oO&tWmU3dkJLG/_!dG\u0016\u001c8o\u001c:`I\u0015\fH\u0003BA\f\u0003SBq\u0001\u001d\u0012\u0002\u0002\u0003\u0007\u0001*\u0001\r`K:<\u0017N\\3TK\u000e,(/\u001b;z\u0003\u000e\u001cWm]:pe\u0002B3aIA8!\r!\u0014\u0011O\u0005\u0004\u0003g*$\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0015%t\u0017\u000e^5bY&TX\r\u0006\u0004\u0002\u0018\u0005e\u00141\u0010\u0005\u0006s\u0011\u0002\rA\u000f\u0005\u0006\u0001\u0012\u0002\rAQ\u0001\u0004O\u0016$H#\u0001%")
public class InternalSecurityAccessor {
    private final boolean isServer;
    private final int cryptoKeyLengthBytes;
    private final int cryptoIvLength;
    private final String cryptoKeyAlgorithm;
    private final String cryptoCipher;
    private final long tokenMaxLifeTime;
    private final EngineSecuritySecretProvider provider;
    private final /* synthetic */ Tuple2 x$1;
    private final Cipher encryptor;
    private final Cipher decryptor;

    public static InternalSecurityAccessor get() {
        return InternalSecurityAccessor$.MODULE$.get();
    }

    public static void initialize(KyuubiConf kyuubiConf, boolean bl) {
        InternalSecurityAccessor$.MODULE$.initialize(kyuubiConf, bl);
    }

    public static void error(Function0<Object> function0) {
        InternalSecurityAccessor$.MODULE$.error(function0);
    }

    public static void error(Function0<Object> function0, Throwable throwable) {
        InternalSecurityAccessor$.MODULE$.error(function0, throwable);
    }

    public static void warn(Function0<Object> function0, Throwable throwable) {
        InternalSecurityAccessor$.MODULE$.warn(function0, throwable);
    }

    public static void warn(Function0<Object> function0) {
        InternalSecurityAccessor$.MODULE$.warn(function0);
    }

    public static void info(Function0<Object> function0) {
        InternalSecurityAccessor$.MODULE$.info(function0);
    }

    public static void debug(Function0<Object> function0) {
        InternalSecurityAccessor$.MODULE$.debug(function0);
    }

    public boolean isServer() {
        return this.isServer;
    }

    public int cryptoKeyLengthBytes() {
        return this.cryptoKeyLengthBytes;
    }

    public int cryptoIvLength() {
        return this.cryptoIvLength;
    }

    public String cryptoKeyAlgorithm() {
        return this.cryptoKeyAlgorithm;
    }

    public String cryptoCipher() {
        return this.cryptoCipher;
    }

    private long tokenMaxLifeTime() {
        return this.tokenMaxLifeTime;
    }

    private EngineSecuritySecretProvider provider() {
        return this.provider;
    }

    private Cipher encryptor() {
        return this.encryptor;
    }

    private Cipher decryptor() {
        return this.decryptor;
    }

    private Tuple2<Cipher, Cipher> initializeForAuth(String cipher, String secret) {
        SecretKeySpec secretKeySpec = new SecretKeySpec(secret.getBytes(), this.cryptoKeyAlgorithm());
        byte[] nonce = new byte[this.cryptoIvLength()];
        IvParameterSpec iv = new IvParameterSpec(nonce);
        Cipher _encryptor = Cipher.getInstance(cipher);
        _encryptor.init(1, (Key)secretKeySpec, iv);
        Cipher _decryptor = Cipher.getInstance(cipher);
        _decryptor.init(2, (Key)secretKeySpec, iv);
        return new Tuple2<Cipher, Cipher>(_encryptor, _decryptor);
    }

    public String issueToken() {
        return this.encrypt(KyuubiInternalAccessIdentifier$.MODULE$.newIdentifier(this.tokenMaxLifeTime()).toJson());
    }

    public void authToken(String tokenStr) {
        KyuubiInternalAccessIdentifier kyuubiInternalAccessIdentifier;
        try {
            kyuubiInternalAccessIdentifier = KyuubiInternalAccessIdentifier$.MODULE$.fromJson(this.decrypt(tokenStr));
        }
        catch (Exception exception) {
            throw KyuubiSQLException$.MODULE$.apply("Invalid engine access token", KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        KyuubiInternalAccessIdentifier identifier = kyuubiInternalAccessIdentifier;
        if (identifier.issueDate() + identifier.maxDate() < System.currentTimeMillis()) {
            throw KyuubiSQLException$.MODULE$.apply("The engine access token is expired", KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
    }

    public synchronized String encrypt(String value) {
        return this.byteArrayToHexString(this.encryptor().doFinal(value.getBytes()));
    }

    public synchronized String decrypt(String value) {
        return new String(this.decryptor().doFinal(this.hexStringToByteArray(value)));
    }

    private String normalizeSecret(String secret) {
        char[] normalizedSecret = new char[this.cryptoKeyLengthBytes()];
        char placeHolder = ' ';
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.cryptoKeyLengthBytes()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
            normalizedSecret$1[i] = i < secret.length() ? secret.charAt(i) : placeHolder;
        });
        return new String(normalizedSecret);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] hexStringToByteArray(String str) {
        void var3_3;
        int len = str.length();
        Predef$.MODULE$.assert(len % 2 == 0);
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
        }
        return var3_3;
    }

    private String byteArrayToHexString(byte[] bytes) {
        return (String)new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).map((Function1<Object, String> & Serializable & scala.Serializable)object -> InternalSecurityAccessor.$anonfun$byteArrayToHexString$1(BoxesRunTime.unboxToByte(object)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).reduce((Function2<String, String, String> & Serializable & scala.Serializable)(x$2, x$3) -> new StringBuilder(0).append((String)x$2).append((String)x$3).toString());
    }

    public static final /* synthetic */ String $anonfun$byteArrayToHexString$1(byte by) {
        return new StringBuilder(0).append(Integer.toHexString(by >> 4 & 0xF)).append(Integer.toHexString(by & 0xF)).toString();
    }

    public InternalSecurityAccessor(KyuubiConf conf, boolean isServer) {
        this.isServer = isServer;
        this.cryptoKeyLengthBytes = BoxesRunTime.unboxToInt(conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_CRYPTO_KEY_LENGTH())) / 8;
        this.cryptoIvLength = BoxesRunTime.unboxToInt(conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_CRYPTO_IV_LENGTH()));
        this.cryptoKeyAlgorithm = conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_CRYPTO_KEY_ALGORITHM());
        this.cryptoCipher = conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_CRYPTO_CIPHER_TRANSFORMATION());
        this.tokenMaxLifeTime = BoxesRunTime.unboxToLong(conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_TOKEN_MAX_LIFETIME()));
        this.provider = EngineSecuritySecretProvider$.MODULE$.create(conf);
        Tuple2<Cipher, Cipher> tuple2 = this.initializeForAuth(this.cryptoCipher(), this.normalizeSecret(this.provider().getSecret()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Cipher encryptor = tuple2._1();
        Cipher decryptor = tuple2._2();
        Tuple2<Cipher, Cipher> tuple22 = new Tuple2<Cipher, Cipher>(encryptor, decryptor);
        this.x$1 = tuple22;
        this.encryptor = (Cipher)this.x$1._1();
        this.decryptor = (Cipher)this.x$1._2();
    }
}

