/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.net;

import java.net.InetSocketAddress;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.CacheReturn;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.GenIgnore;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.VertxGen;
import org.apache.kyuubi.shade.io.vertx.core.impl.Arguments;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.SocketAddressImpl;

@VertxGen
public interface SocketAddress {
    public static SocketAddress inetSocketAddress(int port, String host) {
        Arguments.requireInRange(port, 0, 65535, "port p must be in range 0 <= p <= 65535");
        return new SocketAddressImpl(port, host);
    }

    public static SocketAddress domainSocketAddress(String path) {
        return new SocketAddressImpl(path);
    }

    @GenIgnore(value={"permitted-type"})
    public static SocketAddress inetSocketAddress(InetSocketAddress address) {
        return new SocketAddressImpl(address);
    }

    @CacheReturn
    public String host();

    @CacheReturn
    public String hostName();

    @CacheReturn
    public String hostAddress();

    @CacheReturn
    public int port();

    @CacheReturn
    public String path();

    @CacheReturn
    public boolean isInetSocket();

    @CacheReturn
    public boolean isDomainSocket();
}

