/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.metadata.jdbc;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.google.common.annotations.VisibleForTesting;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.server.metadata.MetadataStore;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.server.metadata.jdbc.DatabaseType$;
import org.apache.kyuubi.server.metadata.jdbc.DerbyDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.GenericDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.JDBCMetadataStore$;
import org.apache.kyuubi.server.metadata.jdbc.JDBCMetadataStoreConf$;
import org.apache.kyuubi.server.metadata.jdbc.JdbcDatabaseDialect;
import org.apache.kyuubi.server.metadata.jdbc.MysqlDatabaseDialect;
import org.apache.kyuubi.session.SessionType$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}g\u0001\u0002\u00192\u0001yB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\u0006-\u0002!\ta\u0016\u0005\b7\u0002\u0011\r\u0011\"\u0003]\u0011\u00199\u0007\u0001)A\u0005;\"9\u0001\u000e\u0001b\u0001\n\u0013I\u0007BB=\u0001A\u0003%!\u000eC\u0004{\u0001\t\u0007I\u0011B>\t\rq\u0004\u0001\u0015!\u0003o\u0011\u001di\bA1A\u0005\nyDq!!\u0002\u0001A\u0003%q\u0010C\u0005\u0002\b\u0001\u0011\r\u0011\"\u0003\u0002\n!A\u0011q\u0003\u0001!\u0002\u0013\tY\u0001C\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0003\u0002\u001c!A\u0011\u0011\u0007\u0001!\u0002\u0013\ti\u0002\u0003\u0006\u00024\u0001\u0011\r\u0011\"\u00018\u0003kA\u0001\"!\u0010\u0001A\u0003%\u0011q\u0007\u0005\n\u0003+\u0002!\u0019!C\u0005\u0003/B\u0001\"!\u001c\u0001A\u0003%\u0011\u0011\f\u0005\t\u0003_\u0002!\u0019!C\u0005w\"9\u0011\u0011\u000f\u0001!\u0002\u0013q\u0007bBA:\u0001\u0011%\u0011Q\u000f\u0005\b\u0003{\u0002A\u0011IA;\u0011\u001d\ty\b\u0001C!\u0003\u0003Cq!!%\u0001\t\u0003\n\u0019\nC\u0004\u0002$\u0002!\t%!*\t\u000f\u0005M\u0007\u0001\"\u0011\u0002V\"9\u0011\u0011\u001c\u0001\u0005B\u0005m\u0007bBAp\u0001\u0011\u0005\u0013\u0011\u001d\u0005\b\u0003[\u0004A\u0011BAx\u0011\u001d\u0011\u0019\u0001\u0001C\u0005\u0005\u000bAqAa\t\u0001\t\u0013\u0011)\u0003C\u0004\u0003L\u0001!IA!\u0014\t\u000f\t\u0005\u0004\u0001\"\u0003\u0003d!9!\u0011\u000f\u0001\u0005\n\tM\u0004\"\u0003BC\u0001E\u0005I\u0011\u0002BD\u0011\u001d\u0011\t\u000b\u0001C\u0005\u0005GCqA!+\u0001\t\u0013\u0011Y\u000bC\u0004\u00038\u0002!IA!/\b\u000f\t}\u0016\u0007#\u0001\u0003B\u001a1\u0001'\rE\u0001\u0005\u0007DaA\u0016\u0015\u0005\u0002\t-\u0007\"\u0003BgQ\t\u0007I\u0011\u0002Bh\u0011!\u0011)\u000e\u000bQ\u0001\n\tE\u0007\u0002\u0003BlQ\t\u0007I\u0011B>\t\u000f\te\u0007\u0006)A\u0005]\"A!1\u001c\u0015C\u0002\u0013%1\u0010C\u0004\u0003^\"\u0002\u000b\u0011\u00028\u0003#)#%iQ'fi\u0006$\u0017\r^1Ti>\u0014XM\u0003\u00023g\u0005!!\u000e\u001a2d\u0015\t!T'\u0001\u0005nKR\fG-\u0019;b\u0015\t1t'\u0001\u0004tKJ4XM\u001d\u0006\u0003qe\naa[=vk\nL'B\u0001\u001e<\u0003\u0019\t\u0007/Y2iK*\tA(A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u007f\u001d[\u0005C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\u0011a\u0017M\\4\u000b\u0003\u0011\u000bAA[1wC&\u0011a)\u0011\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005!KU\"A\u001a\n\u0005)\u001b$!D'fi\u0006$\u0017\r^1Ti>\u0014X\r\u0005\u0002M\u001b6\tq'\u0003\u0002Oo\t9Aj\\4hS:<\u0017\u0001B2p]\u001a\u0004\"!\u0015+\u000e\u0003IS!aU\u001c\u0002\r\r|gNZ5h\u0013\t)&K\u0001\u0006LsV,(-[\"p]\u001a\fa\u0001P5oSRtDC\u0001-[!\tI\u0006!D\u00012\u0011\u0015y%\u00011\u0001Q\u0003\u0019!'\rV=qKV\tQ\f\u0005\u0002_C:\u0011\u0011lX\u0005\u0003AF\nA\u0002R1uC\n\f7/\u001a+za\u0016L!AY2\u0003\u000bY\u000bG.^3\n\u0005\u0011,'aC#ok6,'/\u0019;j_:T\u0011AZ\u0001\u0006g\u000e\fG.Y\u0001\bI\n$\u0016\u0010]3!\u00039!'/\u001b<fe\u000ec\u0017m]:PaR,\u0012A\u001b\t\u0004W2tW\"A3\n\u00055,'AB(qi&|g\u000e\u0005\u0002pm:\u0011\u0001\u000f\u001e\t\u0003c\u0016l\u0011A\u001d\u0006\u0003gv\na\u0001\u0010:p_Rt\u0014BA;f\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000f\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U,\u0017a\u00043sSZ,'o\u00117bgN|\u0005\u000f\u001e\u0011\u0002\u0017\u0011\u0014\u0018N^3s\u00072\f7o]\u000b\u0002]\u0006aAM]5wKJ\u001cE.Y:tA\u0005yA-\u0019;bE\u0006\u001cX-\u00113baR|'/F\u0001\u0000!\rI\u0016\u0011A\u0005\u0004\u0003\u0007\t$a\u0005&eE\u000e$\u0015\r^1cCN,G)[1mK\u000e$\u0018\u0001\u00053bi\u0006\u0014\u0017m]3BI\u0006\u0004Ho\u001c:!\u0003Q!\u0017\r^1t_V\u00148-\u001a)s_B,'\u000f^5fgV\u0011\u00111\u0002\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\"\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003+\tyA\u0001\u0006Qe>\u0004XM\u001d;jKN\fQ\u0003Z1uCN|WO]2f!J|\u0007/\u001a:uS\u0016\u001c\b%\u0001\u0007iS.\f'/[\"p]\u001aLw-\u0006\u0002\u0002\u001eA!\u0011qDA\u0017\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012A\u00025jW\u0006\u0014\u0018N\u0003\u0003\u0002(\u0005%\u0012A\u0002>bqb,'O\u0003\u0002\u0002,\u0005\u00191m\\7\n\t\u0005=\u0012\u0011\u0005\u0002\r\u0011&\\\u0017M]5D_:4\u0017nZ\u0001\u000eQ&\\\u0017M]5D_:4\u0017n\u001a\u0011\u0002!!L7.\u0019:j\t\u0006$\u0018mU8ve\u000e,WCAA\u001c!\u0011\ty\"!\u000f\n\t\u0005m\u0012\u0011\u0005\u0002\u0011\u0011&\\\u0017M]5ECR\f7k\\;sG\u0016\f\u0011\u0003[5lCJLG)\u0019;b'>,(oY3!Q\r\u0001\u0012\u0011\t\t\u0005\u0003\u0007\n\t&\u0004\u0002\u0002F)!\u0011qIA%\u0003-\tgN\\8uCRLwN\\:\u000b\t\u0005-\u0013QJ\u0001\u0007G>lWn\u001c8\u000b\t\u0005=\u0013\u0011F\u0001\u0007O>|w\r\\3\n\t\u0005M\u0013Q\t\u0002\u0012-&\u001c\u0018N\u00197f\r>\u0014H+Z:uS:<\u0017AB7baB,'/\u0006\u0002\u0002ZA!\u00111LA5\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014\u0001\u00033bi\u0006\u0014\u0017N\u001c3\u000b\t\u0005\r\u0014QM\u0001\bU\u0006\u001c7n]8o\u0015\u0011\t9'!\u000b\u0002\u0013\u0019\f7\u000f^3sq6d\u0017\u0002BA6\u0003;\u0012Ab\u00142kK\u000e$X*\u00199qKJ\fq!\\1qa\u0016\u0014\b%\u0001\buKJl\u0017N\\1m'R\fG/Z:\u0002\u001fQ,'/\\5oC2\u001cF/\u0019;fg\u0002\n!\"\u001b8jiN\u001b\u0007.Z7b)\t\t9\bE\u0002l\u0003sJ1!a\u001ff\u0005\u0011)f.\u001b;\u0002\u000b\rdwn]3\u0002\u001d%t7/\u001a:u\u001b\u0016$\u0018\rZ1uCR!\u0011qOAB\u0011\u0019!t\u00031\u0001\u0002\u0006B!\u0011qQAG\u001b\t\tIIC\u0002\u0002\fN\n1!\u00199j\u0013\u0011\ty)!#\u0003\u00115+G/\u00193bi\u0006\f1bZ3u\u001b\u0016$\u0018\rZ1uCR1\u0011QQAK\u00033Ca!a&\u0019\u0001\u0004q\u0017AC5eK:$\u0018NZ5fe\"9\u00111\u0014\rA\u0002\u0005u\u0015!C:uCR,wJ\u001c7z!\rY\u0017qT\u0005\u0004\u0003C+'a\u0002\"p_2,\u0017M\\\u0001\u0010O\u0016$X*\u001a;bI\u0006$\u0018\rT5tiRQ\u0011qUA]\u0003\u0007\fi-!5\u0011\r\u0005%\u00161WAC\u001d\u0011\tY+a,\u000f\u0007E\fi+C\u0001g\u0013\r\t\t,Z\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t),a.\u0003\u0007M+\u0017OC\u0002\u00022\u0016Dq!a/\u001a\u0001\u0004\ti,\u0001\u0004gS2$XM\u001d\t\u0005\u0003\u000f\u000by,\u0003\u0003\u0002B\u0006%%AD'fi\u0006$\u0017\r^1GS2$XM\u001d\u0005\b\u0003\u000bL\u0002\u0019AAd\u0003\u00111'o\\7\u0011\u0007-\fI-C\u0002\u0002L\u0016\u00141!\u00138u\u0011\u001d\ty-\u0007a\u0001\u0003\u000f\fAa]5{K\"9\u00111T\rA\u0002\u0005u\u0015AD;qI\u0006$X-T3uC\u0012\fG/\u0019\u000b\u0005\u0003o\n9\u000e\u0003\u000455\u0001\u0007\u0011QQ\u0001\u001cG2,\u0017M\\;q\u001b\u0016$\u0018\rZ1uC\nK\u0018\nZ3oi&4\u0017.\u001a:\u0015\t\u0005]\u0014Q\u001c\u0005\u0007\u0003/[\u0002\u0019\u00018\u0002)\rdW-\u00198va6+G/\u00193bi\u0006\u0014\u00150Q4f)\u0011\t9(a9\t\u000f\u0005\u0015H\u00041\u0001\u0002h\u00061Q.\u0019=BO\u0016\u00042a[Au\u0013\r\tY/\u001a\u0002\u0005\u0019>tw-A\u0007ck&dG-T3uC\u0012\fG/\u0019\u000b\u0007\u0003O\u000b\tP!\u0001\t\u000f\u0005MX\u00041\u0001\u0002v\u0006I!/Z:vYR\u001cV\r\u001e\t\u0005\u0003o\fi0\u0004\u0002\u0002z*\u0019\u00111`\"\u0002\u0007M\fH.\u0003\u0003\u0002\u0000\u0006e(!\u0003*fgVdGoU3u\u0011\u001d\tY*\ba\u0001\u0003;\u000bq!\u001a=fGV$X\r\u0006\u0005\u0002x\t\u001d!\u0011\u0003B\n\u0011\u001d\u0011IA\ba\u0001\u0005\u0017\tAaY8o]B!\u0011q\u001fB\u0007\u0013\u0011\u0011y!!?\u0003\u0015\r{gN\\3di&|g\u000e\u0003\u0004\u0002|z\u0001\rA\u001c\u0005\b\u0005+q\u0002\u0019\u0001B\f\u0003\u0019\u0001\u0018M]1ngB)1N!\u0007\u0003\u001e%\u0019!1D3\u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u0002l\u0005?I1A!\tf\u0005\r\te._\u0001\u000eo&$\bNU3tk2$8+\u001a;\u0016\t\t\u001d\"q\u0006\u000b\t\u0005S\u0011)Ea\u0012\u0003JQ!!1\u0006B\u001e!\u0011\u0011iCa\f\r\u0001\u00119!\u0011G\u0010C\u0002\tM\"!\u0001+\u0012\t\tU\"Q\u0004\t\u0004W\n]\u0012b\u0001B\u001dK\n9aj\u001c;iS:<\u0007b\u0002B\u001f?\u0001\u0007!qH\u0001\u0002MB91N!\u0011\u0002v\n-\u0012b\u0001B\"K\nIa)\u001e8di&|g.\r\u0005\b\u0005\u0013y\u0002\u0019\u0001B\u0006\u0011\u0019\tYp\ba\u0001]\"9!QC\u0010A\u0002\t]\u0011aD<ji\",\u0006\u000fZ1uK\u000e{WO\u001c;\u0016\t\t=#Q\u000b\u000b\t\u0005#\u0012YF!\u0018\u0003`Q!!1\u000bB,!\u0011\u0011iC!\u0016\u0005\u000f\tE\u0002E1\u0001\u00034!9!Q\b\u0011A\u0002\te\u0003cB6\u0003B\u0005\u001d'1\u000b\u0005\b\u0005\u0013\u0001\u0003\u0019\u0001B\u0006\u0011\u0019\tY\u0010\ta\u0001]\"9!Q\u0003\u0011A\u0002\t]\u0011AE:fiN#\u0018\r^3nK:$\b+\u0019:b[N$b!a\u001e\u0003f\t=\u0004b\u0002B4C\u0001\u0007!\u0011N\u0001\ngR\fG/Z7f]R\u0004B!a>\u0003l%!!QNA}\u0005E\u0001&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e\u0005\b\u0005+\t\u0003\u0019\u0001B\f\u000399\u0018\u000e\u001e5D_:tWm\u0019;j_:,BA!\u001e\u0003|Q!!q\u000fBA)\u0011\u0011IH! \u0011\t\t5\"1\u0010\u0003\b\u0005c\u0011#\u0019\u0001B\u001a\u0011\u001d\u0011iD\ta\u0001\u0005\u007f\u0002ra\u001bB!\u0005\u0017\u0011I\bC\u0005\u0003\u0004\n\u0002\n\u00111\u0001\u0002\u001e\u0006Q\u0011-\u001e;p\u0007>lW.\u001b;\u00021]LG\u000f[\"p]:,7\r^5p]\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u0003\n\n}UC\u0001BFU\u0011\tiJ!$,\u0005\t=\u0005\u0003\u0002BI\u00057k!Aa%\u000b\t\tU%qS\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!'f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005;\u0013\u0019JA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$qA!\r$\u0005\u0004\u0011\u0019$A\u0007wC2,X-Q:TiJLgn\u001a\u000b\u0004]\n\u0015\u0006b\u0002BTI\u0001\u0007!QD\u0001\u0004_\nT\u0017AC:ue&twMM'baR!!Q\u0016BZ!\u0015y'q\u00168o\u0013\r\u0011\t\f\u001f\u0002\u0004\u001b\u0006\u0004\bB\u0002B[K\u0001\u0007a.A\u0002tiJ\f!b\u001d;sS:<'gU3r)\u0011\u0011YL!0\u0011\u000b\u0005%\u00161\u00178\t\r\tUf\u00051\u0001o\u0003EQEIQ\"NKR\fG-\u0019;b'R|'/\u001a\t\u00033\"\u001a2\u0001\u000bBc!\rY'qY\u0005\u0004\u0005\u0013,'AB!osJ+g\r\u0006\u0002\u0003B\u0006qQ*\u0012+B\t\u0006#\u0016i\u0018+B\u00052+UC\u0001Bi!\r\u0001%1[\u0005\u0003o\u0006\u000bq\"T#U\u0003\u0012\u000bE+Q0U\u0003\ncU\tI\u0001\u001c\u001b\u0016#\u0016\tR!U\u0003~\u001bF+\u0011+F?>sE*W0D\u001f2+VJT*\u000295+E+\u0011#B)\u0006{6\u000bV!U\u000b~{e\nT-`\u0007>cU+\u0014(TA\u0005!R*\u0012+B\t\u0006#\u0016iX!M\u0019~\u001bu\nT+N\u001dN\u000bQ#T#U\u0003\u0012\u000bE+Q0B\u00192{6i\u0014'V\u001b:\u001b\u0006\u0005")
public class JDBCMetadataStore
implements MetadataStore,
Logging {
    private final Enumeration.Value dbType;
    private final Option<String> driverClassOpt;
    private final String driverClass;
    private final JdbcDatabaseDialect databaseAdaptor;
    private final Properties datasourceProperties;
    private final HikariConfig hikariConfig;
    @VisibleForTesting
    private final HikariDataSource hikariDataSource;
    private final ObjectMapper mapper;
    private final String terminalStates;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private Enumeration.Value dbType() {
        return this.dbType;
    }

    private Option<String> driverClassOpt() {
        return this.driverClassOpt;
    }

    private String driverClass() {
        return this.driverClass;
    }

    private JdbcDatabaseDialect databaseAdaptor() {
        return this.databaseAdaptor;
    }

    private Properties datasourceProperties() {
        return this.datasourceProperties;
    }

    private HikariConfig hikariConfig() {
        return this.hikariConfig;
    }

    public HikariDataSource hikariDataSource() {
        return this.hikariDataSource;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    private String terminalStates() {
        return this.terminalStates;
    }

    private void initSchema() {
        Option option;
        ClassLoader classLoader = this.getClass().getClassLoader();
        Enumeration.Value value = this.dbType();
        Enumeration.Value value2 = DatabaseType$.MODULE$.DERBY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            option = Option$.MODULE$.apply((Object)classLoader.getResourceAsStream("sql/derby/metadata-store-schema-derby.sql"));
        } else {
            Enumeration.Value value4 = DatabaseType$.MODULE$.MYSQL();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                option = Option$.MODULE$.apply((Object)classLoader.getResourceAsStream("sql/mysql/metadata-store-schema-mysql.sql"));
            } else {
                Enumeration.Value value6 = DatabaseType$.MODULE$.CUSTOM();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    option = None$.MODULE$;
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        Option initSchemaStream = option;
        initSchemaStream.foreach((Function1 & Serializable & scala.Serializable)inputStream -> {
            JDBCMetadataStore.$anonfun$initSchema$1(this, inputStream);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void close() {
        this.hikariDataSource().close();
    }

    @Override
    public void insertMetadata(Metadata metadata) {
        String query = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(449).append("\n         |INSERT INTO ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append("(\n         |identifier,\n         |session_type,\n         |real_user,\n         |user_name,\n         |ip_address,\n         |kyuubi_instance,\n         |state,\n         |resource,\n         |class_name,\n         |request_name,\n         |request_conf,\n         |request_args,\n         |create_time,\n         |engine_type,\n         |cluster_manager\n         |)\n         |VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n         |").toString())).stripMargin();
        this.withConnection(this.withConnection$default$1(), (Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadata.identifier(), metadata.sessionType().toString(), metadata.realUser(), metadata.username(), metadata.ipAddress(), metadata.kyuubiInstance(), metadata.state(), metadata.resource(), metadata.className(), metadata.requestName(), this.valueAsString(metadata.requestConf()), this.valueAsString(metadata.requestArgs()), BoxesRunTime.boxToLong((long)metadata.createTime()), Option$.MODULE$.apply((Object)metadata.engineType()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toUpperCase(Locale.ROOT)).orNull(Predef$.MODULE$.$conforms()), metadata.clusterManager().orNull(Predef$.MODULE$.$conforms())}));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Metadata getMetadata(String identifier, boolean stateOnly) {
        String query = stateOnly ? new java.lang.StringBuilder(34).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_STATE_ONLY_COLUMNS()).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString() : new java.lang.StringBuilder(34).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_ALL_COLUMNS()).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString();
        return (Metadata)this.withConnection(this.withConnection$default$1(), (Function1 & Serializable & scala.Serializable)connection -> (Metadata)this.withResultSet((Connection)connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier}), (Function1 & Serializable & scala.Serializable)rs -> (Metadata)this.buildMetadata((ResultSet)rs, stateOnly).headOption().orNull(Predef$.MODULE$.$conforms())));
    }

    @Override
    public Seq<Metadata> getMetadataList(MetadataFilter filter, int from, int size, boolean stateOnly) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        StringBuilder stringBuilder = stateOnly ? queryBuilder.append(new java.lang.StringBuilder(13).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_STATE_ONLY_COLUMNS()).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString()) : queryBuilder.append(new java.lang.StringBuilder(13).append("SELECT ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_ALL_COLUMNS()).append(" FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        ListBuffer whereConditions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option$.MODULE$.apply((Object)filter.sessionType()).foreach((Function1 & Serializable & scala.Serializable)sessionType -> {
            whereConditions.$plus$eq((Object)" session_type = ?");
            return params.$plus$eq((Object)sessionType.toString());
        });
        Option$.MODULE$.apply((Object)filter.engineType()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getMetadataList$2(x$2))).foreach((Function1 & Serializable & scala.Serializable)engineType -> {
            whereConditions.$plus$eq((Object)" UPPER(engine_type) = ? ");
            return params.$plus$eq((Object)engineType.toUpperCase(Locale.ROOT));
        });
        Option$.MODULE$.apply((Object)filter.username()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getMetadataList$4(x$3))).foreach((Function1 & Serializable & scala.Serializable)username -> {
            whereConditions.$plus$eq((Object)" user_name = ? ");
            return params.$plus$eq(username);
        });
        Option$.MODULE$.apply((Object)filter.state()).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getMetadataList$6(x$4))).foreach((Function1 & Serializable & scala.Serializable)state -> {
            whereConditions.$plus$eq((Object)" state = ? ");
            return params.$plus$eq((Object)state.toUpperCase(Locale.ROOT));
        });
        Option$.MODULE$.apply((Object)filter.kyuubiInstance()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)JDBCMetadataStore.$anonfun$getMetadataList$8(x$5))).foreach((Function1 & Serializable & scala.Serializable)kyuubiInstance -> {
            whereConditions.$plus$eq((Object)" kyuubi_instance = ? ");
            return params.$plus$eq(kyuubiInstance);
        });
        if (filter.createTime() > 0L) {
            whereConditions.$plus$eq((Object)" create_time >= ? ");
            boxedUnit3 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)filter.createTime()));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (filter.endTime() > 0L) {
            whereConditions.$plus$eq((Object)" end_time > 0 ");
            whereConditions.$plus$eq((Object)" end_time <= ? ");
            boxedUnit2 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)filter.endTime()));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (filter.peerInstanceClosed()) {
            whereConditions.$plus$eq((Object)" peer_instance_closed = ? ");
            boxedUnit = params.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)filter.peerInstanceClosed()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = whereConditions.nonEmpty() ? queryBuilder.append(whereConditions.mkString(" WHERE ", " AND ", " ")) : BoxedUnit.UNIT;
        queryBuilder.append(" ORDER BY key_id ");
        String query = this.databaseAdaptor().addLimitAndOffsetToQuery(queryBuilder.toString(), size, from);
        return (Seq)this.withConnection(this.withConnection$default$1(), (Function1 & Serializable & scala.Serializable)connection -> (Seq)this.withResultSet((Connection)connection, query, (Seq<Object>)params, (Function1 & Serializable & scala.Serializable)rs -> this.buildMetadata((ResultSet)rs, stateOnly)));
    }

    @Override
    public void updateMetadata(Metadata metadata) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        StringBuilder queryBuilder = new StringBuilder();
        ListBuffer params = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        queryBuilder.append(new java.lang.StringBuilder(7).append("UPDATE ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).toString());
        ListBuffer setClauses = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Option$.MODULE$.apply((Object)metadata.state()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            setClauses.$plus$eq((Object)" state = ? ");
            return params.$plus$eq((Object)metadata.state());
        });
        if (metadata.endTime() > 0L) {
            setClauses.$plus$eq((Object)" end_time = ? ");
            boxedUnit2 = params.$plus$eq((Object)BoxesRunTime.boxToLong((long)metadata.endTime()));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Option$.MODULE$.apply((Object)metadata.engineId()).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            setClauses.$plus$eq((Object)" engine_id = ? ");
            return params.$plus$eq((Object)metadata.engineId());
        });
        Option$.MODULE$.apply((Object)metadata.engineName()).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            setClauses.$plus$eq((Object)" engine_name = ? ");
            return params.$plus$eq((Object)metadata.engineName());
        });
        Option$.MODULE$.apply((Object)metadata.engineUrl()).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            setClauses.$plus$eq((Object)" engine_url = ? ");
            return params.$plus$eq((Object)metadata.engineUrl());
        });
        Option$.MODULE$.apply((Object)metadata.engineState()).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            setClauses.$plus$eq((Object)" engine_state = ? ");
            return params.$plus$eq((Object)metadata.engineState());
        });
        metadata.engineError().foreach((Function1 & Serializable & scala.Serializable)error -> {
            setClauses.$plus$eq((Object)" engine_error = ? ");
            return params.$plus$eq(error);
        });
        if (metadata.peerInstanceClosed()) {
            setClauses.$plus$eq((Object)" peer_instance_closed = ? ");
            boxedUnit = params.$plus$eq((Object)BoxesRunTime.boxToBoolean((boolean)metadata.peerInstanceClosed()));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Object object = setClauses.nonEmpty() ? queryBuilder.append(setClauses.mkString(" SET ", " , ", " ")) : BoxedUnit.UNIT;
        queryBuilder.append(" WHERE identifier = ? ");
        params.$plus$eq((Object)metadata.identifier());
        String query = queryBuilder.toString();
        this.withConnection(this.withConnection$default$1(), (Function1 & Serializable & scala.Serializable)connection -> {
            this.withUpdateCount(connection, query, (Seq<Object>)params, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)updateCount -> {
                if (updateCount == 0) {
                    throw new KyuubiException(new java.lang.StringBuilder(34).append("Error updating metadata for ").append(metadata$2.identifier()).append(" with ").append(query$4).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void cleanupMetadataByIdentifier(String identifier) {
        String query = new java.lang.StringBuilder(33).append("DELETE FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE identifier = ?").toString();
        this.withConnection(this.withConnection$default$1(), (Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{identifier}));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void cleanupMetadataByAge(long maxAge) {
        long minEndTime = System.currentTimeMillis() - maxAge;
        String query = new java.lang.StringBuilder(47).append("DELETE FROM ").append(JDBCMetadataStore$.MODULE$.org$apache$kyuubi$server$metadata$jdbc$JDBCMetadataStore$$METADATA_TABLE()).append(" WHERE state IN (").append(this.terminalStates()).append(") AND end_time < ?").toString();
        this.withConnection(this.withConnection$default$1(), (Function1 & Serializable & scala.Serializable)connection -> {
            this.execute(connection, query, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)minEndTime)}));
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Metadata> buildMetadata(ResultSet resultSet, boolean stateOnly) {
        void v0;
        try {
            void var3_3;
            ListBuffer metadataList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            while (resultSet.next()) {
                String identifier = resultSet.getString("identifier");
                Enumeration.Value sessionType = SessionType$.MODULE$.withName(resultSet.getString("session_type"));
                String realUser = resultSet.getString("real_user");
                String userName = resultSet.getString("user_name");
                String ipAddress = resultSet.getString("ip_address");
                String kyuubiInstance = resultSet.getString("kyuubi_instance");
                String state = resultSet.getString("state");
                String requestName = resultSet.getString("request_name");
                long createTime = resultSet.getLong("create_time");
                String engineType = resultSet.getString("engine_type");
                Option clusterManager = Option$.MODULE$.apply((Object)resultSet.getString("cluster_manager"));
                String engineId = resultSet.getString("engine_id");
                String engineName = resultSet.getString("engine_name");
                String engineUrl = resultSet.getString("engine_url");
                String engineState = resultSet.getString("engine_state");
                Option engineError = Option$.MODULE$.apply((Object)resultSet.getString("engine_error"));
                long endTime = resultSet.getLong("end_time");
                boolean peerInstanceClosed = resultSet.getBoolean("peer_instance_closed");
                String resource = null;
                String className = null;
                Map<String, String> requestConf = Predef$.MODULE$.Map().empty();
                Seq<String> requestArgs = (Seq<String>)Nil$.MODULE$;
                if (!stateOnly) {
                    resource = resultSet.getString("resource");
                    className = resultSet.getString("class_name");
                    requestConf = this.string2Map(resultSet.getString("request_conf"));
                    requestArgs = this.string2Seq(resultSet.getString("request_args"));
                }
                Metadata metadata = new Metadata(identifier, sessionType, realUser, userName, ipAddress, kyuubiInstance, state, resource, className, requestName, requestConf, requestArgs, createTime, engineType, (Option<String>)clusterManager, engineId, engineName, engineUrl, engineState, (Option<String>)engineError, endTime, peerInstanceClosed);
                metadataList.$plus$eq((Object)metadata);
            }
            v0 = var3_3;
        }
        finally {
            Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> resultSet.close());
        }
        return v0;
    }

    private void execute(Connection conn, String sql, Seq<Object> params) {
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(14).append("executing sql ").append(sql).toString());
        ObjectRef statement = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                ((PreparedStatement)statement.elem).execute();
            }
            catch (SQLException e) {
                throw new KyuubiException(new java.lang.StringBuilder(17).append("Error executing ").append(sql).append(":").append(e.getMessage()).toString(), (Throwable)e);
            }
        }
        finally {
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$1.elem).close());
            }
        }
    }

    private <T> T withResultSet(Connection conn, String sql, Seq<Object> params, Function1<ResultSet, T> f) {
        Object object;
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(30).append("executing sql ").append(sql).append(" with result set").toString());
        ObjectRef statement = ObjectRef.create(null);
        ObjectRef resultSet = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                resultSet.elem = ((PreparedStatement)statement.elem).executeQuery();
                object = f.apply((Object)((ResultSet)resultSet.elem));
            }
            catch (SQLException e) {
                throw new KyuubiException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if ((ResultSet)resultSet.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ResultSet)resultSet$2.elem).close());
            }
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$2.elem).close());
            }
        }
        return (T)object;
    }

    private <T> T withUpdateCount(Connection conn, String sql, Seq<Object> params, Function1<Object, T> f) {
        Object object;
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(32).append("executing sql ").append(sql).append(" with update count").toString());
        ObjectRef statement = ObjectRef.create(null);
        try {
            try {
                statement.elem = conn.prepareStatement(sql);
                this.setStatementParams((PreparedStatement)statement.elem, params);
                object = f.apply((Object)BoxesRunTime.boxToInteger((int)((PreparedStatement)statement.elem).executeUpdate()));
            }
            catch (SQLException e) {
                throw new KyuubiException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if ((PreparedStatement)statement.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((PreparedStatement)statement$3.elem).close());
            }
        }
        return (T)object;
    }

    private void setStatementParams(PreparedStatement statement, Seq<Object> params) {
        ((IterableLike)params.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            JDBCMetadataStore.$anonfun$setStatementParams$1(statement, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private <T> T withConnection(boolean autoCommit, Function1<Connection, T> f) {
        Object object;
        ObjectRef connection = ObjectRef.create(null);
        try {
            try {
                connection.elem = this.hikariDataSource().getConnection();
                ((Connection)connection.elem).setAutoCommit(autoCommit);
                object = f.apply((Object)((Connection)connection.elem));
            }
            catch (SQLException e) {
                throw new KyuubiException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if ((Connection)connection.elem != null) {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Connection)connection$2.elem).close());
            }
        }
        return (T)object;
    }

    private <T> boolean withConnection$default$1() {
        return true;
    }

    private String valueAsString(Object obj) {
        return this.mapper().writeValueAsString(obj);
    }

    private Map<String, String> string2Map(String str) {
        return str == null || str.isEmpty() ? Predef$.MODULE$.Map().empty() : (Map)this.mapper().readValue(str, Map.class);
    }

    private Seq<String> string2Seq(String str) {
        return str == null || str.isEmpty() ? (Seq)Nil$.MODULE$ : (Seq)this.mapper().readValue(str, Seq.class);
    }

    public static final /* synthetic */ void $anonfun$initSchema$4(JDBCMetadataStore $this, Connection connection$1, String ddlStatement) {
        $this.execute(connection$1, ddlStatement, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(39).append("Execute init schema ddl: ").append(ddlStatement).append(" successfully.").toString());
    }

    public static final /* synthetic */ void $anonfun$initSchema$1(JDBCMetadataStore $this, InputStream inputStream) {
        try {
            String[] ddlStatements = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n")).trim().split(";");
            $this.withConnection($this.withConnection$default$1(), (Function1 & Serializable & scala.Serializable)connection -> {
                Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ddlStatements)).foreach((Function1 & Serializable & scala.Serializable)ddlStatement -> {
                    JDBCMetadataStore.$anonfun$initSchema$4($this, connection, ddlStatement);
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
        }
        finally {
            inputStream.close();
        }
    }

    public static final /* synthetic */ boolean $anonfun$getMetadataList$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getMetadataList$4(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getMetadataList$6(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getMetadataList$8(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$setStatementParams$1(PreparedStatement statement$4, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Object param = tuple2._1();
        int index = tuple2._2$mcI$sp();
        Object object = param;
        if (object == null) {
            statement$4.setObject(index + 1, null);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof String) {
            String string = (String)object;
            statement$4.setString(index + 1, string);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            statement$4.setInt(index + 1, n);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            statement$4.setLong(index + 1, l);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            statement$4.setDouble(index + 1, d);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            statement$4.setFloat(index + 1, f);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (!(object instanceof Boolean)) throw new KyuubiException(new java.lang.StringBuilder(23).append("Unsupported param type ").append(param.getClass().getName()).toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            statement$4.setBoolean(index + 1, bl);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public JDBCMetadataStore(KyuubiConf conf) {
        block12: {
            JdbcDatabaseDialect jdbcDatabaseDialect;
            String string;
            Logging.$init$((Logging)this);
            this.dbType = DatabaseType$.MODULE$.withName((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DATABASE_TYPE()));
            this.driverClassOpt = (Option)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DRIVER());
            Enumeration.Value value = this.dbType();
            Enumeration.Value value2 = DatabaseType$.MODULE$.DERBY();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> "org.apache.derby.jdbc.AutoloadedDriver");
            } else {
                Enumeration.Value value4 = DatabaseType$.MODULE$.MYSQL();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> "com.mysql.jdbc.Driver");
                } else {
                    Enumeration.Value value6 = DatabaseType$.MODULE$.CUSTOM();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        string = (String)this.driverClassOpt().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                            throw new IllegalArgumentException("No jdbc driver defined");
                        });
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
            this.driverClass = string;
            Enumeration.Value value8 = this.dbType();
            Enumeration.Value value9 = DatabaseType$.MODULE$.DERBY();
            Enumeration.Value value10 = value8;
            if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                jdbcDatabaseDialect = new DerbyDatabaseDialect();
            } else {
                Enumeration.Value value11 = DatabaseType$.MODULE$.MYSQL();
                Enumeration.Value value12 = value8;
                if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                    jdbcDatabaseDialect = new MysqlDatabaseDialect();
                } else {
                    Enumeration.Value value13 = DatabaseType$.MODULE$.CUSTOM();
                    Enumeration.Value value14 = value8;
                    if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                        jdbcDatabaseDialect = new GenericDatabaseDialect();
                    } else {
                        throw new MatchError((Object)value8);
                    }
                }
            }
            this.databaseAdaptor = jdbcDatabaseDialect;
            this.datasourceProperties = JDBCMetadataStoreConf$.MODULE$.getMetadataStoreJDBCDataSourceProperties(conf);
            this.hikariConfig = new HikariConfig(this.datasourceProperties());
            this.hikariConfig().setDriverClassName(this.driverClass());
            this.hikariConfig().setJdbcUrl((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_URL()));
            this.hikariConfig().setUsername((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_USER()));
            this.hikariConfig().setPassword((String)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_PASSWORD()));
            this.hikariConfig().setPoolName("jdbc-metadata-store-pool");
            this.hikariDataSource = new HikariDataSource(this.hikariConfig());
            this.mapper = new ObjectMapper().registerModule((Module)DefaultScalaModule$.MODULE$);
            this.terminalStates = ((TraversableOnce)OperationState$.MODULE$.terminalStates().map((Function1 & Serializable & scala.Serializable)x -> new java.lang.StringBuilder(2).append("'").append(x.toString()).append("'").toString(), Seq$.MODULE$.canBuildFrom())).mkString(", ");
            if (!BoxesRunTime.unboxToBoolean((Object)conf.get(JDBCMetadataStoreConf$.MODULE$.METADATA_STORE_JDBC_DATABASE_SCHEMA_INIT()))) break block12;
            this.initSchema();
        }
    }
}

