/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.api.v1;

import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.service.rpc.thrift.TBoolValue;
import org.apache.hive.service.rpc.thrift.TByteValue;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TColumnValue;
import org.apache.hive.service.rpc.thrift.TDoubleValue;
import org.apache.hive.service.rpc.thrift.TI16Value;
import org.apache.hive.service.rpc.thrift.TI32Value;
import org.apache.hive.service.rpc.thrift.TI64Value;
import org.apache.hive.service.rpc.thrift.TPrimitiveTypeEntry;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.hive.service.rpc.thrift.TStringValue;
import org.apache.hive.service.rpc.thrift.TTypeEntry;
import org.apache.hive.service.rpc.thrift.TTypeQualifierValue;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.client.api.v1.dto.ColumnDesc;
import org.apache.kyuubi.client.api.v1.dto.Field;
import org.apache.kyuubi.client.api.v1.dto.OpActionRequest;
import org.apache.kyuubi.client.api.v1.dto.OperationLog;
import org.apache.kyuubi.client.api.v1.dto.ResultRowSet;
import org.apache.kyuubi.client.api.v1.dto.ResultSetMetaData;
import org.apache.kyuubi.client.api.v1.dto.Row;
import org.apache.kyuubi.events.KyuubiOperationEvent;
import org.apache.kyuubi.events.KyuubiOperationEvent$;
import org.apache.kyuubi.operation.FetchOrientation$;
import org.apache.kyuubi.operation.KyuubiOperation;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.OperationHandle$;
import org.apache.kyuubi.server.KyuubiRestFrontendService;
import org.apache.kyuubi.server.api.ApiRequestContext;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@Tag(name="Operation")
@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\t\ra!B\u0004\t\u0001!!\u0002\"B\u0012\u0001\t\u0003)\u0003\"\u0002\u0015\u0001\t\u0003I\u0003BB@\u0001\t\u0003\t\t\u0001C\u0004\u0002D\u0001!\t!!\u0012\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j!9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r&AE(qKJ\fG/[8ogJ+7o\\;sG\u0016T!!\u0003\u0006\u0002\u0005Y\f$BA\u0006\r\u0003\r\t\u0007/\u001b\u0006\u0003\u001b9\taa]3sm\u0016\u0014(BA\b\u0011\u0003\u0019Y\u00170^;cS*\u0011\u0011CE\u0001\u0007CB\f7\r[3\u000b\u0003M\t1a\u001c:h'\u0011\u0001QcG\u0010\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\taR$D\u0001\u000b\u0013\tq\"BA\tBa&\u0014V-];fgR\u001cuN\u001c;fqR\u0004\"\u0001I\u0011\u000e\u00039I!A\t\b\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001'!\t9\u0003!D\u0001\t\u0003E9W\r^(qKJ\fG/[8o\u000bZ,g\u000e\u001e\u000b\u0003UA\u0002\"a\u000b\u0018\u000e\u00031R!!\f\b\u0002\r\u00154XM\u001c;t\u0013\tyCF\u0001\u000bLsV,(-[(qKJ\fG/[8o\u000bZ,g\u000e\u001e\u0005\u0006c\t\u0001\rAM\u0001\u0013_B,'/\u0019;j_:D\u0015M\u001c3mKN#(\u000f\u0005\u00024u9\u0011A\u0007\u000f\t\u0003k]i\u0011A\u000e\u0006\u0003o\u0011\na\u0001\u0010:p_Rt\u0014BA\u001d\u0018\u0003\u0019\u0001&/\u001a3fM&\u00111\b\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e:\u0002\u0006\u0002\u0019?\u0011&\u0003\"a\u0010$\u000e\u0003\u0001S!!\u0011\"\u0002\u0005I\u001c(BA\"E\u0003\t98OC\u0001F\u0003\u0015Q\u0017M^1y\u0013\t9\u0005IA\u0005QCRD\u0007+\u0019:b[\u0006)a/\u00197vK\u0006\n!*A\bpa\u0016\u0014\u0018\r^5p]\"\u000bg\u000e\u001a7fQ\u0011\u0011A\nS(\u0011\u0005}j\u0015B\u0001(A\u0005\u0011\u0001\u0016\r\u001e5\"\u0003A\u000bqc_8qKJ\fG/[8o\u0011\u0006tG\r\\3~_\u00154XM\u001c;)\u0005\t\u0011\u0006CA T\u0013\t!\u0006IA\u0002H\u000bRC\u0003B\u0001,gO&TG0 \t\u0003/\u0012l\u0011\u0001\u0017\u0006\u00033j\u000b\u0011B]3ta>t7/Z:\u000b\u0005mc\u0016aC1o]>$\u0018\r^5p]NT!!\u00180\u0002\u0007=\f7O\u0003\u0002`A\u0006\u0011ao\r\u0006\u0003C\n\fqa]<bO\u001e,'OC\u0001d\u0003\tIw.\u0003\u0002f1\nY\u0011\t]5SKN\u0004xN\\:f\u00031\u0011Xm\u001d9p]N,7i\u001c3fC\u0005A\u0017a\u0001\u001a1a\u000591m\u001c8uK:$H&A6,\u000b1\u00148/\u001e<\u0011\u00055\u0004X\"\u00018\u000b\u0005=T\u0016!B7fI&\f\u0017BA9o\u0005\u001d\u0019uN\u001c;f]R\f\u0011\"\\3eS\u0006$\u0016\u0010]3\"\u0003Q\f\u0001#\u00199qY&\u001c\u0017\r^5p]>R7o\u001c8\u0002\rM\u001c\u0007.Z7bW\r9(p\u001f\t\u0003[bL!!\u001f8\u0003\rM\u001b\u0007.Z7b\u00039IW\u000e\u001d7f[\u0016tG/\u0019;j_:\u001c\u0013AK\u0001\fI\u0016\u001c8M]5qi&|g.I\u0001\u007f\u0003Y9U\r\u001e\u0011b]\u0002z\u0007/\u001a:bi&|g\u000eI3wK:$\u0018!D1qa2Lx\n]!di&|g\u000e\u0006\u0004\u0002\u0004\u0005=\u0011q\u0005\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002!\u0002\t\r|'/Z\u0005\u0005\u0003\u001b\t9A\u0001\u0005SKN\u0004xN\\:f\u0011\u001d\t\tb\u0001a\u0001\u0003'\tqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002\u0016\u0005\rRBAA\f\u0015\u0011\tI\"a\u0007\u0002\u0007\u0011$xNC\u0002\n\u0003;Q1aCA\u0010\u0015\r\t\tCD\u0001\u0007G2LWM\u001c;\n\t\u0005\u0015\u0012q\u0003\u0002\u0010\u001fB\f5\r^5p]J+\u0017/^3ti\")\u0011g\u0001a\u0001e!*\u0011q\u0005 I\u0013\"*1\u0001\u0014%\u0002.\u0005\u0012\u0011qF\u0001\u0012w>\u0004XM]1uS>t\u0007*\u00198eY\u0016l\bfA\u0002\u00024A\u0019q(!\u000e\n\u0007\u0005]\u0002IA\u0002Q+RC#b\u0001,gO&\fY\u0004`A Y\t\tidK\u0002meN\f#!!\u0011\u0002A\u0005\u0004\b\u000f\\=!C:\u0004\u0013m\u0019;j_:\u0004cm\u001c:!C:\u0004s\u000e]3sCRLwN\\\u0001\u0015O\u0016$(+Z:vYR\u001cV\r^'fi\u0006$\u0017\r^1\u0015\t\u0005\u001d\u0013Q\n\t\u0005\u0003+\tI%\u0003\u0003\u0002L\u0005]!!\u0005*fgVdGoU3u\u001b\u0016$\u0018\rR1uC\")\u0011\u0007\u0002a\u0001e!*\u0011Q\n I\u0013\"*A\u0001\u0014%\u0002T\u0005\u0012\u0011QK\u0001$w>\u0004XM]1uS>t\u0007*\u00198eY\u0016lxF]3tk2$8/\u001a;nKR\fG-\u0019;bQ\t!!\u000b\u000b\u0006\u0005-\u001a<\u0017.a\u0017}\u0003Gb#!!\u0018,\r1\u00148/^A0W\u00119(0!\u0019$\u0005\u0005\u001d\u0013EAA3\u0003]9W\r\u001e\u0011sKN,H\u000e\u001e\u0011tKR\u0004S.\u001a;bI\u0006$\u0018-A\bhKR|\u0005/\u001a:bi&|g\u000eT8h)\u0019\tY'!\u001d\u0002vA!\u0011QCA7\u0013\u0011\ty'a\u0006\u0003\u0019=\u0003XM]1uS>tGj\\4\t\u000bE*\u0001\u0019\u0001\u001a)\u000b\u0005Ed\bS%\t\u000f\u0005]T\u00011\u0001\u0002z\u00059Q.\u0019=S_^\u001c\bc\u0001\f\u0002|%\u0019\u0011QP\f\u0003\u0007%sG\u000fK\u0004\u0002v\u0005\u0005\u0005*a\"\u0011\u0007}\n\u0019)C\u0002\u0002\u0006\u0002\u0013!\"U;fef\u0004\u0016M]1nC\t\tI)A\u0004nCb\u0014xn^:)\u000b\u0015a\u0005*!$\"\u0005\u0005=\u0015!F>pa\u0016\u0014\u0018\r^5p]\"\u000bg\u000e\u001a7f{>bwn\u001a\u0015\u0003\u000bIC#\"\u0002,gO&\f)\n`AOY\t\t9j\u000b\u0004meN,\u0018\u0011T\u0016\u0005oj\fYj\t\u0002\u0002l\u0005\u0012\u0011qT\u0001\u0012O\u0016$\be\u001c9fe\u0006$\u0018n\u001c8!Y><\u0017!D4fi:+\u0007\u0010\u001e*poN+G\u000f\u0006\u0005\u0002&\u0006-\u0016qVA`!\u0011\t)\"a*\n\t\u0005%\u0016q\u0003\u0002\r%\u0016\u001cX\u000f\u001c;S_^\u001cV\r\u001e\u0005\u0006c\u0019\u0001\rA\r\u0015\u0006\u0003Ws\u0004*\u0013\u0005\b\u0003o2\u0001\u0019AA=Q\u001d\ty+a-I\u0003s\u00032aPA[\u0013\r\t9\f\u0011\u0002\r\t\u00164\u0017-\u001e7u-\u0006dW/Z\u0011\u0003\u0003w\u000b1!\r\u00191Q\u001d\ty+!!I\u0003\u000fCa!!1\u0007\u0001\u0004\u0011\u0014\u0001\u00054fi\u000eDwJ]5f]R\fG/[8oQ\u001d\ty,a-I\u0003\u000b\f#!a2\u0002\u0015\u0019+Ek\u0011%`\u001d\u0016CF\u000bK\u0004\u0002@\u0006\u0005\u0005*a3\"\u0005\u00055\u0017\u0001\u00054fi\u000eDwN]5f]R\fG/[8oQ\u00151A\nSAiC\t\t\u0019.\u0001\r|_B,'/\u0019;j_:D\u0015M\u001c3mKv|#o\\<tKRD#A\u0002*)\u0015\u00191fmZ5\u0002Zr\f\t\u000f\f\u0002\u0002\\.2AN]:v\u0003;\\Ca\u001e>\u0002`\u000e\u0012\u0011QU\u0011\u0003\u0003G\f!cZ3uAI,7/\u001e7uAI|w\u000fI:fi\"2\u0001!a:I\u0003[\u00042aPAu\u0013\r\tY\u000f\u0011\u0002\t!J|G-^2fg2\n1\u000fK\u0004\u0001\u0003c\fi0a@\u0011\t\u0005M\u0018\u0011`\u0007\u0003\u0003kT1!a>[\u0003\u0011!\u0018mZ:\n\t\u0005m\u0018Q\u001f\u0002\u0004)\u0006<\u0017\u0001\u00028b[\u0016\f#A!\u0001\u0002\u0013=\u0003XM]1uS>t\u0007")
public class OperationsResource
implements ApiRequestContext,
Logging {
    private transient Logger org$apache$kyuubi$Logging$$log_;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public final KyuubiRestFrontendService fe() {
        return ApiRequestContext.fe$(this);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=KyuubiOperationEvent.class))}, description="Get an operation event")
    @GET
    @Path(value="{operationHandle}/event")
    public KyuubiOperationEvent getOperationEvent(@PathParam(value="operationHandle") String operationHandleStr) {
        KyuubiOperationEvent kyuubiOperationEvent;
        try {
            OperationHandle opHandle = OperationHandle$.MODULE$.apply(operationHandleStr);
            Operation operation = this.fe().be().sessionManager().operationManager().getOperation(opHandle);
            kyuubiOperationEvent = KyuubiOperationEvent$.MODULE$.apply((KyuubiOperation)operation);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = "Error getting an operation event";
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return kyuubiOperationEvent;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="apply an action for an operation")
    @PUT
    @Path(value="{operationHandle}")
    public Response applyOpAction(OpActionRequest request, @PathParam(value="operationHandle") String operationHandleStr) {
        Response response;
        try {
            OperationHandle operationHandle = OperationHandle$.MODULE$.apply(operationHandleStr);
            String string = request.getAction().toLowerCase();
            if ("cancel".equals(string)) {
                this.fe().be().cancelOperation(operationHandle);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("close".equals(string)) {
                this.fe().be().closeOperation(operationHandle);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(15).append("Invalid action ").append(request.getAction()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }
            response = Response.ok().build();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = new StringBuilder(37).append("Error applying ").append(request.getAction()).append(" for operation handle ").append(operationHandleStr).toString();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return response;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResultSetMetaData.class))}, description="get result set metadata")
    @GET
    @Path(value="{operationHandle}/resultsetmetadata")
    public ResultSetMetaData getResultSetMetadata(@PathParam(value="operationHandle") String operationHandleStr) {
        ResultSetMetaData resultSetMetaData;
        try {
            OperationHandle operationHandle = OperationHandle$.MODULE$.apply(operationHandleStr);
            resultSetMetaData = new ResultSetMetaData((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.fe().be().getResultSetMetadata(operationHandle).getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)c -> {
                TPrimitiveTypeEntry tPrimitiveTypeEntry = ((TTypeEntry)c.getTypeDesc().getTypes().get(0)).getPrimitiveEntry();
                int precision = 0;
                int scale = 0;
                if (tPrimitiveTypeEntry.getTypeQualifiers() != null) {
                    Map qualifiers = tPrimitiveTypeEntry.getTypeQualifiers().getQualifiers();
                    TTypeQualifierValue defaultValue = TTypeQualifierValue.i32Value((int)0);
                    precision = qualifiers.getOrDefault("precision", defaultValue).getI32Value();
                    scale = qualifiers.getOrDefault("scale", defaultValue).getI32Value();
                }
                return new ColumnDesc(c.getColumnName(), tPrimitiveTypeEntry.getType().toString(), c.getPosition(), precision, scale, c.getComment());
            }, Buffer$.MODULE$.canBuildFrom())).asJava());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = new StringBuilder(55).append("Error getting result set metadata for operation handle ").append(operationHandleStr).toString();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return resultSetMetaData;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationLog.class))}, description="get operation log")
    @GET
    @Path(value="{operationHandle}/log")
    public OperationLog getOperationLog(@PathParam(value="operationHandle") String operationHandleStr, @QueryParam(value="maxrows") int maxRows) {
        OperationLog operationLog;
        try {
            TRowSet rowSet = this.fe().be().sessionManager().operationManager().getOperationLogRowSet(OperationHandle$.MODULE$.apply(operationHandleStr), FetchOrientation$.MODULE$.FETCH_NEXT(), maxRows);
            Buffer logRowSet = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((TColumn)rowSet.getColumns().get(0)).getStringVal().getValues()).asScala();
            operationLog = new OperationLog((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(logRowSet).asJava(), logRowSet.size());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = new StringBuilder(49).append("Error getting operation log for operation handle ").append(operationHandleStr).toString();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return operationLog;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=ResultRowSet.class))}, description="get result row set")
    @GET
    @Path(value="{operationHandle}/rowset")
    public ResultRowSet getNextRowSet(@PathParam(value="operationHandle") String operationHandleStr, @QueryParam(value="maxrows") @DefaultValue(value="100") int maxRows, @QueryParam(value="fetchorientation") @DefaultValue(value="FETCH_NEXT") String fetchOrientation) {
        ResultRowSet resultRowSet;
        try {
            TRowSet rowSet = this.fe().be().fetchResults(OperationHandle$.MODULE$.apply(operationHandleStr), FetchOrientation$.MODULE$.withName(fetchOrientation), maxRows, false);
            Buffer rows = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rowSet.getRows()).asScala()).map((Function1 & Serializable & scala.Serializable)i2 -> new Row((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(i2.getColVals()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> {
                Object object;
                String string = ((Enum)i.getSetField()).name();
                TColumnValue._Fields _Fields2 = (TColumnValue._Fields)i.getSetField();
                if (TColumnValue._Fields.STRING_VAL.equals(_Fields2)) {
                    object = i.getStringVal().getFieldValue(TStringValue._Fields.VALUE);
                } else if (TColumnValue._Fields.BOOL_VAL.equals(_Fields2)) {
                    object = i.getBoolVal().getFieldValue(TBoolValue._Fields.VALUE);
                } else if (TColumnValue._Fields.BYTE_VAL.equals(_Fields2)) {
                    object = i.getByteVal().getFieldValue(TByteValue._Fields.VALUE);
                } else if (TColumnValue._Fields.DOUBLE_VAL.equals(_Fields2)) {
                    object = i.getDoubleVal().getFieldValue(TDoubleValue._Fields.VALUE);
                } else if (TColumnValue._Fields.I16_VAL.equals(_Fields2)) {
                    object = i.getI16Val().getFieldValue(TI16Value._Fields.VALUE);
                } else if (TColumnValue._Fields.I32_VAL.equals(_Fields2)) {
                    object = i.getI32Val().getFieldValue(TI32Value._Fields.VALUE);
                } else if (TColumnValue._Fields.I64_VAL.equals(_Fields2)) {
                    object = i.getI64Val().getFieldValue(TI64Value._Fields.VALUE);
                } else {
                    throw new MatchError((Object)_Fields2);
                }
                return new Field(string, object);
            }, Buffer$.MODULE$.canBuildFrom())).asJava()), Buffer$.MODULE$.canBuildFrom());
            resultRowSet = new ResultRowSet((List)JavaConverters$.MODULE$.bufferAsJavaListConverter(rows).asJava(), rows.size());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                String errorMsg = new StringBuilder(50).append("Error getting result row set for operation handle ").append(operationHandleStr).toString();
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                throw new NotFoundException(errorMsg);
            }
            throw throwable;
        }
        return resultRowSet;
    }

    public OperationsResource() {
        ApiRequestContext.$init$(this);
        Logging.$init$((Logging)this);
    }
}

