/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.shareddata.impl;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kyuubi.shade.io.vertx.core.impl.ClusterSerializableUtils;
import org.apache.kyuubi.shade.io.vertx.core.impl.SerializableUtils;
import org.apache.kyuubi.shade.io.vertx.core.impl.logging.Logger;
import org.apache.kyuubi.shade.io.vertx.core.impl.logging.LoggerFactory;
import org.apache.kyuubi.shade.io.vertx.core.shareddata.Shareable;
import org.apache.kyuubi.shade.io.vertx.core.shareddata.impl.ClusterSerializable;

class Checker {
    private static final Logger log = LoggerFactory.getLogger(Checker.class);
    private static final Set<Class<?>> IMMUTABLE_TYPES = Stream.builder().add(String.class).add(Integer.class).add(Long.class).add(Boolean.class).add(Double.class).add(Float.class).add(Short.class).add(Byte.class).add(Character.class).add(BigInteger.class).add(BigDecimal.class).build().collect(Collectors.toSet());

    Checker() {
    }

    static void checkType(Object obj) {
        Objects.requireNonNull(obj, "null not allowed for shareddata data structure");
        if (!(obj instanceof Serializable || obj instanceof Shareable || obj instanceof ClusterSerializable)) {
            throw new IllegalArgumentException("Invalid type for shareddata data structure: " + obj.getClass().getName());
        }
    }

    static <T> T copyIfRequired(T obj) {
        Object result;
        if (obj == null) {
            result = null;
        } else if (IMMUTABLE_TYPES.contains(obj.getClass())) {
            result = obj;
        } else if (obj instanceof byte[]) {
            result = Checker.copyByteArray((byte[])obj);
        } else if (obj instanceof Shareable) {
            result = ((Shareable)obj).copy();
        } else if (obj instanceof ClusterSerializable) {
            result = Checker.copyClusterSerializable((ClusterSerializable)obj);
        } else if (obj instanceof Serializable) {
            result = Checker.copySerializable(obj);
        } else {
            throw new IllegalStateException();
        }
        return (T)result;
    }

    private static byte[] copyByteArray(byte[] bytes) {
        byte[] copy = new byte[bytes.length];
        System.arraycopy(bytes, 0, copy, 0, bytes.length);
        return copy;
    }

    private static ClusterSerializable copyClusterSerializable(ClusterSerializable obj) {
        Checker.logDeveloperInfo(obj);
        return ClusterSerializableUtils.copy(obj);
    }

    private static void logDeveloperInfo(Object obj) {
        if (log.isDebugEnabled()) {
            log.debug("Copying " + obj.getClass() + " for shared data. Consider implementing " + Shareable.class + " for better performance.");
        }
    }

    private static Object copySerializable(Object obj) {
        Checker.logDeveloperInfo(obj);
        return SerializableUtils.fromBytes(SerializableUtils.toBytes(obj), ObjectInputStream::new);
    }
}

