/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.util.command;

import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

public final class CommandLineUtils$ {
    public static CommandLineUtils$ MODULE$;
    private final String CONF;
    private final Regex PATTERN_FOR_KEY_VALUE_ARG;
    private final String REDACTION_REPLACEMENT_TEXT;
    private final String CP;

    static {
        new CommandLineUtils$();
    }

    public String CONF() {
        return this.CONF;
    }

    public Regex PATTERN_FOR_KEY_VALUE_ARG() {
        return this.PATTERN_FOR_KEY_VALUE_ARG;
    }

    public String REDACTION_REPLACEMENT_TEXT() {
        return this.REDACTION_REPLACEMENT_TEXT;
    }

    public String CP() {
        return this.CP;
    }

    public String genKeyValuePair(String key, String value) {
        return new StringBuilder(1).append(key).append("=").append(value).toString().trim();
    }

    public Iterable<String> confKeyValue(String key, String value, String confOption) {
        return (Iterable)new .colon.colon((Object)confOption, (List)new .colon.colon((Object)this.genKeyValuePair(key, value), (List)Nil$.MODULE$));
    }

    public String confKeyValue$default$3() {
        return this.CONF();
    }

    public String confKeyValueStr(String key, String value, String confOption) {
        return this.confKeyValue(key, value, confOption).mkString(" ");
    }

    public String confKeyValueStr$default$3() {
        return this.CONF();
    }

    public Iterable<String> confKeyValues(Iterable<Tuple2<String, String>> configs) {
        return ((TraversableOnce)configs.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return MODULE$.confKeyValue(k, v, MODULE$.confKeyValue$default$3());
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public Iterable<String> genClasspathOption(Iterable<String> classpathEntries) {
        return (Iterable)new .colon.colon((Object)this.CP(), (List)new .colon.colon((Object)classpathEntries.mkString(File.pathSeparator), (List)Nil$.MODULE$));
    }

    public Iterable<String> redactConfValues(Iterable<String> commands, Iterable<String> redactKeys) {
        Set set = redactKeys.toSet();
        if (set.isEmpty()) {
            return commands;
        }
        return (Iterable)commands.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String key;
            String string = x0$1;
            Option option = MODULE$.PATTERN_FOR_KEY_VALUE_ARG().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0 && set.contains((Object)(key = (String)((LinearSeqOptimized)option.get()).apply(0)))) {
                return MODULE$.genKeyValuePair(key, MODULE$.REDACTION_REPLACEMENT_TEXT());
            }
            return string;
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public List<String> parseOptionString(String s) {
        int c;
        ListBuffer opts = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.StringBuilder opt = new scala.collection.mutable.StringBuilder();
        boolean inOpt = false;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean escapeNext = false;
        boolean hasData = false;
        block10: for (int i = 0; i < s.length(); i += Character.charCount(c)) {
            BoxedUnit boxedUnit;
            c = s.codePointAt(i);
            if (escapeNext) {
                opt.appendAll(Character.toChars(c));
                escapeNext = false;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (inOpt) {
                int n = c;
                switch (n) {
                    case 92: {
                        if (inSingleQuote) {
                            boxedUnit = opt.appendAll(Character.toChars(c));
                            break;
                        }
                        escapeNext = true;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    case 39: {
                        if (inDoubleQuote) {
                            boxedUnit = opt.appendAll(Character.toChars(c));
                            break;
                        }
                        inSingleQuote = !inSingleQuote;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    case 34: {
                        if (inSingleQuote) {
                            boxedUnit = opt.appendAll(Character.toChars(c));
                            break;
                        }
                        inDoubleQuote = !inDoubleQuote;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    default: {
                        if (!Character.isWhitespace(c) || inSingleQuote || inDoubleQuote) {
                            boxedUnit = opt.appendAll(Character.toChars(c));
                            break;
                        }
                        opts.$plus$eq((Object)opt.toString());
                        opt.setLength(0);
                        inOpt = false;
                        hasData = false;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                }
                continue;
            }
            int n = c;
            switch (n) {
                case 39: {
                    inSingleQuote = true;
                    inOpt = true;
                    hasData = true;
                    boxedUnit = BoxedUnit.UNIT;
                    continue block10;
                }
                case 34: {
                    inDoubleQuote = true;
                    inOpt = true;
                    hasData = true;
                    boxedUnit = BoxedUnit.UNIT;
                    continue block10;
                }
                case 92: {
                    escapeNext = true;
                    inOpt = true;
                    hasData = true;
                    boxedUnit = BoxedUnit.UNIT;
                    continue block10;
                }
                default: {
                    if (!Character.isWhitespace(c)) {
                        inOpt = true;
                        hasData = true;
                        boxedUnit = opt.appendAll(Character.toChars(c));
                        continue block10;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    continue block10;
                }
            }
        }
        Predef$.MODULE$.require(!inSingleQuote && !inDoubleQuote && !escapeNext, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Invalid option string: ").append(s).toString());
        Object object = hasData ? opts.$plus$eq((Object)opt.toString()) : BoxedUnit.UNIT;
        return opts.toList();
    }

    private CommandLineUtils$() {
        MODULE$ = this;
        this.CONF = "--conf";
        this.PATTERN_FOR_KEY_VALUE_ARG = new StringOps(Predef$.MODULE$.augmentString("(.+?)=(.+)")).r();
        this.REDACTION_REPLACEMENT_TEXT = "*********(redacted)";
        this.CP = "-cp";
    }
}

