/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiPredicate;

public final class SingleContains<T>
extends Single<Boolean> {
    final SingleSource<T> source;
    final Object value;
    final BiPredicate<Object, Object> comparer;

    public SingleContains(SingleSource<T> source, Object value, BiPredicate<Object, Object> comparer) {
        this.source = source;
        this.value = value;
        this.comparer = comparer;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super Boolean> s) {
        this.source.subscribe(new SingleObserver<T>(){

            @Override
            public void onSubscribe(Disposable d) {
                s.onSubscribe(d);
            }

            @Override
            public void onSuccess(T v) {
                boolean b;
                try {
                    b = SingleContains.this.comparer.test(v, SingleContains.this.value);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    s.onError(ex);
                    return;
                }
                s.onSuccess(b);
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
            }
        });
    }
}

