/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.chat.provider;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.theokanning.openai.service.OpenAiService;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.chat.api.ErnieBotApi;
import org.apache.kyuubi.engine.chat.ernie.bean.ChatCompletionRequest;
import org.apache.kyuubi.engine.chat.ernie.bean.ChatCompletionRequest$;
import org.apache.kyuubi.engine.chat.ernie.bean.ChatCompletionResult;
import org.apache.kyuubi.engine.chat.ernie.bean.ChatMessage;
import org.apache.kyuubi.engine.chat.ernie.bean.ChatMessage$;
import org.apache.kyuubi.engine.chat.ernie.bean.Function;
import org.apache.kyuubi.engine.chat.ernie.enums.ChatMessageRole;
import org.apache.kyuubi.engine.chat.ernie.service.ErnieBotService;
import org.apache.kyuubi.engine.chat.ernie.service.ErnieBotService$;
import org.apache.kyuubi.engine.chat.provider.ChatProvider;
import retrofit2.Retrofit;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\t\u0013\u0001}A\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006c\u0001!\tA\r\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0011\u0019\u0011\u0005\u0001)A\u0005o!91\t\u0001b\u0001\n\u00131\u0004B\u0002#\u0001A\u0003%q\u0007C\u0004F\u0001\t\u0007I\u0011\u0002$\t\r=\u0003\u0001\u0015!\u0003H\u0011\u001d\u0001\u0006\u00011A\u0005\nECq!\u0016\u0001A\u0002\u0013%a\u000b\u0003\u0004]\u0001\u0001\u0006KA\u0015\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u0011\u0019I\b\u0001)A\u0005?\")!\u0010\u0001C!w\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0001bBA\u0006\u0001\u0011\u0005\u0013Q\u0002\u0002\u0011\u000bJt\u0017.\u001a\"piB\u0013xN^5eKJT!a\u0005\u000b\u0002\u0011A\u0014xN^5eKJT!!\u0006\f\u0002\t\rD\u0017\r\u001e\u0006\u0003/a\ta!\u001a8hS:,'BA\r\u001b\u0003\u0019Y\u00170^;cS*\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0011'!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fMB\u0011q\u0005K\u0007\u0002%%\u0011\u0011F\u0005\u0002\r\u0007\"\fG\u000f\u0015:pm&$WM]\u0001\u0005G>tg\r\u0005\u0002-_5\tQF\u0003\u0002/1\u000511m\u001c8gS\u001eL!\u0001M\u0017\u0003\u0015-KX/\u001e2j\u0007>tg-\u0001\u0004=S:LGO\u0010\u000b\u0003gQ\u0002\"a\n\u0001\t\u000b)\u0012\u0001\u0019A\u0016\u0002\u0017\u0005\u001c7-Z:t)>\\WM\\\u000b\u0002oA\u0011\u0001h\u0010\b\u0003su\u0002\"A\u000f\u0012\u000e\u0003mR!\u0001\u0010\u0010\u0002\rq\u0012xn\u001c;?\u0013\tq$%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001\u0006\u0013aa\u0015;sS:<'B\u0001 #\u00031\t7mY3tgR{7.\u001a8!\u0003\u0015iw\u000eZ3m\u0003\u0019iw\u000eZ3mA\u0005yQM\u001d8jK\n{GoU3sm&\u001cW-F\u0001H!\tAU*D\u0001J\u0015\tQ5*A\u0004tKJ4\u0018nY3\u000b\u00051#\u0012!B3s]&,\u0017B\u0001(J\u0005=)%O\\5f\u0005>$8+\u001a:wS\u000e,\u0017\u0001E3s]&,'i\u001c;TKJ4\u0018nY3!\u0003-\u0019Xm]:j_:,6/\u001a:\u0016\u0003I\u00032!I*8\u0013\t!&E\u0001\u0004PaRLwN\\\u0001\u0010g\u0016\u001c8/[8o+N,'o\u0018\u0013fcR\u0011qK\u0017\t\u0003CaK!!\u0017\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b7*\t\t\u00111\u0001S\u0003\rAH%M\u0001\rg\u0016\u001c8/[8o+N,'\u000fI\u0001\fG\"\fG\u000fS5ti>\u0014\u00180F\u0001`!\u0011\u0001\u0017nN6\u000e\u0003\u0005T!AY2\u0002\u000b\r\f7\r[3\u000b\u0005\u0011,\u0017AB2p[6|gN\u0003\u0002gO\u00061qm\\8hY\u0016T\u0011\u0001[\u0001\u0004G>l\u0017B\u00016b\u00051au.\u00193j]\u001e\u001c\u0015m\u00195f!\ra\u0017o]\u0007\u0002[*\u0011an\\\u0001\u0005kRLGNC\u0001q\u0003\u0011Q\u0017M^1\n\u0005Il'AC!se\u0006LH)Z9vKB\u0011Ao^\u0007\u0002k*\u0011aoS\u0001\u0005E\u0016\fg.\u0003\u0002yk\nY1\t[1u\u001b\u0016\u001c8/Y4f\u00031\u0019\u0007.\u0019;ISN$xN]=!\u0003\u0011y\u0007/\u001a8\u0015\u0007]ch\u0010C\u0003~\u001d\u0001\u0007q'A\u0005tKN\u001c\u0018n\u001c8JI\"9qP\u0004I\u0001\u0002\u0004\u0011\u0016\u0001B;tKJ\f1!Y:l)\u00159\u0014QAA\u0004\u0011\u0015ix\u00021\u00018\u0011\u0019\tIa\u0004a\u0001o\u0005\t\u0011/A\u0003dY>\u001cX\rF\u0002X\u0003\u001fAQ! \tA\u0002]\u0002")
public class ErnieBotProvider
implements ChatProvider {
    private final String accessToken;
    private final String model;
    private final ErnieBotService ernieBotService;
    private Option<String> sessionUser;
    private final LoadingCache<String, ArrayDeque<ChatMessage>> chatHistory;

    @Override
    public Option<String> open$default$2() {
        return ChatProvider.open$default$2$(this);
    }

    private String accessToken() {
        return this.accessToken;
    }

    private String model() {
        return this.model;
    }

    private ErnieBotService ernieBotService() {
        return this.ernieBotService;
    }

    private Option<String> sessionUser() {
        return this.sessionUser;
    }

    private void sessionUser_$eq(Option<String> x$1) {
        this.sessionUser = x$1;
    }

    private LoadingCache<String, ArrayDeque<ChatMessage>> chatHistory() {
        return this.chatHistory;
    }

    @Override
    public void open(String sessionId, Option<String> user) {
        this.sessionUser_$eq(user);
        this.chatHistory().getIfPresent((Object)sessionId);
    }

    @Override
    public String ask(String sessionId, String q) {
        String string;
        ArrayDeque messages = (ArrayDeque)this.chatHistory().get((Object)sessionId);
        try {
            String responseText;
            messages.addLast(new ChatMessage(ChatMessageRole.USER.value(), q, null, ChatMessage$.MODULE$.apply$default$4()));
            List x$1 = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)messages).asScala()).toList()).asJava();
            String x$2 = (String)this.sessionUser().orNull(Predef$.MODULE$.$conforms());
            List<Function> x$3 = ChatCompletionRequest$.MODULE$.apply$default$2();
            Double x$4 = ChatCompletionRequest$.MODULE$.apply$default$3();
            Double x$5 = ChatCompletionRequest$.MODULE$.apply$default$4();
            Double x$6 = ChatCompletionRequest$.MODULE$.apply$default$5();
            boolean x$7 = ChatCompletionRequest$.MODULE$.apply$default$6();
            String x$8 = ChatCompletionRequest$.MODULE$.apply$default$7();
            List<String> x$9 = ChatCompletionRequest$.MODULE$.apply$default$8();
            boolean x$10 = ChatCompletionRequest$.MODULE$.apply$default$9();
            boolean x$11 = ChatCompletionRequest$.MODULE$.apply$default$10();
            ChatCompletionRequest completionRequest = new ChatCompletionRequest(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$2);
            ChatCompletionResult chatCompletionResult = this.ernieBotService().createChatCompletion(completionRequest, this.model(), this.accessToken());
            if (chatCompletionResult.errorMsg() != null) {
                throw new RuntimeException(chatCompletionResult.errorMsg());
            }
            string = responseText = chatCompletionResult.result();
        }
        catch (Throwable e) {
            messages.removeLast();
            string = new StringBuilder(20).append("Chat failed. Error: ").append(e.getMessage()).toString();
        }
        return string;
    }

    @Override
    public void close(String sessionId) {
        this.chatHistory().invalidate((Object)sessionId);
    }

    public ErnieBotProvider(KyuubiConf conf) {
        this.accessToken = (String)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_ERNIE_BOT_ACCESS_TOKEN())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(99).append("'").append(KyuubiConf$.MODULE$.ENGINE_ERNIE_BOT_ACCESS_TOKEN().key()).append("' must be configured, ").append("which could be got at https://cloud.baidu.com/doc/WENXINWORKSHOP/s/Ilkkrb0i5").toString());
        });
        this.model = (String)conf.get(KyuubiConf$.MODULE$.ENGINE_ERNIE_BOT_MODEL());
        OkHttpClient.Builder builder = ErnieBotService$.MODULE$.defaultClient(Duration.ofMillis(BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_ERNIE_HTTP_SOCKET_TIMEOUT())))).newBuilder().connectTimeout(Duration.ofMillis(BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_ERNIE_HTTP_CONNECT_TIMEOUT()))));
        Option option = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_CHAT_GPT_HTTP_PROXY());
        if (option instanceof Some) {
            Some some = (Some)option;
            String httpProxyUrl = (String)some.value();
            URL url = new URL(httpProxyUrl);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(url.getHost(), url.getPort()));
            builder.proxy(proxy);
        }
        Retrofit retrofit = ErnieBotService$.MODULE$.defaultRetrofit(builder.build(), OpenAiService.defaultObjectMapper());
        ErnieBotApi ernieBotApi = (ErnieBotApi)retrofit.create(ErnieBotApi.class);
        this.ernieBotService = new ErnieBotService(ernieBotApi);
        this.sessionUser = None$.MODULE$;
        this.chatHistory = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, ArrayDeque<ChatMessage>>(null){

            public ArrayDeque<ChatMessage> load(String sessionId) {
                return new ArrayDeque<ChatMessage>();
            }
        });
    }
}

