/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.scheduling;

import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.util.Assert;

public class DelegatingSecurityContextTaskScheduler
implements TaskScheduler {
    private final TaskScheduler taskScheduler;

    public DelegatingSecurityContextTaskScheduler(TaskScheduler taskScheduler) {
        Assert.notNull((Object)taskScheduler, "Task scheduler must not be null");
        this.taskScheduler = taskScheduler;
    }

    public ScheduledFuture<?> schedule(Runnable task, Trigger trigger) {
        return this.taskScheduler.schedule(task, trigger);
    }

    public ScheduledFuture<?> schedule(Runnable task, Date startTime) {
        return this.taskScheduler.schedule(task, startTime);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, Date startTime, long period) {
        return this.taskScheduler.scheduleAtFixedRate(task, startTime, period);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long period) {
        return this.taskScheduler.scheduleAtFixedRate(task, period);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, Date startTime, long delay) {
        return this.taskScheduler.scheduleWithFixedDelay(task, startTime, delay);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long delay) {
        return this.taskScheduler.scheduleWithFixedDelay(task, delay);
    }
}

