/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query;

import java.io.Serializable;
import java.util.Locale;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.gridtable.CuboidToGridTableMapping;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.query.AggColumnInfo;
import org.apache.kylin.query.DeriveTableColumnInfo;
import org.apache.kylin.query.FactTableCulumnInfo;
import org.apache.kylin.query.TopNColumnInfo;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.utils.SparkTypeUtil$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SchemaProcessor$ {
    public static SchemaProcessor$ MODULE$;
    private final String COLUMN_NAME_SEPARATOR;

    static {
        new SchemaProcessor$();
    }

    public String COLUMN_NAME_SEPARATOR() {
        return this.COLUMN_NAME_SEPARATOR;
    }

    public Seq<String> buildGTSchema(Cuboid cuboid, String tableName) {
        return this.genColumnNames(tableName, cuboid, cuboid.getCuboidToGridTableMapping());
    }

    private Seq<String> genColumnNames(String tableName, Cuboid cuboid, CuboidToGridTableMapping mapping) {
        String[] coolumnMapping = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.initColumnNameMapping(cuboid))).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        ImmutableBitSet colAll = new ImmutableBitSet(0, mapping.getDataTypes().length);
        Iterable measures = (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)colAll.andNot(mapping.getPrimaryKey())).asScala();
        return (Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)mapping.getPrimaryKey()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> new FactTableCulumnInfo(tableName, Predef$.MODULE$.Integer2int(i), coolumnMapping[Predef$.MODULE$.Integer2int(i)]).toString(), Iterable$.MODULE$.canBuildFrom())).toSeq().$plus$plus((GenTraversableOnce)((TraversableOnce)measures.map((Function1 & Serializable & scala.Serializable)i -> new FactTableCulumnInfo(tableName, Predef$.MODULE$.Integer2int(i), coolumnMapping[Predef$.MODULE$.Integer2int(i)]).toString(), Iterable$.MODULE$.canBuildFrom())).toSeq(), Seq$.MODULE$.canBuildFrom());
    }

    public Tuple2<String, String>[] initColumnNameMapping(Cuboid cuboid) {
        Tuple2[] cols = (Tuple2[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cuboid.getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)col -> new Tuple2((Object)col.getIdentity().replace(".", "_"), (Object)col.getType().getName()), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        Tuple2[] measures = (Tuple2[])((TraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(cuboid.getCubeDesc().getMeasures()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)measure -> new Tuple2((Object)measure.getName().replace(".", "_"), (Object)measure.getFunction().getReturnType()), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cols)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])measures)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public DataType generateFunctionReturnDataType(FunctionDesc function) {
        LongType$ longType$;
        String string = function.getExpression().toUpperCase(Locale.ROOT);
        if ("SUM".equals(string)) {
            ParameterDesc parameter = function.getParameter();
            longType$ = parameter.isColumnType() ? SparkTypeUtil$.MODULE$.toSparkType(parameter.getColRef().getType(), true) : SparkTypeUtil$.MODULE$.toSparkType(function.getReturnDataType(), true);
        } else if ("COUNT".equals(string)) {
            longType$ = LongType$.MODULE$;
        } else if (string.startsWith("TOP_N")) {
            Buffer fields = (Buffer)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(function.getParameter().getColRefs()).asScala()).drop(1)).map((Function1 & Serializable & scala.Serializable)col -> new StructField(new StringBuilder(10).append("DIMENSION_").append(col.getName()).toString(), SparkTypeUtil$.MODULE$.toSparkType(col.getType(), SparkTypeUtil$.MODULE$.toSparkType$default$2()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom());
            longType$ = DataTypes.createArrayType((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("measure", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("dim", (DataType)StructType$.MODULE$.apply((Seq)fields), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
        } else {
            boolean bl = "MAX".equals(string) ? true : "MIN".equals(string);
            if (bl) {
                ParameterDesc parameter = function.getParameter();
                longType$ = parameter.isColumnType() ? SparkTypeUtil$.MODULE$.toSparkType(parameter.getColRef().getType(), SparkTypeUtil$.MODULE$.toSparkType$default$2()) : SparkTypeUtil$.MODULE$.toSparkType(function.getReturnDataType(), SparkTypeUtil$.MODULE$.toSparkType$default$2());
            } else if ("COLLECT_SET".equals(string)) {
                ParameterDesc parameter = function.getParameter();
                longType$ = ArrayType$.MODULE$.apply(SparkTypeUtil$.MODULE$.toSparkType(parameter.getColRef().getType(), SparkTypeUtil$.MODULE$.toSparkType$default$2()));
            } else {
                longType$ = SparkTypeUtil$.MODULE$.toSparkType(function.getReturnDataType(), SparkTypeUtil$.MODULE$.toSparkType$default$2());
            }
        }
        return longType$;
    }

    public int factTableSchemaNameToColumnId(String schemaName) {
        String[] data = schemaName.split(this.COLUMN_NAME_SEPARATOR());
        return new StringOps(Predef$.MODULE$.augmentString(data[data.length - 1])).toInt();
    }

    public DeriveTableColumnInfo parseDeriveTableSchemaName(String schemaName) {
        String[] data = schemaName.split(this.COLUMN_NAME_SEPARATOR());
        DeriveTableColumnInfo deriveTableColumnInfo = new DeriveTableColumnInfo(data[2], new StringOps(Predef$.MODULE$.augmentString(data[3])).toInt(), data[1]);
        return deriveTableColumnInfo;
    }

    public String generateDeriveTableSchemaName(String deriveTableName, int colId, String columnName) {
        return new DeriveTableColumnInfo(deriveTableName, colId, columnName).toString();
    }

    public String generateDeriveTableSchemaName$default$3() {
        return "N";
    }

    public String replaceToAggravateSchemaName(int index, String aggFuncName, String hash, Seq<String> aggArgs) {
        return new AggColumnInfo(index, aggFuncName, hash, aggArgs).toString();
    }

    public String[] buildFactTableSortNames(StructType sourceSchema) {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceSchema.fieldNames())).filter((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)SchemaProcessor$.$anonfun$buildFactTableSortNames$1(name))))).map((Function1 & Serializable & scala.Serializable)name -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)MODULE$.factTableSchemaNameToColumnId((String)name)), name), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$))).map((Function1 & Serializable & scala.Serializable)x$3 -> (String)x$3._2(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public StructType buildSchemaWithRawTable(ColumnDesc[] columnDescs) {
        return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnDescs)).map((Function1 & Serializable & scala.Serializable)columnDesc -> new StructField(columnDesc.getName(), SparkTypeUtil$.MODULE$.toSparkType(columnDesc.getType(), SparkTypeUtil$.MODULE$.toSparkType$default$2()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
    }

    public String genTopNSchema(String advanceTableName, int colId, String columnName) {
        return new TopNColumnInfo(advanceTableName, colId, columnName).toString();
    }

    public String genTopNSchema$default$3() {
        return "N";
    }

    public StructField createStructType(String name, DataType dataType, boolean nullable) {
        return new StructField(name, dataType, nullable, StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ boolean $anonfun$buildFactTableSortNames$1(String name) {
        return name.startsWith("F__") || name.startsWith("R__");
    }

    private SchemaProcessor$() {
        MODULE$ = this;
        this.COLUMN_NAME_SEPARATOR = "__";
    }
}

