/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.metadata.model.TableDesc;

public class DatabaseDesc
implements Serializable {
    private String name;

    public String getName() {
        return this.name == null ? "null" : this.name.toUpperCase(Locale.ROOT);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return "DatabaseDesc [name=" + this.name + "]";
    }

    public static HashMap<String, Integer> extractDatabaseOccurenceCounts(Collection<TableDesc> tables) {
        HashMap<String, Integer> databaseCounts = new HashMap<String, Integer>();
        for (TableDesc tableDesc : tables) {
            String databaseName = tableDesc.getDatabase();
            Integer counter = databaseCounts.get(databaseName);
            if (counter != null) {
                databaseCounts.put(databaseName, counter + 1);
                continue;
            }
            databaseCounts.put(databaseName, 1);
        }
        return databaseCounts;
    }

    public static HashSet<String> extractDatabaseNames(List<TableDesc> tables) {
        HashSet<String> databaseNames = new HashSet<String>();
        for (TableDesc tableDesc : tables) {
            databaseNames.add(tableDesc.getDatabase());
        }
        return databaseNames;
    }
}

