/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.hllc;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HLLDistinctCountAggFunc {
    private static final Logger logger = LoggerFactory.getLogger(HLLDistinctCountAggFunc.class);

    public static HLLCounter init() {
        return null;
    }

    public static HLLCounter initAdd(Object v) {
        if (v instanceof Long) {
            long l = (Long)v;
            return new FixedValueHLLCMockup(l);
        }
        HLLCounter c = (HLLCounter)v;
        return new HLLCounter(c);
    }

    public static HLLCounter add(HLLCounter counter, Object v) {
        if (v instanceof Long) {
            long l = (Long)v;
            if (counter == null) {
                return new FixedValueHLLCMockup(l);
            }
            if (!(counter instanceof FixedValueHLLCMockup)) {
                throw new IllegalStateException("counter is not FixedValueHLLCMockup");
            }
            ((FixedValueHLLCMockup)counter).set(l);
            return counter;
        }
        HLLCounter c = (HLLCounter)v;
        if (counter == null) {
            return new HLLCounter(c);
        }
        counter.merge(c);
        return counter;
    }

    public static HLLCounter merge(HLLCounter counter0, Object counter1) {
        return HLLDistinctCountAggFunc.add(counter0, counter1);
    }

    public static long result(HLLCounter counter) {
        return counter == null ? 0L : counter.getCountEstimate();
    }

    public static class FixedValueHLLCMockup
    extends HLLCounter {
        private Long value = null;

        FixedValueHLLCMockup(long value) {
            this.value = value;
        }

        public void set(long value) {
            if (this.value == null) {
                this.value = value;
            } else {
                long oldValue = Math.abs(this.value);
                long take = Math.max(oldValue, value);
                logger.warn("Error to aggregate holistic count distinct, old value " + oldValue + ", new value " + value + ", taking " + take);
                this.value = -take;
            }
        }

        @Override
        public void clear() {
            this.value = null;
        }

        @Override
        protected void add(long hash) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void merge(HLLCounter another) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getCountEstimate() {
            return this.value;
        }

        @Override
        public void writeRegisters(ByteBuffer out) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void readRegisters(ByteBuffer in) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.value ^ this.value >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FixedValueHLLCMockup other = (FixedValueHLLCMockup)obj;
            return this.value.equals(other.value);
        }
    }
}

