/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.stats.utils;

import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;

public class DateTimeCheckUtils {
    public static boolean isDate(String value) {
        if (DateTimeCheckUtils.checkDatesPreconditions(value)) {
            return DateTimeCheckUtils.checkDatesPattern(value);
        }
        return false;
    }

    public static boolean isTime(String value) {
        return StringUtils.isNotEmpty(value) && value.length() >= 4 && value.length() <= 24 && DateTimeCheckUtils.checkEnoughDigits(value) && DateTimeCheckUtils.checkDatesPattern(value);
    }

    private static boolean checkDatesPreconditions(String value) {
        return StringUtils.isNotEmpty(value) && value.length() >= 6 && value.length() <= 64 && DateTimeCheckUtils.checkEnoughDigits(value);
    }

    private static boolean checkDatesPattern(String value) {
        return true;
    }

    private static boolean checkEnoughDigits(String value) {
        int digitCount = 0;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch < '0' || ch > '9' || ++digitCount <= 2) continue;
            return true;
        }
        return false;
    }
}

