/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.threadlocal.InternalThreadLocal;
import org.apache.kylin.common.util.ImplementationSwitch;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.IBatchCubingEngine;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.metadata.model.IEngineAware;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.TableDesc;

public class EngineFactory {
    private static InternalThreadLocal<ImplementationSwitch<IBatchCubingEngine>> engines = new InternalThreadLocal();

    public static IBatchCubingEngine batchEngine(IEngineAware aware) {
        ImplementationSwitch<IBatchCubingEngine> current = engines.get();
        if (current == null) {
            current = new ImplementationSwitch<IBatchCubingEngine>(KylinConfig.getInstanceFromEnv().getJobEngines(), IBatchCubingEngine.class);
            engines.set(current);
        }
        return current.get(aware.getEngineType());
    }

    public static IBatchCubingEngine batchEngine() {
        ImplementationSwitch<IBatchCubingEngine> current = engines.get();
        if (current == null) {
            current = new ImplementationSwitch<IBatchCubingEngine>(KylinConfig.getInstanceFromEnv().getJobEngines(), IBatchCubingEngine.class);
            engines.set(current);
        }
        return current.get(6);
    }

    @Deprecated
    public static IJoinedFlatTableDesc getJoinedFlatTableDesc(CubeDesc cubeDesc) {
        return EngineFactory.batchEngine(cubeDesc).getJoinedFlatTableDesc(cubeDesc);
    }

    public static IJoinedFlatTableDesc getJoinedFlatTableDesc(CubeSegment newSegment) {
        return EngineFactory.batchEngine(newSegment).getJoinedFlatTableDesc(newSegment);
    }

    public static DefaultChainedExecutable createBatchCubingJob(CubeSegment newSegment, String submitter) {
        return EngineFactory.createBatchCubingJob(newSegment, submitter, 0);
    }

    public static DefaultChainedExecutable createBatchCubingJob(CubeSegment newSegment, String submitter, Integer priorityOffset) {
        return EngineFactory.batchEngine(newSegment).createBatchCubingJob(newSegment, submitter, priorityOffset);
    }

    public static DefaultChainedExecutable createBatchMergeJob(CubeSegment mergeSegment, String submitter) {
        return EngineFactory.batchEngine(mergeSegment).createBatchMergeJob(mergeSegment, submitter);
    }

    public static DefaultChainedExecutable createBatchOptimizeJob(CubeSegment optimizeSegment, String submitter) {
        return EngineFactory.batchEngine(optimizeSegment).createBatchOptimizeJob(optimizeSegment, submitter);
    }

    public static DefaultChainedExecutable createSampleTableJob(String project, String submitter, long maxSampleCount, TableDesc tableDesc) {
        return EngineFactory.batchEngine().createSampleTableJob(project, submitter, maxSampleCount, tableDesc);
    }
}

