/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.coprocessor.shaded.org.roaringbitmap;

import org.apache.kylin.coprocessor.shaded.org.roaringbitmap.PeekableShortIterator;
import org.apache.kylin.coprocessor.shaded.org.roaringbitmap.Util;

final class BitmapContainerShortIterator
implements PeekableShortIterator {
    long w;
    int x;
    long[] bitmap;

    BitmapContainerShortIterator() {
    }

    BitmapContainerShortIterator(long[] p) {
        this.wrap(p);
    }

    @Override
    public PeekableShortIterator clone() {
        try {
            return (PeekableShortIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.x < this.bitmap.length;
    }

    @Override
    public short next() {
        long t = this.w & -this.w;
        short answer = (short)(this.x * 64 + Long.bitCount(t - 1L));
        this.w ^= t;
        while (this.w == 0L) {
            ++this.x;
            if (this.x == this.bitmap.length) break;
            this.w = this.bitmap[this.x];
        }
        return answer;
    }

    @Override
    public int nextAsInt() {
        long t = this.w & -this.w;
        int answer = this.x * 64 + Long.bitCount(t - 1L);
        this.w ^= t;
        while (this.w == 0L) {
            ++this.x;
            if (this.x == this.bitmap.length) break;
            this.w = this.bitmap[this.x];
        }
        return answer;
    }

    @Override
    public void remove() {
        throw new RuntimeException("unsupported operation: remove");
    }

    public void wrap(long[] b) {
        this.bitmap = b;
        this.x = 0;
        while (this.x < this.bitmap.length && (this.w = this.bitmap[this.x]) == 0L) {
            ++this.x;
        }
    }

    @Override
    public void advanceIfNeeded(short minval) {
        if (Util.toIntUnsigned(minval) >= (this.x + 1) * 64) {
            this.x = Util.toIntUnsigned(minval) / 64;
            this.w = this.bitmap[this.x];
            while (this.w == 0L) {
                ++this.x;
                if (this.x == this.bitmap.length) {
                    return;
                }
                this.w = this.bitmap[this.x];
            }
        }
        while (this.hasNext() && Util.toIntUnsigned(this.peekNext()) < Util.toIntUnsigned(minval)) {
            this.next();
        }
    }

    @Override
    public short peekNext() {
        long t = this.w & -this.w;
        return (short)(this.x * 64 + Long.bitCount(t - 1L));
    }
}

