/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.metrics.metrics2;

import com.codahale.metrics.ObjectNameFactory;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinObjectNameFactory
implements ObjectNameFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(KylinObjectNameFactory.class);

    public ObjectName createName(String type, String domain, String name) {
        try {
            if (name.startsWith(domain)) {
                ObjectName objectName = new ObjectName(name);
                return objectName;
            }
            ObjectName objectName = new ObjectName(domain, "name", name);
            if (objectName.isPattern()) {
                objectName = new ObjectName(domain, "name", ObjectName.quote(name));
            }
            return objectName;
        }
        catch (MalformedObjectNameException e) {
            try {
                return new ObjectName(domain, "name", ObjectName.quote(name));
            }
            catch (MalformedObjectNameException e1) {
                LOGGER.warn("Unable to register {} {}", new Object[]{type, name, e1});
                throw new RuntimeException(e1);
            }
        }
    }

    public ObjectName process(String domain, String name) throws MalformedObjectNameException {
        String[] kvArry = name.split(",");
        Hashtable<String, String> hashTable = new Hashtable<String, String>();
        for (int i = 0; i < kvArry.length; ++i) {
            String[] split = kvArry[i].split("=");
            hashTable.put(split[0], split[1]);
        }
        ObjectName objectName = new ObjectName(domain, hashTable);
        return objectName;
    }
}

