/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.server.rest.controller;

import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.stream.core.model.AssignRequest;
import org.apache.kylin.stream.core.model.ConsumerStatsResponse;
import org.apache.kylin.stream.core.model.PauseConsumersRequest;
import org.apache.kylin.stream.core.model.ResumeConsumerRequest;
import org.apache.kylin.stream.core.model.StartConsumersRequest;
import org.apache.kylin.stream.core.model.StopConsumersRequest;
import org.apache.kylin.stream.core.model.UnAssignRequest;
import org.apache.kylin.stream.core.storage.StreamingSegmentManager;
import org.apache.kylin.stream.server.StreamingServer;
import org.apache.kylin.stream.server.rest.controller.BasicController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admin"})
public class AdminController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(AdminController.class);
    private StreamingServer streamingServer = StreamingServer.getInstance();

    @RequestMapping(value={"/assign"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public void assign(@RequestBody AssignRequest assignRequest) {
        logger.info("receive assign request:{}", (Object)assignRequest);
        this.streamingServer.assign(assignRequest.getCubeName(), assignRequest.getPartitions());
        if (assignRequest.isStartConsumers()) {
            this.streamingServer.startConsumers(Lists.newArrayList(assignRequest.getCubeName()));
        }
    }

    @RequestMapping(value={"/unAssign"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public void unAssign(@RequestBody UnAssignRequest unAssignRequest) {
        logger.info("receive unassign request:{}", (Object)unAssignRequest);
        this.streamingServer.unAssign(unAssignRequest.getCube());
    }

    @RequestMapping(value={"/consumers/start"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public void startConsumers(@RequestBody StartConsumersRequest startRequest) {
        logger.info("receive start consumer request:{}", (Object)startRequest);
        this.streamingServer.startConsumer(startRequest.getCube(), startRequest.getStartProtocol());
    }

    @RequestMapping(value={"/consumers/stop"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ConsumerStatsResponse stopConsumers(@RequestBody StopConsumersRequest request) {
        logger.info("receive stop consumer request:{}", (Object)request);
        ConsumerStatsResponse response = this.streamingServer.stopConsumer(request.getCube());
        if (request.isRemoveData()) {
            this.streamingServer.removeCubeData(request.getCube());
        }
        return response;
    }

    @RequestMapping(value={"/consumers/pause"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ConsumerStatsResponse pauseConsumers(@RequestBody PauseConsumersRequest request) {
        logger.info("receive pause consumer request:{}", (Object)request);
        return this.streamingServer.pauseConsumer(request.getCube());
    }

    @RequestMapping(value={"/consumers/resume"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ConsumerStatsResponse resumeConsumers(@RequestBody ResumeConsumerRequest request) {
        logger.info("receive resume consumer request:{}", (Object)request);
        return this.streamingServer.resumeConsumer(request.getCube(), request.getResumeToPosition());
    }

    @RequestMapping(value={"/segment_build_complete/{cubeName}/{segmentName}"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public void segmentBuildComplete(@PathVariable(value="cubeName") String cubeName, @PathVariable(value="segmentName") String segmentName) {
        logger.info("receive segment build complete, cube:{}, segment:{}", (Object)cubeName, (Object)segmentName);
        this.streamingServer.remoteSegmentBuildComplete(cubeName, segmentName);
    }

    @RequestMapping(value={"/data/{cubeName}/{segmentName}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public void removeSegment(@PathVariable(value="cubeName") String cubeName, @PathVariable(value="segmentName") String segmentName) {
        logger.info("receive remove segment request, cube:{}, segment:{}", (Object)cubeName, (Object)segmentName);
        StreamingSegmentManager segmentManager = this.streamingServer.getStreamingSegmentManager(cubeName);
        segmentManager.purgeSegment(segmentName);
    }

    @RequestMapping(value={"/data/{cubeName}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public void removeCubeData(@PathVariable(value="cubeName") String cubeName) {
        logger.info("receive remove cube request, cube:{}", (Object)cubeName);
        this.streamingServer.removeCubeData(cubeName);
    }

    @RequestMapping(value={"/data/{cubeName}/immutable"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public void immuteCube(@PathVariable(value="cubeName") String cubeName) {
        logger.info("receive make cube immutable request, cube:{}", (Object)cubeName);
        this.streamingServer.makeCubeImmutable(cubeName);
    }

    @RequestMapping(value={"/data/{cubeName}/{segmentName}/immutable"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public void immuteCubeSegment(@PathVariable(value="cubeName") String cubeName, @PathVariable(value="segmentName") String segmentName) {
        logger.info("receive make cube segment immutable request, cube:{} segment:{}", (Object)cubeName, (Object)segmentName);
        this.streamingServer.makeCubeSegmentImmutable(cubeName, segmentName);
    }

    @RequestMapping(value={"/data/{cubeName}/{segmentName}/reSubmit"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public void reSubmitCubeSegment(@PathVariable(value="cubeName") String cubeName, @PathVariable(value="segmentName") String segmentName) {
        logger.info("receive reSubmit segment request, cube:{} segment:{}", (Object)cubeName, (Object)segmentName);
        this.streamingServer.reSubmitCubeSegment(cubeName, segmentName);
    }

    @RequestMapping(value={"/replica_set/{rsID}/add"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public void addToReplicaSet(@PathVariable(value="rsID") int replicaSetID) {
        logger.info("receive add to replica set request, rsID:{}", (Object)replicaSetID);
        this.streamingServer.addToReplicaSet(replicaSetID);
    }

    @RequestMapping(value={"/replica_set/remove"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public void removeFromReplicaSet() {
        logger.info("receive remove from replica set request");
        this.streamingServer.removeFromReplicaSet();
    }
}

