/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.kylin.common.KylinConfig;

public class HDFSUtil {
    private static final ThreadLocal<Configuration> hadoopConfig = new ThreadLocal();

    public static FileSystem getFileSystemForPath(String path) throws IOException {
        return FileSystem.get((URI)HDFSUtil.makeURI(path), (Configuration)HDFSUtil.getCurrentConfiguration());
    }

    private static URI makeURI(String filePath) {
        try {
            return new URI(HDFSUtil.fixWindowsPath(filePath));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot create FileSystem from URI: " + filePath, e);
        }
    }

    private static String fixWindowsPath(String path) {
        if (path.startsWith("file://") && !path.startsWith("file:///") && path.contains(":\\")) {
            path = path.replace("file://", "file:///");
        }
        if (path.startsWith("file:///")) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    public static Configuration getCurrentConfiguration() {
        if (hadoopConfig.get() == null) {
            Configuration conf = HDFSUtil.healSickConfig(new Configuration());
            return conf;
        }
        return hadoopConfig.get();
    }

    private static Configuration healSickConfig(Configuration conf) {
        conf.set("dfs.client.block.write.locateFollowingBlock.retries", "8");
        if (StringUtils.isBlank((String)conf.get("hadoop.tmp.dir"))) {
            conf.set("hadoop.tmp.dir", "/tmp");
        }
        if (StringUtils.isBlank((String)conf.get("hbase.fs.tmp.dir"))) {
            conf.set("hbase.fs.tmp.dir", "/tmp");
        }
        return conf;
    }

    public static String getStreamingSegmentFilePath(String cubeName, String segmentName) {
        return HDFSUtil.getStreamingCubeFilePath(cubeName) + "/" + segmentName;
    }

    public static String getStreamingCubeFilePath(String cubeName) {
        return KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory() + "stream/" + cubeName;
    }
}

