/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar.compress;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataReader;

public class FSInputLZ4CompressedColumnReader
implements ColumnDataReader {
    private int rowCount;
    private int valLen;
    private int numValInBlock;
    private int maxDecompressedLength;
    private int currBlockNum;
    private LZ4SafeDecompressor deCompressor;
    private FSDataInputStream fsInputStream;

    public FSInputLZ4CompressedColumnReader(FileSystem fs, Path file, int columnDataStartOffset, int columnDataLength, int rowCount) throws IOException {
        this.rowCount = rowCount;
        this.fsInputStream = fs.open(file);
        int footStartOffset = columnDataStartOffset + columnDataLength - 8;
        this.fsInputStream.seek((long)footStartOffset);
        this.numValInBlock = this.fsInputStream.readInt();
        this.valLen = this.fsInputStream.readInt();
        this.fsInputStream.seek((long)columnDataStartOffset);
        this.currBlockNum = -1;
        this.deCompressor = LZ4Factory.fastestInstance().safeDecompressor();
        this.maxDecompressedLength = this.numValInBlock * this.valLen;
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new LZ4CompressedColumnDataItr();
    }

    @Override
    public byte[] read(int rowNum) {
        throw new UnsupportedOperationException("not support to read row operation");
    }

    @Override
    public void close() throws IOException {
        this.fsInputStream.close();
    }

    private class LZ4CompressedColumnDataItr
    implements Iterator<byte[]> {
        private int readRowCount = 0;
        private ByteBuffer decompressedBuffer;
        private byte[] decompressedBytes;

        public LZ4CompressedColumnDataItr() {
            this.decompressedBytes = new byte[FSInputLZ4CompressedColumnReader.this.maxDecompressedLength];
        }

        @Override
        public boolean hasNext() {
            return this.readRowCount < FSInputLZ4CompressedColumnReader.this.rowCount;
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (FSInputLZ4CompressedColumnReader.this.currBlockNum == -1 || !this.decompressedBuffer.hasRemaining()) {
                try {
                    this.loadNextBuffer();
                }
                catch (IOException e) {
                    throw new NoSuchElementException("error when read data " + e.getMessage());
                }
            }
            byte[] readBuffer = new byte[FSInputLZ4CompressedColumnReader.this.valLen];
            this.decompressedBuffer.get(readBuffer);
            ++this.readRowCount;
            return readBuffer;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("not supported");
        }

        private void loadNextBuffer() throws IOException {
            int len = FSInputLZ4CompressedColumnReader.this.fsInputStream.readInt();
            byte[] bytes = new byte[len];
            FSInputLZ4CompressedColumnReader.this.fsInputStream.readFully(bytes);
            int decompressedSize = FSInputLZ4CompressedColumnReader.this.deCompressor.decompress(bytes, this.decompressedBytes);
            this.decompressedBuffer = ByteBuffer.wrap(this.decompressedBytes, 0, decompressedSize);
            FSInputLZ4CompressedColumnReader.this.currBlockNum++;
        }
    }
}

