/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.query;

import java.util.Set;
import java.util.TreeSet;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.stream.core.query.ResponseResultSchema;
import org.apache.kylin.stream.core.query.StreamingDataQueryPlanner;

public class StreamingSearchContext {
    private CubeDesc cubeDesc;
    private TupleFilter filter;
    private Set<TblColRef> dimensions;
    private Set<TblColRef> groups;
    private TupleFilter havingFilter;
    private Set<FunctionDesc> metrics;
    private Set<TblColRef> addedGroups;
    private ResponseResultSchema respResultSchema;
    private StreamingDataQueryPlanner queryPlanner;
    private long hitCuboid;
    private long basicCuboid;
    private long deadline = Long.MAX_VALUE;

    public StreamingSearchContext(CubeDesc cubeDesc, Set<TblColRef> dimensions, Set<TblColRef> groups, Set<FunctionDesc> metrics, TupleFilter filter, TupleFilter havingFilter) {
        this.cubeDesc = cubeDesc;
        this.dimensions = dimensions;
        this.groups = groups;
        this.metrics = metrics;
        this.filter = filter;
        this.havingFilter = havingFilter;
        this.respResultSchema = new ResponseResultSchema(cubeDesc, dimensions, metrics);
        this.queryPlanner = new StreamingDataQueryPlanner(cubeDesc, filter);
        this.addedGroups = Sets.newHashSet();
        this.calculateHitCuboid();
    }

    public TupleFilter getFilter() {
        return this.filter;
    }

    public Set<TblColRef> getGroups() {
        return this.groups;
    }

    public void addNewGroups(Set<TblColRef> newGroups) {
        this.addedGroups.addAll(newGroups);
    }

    public Set<TblColRef> getAllGroups() {
        if (this.addedGroups.isEmpty()) {
            return this.groups;
        }
        return Sets.union(this.groups, this.addedGroups);
    }

    public Set<FunctionDesc> getMetrics() {
        return this.metrics;
    }

    public Set<TblColRef> getDimensions() {
        return this.dimensions;
    }

    public ResponseResultSchema getRespResultSchema() {
        return this.respResultSchema;
    }

    public TupleFilter getHavingFilter() {
        return this.havingFilter;
    }

    public void setRespResultSchema(ResponseResultSchema respResultSchema) {
        this.respResultSchema = respResultSchema;
    }

    public CubeDesc getCubeDesc() {
        return this.cubeDesc;
    }

    public long getHitCuboid() {
        return this.hitCuboid;
    }

    public void setHitCuboid(long hitCuboid) {
        this.hitCuboid = hitCuboid;
    }

    public void setBasicCuboid(long basicCuboid) {
        this.basicCuboid = basicCuboid;
    }

    public boolean hitBasicCuboid() {
        return this.hitCuboid == this.basicCuboid;
    }

    public StreamingDataQueryPlanner getQueryPlanner() {
        return this.queryPlanner;
    }

    public void setQueryPlanner(StreamingDataQueryPlanner queryPlanner) {
        this.queryPlanner = queryPlanner;
    }

    private void calculateHitCuboid() {
        long basicCuboid = Cuboid.getBaseCuboidId(this.cubeDesc);
        this.setBasicCuboid(basicCuboid);
        if (!this.cubeDesc.getConfig().isStreamingBuildAdditionalCuboids()) {
            this.setHitCuboid(basicCuboid);
            return;
        }
        long targetCuboidID = this.identifyCuboid(this.dimensions);
        Set<Long> mandatoryCuboids = this.getMandatoryCuboids();
        for (long cuboidID : mandatoryCuboids) {
            if ((targetCuboidID & (cuboidID ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) continue;
            this.setHitCuboid(cuboidID);
            return;
        }
        this.setHitCuboid(basicCuboid);
    }

    private long identifyCuboid(Set<TblColRef> dimensions) {
        long cuboidID = 0L;
        for (TblColRef column : dimensions) {
            int index = this.cubeDesc.getRowkey().getColumnBitIndex(column);
            cuboidID |= 1L << index;
        }
        return cuboidID;
    }

    private Set<Long> getMandatoryCuboids() {
        TreeSet<Long> sortedSet = Sets.newTreeSet(Cuboid.cuboidSelectComparator);
        sortedSet.addAll(this.cubeDesc.getMandatoryCuboids());
        return sortedSet;
    }

    long getDeadline() {
        return this.deadline;
    }

    public void setDeadline(long deadline) {
        this.deadline = deadline;
    }
}

