/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.query;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kylin.gridtable.StorageSideBehavior;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class StreamingQueryProfile {
    private static ThreadLocal<StreamingQueryProfile> threadProfile = new ThreadLocal();
    private String queryId;
    private boolean enableDetailProfile;
    private long queryStartTime;
    private long requestSendTime;
    private int totalScanFiles = 0;
    private long totalScanFileSize = 0L;
    private AtomicLong scanRows = new AtomicLong(0L);
    private AtomicLong filterRows = new AtomicLong(0L);
    private long finalRows;
    private StorageSideBehavior storageBehavior = StorageSideBehavior.SCAN_FILTER_AGGR_CHECKMEM;
    private List<String> includeSegments;
    private List<String> skippedSegments;
    private List<ProfileStep> profileSteps;
    private Map<String, ProfileStep> stepMap;

    public StreamingQueryProfile(String queryId, long requestSendTime) {
        this.queryId = queryId;
        this.includeSegments = Lists.newArrayList();
        this.skippedSegments = Lists.newArrayList();
        this.profileSteps = Lists.newArrayList();
        this.stepMap = Maps.newHashMap();
        this.requestSendTime = requestSendTime;
        this.queryStartTime = System.currentTimeMillis();
    }

    public static StreamingQueryProfile get() {
        return threadProfile.get();
    }

    public static void set(StreamingQueryProfile profile) {
        threadProfile.set(profile);
    }

    public boolean isDetailProfileEnable() {
        return this.enableDetailProfile;
    }

    public void enableDetailProfile() {
        this.enableDetailProfile = true;
    }

    public void includeSegment(String segmentName) {
        this.includeSegments.add(segmentName);
    }

    public void skipSegment(String segmentName) {
        this.skippedSegments.add(segmentName);
    }

    public void incScanFile(int fileSize) {
        ++this.totalScanFiles;
        this.totalScanFileSize += (long)fileSize;
    }

    public ProfileStep startStep(String stepName) {
        long startTime = System.currentTimeMillis();
        ProfileStep step = new ProfileStep(stepName, startTime);
        this.profileSteps.add(step);
        this.stepMap.put(stepName, step);
        return step;
    }

    public ProfileStep finishStep(String stepName) {
        ProfileStep step = this.stepMap.get(stepName);
        if (step != null) {
            step.duration = System.currentTimeMillis() - step.startTime;
        }
        return step;
    }

    public void addStepInfo(String stepName, String key, String val) {
        ProfileStep step = this.stepMap.get(stepName);
        if (step != null) {
            step.stepInfo(key, val);
        }
    }

    public String getQueryId() {
        return this.queryId;
    }

    public void incScanRows(long n) {
        this.scanRows.addAndGet(n);
    }

    public void incFilterRows(long n) {
        this.filterRows.addAndGet(n);
    }

    public void setFinalRows(long n) {
        this.finalRows = n;
    }

    public StorageSideBehavior getStorageBehavior() {
        return this.storageBehavior;
    }

    public void setStorageBehavior(StorageSideBehavior storageBehavior) {
        this.storageBehavior = storageBehavior;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println();
        pw.println("start:          " + (this.queryStartTime - this.requestSendTime));
        pw.println("segments num:   " + this.includeSegments.size());
        pw.println("segments:       " + this.includeSegments);
        pw.println("skip segments:  " + this.skippedSegments);
        pw.println("total files:    " + this.totalScanFiles);
        pw.println("total file size:" + this.totalScanFileSize);
        pw.println("scan rows:      " + this.scanRows);
        pw.println("filter rows:    " + this.filterRows);
        pw.println("final rows:      " + this.finalRows);
        pw.println();
        if (this.enableDetailProfile) {
            pw.println("details:");
            for (ProfileStep profileStep : this.profileSteps) {
                pw.println("  " + profileStep.toString());
            }
        }
        return sw.toString();
    }

    public class ProfileStep {
        String name;
        Map<String, String> properties;
        long startTime;
        long duration;

        ProfileStep(String name, long startTime) {
            this.name = name;
            this.properties = Maps.newHashMap();
            this.startTime = startTime;
        }

        public ProfileStep stepInfo(String key, String val) {
            this.properties.put(key, val);
            return this;
        }

        public long getDuration() {
            return this.duration;
        }

        public String toString() {
            String start = String.valueOf(this.startTime - StreamingQueryProfile.this.queryStartTime);
            StringBuilder builder = new StringBuilder();
            builder.append(start);
            builder.append("    ");
            builder.append(this.name);
            if (!this.properties.isEmpty()) {
                builder.append(this.properties.toString());
            }
            builder.append("    ");
            builder.append(this.duration);
            builder.append("ms");
            return builder.toString();
        }
    }
}

