/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.tools.DistCp;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HFileDistcpJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(HFileDistcpJob.class);

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_HTABLE_NAME);
            this.parseOptions(options, args);
            Configuration configuration = new Configuration();
            HBaseConnection.addHBaseClusterNNHAConfiguration(configuration);
            Path input = new Path(this.getOptionValue(OPTION_INPUT_PATH));
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            FileSystem fs = HadoopUtil.getFileSystem(output, configuration);
            if (!fs.exists(output)) {
                fs.mkdirs(output);
            }
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME);
            CubeManager cubeMgr = CubeManager.getInstance(KylinConfig.getInstanceFromEnv());
            CubeInstance cube = cubeMgr.getCube(cubeName);
            ArrayList<Path> sourceList = Lists.newArrayList();
            sourceList.add(input);
            DistCpOptions distCpOptions = new DistCpOptions(sourceList, output);
            distCpOptions.setMapBandwidth(cube.getConfig().getDistCPMapBandWidth());
            distCpOptions.setMaxMaps(cube.getConfig().getDistCPMaxMapNum());
            distCpOptions.setOverwrite(true);
            distCpOptions.setBlocking(true);
            configuration.set("mapreduce.job.name", this.getOptionValue(OPTION_JOB_NAME));
            DistCp distCp = new DistCp(configuration, distCpOptions);
            this.job = distCp.execute();
            this.job.getConfiguration().set("cube.name", cubeName);
            this.attachCubeMetadata(cube, this.job.getConfiguration());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new HFileDistcpJob(), (String[])args);
        System.exit(exitCode);
    }
}

