/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v2;

import org.apache.kylin.cache.memcached.CacheStats;
import org.apache.kylin.cache.memcached.MemcachedCache;
import org.apache.kylin.cache.memcached.MemcachedCacheConfig;
import org.apache.kylin.cache.memcached.MemcachedChunkingCache;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.job.shaded.org.apache.commons.lang3.SerializationUtils;
import org.apache.kylin.storage.hbase.cube.v2.SegmentQueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentQueryCache {
    public static final Logger logger = LoggerFactory.getLogger(SegmentQueryCache.class);
    private static final String SEG_QUERY_CACHE_NAME = "query_segment_cache";
    private static SegmentQueryCache segmentQueryCacheInstance = new SegmentQueryCache();
    private MemcachedChunkingCache memcachedCache;

    public static SegmentQueryCache getInstance() {
        return segmentQueryCacheInstance;
    }

    private SegmentQueryCache() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        MemcachedCacheConfig memcachedCacheConfig = new MemcachedCacheConfig();
        String configHosts = kylinConfig.getMemCachedHosts();
        memcachedCacheConfig.setTimeout(kylinConfig.getQuerySegmentCacheTimeout());
        memcachedCacheConfig.setMaxObjectSize(1000000);
        memcachedCacheConfig.setHosts(configHosts);
        memcachedCacheConfig.setEnableCompression(!kylinConfig.getCompressionResult());
        String cacheName = SEG_QUERY_CACHE_NAME;
        this.memcachedCache = new MemcachedChunkingCache(MemcachedCache.create(memcachedCacheConfig, cacheName));
    }

    public void put(String key, SegmentQueryResult segmentQueryResult) {
        this.memcachedCache.put(key, (Object)segmentQueryResult);
    }

    public SegmentQueryResult get(String key) {
        byte[] value = this.memcachedCache.get(key);
        if (value == null) {
            return null;
        }
        return (SegmentQueryResult)SerializationUtils.deserialize(value);
    }

    public CacheStats getCacheStats() {
        return this.memcachedCache.getStats();
    }

    public void evict(String segmentQueryKey) {
        this.memcachedCache.evict(segmentQueryKey);
    }
}

