/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.TreeMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.SourceDialect;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.hive.DBConnConf;
import org.apache.kylin.source.jdbc.JdbcHiveInputBase;
import org.apache.kylin.source.jdbc.SqlUtil;
import org.apache.kylin.source.jdbc.metadata.IJdbcMetadata;
import org.apache.kylin.source.jdbc.metadata.JdbcMetadataFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTableReader
implements IReadableTable.TableReader {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTableReader.class);
    private String dbName;
    private String tableName;
    private DBConnConf dbconf;
    private Connection jdbcCon;
    private Statement statement;
    private ResultSet rs;
    private int colCount;

    public JdbcTableReader(String dbName, String tableName) throws IOException {
        this.dbName = dbName;
        this.tableName = tableName;
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String connectionUrl = config.getJdbcSourceConnectionUrl();
        String driverClass = config.getJdbcSourceDriver();
        String jdbcUser = config.getJdbcSourceUser();
        String jdbcPass = config.getJdbcSourcePass();
        this.dbconf = new DBConnConf(driverClass, connectionUrl, jdbcUser, jdbcPass);
        this.jdbcCon = SqlUtil.getConnection(this.dbconf);
        IJdbcMetadata meta = JdbcMetadataFactory.getJdbcMetadata(SourceDialect.getDialect(config.getJdbcSourceDialect()), this.dbconf);
        TreeMap<String, String> metadataCache = new TreeMap<String, String>();
        JdbcHiveInputBase.JdbcBaseBatchCubingInputSide.calCachedJdbcMeta(metadataCache, this.dbconf, meta);
        String database = JdbcHiveInputBase.getSchemaQuoted(metadataCache, dbName, meta, true);
        String table = JdbcHiveInputBase.getTableIdentityQuoted(dbName, tableName, metadataCache, meta, true);
        String sql = String.format(Locale.ROOT, "select * from %s.%s", database, table);
        try {
            this.statement = this.jdbcCon.createStatement();
            this.rs = this.statement.executeQuery(sql);
            this.colCount = this.rs.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw new IOException(String.format(Locale.ROOT, "error while exec %s", sql), e);
        }
    }

    @Override
    public boolean next() throws IOException {
        try {
            return this.rs.next();
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String[] getRow() {
        String[] ret = new String[this.colCount];
        for (int i = 1; i <= this.colCount; ++i) {
            try {
                Object o = this.rs.getObject(i);
                String result = null == o || o instanceof byte[] ? null : o.toString();
                ret[i - 1] = result;
                continue;
            }
            catch (Exception e) {
                logger.error("", e);
            }
        }
        return ret;
    }

    @Override
    public void close() throws IOException {
        SqlUtil.closeResources(this.jdbcCon, this.statement);
    }

    public String toString() {
        return "jdbc table reader for: " + this.dbName + "." + this.tableName;
    }
}

