/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter.function;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.common.threadlocal.InternalThreadLocal;
import org.apache.kylin.job.shaded.org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.kylin.metadata.filter.function.LikeMatchers;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableMap;

public enum BuiltInMethod {
    UPPER(BuiltInMethod.class, "upper", String.class),
    LOWER(BuiltInMethod.class, "lower", String.class),
    SUBSTRING(BuiltInMethod.class, "substring", String.class, Integer.TYPE, Integer.TYPE),
    CHAR_LENGTH(BuiltInMethod.class, "charLength", String.class),
    LIKE(BuiltInMethod.class, "like", String.class, String.class),
    INITCAP(BuiltInMethod.class, "initcap", String.class),
    CONCAT(BuiltInMethod.class, "concat", String.class, String.class);

    public final Method method;
    public static final ImmutableMap<String, BuiltInMethod> MAP;
    private static InternalThreadLocal<Map<String, LikeMatchers.LikeMatcher>> likePatterns;

    private BuiltInMethod(Class<?> clazz, String methodName, Class<?> ... argumentTypes) {
        this.method = MethodUtils.getMatchingAccessibleMethod(clazz, methodName, argumentTypes);
    }

    public static boolean like(String s, String patternStr) {
        if (s == null || patternStr == null) {
            return false;
        }
        Map<String, LikeMatchers.LikeMatcher> patterns = likePatterns.get();
        LikeMatchers.LikeMatcher p = patterns.get(patternStr);
        if (p == null) {
            p = LikeMatchers.createMatcher(patternStr);
            if (patterns.size() > 100) {
                patterns.clear();
            }
            patterns.put(patternStr, p);
        }
        return p.matches(s);
    }

    public static String initcap(String s) {
        int len = s.length();
        boolean start = true;
        StringBuilder newS = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char curCh;
            char c = curCh = s.charAt(i);
            if (start) {
                if (c > '/' && c < ':') {
                    start = false;
                } else if (c > '@' && c < '[') {
                    start = false;
                } else if (c > '`' && c < '{') {
                    start = false;
                    curCh = (char)(c - 32);
                }
            } else if (c <= '/' || c >= ':') {
                if (c > '@' && c < '[') {
                    curCh = (char)(c + 32);
                } else if (c <= '`' || c >= '{') {
                    start = true;
                }
            }
            newS.append(curCh);
        }
        return newS.toString();
    }

    public static int charLength(String s) {
        return s.length();
    }

    public static String substring(String s, int from, int for_) {
        if (s == null) {
            return null;
        }
        return s.substring(from - 1, Math.min(from - 1 + for_, s.length()));
    }

    public static String upper(String s) {
        if (s == null) {
            return null;
        }
        return s.toUpperCase(Locale.ROOT);
    }

    public static String lower(String s) {
        if (s == null) {
            return null;
        }
        return s.toLowerCase(Locale.ROOT);
    }

    public static String concat(String left, String right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return left.concat(right);
    }

    static {
        likePatterns = new InternalThreadLocal<Map<String, LikeMatchers.LikeMatcher>>(){

            @Override
            public Map<String, LikeMatchers.LikeMatcher> initialValue() {
                return new HashMap<String, LikeMatchers.LikeMatcher>();
            }
        };
        ImmutableMap.Builder<String, BuiltInMethod> builder = ImmutableMap.builder();
        for (BuiltInMethod value : BuiltInMethod.values()) {
            if (value.method == null) continue;
            builder.put(value.name(), value);
        }
        MAP = builder.build();
    }
}

