/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.shaded.org.roaringbitmap.buffer;

import org.apache.kylin.job.shaded.org.roaringbitmap.PeekableShortIterator;
import org.apache.kylin.job.shaded.org.roaringbitmap.buffer.BufferUtil;
import org.apache.kylin.job.shaded.org.roaringbitmap.buffer.MappeableBitmapContainer;

final class MappeableBitmapContainerShortIterator
implements PeekableShortIterator {
    static final int len = 1024;
    long w;
    int x;
    MappeableBitmapContainer parent;

    MappeableBitmapContainerShortIterator() {
    }

    MappeableBitmapContainerShortIterator(MappeableBitmapContainer p) {
        this.wrap(p);
    }

    @Override
    public PeekableShortIterator clone() {
        try {
            return (PeekableShortIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.x < 1024;
    }

    @Override
    public short next() {
        long t = this.w & -this.w;
        short answer = (short)(this.x * 64 + Long.bitCount(t - 1L));
        this.w ^= t;
        while (this.w == 0L) {
            ++this.x;
            if (this.x == 1024) break;
            this.w = this.parent.bitmap.get(this.x);
        }
        return answer;
    }

    @Override
    public int nextAsInt() {
        long t = this.w & -this.w;
        int answer = this.x * 64 + Long.bitCount(t - 1L);
        this.w ^= t;
        while (this.w == 0L) {
            ++this.x;
            if (this.x == 1024) break;
            this.w = this.parent.bitmap.get(this.x);
        }
        return answer;
    }

    @Override
    public void remove() {
        throw new RuntimeException("unsupported operation: remove");
    }

    void wrap(MappeableBitmapContainer p) {
        this.parent = p;
        this.x = 0;
        while (this.x < 1024 && (this.w = this.parent.bitmap.get(this.x)) == 0L) {
            ++this.x;
        }
    }

    @Override
    public void advanceIfNeeded(short minval) {
        if (BufferUtil.toIntUnsigned(minval) >= (this.x + 1) * 64) {
            this.x = BufferUtil.toIntUnsigned(minval) / 64;
            this.w = this.parent.bitmap.get(this.x);
            while (this.w == 0L) {
                ++this.x;
                if (this.x == 1024) {
                    return;
                }
                this.w = this.parent.bitmap.get(this.x);
            }
        }
        while (this.hasNext() && BufferUtil.toIntUnsigned(this.peekNext()) < BufferUtil.toIntUnsigned(minval)) {
            this.next();
        }
    }

    @Override
    public short peekNext() {
        long t = this.w & -this.w;
        return (short)(this.x * 64 + Long.bitCount(t - 1L));
    }
}

