/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.shaded.org.roaringbitmap;

import org.apache.kylin.job.shaded.org.roaringbitmap.PeekableShortIterator;
import org.apache.kylin.job.shaded.org.roaringbitmap.RunContainer;
import org.apache.kylin.job.shaded.org.roaringbitmap.Util;

final class RunContainerShortIterator
implements PeekableShortIterator {
    int pos;
    int le = 0;
    int maxlength;
    int base;
    RunContainer parent;

    RunContainerShortIterator() {
    }

    RunContainerShortIterator(RunContainer p) {
        this.wrap(p);
    }

    @Override
    public PeekableShortIterator clone() {
        try {
            return (PeekableShortIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.parent.nbrruns;
    }

    @Override
    public short next() {
        short ans = (short)(this.base + this.le);
        ++this.le;
        if (this.le > this.maxlength) {
            ++this.pos;
            this.le = 0;
            if (this.pos < this.parent.nbrruns) {
                this.maxlength = Util.toIntUnsigned(this.parent.getLength(this.pos));
                this.base = Util.toIntUnsigned(this.parent.getValue(this.pos));
            }
        }
        return ans;
    }

    @Override
    public int nextAsInt() {
        int ans = this.base + this.le;
        ++this.le;
        if (this.le > this.maxlength) {
            ++this.pos;
            this.le = 0;
            if (this.pos < this.parent.nbrruns) {
                this.maxlength = Util.toIntUnsigned(this.parent.getLength(this.pos));
                this.base = Util.toIntUnsigned(this.parent.getValue(this.pos));
            }
        }
        return ans;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    void wrap(RunContainer p) {
        this.parent = p;
        this.pos = 0;
        this.le = 0;
        if (this.pos < this.parent.nbrruns) {
            this.maxlength = Util.toIntUnsigned(this.parent.getLength(this.pos));
            this.base = Util.toIntUnsigned(this.parent.getValue(this.pos));
        }
    }

    @Override
    public void advanceIfNeeded(short minval) {
        while (this.base + this.maxlength < Util.toIntUnsigned(minval)) {
            ++this.pos;
            this.le = 0;
            if (this.pos < this.parent.nbrruns) {
                this.maxlength = Util.toIntUnsigned(this.parent.getLength(this.pos));
                this.base = Util.toIntUnsigned(this.parent.getValue(this.pos));
                continue;
            }
            return;
        }
        if (this.base > Util.toIntUnsigned(minval)) {
            return;
        }
        this.le = Util.toIntUnsigned(minval) - this.base;
    }

    @Override
    public short peekNext() {
        return (short)(this.base + this.le);
    }
}

