/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.impl.threadpool;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.lock.DistributedLock;
import org.apache.kylin.common.util.ServerMode;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.common.util.ToolUtil;
import org.apache.kylin.job.Scheduler;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.exception.PersistentException;
import org.apache.kylin.job.exception.SchedulerException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.Output;
import org.apache.kylin.job.impl.threadpool.DefaultContext;
import org.apache.kylin.job.impl.threadpool.DefaultFetcherRunner;
import org.apache.kylin.job.impl.threadpool.FetcherRunner;
import org.apache.kylin.job.impl.threadpool.IJobRunner;
import org.apache.kylin.job.impl.threadpool.JobExecutor;
import org.apache.kylin.job.impl.threadpool.PriorityFetcherRunner;
import org.apache.kylin.job.lock.JobLock;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedScheduler
implements Scheduler<AbstractExecutable> {
    public static final String ZOOKEEPER_LOCK_PATH = "/job_engine/lock";
    private static final Logger logger = LoggerFactory.getLogger(DistributedScheduler.class);
    private final Set<String> jobWithLocks = new CopyOnWriteArraySet<String>();
    private ExecutableManager executableManager;
    private FetcherRunner fetcher;
    private ScheduledExecutorService fetcherPool;
    private ExecutorService watchPool;
    private ExecutorService jobPool;
    private DefaultContext context;
    private DistributedLock jobLock;
    private Closeable lockWatch;
    private volatile boolean initialized = false;
    private volatile boolean hasStarted = false;
    private JobEngineConfig jobEngineConfig;
    private String serverName;

    public static DistributedScheduler getInstance(KylinConfig config) {
        return config.getManager(DistributedScheduler.class);
    }

    static DistributedScheduler newInstance(KylinConfig config) throws IOException {
        return new DistributedScheduler();
    }

    public static String getLockPath(String pathName) {
        return DistributedScheduler.dropDoubleSlash("/job_engine/lock/" + pathName);
    }

    private static String getWatchPath() {
        return DistributedScheduler.dropDoubleSlash(ZOOKEEPER_LOCK_PATH);
    }

    public static String dropDoubleSlash(String path) {
        int n = Integer.MAX_VALUE;
        while (n > path.length()) {
            n = path.length();
            path = path.replace("//", "/");
        }
        return path;
    }

    @Override
    public synchronized void init(JobEngineConfig jobEngineConfig, JobLock jobLock) throws SchedulerException {
        if (!ServerMode.SERVER_MODE.canServeJobBuild()) {
            logger.info("server mode: " + jobEngineConfig.getConfig().getServerMode() + ", no need to run job scheduler");
            return;
        }
        logger.info("Initializing Job Engine ....");
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.jobEngineConfig = jobEngineConfig;
        this.jobLock = (DistributedLock)((Object)jobLock);
        this.serverName = this.jobLock.getClient();
        this.executableManager = ExecutableManager.getInstance(jobEngineConfig.getConfig());
        this.fetcherPool = Executors.newScheduledThreadPool(1);
        this.watchPool = Executors.newFixedThreadPool(1);
        WatcherProcessImpl watcherProcess = new WatcherProcessImpl(this.serverName);
        this.lockWatch = this.jobLock.watchLocks(DistributedScheduler.getWatchPath(), this.watchPool, watcherProcess);
        int corePoolSize = jobEngineConfig.getMaxConcurrentJobLimit();
        this.jobPool = new ThreadPoolExecutor(corePoolSize, corePoolSize, Long.MAX_VALUE, TimeUnit.DAYS, new SynchronousQueue<Runnable>());
        this.context = new DefaultContext(Maps.newConcurrentMap(), jobEngineConfig.getConfig());
        int pollSecond = jobEngineConfig.getPollIntervalSecond();
        logger.info("Fetching jobs every {} seconds", (Object)pollSecond);
        JobExecutor jobExecutor = new JobExecutor(){

            @Override
            public void execute(AbstractExecutable executable) {
                DistributedScheduler.this.jobPool.execute(new JobRunner(executable));
            }
        };
        this.fetcher = jobEngineConfig.getJobPriorityConsidered() ? new PriorityFetcherRunner(jobEngineConfig, this.context, jobExecutor) : new DefaultFetcherRunner(jobEngineConfig, this.context, jobExecutor);
        this.fetcherPool.scheduleAtFixedRate(this.fetcher, pollSecond / 10, pollSecond, TimeUnit.SECONDS);
        this.hasStarted = true;
        this.resumeAllRunningJobs();
    }

    private void resumeAllRunningJobs() {
        for (String id : this.executableManager.getAllJobIds()) {
            Output output = this.executableManager.getOutput(id);
            AbstractExecutable executable = this.executableManager.getJob(id);
            if (output.getState() != ExecutableState.RUNNING || !(executable instanceof DefaultChainedExecutable)) continue;
            try {
                if (this.jobLock.isLocked(DistributedScheduler.getLockPath(executable.getId()))) continue;
                this.executableManager.resumeRunningJobForce(executable.getId());
                this.fetcherPool.schedule(this.fetcher, 0L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                logger.error("resume the job " + id + " fail in server: " + this.serverName, e);
            }
        }
    }

    @Override
    public void shutdown() throws SchedulerException {
        logger.info("Will shut down Job Engine ....");
        try {
            this.lockWatch.close();
        }
        catch (IOException e) {
            throw new SchedulerException(e);
        }
        this.releaseAllLocks();
        logger.info("The all locks has released");
        this.fetcherPool.shutdown();
        logger.info("The fetcherPool has down");
        this.jobPool.shutdown();
        logger.info("The jobPoll has down");
    }

    private void releaseAllLocks() {
        for (String jobId : this.jobWithLocks) {
            this.jobLock.unlock(DistributedScheduler.getLockPath(jobId));
        }
    }

    @Override
    public boolean hasStarted() {
        return this.hasStarted;
    }

    private class WatcherProcessImpl
    implements DistributedLock.Watcher {
        private String serverName;

        public WatcherProcessImpl(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public void onUnlock(String path, String nodeData) {
            AbstractExecutable executable;
            String[] paths = StringUtil.split(path, "/");
            String jobId = paths[paths.length - 1];
            try {
                DistributedScheduler.this.executableManager.syncDigestsOfJob(jobId);
            }
            catch (PersistentException e) {
                logger.error("Failed to sync cache of job: " + jobId + ", at server: " + this.serverName);
            }
            Output output = DistributedScheduler.this.executableManager.getOutput(jobId);
            if (output.getState() == ExecutableState.RUNNING && (executable = DistributedScheduler.this.executableManager.getJob(jobId)) instanceof DefaultChainedExecutable && !nodeData.equalsIgnoreCase(this.serverName)) {
                try {
                    logger.warn(nodeData + " has released the lock for: " + jobId + " but the job still running. so " + this.serverName + " resume the job");
                    if (!DistributedScheduler.this.jobLock.isLocked(DistributedScheduler.getLockPath(jobId))) {
                        DistributedScheduler.this.executableManager.resumeRunningJobForce(executable.getId());
                        DistributedScheduler.this.fetcherPool.schedule(DistributedScheduler.this.fetcher, 0L, TimeUnit.SECONDS);
                    }
                }
                catch (Exception e) {
                    logger.error("resume the job but fail in server: " + this.serverName, e);
                }
            }
        }

        @Override
        public void onLock(String lockPath, String client) {
        }
    }

    private class JobRunner
    implements IJobRunner {
        private final AbstractExecutable executable;

        public JobRunner(AbstractExecutable executable) {
            this.executable = executable;
        }

        @Override
        public boolean acquireJobLock() {
            return DistributedScheduler.this.jobLock.lock(DistributedScheduler.getLockPath(this.executable.getId()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (SetThreadName ignored = new SetThreadName("Scheduler %s Job %s", System.identityHashCode(DistributedScheduler.this), this.executable.getId());){
                boolean isAssigned = true;
                if (!StringUtils.isEmpty((String)this.executable.getCubeName())) {
                    KylinConfig config = this.executable.getCubeSpecificConfig();
                    isAssigned = config.isOnAssignedServer(ToolUtil.getHostName(), ToolUtil.getFirstIPV4NonLoopBackAddress().getHostAddress());
                    logger.debug("cube = " + this.executable.getCubeName() + "; jobId=" + this.executable.getId() + (isAssigned ? " is " : " is not ") + "assigned on this server : " + ToolUtil.getHostName());
                }
                if (isAssigned && this.acquireJobLock()) {
                    logger.info(this.executable.toString() + " scheduled in server: " + DistributedScheduler.this.serverName);
                    DistributedScheduler.this.context.addRunningJob(this.executable);
                    DistributedScheduler.this.jobWithLocks.add(this.executable.getId());
                    this.executable.execute(DistributedScheduler.this.context, this);
                }
            }
            catch (ExecuteException e) {
                logger.error("ExecuteException job:" + this.executable.getId() + " in server: " + DistributedScheduler.this.serverName, e);
            }
            catch (Exception e) {
                logger.error("unknown error execute job:" + this.executable.getId() + " in server: " + DistributedScheduler.this.serverName, e);
            }
            finally {
                DistributedScheduler.this.context.removeRunningJob(this.executable);
                this.releaseJobLock(this.executable);
                DistributedScheduler.this.fetcherPool.schedule(DistributedScheduler.this.fetcher, 0L, TimeUnit.SECONDS);
            }
        }

        private void releaseJobLock(AbstractExecutable executable) {
            ExecutableState state;
            if (executable instanceof DefaultChainedExecutable && (state = executable.getStatus()) != ExecutableState.READY && state != ExecutableState.RUNNING && DistributedScheduler.this.jobWithLocks.contains(executable.getId())) {
                logger.info(executable.toString() + " will release the lock for the job: " + executable.getId());
                DistributedScheduler.this.jobLock.unlock(DistributedScheduler.getLockPath(executable.getId()));
                DistributedScheduler.this.jobWithLocks.remove(executable.getId());
            }
        }
    }
}

