/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.DimensionRangeInfo;
import org.apache.kylin.cube.model.SnapshotTableDesc;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.LookupMaterializeContext;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.impl.threadpool.IJobRunner;
import org.apache.kylin.metadata.datatype.DataTypeOrder;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.Strings;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCubeInfoAfterBuildStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCubeInfoAfterBuildStep.class);
    private long timeMaxValue = Long.MIN_VALUE;
    private long timeMinValue = Long.MAX_VALUE;

    @Override
    protected ExecuteResult doWork(ExecutableContext context, IJobRunner jobRunner) throws ExecuteException {
        CubeManager cubeManager = CubeManager.getInstance(context.getConfig());
        CubeInstance cube = cubeManager.getCube(CubingExecutableUtil.getCubeName(this.getParams())).latestCopyForWrite();
        CubeSegment segment = cube.getSegmentById(CubingExecutableUtil.getSegmentId(this.getParams()));
        CubingJob cubingJob = (CubingJob)this.getManager().getJob(CubingExecutableUtil.getCubingJobId(this.getParams()));
        long sourceCount = cubingJob.findSourceRecordCount();
        long sourceSizeBytes = cubingJob.findSourceSizeBytes();
        long cubeSizeBytes = cubingJob.findCubeSizeBytes();
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        List<Double> cuboidEstimateRatio = cubingJob.findEstimateRatio(segment, config);
        segment.setLastBuildJobID(CubingExecutableUtil.getCubingJobId(this.getParams()));
        segment.setLastBuildTime(System.currentTimeMillis());
        segment.setSizeKB(cubeSizeBytes / 1024L);
        segment.setInputRecords(sourceCount);
        segment.setInputRecordsSize(sourceSizeBytes);
        segment.setEstimateRatio(cuboidEstimateRatio);
        try {
            this.deleteDictionaryIfNeeded(segment);
            this.saveExtSnapshotIfNeeded(cubeManager, cube, segment);
            this.updateSegment(segment);
            cubeManager.promoteNewlyBuiltSegments(cube, segment);
            return new ExecuteResult();
        }
        catch (IOException e) {
            logger.error("fail to update cube after build", e);
            return ExecuteResult.createError(e);
        }
    }

    private Set<String> deleteDictionaryIfNeeded(CubeSegment segment) {
        Set<TblColRef> dictColToDelete = segment.getCubeDesc().getAllColumnsNeedDictionaryForBuildingOnly();
        HashSet<String> dictResPathToDelete = Sets.newHashSetWithExpectedSize(dictColToDelete.size());
        for (TblColRef dictCol : dictColToDelete) {
            String pathToDelete = segment.removeDictResPath(dictCol);
            if (Strings.isNullOrEmpty(pathToDelete)) continue;
            dictResPathToDelete.add(pathToDelete);
        }
        return dictResPathToDelete;
    }

    private void saveExtSnapshotIfNeeded(CubeManager cubeManager, CubeInstance cube, CubeSegment segment) throws IOException {
        String extLookupSnapshotStr = this.getParam("extlookupsnapshots");
        if (extLookupSnapshotStr == null || extLookupSnapshotStr.isEmpty()) {
            return;
        }
        Map<String, String> extLookupSnapshotMap = LookupMaterializeContext.parseLookupSnapshots(extLookupSnapshotStr);
        logger.info("update ext lookup snapshots:{}", (Object)extLookupSnapshotMap);
        List<SnapshotTableDesc> snapshotTableDescList = cube.getDescriptor().getSnapshotTableDescList();
        for (SnapshotTableDesc snapshotTableDesc : snapshotTableDescList) {
            String newSnapshotResPath;
            String tableName = snapshotTableDesc.getTableName();
            if (!snapshotTableDesc.isExtSnapshotTable() || (newSnapshotResPath = extLookupSnapshotMap.get(tableName)) == null || newSnapshotResPath.isEmpty()) continue;
            if (snapshotTableDesc.isGlobal()) {
                if (newSnapshotResPath.equals(cube.getSnapshotResPath(tableName))) continue;
                cubeManager.updateCubeLookupSnapshot(cube, tableName, newSnapshotResPath);
                continue;
            }
            segment.putSnapshotResPath(tableName, newSnapshotResPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSegment(CubeSegment segment) throws IOException {
        TblColRef partitionCol = segment.getCubeDesc().getModel().getPartitionDesc().getPartitionDateColumnRef();
        for (TblColRef dimColRef : segment.getCubeDesc().listDimensionColumnsExcludingDerived(true)) {
            if (!dimColRef.getType().needCompare()) continue;
            String factColumnsInputPath = this.getParams().get("output.path");
            Path colDir = new Path(factColumnsInputPath, dimColRef.getIdentity());
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            Path[] outputFiles = HadoopUtil.getFilteredPath(fs, colDir, dimColRef.getName() + ".dci");
            if (outputFiles == null || outputFiles.length == 0) {
                segment.getDimensionRangeInfoMap().put(dimColRef.getIdentity(), new DimensionRangeInfo(null, null));
                continue;
            }
            FSDataInputStream is = null;
            BufferedReader bufferedReader = null;
            InputStreamReader isr = null;
            HashSet<String> minValues = Sets.newHashSet();
            HashSet<String> maxValues = Sets.newHashSet();
            for (Path outputFile : outputFiles) {
                try {
                    is = fs.open(outputFile);
                    isr = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
                    bufferedReader = new BufferedReader(isr);
                    minValues.add(bufferedReader.readLine());
                    maxValues.add(bufferedReader.readLine());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)is);
                    IOUtils.closeQuietly(isr);
                    IOUtils.closeQuietly(bufferedReader);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((Reader)isr);
                IOUtils.closeQuietly((Reader)bufferedReader);
            }
            DataTypeOrder order = dimColRef.getType().getOrder();
            String minValue = order.min(minValues);
            String maxValue = order.max(maxValues);
            if (segment.isOffsetCube() && partitionCol != null && partitionCol.getIdentity().equals(dimColRef.getIdentity())) {
                logger.debug("update partition. {} timeMinValue:" + minValue + " timeMaxValue:" + maxValue, (Object)dimColRef.getName());
                if (DateFormat.stringToMillis(minValue) != this.timeMinValue && DateFormat.stringToMillis(maxValue) != this.timeMaxValue) {
                    segment.setTSRange(new SegmentRange.TSRange(DateFormat.stringToMillis(minValue), DateFormat.stringToMillis(maxValue) + 1L));
                }
            }
            segment.getDimensionRangeInfoMap().put(dimColRef.getIdentity(), new DimensionRangeInfo(minValue, maxValue));
        }
    }
}

