/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonProperty;

public class SelectRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="hierarchy_dims")
    public String[][] hierarchyDims;
    @JsonProperty(value="mandatory_dims")
    public String[] mandatoryDims;
    @JsonProperty(value="joint_dims")
    public String[][] jointDims;
    @JsonProperty(value="dim_cap")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer dimCap;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectRule that = (SelectRule)o;
        if (this.hierarchyDims != that.hierarchyDims) {
            if (this.hierarchyDims == null || that.hierarchyDims == null) {
                return false;
            }
            if (!IntStream.range(0, this.hierarchyDims.length).allMatch(i -> Arrays.equals(this.hierarchyDims[i], that.hierarchyDims[i]))) {
                return false;
            }
        }
        if (this.jointDims != that.jointDims) {
            if (this.jointDims == null || that.jointDims == null) {
                return false;
            }
            if (!IntStream.range(0, this.jointDims.length).allMatch(i -> Arrays.equals(this.jointDims[i], that.jointDims[i]))) {
                return false;
            }
        }
        return Arrays.equals(this.mandatoryDims, that.mandatoryDims) && Objects.equals(this.dimCap, that.dimCap);
    }

    public int hashCode() {
        int result = Objects.hash(this.dimCap);
        result = 31 * result + Arrays.hashCode((Object[])this.hierarchyDims);
        result = 31 * result + Arrays.hashCode(this.mandatoryDims);
        result = 31 * result + Arrays.hashCode((Object[])this.jointDims);
        return result;
    }
}

