/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.gridtable;

import java.nio.ByteBuffer;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.dimension.AbstractDateDimEnc;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.SegmentRange;

public class SegmentGTStartAndEnd {
    private ISegment segment;
    private GTInfo info;

    public SegmentGTStartAndEnd(ISegment segment, GTInfo info) {
        this.segment = segment;
        this.info = info;
    }

    public boolean isUsingDatetimeEncoding(int index) {
        return this.info.getCodeSystem().getDimEnc(index) instanceof AbstractDateDimEnc;
    }

    public Pair<ByteArray, ByteArray> getSegmentStartAndEnd(int index) {
        SegmentRange.TSRange tsRange = this.segment.getTSRange();
        ByteArray start = !tsRange.start.isMin ? this.encodeTime((Long)tsRange.start.v, index, 1) : new ByteArray();
        ByteArray end = !tsRange.end.isMax ? this.encodeTime((Long)tsRange.end.v, index, -1) : new ByteArray();
        return Pair.newPair(start, end);
    }

    private ByteArray encodeTime(long ts, int index, int roundingFlag) {
        String value;
        DataType partitionColType = this.info.getColumnType(index);
        if (partitionColType.isDate()) {
            value = DateFormat.formatToDateStr(ts);
        } else if (partitionColType.isTimeFamily()) {
            value = DateFormat.formatToTimeWithoutMilliStr(ts);
        } else if (partitionColType.isStringFamily() || partitionColType.isIntegerFamily()) {
            String partitionDateFormat = this.segment.getModel().getPartitionDesc().getPartitionDateFormat();
            value = StringUtils.isEmpty((String)partitionDateFormat) ? "" + ts : DateFormat.formatToDateStr(ts, partitionDateFormat);
        } else {
            throw new RuntimeException("Type " + partitionColType + " is not valid partition column type");
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.info.getMaxColumnLength());
        this.info.getCodeSystem().encodeColumnValue(index, value, roundingFlag, buffer);
        return ByteArray.copyOf(buffer.array(), 0, buffer.position());
    }
}

