/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.ContentReader;
import org.apache.kylin.common.persistence.ContentWriter;
import org.apache.kylin.common.persistence.ExponentialBackoffRetry;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.persistence.WriteConflictException;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceStore {
    private static final Logger logger = LoggerFactory.getLogger(ResourceStore.class);
    public static final String CUBE_RESOURCE_ROOT = "/cube";
    public static final String CUBE_DESC_RESOURCE_ROOT = "/cube_desc";
    public static final String DATA_MODEL_DESC_RESOURCE_ROOT = "/model_desc";
    public static final String DICT_RESOURCE_ROOT = "/dict";
    public static final String PROJECT_RESOURCE_ROOT = "/project";
    public static final String SNAPSHOT_RESOURCE_ROOT = "/table_snapshot";
    public static final String TABLE_EXD_RESOURCE_ROOT = "/table_exd";
    public static final String TEMP_STATMENT_RESOURCE_ROOT = "/temp_statement";
    public static final String TABLE_RESOURCE_ROOT = "/table";
    public static final String EXTERNAL_FILTER_RESOURCE_ROOT = "/ext_filter";
    public static final String HYBRID_RESOURCE_ROOT = "/hybrid";
    public static final String EXECUTE_RESOURCE_ROOT = "/execute";
    public static final String EXECUTE_OUTPUT_RESOURCE_ROOT = "/execute_output";
    public static final String STREAMING_RESOURCE_ROOT = "/streaming";
    public static final String STREAMING_V2_RESOURCE_ROOT = "/streaming_v2";
    public static final String KAFKA_RESOURCE_ROOT = "/kafka";
    public static final String STREAMING_OUTPUT_RESOURCE_ROOT = "/streaming_output";
    public static final String CUBE_STATISTICS_ROOT = "/cube_statistics";
    public static final String BAD_QUERY_RESOURCE_ROOT = "/bad_query";
    public static final String DRAFT_RESOURCE_ROOT = "/draft";
    public static final String USER_ROOT = "/user";
    public static final String EXT_SNAPSHOT_RESOURCE_ROOT = "/ext_table_snapshot";
    public static final String METASTORE_UUID_TAG = "/UUID";
    private static final ConcurrentMap<KylinConfig, ResourceStore> CACHE = new ConcurrentHashMap<KylinConfig, ResourceStore>();
    protected final KylinConfig kylinConfig;
    ThreadLocal<Checkpoint> checkpointing = new ThreadLocal();

    private static ResourceStore createResourceStore(KylinConfig kylinConfig) {
        StorageURL metadataUrl = kylinConfig.getMetadataUrl();
        logger.info("Using metadata url {} for resource store", (Object)metadataUrl);
        String clsName = kylinConfig.getResourceStoreImpls().get(metadataUrl.getScheme());
        try {
            Class<ResourceStore> cls = ClassUtil.forName(clsName, ResourceStore.class);
            ResourceStore store = cls.getConstructor(KylinConfig.class).newInstance(kylinConfig);
            if (!store.exists(METASTORE_UUID_TAG)) {
                store.checkAndPutResource(METASTORE_UUID_TAG, new StringEntity(store.createMetaStoreUUID()), 0L, StringEntity.serializer);
            }
            return store;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to find metadata store by url: " + metadataUrl, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceStore getStore(KylinConfig kylinConfig) {
        if (CACHE.containsKey(kylinConfig)) {
            return (ResourceStore)CACHE.get(kylinConfig);
        }
        Class<ResourceStore> clazz = ResourceStore.class;
        synchronized (ResourceStore.class) {
            if (CACHE.containsKey(kylinConfig)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return (ResourceStore)CACHE.get(kylinConfig);
            }
            CACHE.putIfAbsent(kylinConfig, ResourceStore.createResourceStore(kylinConfig));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (ResourceStore)CACHE.get(kylinConfig);
        }
    }

    protected ResourceStore(KylinConfig kylinConfig) {
        this.kylinConfig = kylinConfig;
    }

    public final KylinConfig getConfig() {
        return this.kylinConfig;
    }

    protected String createMetaStoreUUID() throws IOException {
        return UUID.randomUUID().toString();
    }

    public String getMetaStoreUUID() throws IOException {
        StringEntity entity;
        if (!this.exists(METASTORE_UUID_TAG)) {
            this.checkAndPutResource(METASTORE_UUID_TAG, new StringEntity(this.createMetaStoreUUID()), 0L, StringEntity.serializer);
        }
        return (entity = this.getResource(METASTORE_UUID_TAG, StringEntity.serializer)) == null ? "" : entity.toString();
    }

    public final List<String> collectResourceRecursively(final String folderPath, final String suffix) throws IOException {
        return new ExponentialBackoffRetry(this).doWithRetry(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                final ArrayList<String> collector = Lists.newArrayList();
                ResourceStore.this.visitFolder(folderPath, true, new Visitor(){

                    @Override
                    public void visit(RawResource resource) {
                        String path = resource.path();
                        if (suffix == null || path.endsWith(suffix)) {
                            collector.add(path);
                        }
                    }
                });
                return collector;
            }
        });
    }

    public final NavigableSet<String> listResources(String folderPath) throws IOException {
        return this.listResourcesImpl(this.norm(folderPath));
    }

    protected NavigableSet<String> listResourcesImpl(String folderPath) throws IOException {
        List<String> list = this.collectResourceRecursively(folderPath, null);
        if (list.isEmpty()) {
            return null;
        }
        TreeSet<String> result = new TreeSet<String>();
        String root = this.norm(folderPath);
        for (String p : list) {
            int cut = p.indexOf(47, root.length() + 1);
            result.add(cut < 0 ? p : p.substring(0, cut));
        }
        return result;
    }

    public final NavigableSet<String> listResourcesRecursively(String folderPath) throws IOException {
        return this.listResourcesRecursivelyImpl(this.norm(folderPath));
    }

    protected NavigableSet<String> listResourcesRecursivelyImpl(String folderPath) throws IOException {
        List<String> list = this.collectResourceRecursively(folderPath, null);
        if (list.isEmpty()) {
            return null;
        }
        return new TreeSet<String>(list);
    }

    public final <T extends RootPersistentEntity> List<T> getAllResources(String folderPath, Serializer<T> serializer) throws IOException {
        return this.getAllResources(folderPath, false, null, new ContentReader<T>(serializer));
    }

    public final <T extends RootPersistentEntity> List<T> getAllResources(final String folderPath, final boolean recursive, final VisitFilter filter, final ContentReader<T> reader) throws IOException {
        return (List)new ExponentialBackoffRetry(this).doWithRetry(new Callable<List<T>>(){

            @Override
            public List<T> call() throws Exception {
                final ArrayList collector = Lists.newArrayList();
                ResourceStore.this.visitFolderAndContent(folderPath, recursive, filter, new Visitor(){

                    @Override
                    public void visit(RawResource resource) throws IOException {
                        try {
                            Object entity = reader.readContent(resource);
                            if (entity != null) {
                                collector.add(entity);
                            }
                        }
                        catch (Exception ex) {
                            logger.error("Error reading resource " + resource.path(), ex);
                        }
                    }
                });
                return collector;
            }
        });
    }

    public final <T extends RootPersistentEntity> Map<String, T> getAllResourcesMap(String folderPath, boolean recursive, VisitFilter filter, final ContentReader<T> reader) throws IOException {
        return new ExponentialBackoffRetry(this).doWithRetry(() -> {
            final LinkedHashMap collector = new LinkedHashMap();
            this.visitFolderAndContent(folderPath, recursive, filter, new Visitor(){

                @Override
                public void visit(RawResource resource) throws IOException {
                    try {
                        Object entity = reader.readContent(resource);
                        if (entity != null) {
                            collector.put(resource.path(), entity);
                        }
                    }
                    catch (Exception ex) {
                        logger.error("Error reading resource " + resource.path(), ex);
                    }
                }
            });
            return collector;
        });
    }

    public final boolean exists(String resPath) throws IOException {
        return this.existsImpl(this.norm(resPath));
    }

    protected abstract boolean existsImpl(String var1) throws IOException;

    public final <T extends RootPersistentEntity> T getResource(String resPath, Serializer<T> serializer) throws IOException {
        return this.getResource(resPath, new ContentReader<T>(serializer));
    }

    public final <T extends RootPersistentEntity> T getResource(String resPath, ContentReader<T> reader) throws IOException {
        RawResource res = this.getResourceWithRetry(resPath = this.norm(resPath));
        if (res == null) {
            return null;
        }
        return reader.readContent(res);
    }

    public final RawResource getResource(String resPath) throws IOException {
        return this.getResourceWithRetry(this.norm(resPath));
    }

    protected abstract RawResource getResourceImpl(String var1) throws IOException;

    private RawResource getResourceWithRetry(String resPath) throws IOException {
        ExponentialBackoffRetry retry = new ExponentialBackoffRetry(this);
        return retry.doWithRetry(() -> this.getResourceImpl(resPath));
    }

    public final long getResourceTimestamp(String resPath) throws IOException {
        return this.getResourceTimestampWithRetry(this.norm(resPath));
    }

    protected abstract long getResourceTimestampImpl(String var1) throws IOException;

    public final long getResourceTimestampWithRetry(String resPath) throws IOException {
        String path = this.norm(resPath);
        ExponentialBackoffRetry retry = new ExponentialBackoffRetry(this);
        return retry.doWithRetry(() -> this.getResourceTimestampImpl(path));
    }

    public final <T extends RootPersistentEntity> long putResource(String resPath, T obj, long ts, Serializer<T> serializer) throws IOException {
        resPath = this.norm(resPath);
        obj.setLastModified(ts);
        ContentWriter writer = ContentWriter.create(obj, serializer);
        this.putResourceCheckpoint(resPath, writer, ts);
        return writer.bytesWritten();
    }

    public final <T extends RootPersistentEntity> long putBigResource(String resPath, T obj, long ts, Serializer<T> serializer) throws IOException {
        resPath = this.norm(resPath);
        obj.setLastModified(ts);
        ContentWriter writer = ContentWriter.create(obj, serializer);
        writer.markBigContent();
        this.putResourceCheckpoint(resPath, writer, ts);
        return writer.bytesWritten();
    }

    public final long putResource(String resPath, InputStream content, long ts) throws IOException {
        resPath = this.norm(resPath);
        ContentWriter writer = ContentWriter.create(content);
        this.putResourceCheckpoint(resPath, writer, ts);
        return writer.bytesWritten();
    }

    private void putResourceCheckpoint(String resPath, ContentWriter content, long ts) throws IOException {
        logger.trace("Directly saving resource {} (Store {})", (Object)resPath, (Object)this.kylinConfig.getMetadataUrl());
        this.beforeChange(resPath);
        this.putResourceWithRetry(resPath, content, ts);
    }

    protected abstract void putResourceImpl(String var1, ContentWriter var2, long var3) throws IOException;

    protected void putResourceWithRetry(String resPath, ContentWriter content, long ts) throws IOException {
        ExponentialBackoffRetry retry = new ExponentialBackoffRetry(this);
        retry.doWithRetry(() -> {
            this.putResourceImpl(resPath, content, ts);
            return null;
        });
    }

    public final <T extends RootPersistentEntity> void checkAndPutResource(String resPath, T obj, Serializer<T> serializer) throws IOException, WriteConflictException {
        this.checkAndPutResource(resPath, obj, System.currentTimeMillis(), serializer);
    }

    public final <T extends RootPersistentEntity> void checkAndPutResource(String resPath, T obj, long newTS, Serializer<T> serializer) throws IOException, WriteConflictException {
        resPath = this.norm(resPath);
        long oldTS = obj.getLastModified();
        obj.setLastModified(newTS);
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(buf);
            serializer.serialize(obj, dout);
            dout.close();
            buf.close();
            long confirmedTS = this.checkAndPutResource(resPath, buf.toByteArray(), oldTS, newTS);
            obj.setLastModified(confirmedTS);
        }
        catch (IOException | RuntimeException e) {
            obj.setLastModified(oldTS);
            throw e;
        }
    }

    public final long checkAndPutResource(String resPath, byte[] content, long oldTS, long newTS) throws IOException, WriteConflictException {
        return this.checkAndPutResourceCheckpoint(this.norm(resPath), content, oldTS, newTS);
    }

    private long checkAndPutResourceCheckpoint(String resPath, byte[] content, long oldTS, long newTS) throws IOException, WriteConflictException {
        this.beforeChange(resPath);
        return this.checkAndPutResourceWithRetry(resPath, content, oldTS, newTS);
    }

    protected abstract long checkAndPutResourceImpl(String var1, byte[] var2, long var3, long var5) throws IOException, WriteConflictException;

    private long checkAndPutResourceWithRetry(String resPath, byte[] content, long oldTS, long newTS) throws IOException, WriteConflictException {
        ExponentialBackoffRetry retry = new ExponentialBackoffRetry(this);
        return retry.doWithRetry(() -> this.checkAndPutResourceImpl(resPath, content, oldTS, newTS));
    }

    public final void updateTimestamp(String resPath, long timestamp) throws IOException {
        logger.trace("Updating resource: {} with timestamp {} (Store {})", resPath, timestamp, this.kylinConfig.getMetadataUrl());
        this.updateTimestampCheckPoint(this.norm(resPath), timestamp);
    }

    private void updateTimestampCheckPoint(String resPath, long timestamp) throws IOException {
        this.beforeChange(resPath);
        this.updateTimestampWithRetry(resPath, timestamp);
    }

    private void updateTimestampWithRetry(String resPath, long timestamp) throws IOException {
        ExponentialBackoffRetry retry = new ExponentialBackoffRetry(this);
        retry.doWithRetry(() -> {
            this.updateTimestampImpl(resPath, timestamp);
            return null;
        });
    }

    protected abstract void updateTimestampImpl(String var1, long var2) throws IOException;

    public final void deleteResource(String resPath) throws IOException {
        logger.trace("Deleting resource {} (Store {})", (Object)resPath, (Object)this.kylinConfig.getMetadataUrl());
        this.deleteResourceCheckpoint(this.norm(resPath));
    }

    public final void deleteResource(String resPath, long timestamp) throws IOException {
        logger.trace("Deleting resource {} within timestamp {} (Store {})", resPath, timestamp, this.kylinConfig.getMetadataUrl());
        this.deleteResourceCheckpoint(this.norm(resPath), timestamp);
    }

    private void deleteResourceCheckpoint(String resPath) throws IOException {
        this.beforeChange(resPath);
        this.deleteResourceWithRetry(resPath);
    }

    private void deleteResourceCheckpoint(String resPath, long timestamp) throws IOException {
        this.beforeChange(resPath);
        this.deleteResourceWithRetry(resPath, timestamp);
    }

    protected abstract void deleteResourceImpl(String var1) throws IOException;

    protected abstract void deleteResourceImpl(String var1, long var2) throws IOException;

    private void deleteResourceWithRetry(String resPath) throws IOException {
        ExponentialBackoffRetry retry = new ExponentialBackoffRetry(this);
        retry.doWithRetry(() -> {
            this.deleteResourceImpl(resPath);
            return null;
        });
    }

    private void deleteResourceWithRetry(String resPath, long timestamp) throws IOException {
        ExponentialBackoffRetry retry = new ExponentialBackoffRetry(this);
        retry.doWithRetry(() -> {
            this.deleteResourceImpl(resPath, timestamp);
            return null;
        });
    }

    protected boolean checkTimeStampBeforeDelete(long originLastModified, long timestamp) {
        long timeDiff;
        boolean passCheck = false;
        passCheck = originLastModified > timestamp ? (timeDiff = originLastModified - timestamp) < 1000L : true;
        logger.trace("check timestamp before delete: {}, [originLastModified: {}, timestamp: {}]", passCheck, originLastModified, timestamp);
        return passCheck;
    }

    protected boolean isUnreachableException(Throwable ex) {
        String exception;
        ArrayList<String> connectionExceptions = Lists.newArrayList(this.kylinConfig.getResourceStoreConnectionExceptions().split(","));
        boolean hasException = false;
        Iterator iterator = connectionExceptions.iterator();
        while (iterator.hasNext() && !(hasException = this.containsException(ex, exception = (String)iterator.next()))) {
        }
        return hasException;
    }

    private boolean containsException(Throwable ex, String targetException) {
        Throwable t = ex;
        for (int depth = 0; t != null && depth < 5; ++depth, t = t.getCause()) {
            if (!t.getClass().getName().equals(targetException)) continue;
            return true;
        }
        return false;
    }

    public final String getReadableResourcePath(String resPath) {
        return this.getReadableResourcePathImpl(this.norm(resPath));
    }

    protected abstract String getReadableResourcePathImpl(String var1);

    private String norm(String resPath) {
        resPath = resPath.trim();
        while (resPath.startsWith("//")) {
            resPath = resPath.substring(1);
        }
        while (resPath.endsWith("/")) {
            resPath = resPath.substring(0, resPath.length() - 1);
        }
        if (!resPath.startsWith("/")) {
            resPath = "/" + resPath;
        }
        return resPath;
    }

    public Checkpoint checkpoint() {
        Checkpoint cp = this.checkpointing.get();
        if (cp != null) {
            throw new IllegalStateException("A checkpoint has been open for this thread: " + cp);
        }
        cp = new Checkpoint();
        this.checkpointing.set(cp);
        return cp;
    }

    private void beforeChange(String resPath) throws IOException {
        Checkpoint cp = this.checkpointing.get();
        if (cp != null) {
            cp.beforeChange(resPath);
        }
    }

    public final void visitFolder(String folderPath, boolean recursive, Visitor visitor) throws IOException {
        this.visitFolderInner(folderPath, recursive, null, false, visitor);
    }

    public final void visitFolder(String folderPath, boolean recursive, VisitFilter filter, Visitor visitor) throws IOException {
        this.visitFolderInner(folderPath, recursive, filter, false, visitor);
    }

    public final void visitFolderAndContent(String folderPath, boolean recursive, VisitFilter filter, Visitor visitor) throws IOException {
        this.visitFolderInner(folderPath, recursive, filter, true, visitor);
    }

    private void visitFolderInner(String folderPath, boolean recursive, VisitFilter filter, boolean loadContent, Visitor visitor) throws IOException {
        if (filter == null) {
            filter = new VisitFilter();
        }
        folderPath = this.norm(folderPath);
        if (filter.hasPathPrefixFilter()) {
            String folderPrefix = folderPath.endsWith("/") ? folderPath : folderPath + "/";
            Preconditions.checkArgument(filter.pathPrefix.startsWith(folderPrefix));
        }
        this.visitFolderImpl(folderPath, recursive, filter, loadContent, visitor);
    }

    protected abstract void visitFolderImpl(String var1, boolean var2, VisitFilter var3, boolean var4, Visitor var5) throws IOException;

    public static String dumpResources(KylinConfig kylinConfig, Collection<String> dumpList) throws IOException {
        File tmp = File.createTempFile("kylin_job_meta", "");
        FileUtils.forceDelete((File)tmp);
        File metaDir = new File(tmp, "meta");
        metaDir.mkdirs();
        File kylinPropsFile = new File(metaDir, "kylin.properties");
        kylinConfig.exportToFile(kylinPropsFile);
        ResourceStore from = ResourceStore.getStore(kylinConfig);
        KylinConfig localConfig = KylinConfig.createInstanceFromUri(metaDir.getAbsolutePath());
        ResourceStore to = ResourceStore.getStore(localConfig);
        for (String path : dumpList) {
            RawResource res = from.getResource(path);
            if (res == null) {
                throw new IllegalStateException("No resource found at -- " + path);
            }
            to.putResource(path, res.content(), res.lastModified());
            res.close();
        }
        String metaDirURI = OptionsHelper.convertToFileURL(metaDir.getAbsolutePath());
        metaDirURI = metaDirURI.startsWith("/") ? "file://" + metaDirURI : "file:///" + metaDirURI;
        logger.info("meta dir is: {}", (Object)metaDirURI);
        return metaDirURI;
    }

    public static class VisitFilter {
        private String pathPrefix = null;
        private long lastModStart = Long.MIN_VALUE;
        private long lastModEndExclusive = Long.MAX_VALUE;

        public VisitFilter() {
        }

        public VisitFilter(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        public VisitFilter(long lastModStart, long lastModEndExclusive) {
            this(null, lastModStart, lastModEndExclusive);
        }

        public VisitFilter(String pathPrefix, long lastModStart, long lastModEndExclusive) {
            this.pathPrefix = pathPrefix;
            this.lastModStart = lastModStart;
            this.lastModEndExclusive = lastModEndExclusive;
        }

        public boolean hasPathPrefixFilter() {
            return this.pathPrefix != null;
        }

        public boolean hasTimeFilter() {
            return this.lastModStart != Long.MIN_VALUE || this.lastModEndExclusive != Long.MAX_VALUE;
        }

        public boolean matches(String resPath, long lastModified) {
            if (this.hasPathPrefixFilter() && !resPath.startsWith(this.pathPrefix)) {
                return false;
            }
            return !this.hasTimeFilter() || this.lastModStart <= lastModified && lastModified < this.lastModEndExclusive;
        }

        public String getPathPrefix() {
            return this.pathPrefix;
        }

        public long getLastModStart() {
            return this.lastModStart;
        }

        public long getLastModEndExclusive() {
            return this.lastModEndExclusive;
        }
    }

    public static interface Visitor {
        public void visit(RawResource var1) throws IOException;
    }

    public class Checkpoint
    implements Closeable {
        LinkedHashMap<String, byte[]> origResData = new LinkedHashMap();
        LinkedHashMap<String, Long> origResTimestamp = new LinkedHashMap();

        private void beforeChange(String resPath) throws IOException {
            if (this.origResData.containsKey(resPath)) {
                return;
            }
            RawResource raw = ResourceStore.this.getResourceWithRetry(resPath);
            if (raw == null) {
                this.origResData.put(resPath, null);
                this.origResTimestamp.put(resPath, null);
            } else {
                this.origResData.put(resPath, this.readAll(raw.content()));
                this.origResTimestamp.put(resPath, raw.lastModified());
            }
        }

        private byte[] readAll(InputStream inputStream) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)out);
            inputStream.close();
            out.close();
            return out.toByteArray();
        }

        public void rollback() {
            this.checkThread();
            for (String resPath : this.origResData.keySet()) {
                logger.debug("Rollbacking {}", (Object)resPath);
                try {
                    byte[] data = this.origResData.get(resPath);
                    Long ts = this.origResTimestamp.get(resPath);
                    if (data == null || ts == null) {
                        ResourceStore.this.deleteResourceWithRetry(resPath);
                        continue;
                    }
                    ResourceStore.this.putResourceWithRetry(resPath, ContentWriter.create(data), ts);
                }
                catch (IOException ex) {
                    logger.error("Failed to rollback " + resPath, ex);
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.checkThread();
            this.origResData = null;
            this.origResTimestamp = null;
            ResourceStore.this.checkpointing.set(null);
        }

        private void checkThread() {
            Checkpoint cp = ResourceStore.this.checkpointing.get();
            if (this != cp) {
                throw new IllegalStateException();
            }
        }
    }
}

